/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file implements classes SKGBankObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankobject.h"
#include "skgaccountobject.h"
#include "skgdocumentbank.h"

#include <klocale.h>

SKGBankObject::SKGBankObject(const SKGDocument* iDocument, int iID): SKGNamedObject(iDocument, "v_bank", iID)
{
}

SKGBankObject::~SKGBankObject()
{
}

SKGBankObject::SKGBankObject(const SKGBankObject& iObject)
                :SKGNamedObject(iObject)
{
}

const SKGBankObject& SKGBankObject::operator= (const SKGObjectBase& iObject)
{
        copyFrom(iObject);
        return *this;
}

SKGError SKGBankObject::addAccount(SKGAccountObject& oAccount)
{
        SKGError err;
        if (getID() == 0) err=SKGError(ERR_FAIL, i18nc("Error message", "%1 failed because linked object is not yet saved in the database.",QString("SKGBankObject::addAccount")));
        else {
                oAccount = SKGAccountObject((SKGDocumentBank*) getDocument());
                err = oAccount.setAttribute("rd_bank_id", SKGServices::intToString(getID()));
        }
        return err;
}

SKGError SKGBankObject::getAccounts(SKGListSKGObjectBase& oAccountList) const
{
        SKGError err = getObjects(getDocument(), "v_account",
                                  "rd_bank_id=" + SKGServices::intToString(getID()),
                                  oAccountList);
        return err;
}

SKGError SKGBankObject::setNumber(const QString& iNumber)
{
        return setAttribute("t_bank_number", iNumber);
}

QString SKGBankObject::getNumber() const
{
        return getAttribute("t_bank_number");
}

SKGError SKGBankObject::setIcon(const QString& iIcon)
{
        return setAttribute("t_icon", iIcon);
}

QString SKGBankObject::getIcon() const
{
        return getAttribute("t_icon");
}

double SKGBankObject::getCurrentAmount() const
{
        return SKGServices::stringToDouble(getAttribute("f_CURRENTAMOUNT"));
}
#include "skgbankobject.moc"
