#
# Support library for scripts parsing the sitesummary files.
#

package SiteSummary;
require Exporter;

our $VERSION = 0.01;
our @ISA     = qw(Exporter);
our @EXPORT  = qw(
                  for_all_hosts
                  get_filepath_current
                  get_site
                  get_sitegroup
                  get_hostname
                  get_linux_kernel_ver
                  get_debian_edu_profile
                  get_debian_edu_ver
                  );

my $pwd = "/var/lib/sitesummary/entries";  # Path to the entries

# File for debian-edu configuration
my $debian_edu_config = "/debian-edu/config";

sub get_filepath_current {
    my ($hostid, $file) = @_;
    return "$pwd/$hostid$file";
}

#
# Return the value string from a file, ignoring comments
#
sub get_file_string {
    my ($hostid, $filename) = @_;
    my $path = get_filepath_current($hostid, $filename);
    my $string;
    if (open (FILE, $path)) {
        while(<FILE>) {
            chomp;
            s/\#.+$//;
            next if (/^\s*$/);
            $string = $_;
        }
        close(FILE);
        return $string;
    } else {
        return undef;
    }
}

#
# Return the site string
#
sub get_site {
    my $hostid = shift;
    return get_file_string($hostid, "/siteinfo/site");
}

#
# Return the sitegroup string
#
sub get_sitegroup {
    my $hostid = shift;
    return get_file_string($hostid, "/siteinfo/sitegroup");
}

#
# Return the hostname string
#
sub get_hostname {
    my $hostid = shift;
    return get_file_string($hostid, "/system/hostname");
}

#
# Return Linux kernel version for the machines using Linux.
#
sub get_linux_kernel_ver {
    my $hostid = shift;
    my $path = get_filepath_current($hostid, "/system/uname-smr");
    my $kver;
    if (open (FILE, $path)) {
        while(<FILE>) {
            chomp;
            s/\#.+$//;
            next if (/^\s*$/);
            my @f = (split(/\s+/, $_));
            $kver = $f[1] if ("Linux" eq $f[0]);
        }
        close(FILE);
        return $kver;
    } else {
        return undef;
    }
}

sub get_debian_edu_profile {
    my $hostid = shift;
    my $path = get_filepath_current($hostid, $debian_edu_config);
    if ( ! -e $path ) {
        return undef;
    }
    if (open (FILE, $path)) {
        while (<FILE>) {
                chomp;
                s/\#.+$//;
                next if not (/PROFILE/);
                s/^PROFILE=//;
                return $_;
        }
    }
    close(FILE);
}

sub get_debian_edu_ver {
    my $hostid = shift;
    my $path = get_filepath_current($hostid, $debian_edu_config);
    if ( ! -e $path ) {
        return undef;
    }
    if (open (FILE, $path)) {
        while (<FILE>) {
                chomp;
                s/\#.+$//;
                next if not (/VERSION/);
                s/^VERSION=//;
                return $_;
        }
    }
}

sub for_all_hosts {
    my $callback = shift;

    if ( ! -d $pwd ) {
        print STDERR "error: Missing $pwd directory.\n";
        return undef;
    }
    opendir(DIR, $pwd) or die "$!: $pwd\nDied";
    my $count = 0;
    foreach (readdir(DIR)) {
        chomp;
        next if m/^$/ || m/^.$/ || m/^..$/;
        my $hostid = $_;
        if ( -d "$pwd/$hostid" ) {
            $count ++ if ($callback->($hostid));
        } else {
            print STDERR "warning: Junk in filelog: $pwd/$hostid\n";
        }
    }
    closedir(DIR);
    return $count;
}

1;

########################################################################
# Local Variables:
# mode: perl
# End:
########################################################################
