# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/urls.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: urls for output files

=end
module SiSU_Urls
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env; include SiSU_Screen
  class Source
    attr_reader :opt
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        SiSU_Urls::OutputUrls.new(@opt).songsheet if @opt.fnb
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
  end
  class OutputUrls
    attr_reader :fns,:fnb,:cmd,:dir,:m_regular,:u
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_env_md(opt)
      @cmd=@opt.cmd
      @md=@particulars.md
      @env=@particulars.env
      @fnb=@env.fnb
      fn_set_lang=SiSU_Env::StandardiseLanguage.new(@opt.lng).language
      @fnl=@env.i18n.lang_filename(fn_set_lang[:c])
      @fn=SiSU_Env::EnvCall.new(@opt.fns).lang(fn_set_lang[:c])
      @m_regular=/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/
      @prog=@env.program
      @u ||= {
        'b --xhtml (XHTML)'=>@fn[:xhtml],
        'D[iu] --psql (DBI import/update postgresql)'=>'dbi psql',
        'd --sqlite (DBI sqlite)'=>'dbi sqlite3',
        'd[iu] --sqlite (DBI sqlite)'=>'dbi sqlite3',
        'e --epub (EPUB)'=>@fn[:epub],
        'P --pot (Pot)'=>@fn[:pot],
        'h --html (HTML segmented)'=>@fn[:toc],
        'h --html (HTML scroll)'=>@fn[:doc],
        'I --texinfo (Info file)'=>'info',
        'i --manpage (manpage)'=>'manpage',
        'm --ao (Document Abstraction)'=>'ao',
        'N --hash-digests (Digests sha512/sha256/md5)'=>@fn[:digest],
        'o --odt (ODF:ODT - Open Document)'=>@fn[:odf],
        'p --pdf (PDF landscape)'=>@fn[:pdf_l],
        'p --pdf (PDF portrait)'=>@fn[:pdf_p],
        'E --profile (Ruby profiler)'=>'profile',
        's --source (sisu markup)'=>@opt.fno,
        'S --sisupod (sisupod)'=>@fn[:sisupod],
        't --txt (Plain-text (endnotes))'=>@fn[:plain],
        '  --textile (textile txt)'=>@fn[:txt_textile],
        '  --asciidoc (AsciiDoc txt)'=>@fn[:txt_asciidoc],
        '  --markdown (markdown txt)'=>@fn[:txt_markdown],
        '  --rst (rST restructured-text)'=>@fn[:txt_rst],
        '  --docbook-book (DocBook Book)'=>@fn[:xml_docbook_book],
        '  --fictionbook (Fictionbook)'=>@fn[:xml_fictionbook],
        'x --xml-sax (XML sax type)'=>@fn[:sax],
        'X --xml-dom (XML dom type)'=>@fn[:dom],
        '  --xml-scaffold-sisu (XML scaffold)'=>@fn[:xml_scaffold_structure_sisu],
        '  --xml-scaffold-collapse (XML scaffold)'=>@fn[:xml_scaffold_structure_collapse],
        'Q --qrcode (QR Code jpg)'=>@fn[:qrcode],
        'y --manifest (Manifest, html)'=>@fn[:manifest],
        'Y (Sitemap, xml)'=>@fn[:sitemap],
        'w --concordance (Concordance, html)'=>@fn[:concordance],
      }.sort {|a,b| a[0].downcase<=>b[0].downcase}
    end
    def songsheet
      begin
       @opt.cmd=~/U/ ? urls_all : (urls_select unless @opt.act[:quiet][:set]==:on)
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def show
      def source
        def src(x,y)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.text_editor} #{@md.file.output_path.src.dir}/#{y}"
          ).result
        end
        def pod(x,y)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.sisupod.dir}/#{y}"
          ).result
        end
        self
      end
      def generic(x,y)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} #{@env.url.output_tell}/#{@fnb}/#{y}"
        ).result
      end
      def meta(x,y)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.text_editor} ~#{y}/#{@fnb}.#{y}"
        ).result
      end
      def text(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.txt.dir}/#{@md.file.base_filename.txt}"
        ).result
      end
      def textile(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.textile.dir}/#{@md.file.base_filename.textile}"
        ).result
      end
      def asciidoc(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.asciidoc.dir}/#{@md.file.base_filename.asciidoc}"
        ).result
      end
      def markdown(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.markdown.dir}/#{@md.file.base_filename.markdown}"
        ).result
      end
      def rst(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.rst.dir}/#{@md.file.base_filename.rst}"
        ).result
      end
      def epub(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.epub_viewer} #{@md.file.output_path.epub.dir}/#{@md.file.base_filename.epub}"
        ).result
      end
      def html
        def scroll(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.html_scroll.dir}/#{@md.file.base_filename.html_scroll}"
          ).result
        end
        def toc(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.html_seg.dir}/#{@md.file.base_filename.html_segtoc}"
          ).result
        end
        def concordance(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.html_concordance.dir}/#{@md.file.base_filename.html_concordance}"
          ).result
        end
        def manifest(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.manifest.dir}/#{@md.file.base_filename.manifest}"
          ).result
        end
        self
      end
      def qrcode(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.manifest.dir}/#{@md.file.base_filename.manifest}"
        ).result
      end
      def odt(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.odf_viewer} file://#{@md.file.output_path.odt.dir}/#{@md.file.base_filename.odt}"
        ).result
      end
      def pdf
        def portrait(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.pdf_viewer} #{@md.file.output_path.pdf.dir}/#{@md.file.base_filename.pdf_p}#{@md.papersize_array[0]}.pdf"
          ).result
        end
        def landscape(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.pdf_viewer} #{@md.file.output_path.pdf.dir}/#{@md.file.base_filename.pdf_l}#{@md.papersize_array[0]}.pdf"
          ).result
        end
        self
      end
      def manpage(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.manpage_viewer} #{@md.file.output_path.manpage.dir}/#{@md.file.base_filename.manpage}"
        ).result
      end
      def pinfo(x,y)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "cd #{@md.file.output_path.texinfo.dir} && #{@env.program.texinfo} #{@md.file.base_filename.info}; cd -"
        ).result
      end
      def po4a
        def po(x,y)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "-#{x}",
            "#{@prog.text_editor} #{@md.file.output_path.po.dir}/#{y}"
          ).result
        end
        def pot(x,y)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "-#{x}",
            "#{@prog.text_editor} #{@md.file.output_path.pot.dir}/#{y}"
          ).result
        end
        self
      end
      def xhtml(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.xhtml.dir}/#{@md.file.base_filename.xhtml}"
        ).result
      end
      def xml
        def sax(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.xml_sax.dir}/#{@md.file.base_filename.xml_sax}"
          ).result
        end
        def dom(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],"[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.xml_dom.dir}/#{@md.file.base_filename.xml_dom}"
          ).result
        end
        def docbook_book(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.xml_docbook_book.dir}/#{@md.file.base_filename.xml_docbook_book}"
          ).result
        end
        def fictionbook(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.xml_fictionbook.dir}/#{@md.file.base_filename.xml_fictionbook}"
          ).result
        end
        def scaffold_structure_sisu(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.xml_scaffold_structure_sisu.dir}/#{@md.file.base_filename.xml_scaffold_structure_sisu}"
          ).result
        end
        def scaffold_structure_collapse(x)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.xml_scaffold_structure_collapse.dir}/#{@md.file.base_filename.xml_scaffold_structure_collapse}"
          ).result
        end
        def sitemap(x) #BROKEN
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "#{@prog.web_browser} file://#{@md.file.output_path.sitemaps.dir}/#{@md.file.base_filename.sitemap}"
          ).result
        end
        self
      end
      def hash_digest(x)
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          "[#{@opt.f_pth[:lng_is]}] -#{x}",
          "#{@prog.web_browser} file://#{@md.file.output_path.hash_digest.dir}/#{@md.file.base_filename.hash_digest}"
        ).result
      end
      def db
        def psql(x,y)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x} DBI psql","#{@pwd_stub}::#{@opt.fns}",
            y
          ).result
        end
        def sqlite(x,y)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x} DBI sqlite",
            "sqlite3 #{@env.path.webserv}/#{@md.opt.f_pth[:pth_stub]}/sisu_sqlite.db"
          ).result
        end
        def sqlite_discrete(x,y)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "[#{@opt.f_pth[:lng_is]}] -#{x}",
            "sqlite3 #{@md.file.output_path.sqlite_discrete.dir}/#{@md.file.base_filename.sqlite_discrete}"
          ).result
        end
        self
      end
      self
    end
    def urls_maintenance(opt,x,y)
      if x=~/^([abcehHmNoptwxXy])/ \
      and opt.cmd =~/[abcehHmNoptwxXy]/ \
      and x=~/^[#{opt.cmd}]/ \
      and (@opt.act[:verbose_plus][:set]==:on \
      || @opt.act[:maintenance][:set]==:on)
        tool=@prog.text_editor
        if x =~/^m/ \
        and @opt.cmd=~/m/ \
        and x=~/^[#{opt.cmd}]/
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "-#{x}",
            "#{@prog.text_editor} #{@env.processing_path.ao}/#{@opt.fns}.meta"
          ).maintenance
        end
        if x=~/^([hw])/ \
        and @opt.cmd=~/[hw]/ \
        and x=~/^[#{@opt.cmd}]/ \
        and x !~/segmented/
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "-#{x}",
            "#{@prog.text_editor} #{@env.processing_path.tune}/#{@md.fns}.tune"
          ).maintenance
        end
        if x=~/^p/ \
        and @opt.cmd=~/p/ \
        and x=~/^[#{@opt.cmd}]/
          tool=@prog.pdf_viewer
          fns=@opt.fns.gsub(/~/,'-')
          unless @opt.cmd =~/q/
            tell=if x =~/landscape/
              SiSU_Screen::Ansi.new(
                @opt.act[:color_state][:set],
                "-#{x}",
                "#{@prog.text_editor} #{@env.processing_path.tex}/#{fns}.landscape.tex"
              )
            else
              SiSU_Screen::Ansi.new(
                @opt.act[:color_state][:set],
                "-#{x}",
                "#{@prog.text_editor} #{@env.processing_path.tex}/#{fns}.tex"
              )
            end
            tell.maintenance
          end
        end
        if x=~/^o/ \
        and @opt.cmd=~/o/ \
        and x=~/^[#{@opt.cmd}]/
          tool=@prog.odf_viewer
        end
        if x=~/^e/ \
        and @opt.cmd=~/e/ \
        and x=~/^[#{@opt.cmd}]/
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "-#{x}",
            "#{@prog.text_editor} #{@env.processing_path.epub}/#{Ep[:d_oebps]}/toc.xhtml"
          ).maintenance
        end
        if x=~/^o/ \
        and @opt.cmd=~/o/ \
        and x=~/^[#{@opt.cmd}]/
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            "-#{x}",
            "#{@prog.text_editor} #{@env.processing_path.odf}/#{@opt.fns}/odt/content.xml"
          ).maintenance
        end
      end
    end
    def urls_select
      unless @opt.cmd =~/q/
        i1='[' + @opt.f_pth[:lng_is] + ']'
        i2='file://' \
        + @md.file.output_path.manifest.dir + '/' \
        + @md.file.base_filename.manifest
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'URLs'
          ).green_title_hi
        : SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'URL (output manifest)',
            i1, i2
          ).grey_title_grey_blue
        SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          i1, i2,
        ).flow if @opt.cmd =~/[MVv]/
      end
      m=/.+\/(?:src\/)?(\S+)/im # m=/.+?\/(?:src\/)?([^\/]+)$/im # m=/.+\/(\S+)/m
      @pwd_stub="#{@env.url.output_tell}"[m,1]
      unless @opt.act[:quiet][:set]==:on
        @u.each do |x,y|
          if @opt.fns =~ @m_regular
            if (@opt.act[:verbose][:set]==:on \
            || @opt.act[:verbose_plus][:set]==:on \
            || @opt.act[:maintenance][:set]==:on)
              if x=~/--txt\b/ \
              and @opt.act[:txt][:set]==:on
                show.text(x)
              end
              if x=~/--textile\b/ \
              and @opt.act[:txt_textile][:set]==:on
                show.textile(x)
              end
              if x=~/--asciidoc\b/ \
              and @opt.act[:txt_asciidoc][:set]==:on
                show.asciidoc(x)
              end
              if x=~/--markdown\b/ \
              and @opt.act[:txt_markdown][:set]==:on
                show.markdown(x)
              end
              if x=~/--rst\b/ \
              and @opt.act[:txt_rst][:set]==:on
                show.rst(x)
              end
              if x=~/--xhtml\b/ \
              and @opt.act[:xhtml][:set]==:on
                show.xhtml(x)
              end
              if x=~/--psql\b/ \
              and @opt.act[:psql][:set]==:on
                show.db.psql(x,y)
              end
              if x=~/d\s+--sqlite\b|--sql\b/ \
              and @opt.act[:sqlite_discrete][:set]==:on
                show.db.sqlite_discrete(x,y)
              end
              if x=~/d\[iu\]\s+--sqlite\b/ \
              and @opt.act[:sqlite][:set]==:on
                show.db.sqlite(x,y)
              end
              if x=~/--epub\b/ \
              and @opt.act[:epub][:set]==:on
                show.epub(x)
              end
              if x=~/--html\b/ \
              and (@opt.act[:html][:set]==:on \
              or @opt.act[:html_scroll][:set]==:on \
              or @opt.act[:html_seg][:set]==:on)
                if x =~/scroll/
                  if @opt.act[:html_scroll][:set]==:on
                    show.html.scroll(x)
                  end
                else
                  if @opt.act[:html_seg][:set]==:on
                    show.html.toc(x)
                  end
                end
              end
              if x=~/--texinfo\b/ \
              and @opt.cmd =~/I/
                show.pinfo(x,y)
              end
              if x=~/--manpage\b/ \
              and @opt.act[:manpage][:set]==:on
                show.manpage(x)
              end
              if x=~/--hash-digests\b/ \
              and @opt.cmd =~/N/
                show.hash_digest(x)
              end
              if x=~/--odt\b|--odf\b/ \
              and @opt.act[:odt][:set]==:on
                show.odt(x)
              end
              if x=~/^P/ \
              and @opt.cmd =~/P/
                if @opt.fns =~/\S+?~\S{2}(?:_\S{2})?\.ss[mt]/
                  f=y.gsub(/\.pot$/,'.po')
                  show.po4a.po(x,f)
                else
                  show.po4a.pot(x,f)
                end
              end
              if x=~/--pdf\b/ \
              and (@opt.act[:pdf][:set]==:on \
              or @opt.act[:pdf_p][:set]==:on \
              or @opt.act[:pdf_l][:set]==:on)
                if x =~/portrait/
                  if @opt.act[:pdf_p][:set]==:on
                    show.pdf.portrait(x)
                  end
                else
                  if @opt.act[:pdf_l][:set]==:on
                    show.pdf.landscape(x)
                  end
                end
              end
              if x=~/--sisupod\b/ \
              and @opt.act[:sisupod][:set]==:on
                (@opt.fno =~/\.ssm$/) \
                ? y.gsub(/(?:\~\S{2,3})?(\.ssm.sst\.txz)$/,'.ssm.txz')
                : y.gsub(/(?:\~\S{2,3})?(\.sst\.txz)$/,'\1')
                show.source.pod(x,y)
              end
              if x=~/--source\b/ \
              and @opt.act[:share_source][:set]==:on
                show.source.src(x,y)
              end
              if x=~/--concordance\b/ \
              and @opt.act[:concordance][:set]==:on
                show.html.concordance(x)
              end
              if x=~/--xml-dom\b/ \
              and @opt.act[:xml_dom][:set]==:on
                show.xml.dom(x)
              end
              if x=~/--xml-sax\b/ \
              and @opt.act[:xml_sax][:set]==:on
                show.xml.sax(x)
              end
              if x=~/--docbook-book\b/ \
              and @opt.act[:xml_docbook_book][:set]==:on
                show.xml.docbook_book(x)
              end
              if x=~/--fictionbook\b/ \
              and @opt.act[:xml_fictionbook][:set]==:on
                show.xml.fictionbook(x)
              end
              if x=~/--xml-scaffold-sisu\b/ \
              and @opt.act[:xml_scaffold_structure_sisu][:set]==:on
                show.xml.scaffold_structure_sisu(x)
              end
              if x=~/--xml-scaffold-collapse\b/ \
              and @opt.act[:xml_scaffold_structure_collapse][:set]==:on
                show.xml.scaffold_structure_collapse(x)
              end
              if x=~/--qrcode\b/ \
              and @opt.act[:qrcode][:set]==:on
                show.qrcode(x)
              end
              if x=~/--sitemap\b/ \
              and @opt.cmd =~/Y/ #BROKEN
                show.xml.sitemap(x)
              end
              if x=~/--manifest\b/ \
              and @opt.act[:manifest][:set]==:on
                show.html.manifest(x)
              end
            end
            if (@opt.act[:verbose_plus][:set]==:on \
            || @opt.act[:maintenance][:set]==:on)
              urls_maintenance(@opt,x,y)
            end
          end
        end
      end
    end
    def urls_all
      i="(output manifest) [#{@opt.f_pth[:lng_is]}] #{@env.url.output_tell}/#{@fnb}/sisu_manifest.html"
      SiSU_Screen::Ansi.new(
        @opt.act[:color_state][:set],
        'URLs',
        i
      ).grey_title_hi
      @u.each do |x,y|
        case x
        when /^m/
          show.meta(x,y)
        when /^[BcdNsxXy]/
          show.generic(x,y)
        when /^[at]/
          show.text(x)
        when /^b/
          show.xhtml(x)
        when /^e/
          show.epub(x)
        when /^h/
          if x =~/scroll/
            show.html.scroll(x)
          else
            show.html.toc(x)
          end
        when /^o/
          show.odt(x)
        when /^p/
          if x =~/portrait/
            show.pdf.portrait(x)
          else
            show.pdf.landscape(x)
          end
        when /^w/
          show.html.concordance(x)
        when /^Y/
          show.xml.sitemap(x)
        when /^I/
          show.pinfo(x,y)
        when /^i/
          show.manpage(x)
        end
      end
    end
  end
end
__END__
