# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/db_dbi.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module  SiSU_DbDBI
  require_relative 'db_columns'                                             # db_columns.rb
  require_relative 'db_tests'                                               # db_tests.rb
  require_relative 'db_create'                                              # db_create.rb
  require_relative 'db_select'                                              # db_select.rb
  require_relative 'db_indexes'                                             # db_indexes.rb
  require_relative 'db_drop'                                                # db_drop.rb
  require_relative 'db_remove'                                              # db_remove.rb
  require_relative 'db_load_tuple'                                          # db_load_tuple.rb
  require_relative 'db_import'                                              # db_import.rb
  class ColumnSize < SiSU_DbColumns::ColumnSize                             # db_columns.rb
  end
  class Test < SiSU_DbTests::Test                                           # db_tests.rb
  end
  class Create <SiSU_DbCreate::Create                                       # db_create.rb
  end
  class Case <SiSU_DbSelect::Case                                           # db_select.rb
  end
  class Index <SiSU_DbIndex::Index                                          # db_indexes.rb
  end
  class Drop <SiSU_DbDrop::Drop                                             # db_drop.rb
  end
  class Remove <SiSU_DbRemove::Remove                                       # db_remove.rb
  end
  class LoadDocuments <SiSU_DbTuple::LoadDocuments                          # db_load_tuple.rb
  end
  class LoadMetadata <SiSU_DbTuple::LoadMetadata                            # db_load_tuple.rb
  end
  class LoadUrls <SiSU_DbTuple::LoadUrls                                    # db_update urls
  end
  class Import <SiSU_DbImport::Import #<SiSU_DB::ColumnSize                 # db_import.rb
  end
end
__END__
