# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: epub generation, processing

=end
module SiSU_EPUB
  require 'pstore'
  require_relative 'particulars'                        # particulars.rb
    include SiSU_Particulars
  require_relative 'defaults'                           # defaults.rb
    include SiSU_Viz
  require_relative 'xhtml_table'                        # xhtml_table.rb
  require_relative 'epub_format'                        # epub_format.rb
    include SiSU_EPUB_Format
  require_relative 'epub_segments'                      # epub_segments.rb
    include SiSU_EPUB_Seg
  require_relative 'epub_tune'                          # epub_tune.rb
    include SiSU_EPUB_Tune
  require_relative 'epub_concordance'                   # epub_concordance.rb
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @md=@particulars.md
        @fnb=@md.fnb
        @env=@particulars.env
        loc=@env.path.url.output_tell
        unless @opt.cmd =~/q/
          tool=(@opt.cmd =~/[MVvz]/) \
          ? "#{@env.program.epub_viewer} #{@md.file.output_path.epub.dir}/#{@md.file.base_filename.epub}"
          : "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}"
          @opt.cmd=~/[MVvz]/ \
          ? SiSU_Screen::Ansi.new(@opt.cmd,'EPUB',tool).green_hi_blue
          : SiSU_Screen::Ansi.new(@opt.cmd,'EPUB',tool).green_title_hi
          SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@md.file.output_path.epub.dir}/#{@md.file.base_filename.epub}").flow if @opt.cmd =~/[MV]/
        end
        @env.processing_path.epub_bld #(@md)
        @env.processing_path.epub_cp_images(@md)
        dir_epub=@env.processing_path.epub
        SiSU_Env::InfoSkin.new(@md).select
        data=nil
        SiSU_Env::FileOp.new(@md).mkdir.output.epub
        @tuned_file_array=SiSU_EPUB::Source::XHTML_Environment.new(@particulars).tuned_file_instructions
        data=@tuned_file_array
        scr_endnotes=SiSU_EPUB::Source::Endnotes.new(@md,data).scroll
        toc=SiSU_EPUB::Source::Toc.new(@md,data).songsheet
        data=@tuned_file_array
        scr_toc=SiSU_EPUB::Source::ScrollHeadAndSegToc.new(@md,toc).in_common #watch
        SiSU_EPUB::Source::Seg.new(@md,data).songsheet
        SiSU_EPUB::Source::Output.new(@md).songsheet
      rescue
        SiSU_Errors::InfoError.new($!,$@,@opt.cmd,@opt.fns).error do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        unless @opt.cmd =~/[MV]/ #check maintenance flag
          texfiles=Dir["#{@env.processing_path.tune}/#{@opt.fns}*"]
          texfiles.each do |f|
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        SiSU_Env::Clear.new(@opt.cmd,@opt.fns).param_instantiate
        @@flag,@@scr,@@seg,@@seg_endnotes,@@seg_subtoc,@@seg_ad={},{},{},{},{},{}
        @@seg_total,@@tracker,@@loop_count,@@tablehead,@@number_of_cols=0,0,0,0,0
        @@seg_name,@@seg_name_html,@@seg_subtoc_array,@@seg_endnotes_array,@@segtocband,@@tablefoot=Array.new(7){[]}
        @@filename_seg,@@seg_url,@@fn,@@to_lev4,@@get_hash_to,@@get_hash_fn='','','','','','',''
        @@is4=@@is3=@@is2=@@is1=@@heading1=@@heading2=@@heading3=@@heading4=0
      end
    end
    private
    class XHTML_Environment
      def initialize(particulars)
        @particulars=particulars
        @md,@env=particulars.md,particulars.env
        @vz=SiSU_Env::GetInit.instance.skin
        @env,@css=particulars.env,SiSU_Style::CSS.new
      end
      def directories
        title=File.basename(@md.fns,'.rb')
        SiSU_Env::FileOp.new(@md).mkdir.output.epub
      end
      def tuned_file_instructions
        @tell=SiSU_Screen::Ansi.new(@md.opt.cmd)
        @md.opt.cmd=@md.opt.cmd.gsub(/H/,'h')
        @md.file_type='html' if @md.opt.cmd =~/[hon]/
        directories
        dal_array=@particulars.dal_array # dal file drawn here
        @tuned_file_array=SiSU_EPUB_Tune::Tune.new(dal_array,@md).songsheet
        @tuned_file_array
      end
    end
    class Endnotes
      include SiSU_EPUB_Format
      def initialize(md,data)
        @md,@data=md,data
      end
      def scroll
        @scr_endnotes=[]
        format_head_scroll=SiSU_EPUB_Format::HeadScroll.new(@md)
        @data.each do |dob|
          pg=dob.dup
          unless pg.is ==:code
            if pg.obj =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+ /
              endnote_array=[]
              if pg.obj=~/#{Mx[:en_a_o]}[\d*+].+?#{Mx[:en_a_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_a_o]}[\d*+]+(.+?)#{Mx[:en_a_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d*]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d*]+(.+?)#{Mx[:en_b_c]}/m)
              end
              if pg.obj=~/#{Mx[:en_b_o]}[\d+]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array = pg.obj.scan(/#{Mx[:en_b_o]}[\d+]+(.+?)#{Mx[:en_b_c]}/m)
              end
              endnote_array.flatten.each do |note|
                txt_obj={ txt: note }
                format_scroll=SiSU_EPUB_Format::FormatScroll.new(@md,txt_obj)
                @scr_endnotes << format_scroll.endnote_body
              end
            end
          end
        end
        @scr_endnotes
      end
    end
    class Toc
      @@toc={ seg: [], seg_mini: [], scr: [], ncx: [], opf: [] }
      @@seg_url=''
      @@firstseg=nil
      def initialize(md=nil,data='')
        @md,@data=md,data
        @vz=SiSU_Env::GetInit.instance.skin
        @epub=SiSU_EPUB_Format::HeadInformation.new(@md)
        @tell=SiSU_Screen::Ansi.new(@md.opt.cmd) if @md
        @make=SiSU_Env::ProcessingSettings.new(@md)
      end
      def songsheet #extracts toc for scroll & seg
        SiSU_Screen::Ansi.new(@md.opt.cmd,'Toc').txt_grey if @md.opt.cmd =~/[MVv]/
        toc=nil
        @@firstseg=nil
        @@toc={ seg: [], seg_mini: [], scr: [], ncx: [], opf: [] }
        md_opf_a_content,md_opf_a_spine,md_opf_a_guide=[],[],[]
        @nav_no=0
        @s_a_no,@s_b_no,@s_c_no=0,0,0
        @@toc[:ncx] << @epub.toc_ncx.open #epub ncx navmap
        @@toc[:ncx] << @epub.toc_ncx.head_open << @epub.toc_ncx.head << @epub.toc_ncx.head_close
        @@toc[:ncx] << @epub.toc_ncx.doc_title << @epub.toc_ncx.doc_author
        @@toc[:ncx] << @epub.toc_ncx.navmap_open
        @@toc[:opf] << @epub.metadata_opf.package_open
        @@toc[:opf] << @epub.metadata_opf.metadata
        @@toc[:opf] << @epub.metadata_opf.manifest_open
        @@toc[:seg] << %{<div class="content">\n<div class="substance">}
        @@toc[:scr] << %{<div class="content">\n<div class="substance">}
        md_opf_a_content << @epub.metadata_opf.manifest_content_sisu_toc
        if @make.build.toc?
          md_opf_a_spine << @epub.metadata_opf.spine_sisu_toc
          md_opf_a_guide << @epub.metadata_opf.guide_sisu_toc
        end
        @ncxo=[nil,false,false,false,false,false,false]
        @dob_toc2,@dob_toc3=nil,nil
        @ncx_cls=[]
        @level_a_first_occurrence=true
        @data.each do |dob|
          if dob.is==:heading \
          || dob.is==:heading_insert
            dob_toc=dob.dup
            toc=case dob_toc.ln
            when 1
              @s_a_no +=1
              name_s_a='section_a' + @s_a_no.to_s
              @nav_no+=1
              @nav_no2=@nav_no
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[4]
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[3]
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[2]
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[1]
              @ncxo[1],@ncxo[2],@ncxo[3],@ncxo[4]=true,false,false,false
              @epub.sections(dob_toc,name_s_a)
              @@toc[:ncx] << @epub.toc_ncx.navpoint(dob_toc,@nav_no,name_s_a) if dob_toc
              if @level_a_first_occurrence \
              && @make.build.toc?
                @nav_no+=1
                @@toc[:ncx] << @epub.toc_ncx.navmap_sisu_toc(@nav_no) #epub ncx navmap, toc
                @level_a_first_occurrence=false
              end
              md_opf_a_content << @epub.metadata_opf.manifest_content(dob_toc,name_s_a)
              md_opf_a_spine << @epub.metadata_opf.spine(dob_toc,name_s_a)
              md_opf_a_guide << @epub.metadata_opf.guide(dob_toc,name_s_a)
              SiSU_EPUB::Source::Toc.new(@md,dob_toc).level_1
            when 2
              @s_b_no +=1
              name_s_b='section_b' + @s_b_no.to_s
              @nav_no+=1
              @nav_no2=@nav_no
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[4]
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[3]
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[2]
              @ncxo[2],@ncxo[3],@ncxo[4]=true,false,false
              @epub.sections(dob_toc,name_s_b)
              @@toc[:ncx] << @epub.toc_ncx.navpoint(dob_toc,@nav_no,name_s_b) if dob_toc
              md_opf_a_content << @epub.metadata_opf.manifest_content(dob_toc,name_s_b)
              md_opf_a_spine << @epub.metadata_opf.spine(dob_toc,name_s_b)
              md_opf_a_guide << @epub.metadata_opf.guide(dob_toc,name_s_b)
              SiSU_EPUB::Source::Toc.new(@md,dob_toc).level_2
            when 3
              @s_c_no +=1
              name_s_c='section_c' + @s_c_no.to_s
              @nav_no+=1
              @nav_no3=@nav_no
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[4]
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[3]
              @ncxo[3],@ncxo[4]=true,false
              @epub.sections(dob_toc,name_s_c)
              @@toc[:ncx] << @epub.toc_ncx.navpoint(dob_toc,@nav_no,name_s_c) if dob_toc
              md_opf_a_content << @epub.metadata_opf.manifest_content(dob_toc,name_s_c)
              md_opf_a_spine << @epub.metadata_opf.spine(dob_toc,name_s_c)
              md_opf_a_guide << @epub.metadata_opf.guide(dob_toc,name_s_c)
              SiSU_EPUB::Source::Toc.new(@md,dob_toc).level_3
            when 4
              @ncx_cls=[]
              @nav_no+=1
              @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[4]
              @ncxo[4]=true
              @@toc[:ncx] << @epub.toc_ncx.navpoint(dob_toc,@nav_no) if dob_toc
              md_opf_a_content << @epub.metadata_opf.manifest_content(dob_toc)
              md_opf_a_spine << @epub.metadata_opf.spine(dob_toc)
              md_opf_a_guide << @epub.metadata_opf.guide(dob_toc)
              SiSU_EPUB::Source::Toc.new(@md,dob_toc).level_4
            when 5; SiSU_EPUB::Source::Toc.new(@md,dob_toc).level_5
            when 6; SiSU_EPUB::Source::Toc.new(@md,dob_toc).level_6
            else nil
            end
            toc.each do |k,d|
              d.gsub!(/(?:#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}.+?#{Mx[:en_b_c]})\s*/m,' ')
            end if toc
            if @@firstseg.nil? \
            and dob.ln==4 \
            and dob.name =~/\S+/
              @@firstseg=dob.name
            end
            if toc
              begin
                @@toc[:seg] << toc[:seg]
                @@toc[:scr] << toc[:seg]
              rescue
                SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
                  __LINE__.to_s + ':' + __FILE__
                end
              end
            end
          end
        end
        @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[4]
        @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[3]
        @@toc[:ncx] << @epub.toc_ncx.navpoint_close if @ncxo[2]
        @ncxo[1],@ncxo[2],@ncxo[3],@ncxo[4]=false,false,false,false
        md_opf_a_content << @epub.metadata_opf.manifest_images(@md.ec[:image])
        @@toc[:seg] << "</div>\n</div>"
        @@toc[:scr] << "</div>\n</div>"
        @@toc[:ncx] << @epub.toc_ncx.navmap_close
        @@toc[:ncx] << @epub.toc_ncx.close
        @@toc[:opf] << md_opf_a_content << @epub.metadata_opf.manifest_close
        @@toc[:opf] << @epub.metadata_opf.spine_open << md_opf_a_spine << @epub.metadata_opf.spine_close
        @@toc[:opf] << @epub.metadata_opf.guide_open << md_opf_a_guide << @epub.metadata_opf.guide_close
        @@toc[:opf] << @epub.metadata_opf.package_close
        @@toc[:opf]=@@toc[:opf].flatten
        SiSU_EPUB::Source::Output.new(@md,@@toc[:opf]).epub_metadata_opf
        SiSU_EPUB::Source::Output.new(@md,@@toc[:ncx]).epub_toc_ncx
        @md.firstseg=@@firstseg
        @@toc
      end
    protected
      def level_1
        dob=@data
        linkname,link=dob.obj.strip,dob.ocn
        if link \
        and link !~/#/ #% keep eye on link
          p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,link)
        end
        title=if dob.obj !~/Document Information/; linkname
        else
          link='metadata'
          %{<b><a href="#{link}#{Sfx[:epub_xhtml]}">#{linkname}</a></b>}
        end
        toc={}
        txt_obj={ txt: title }
        format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
        toc[:seg]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/ #check
          format_toc.lev0
        else format_toc.lev1
        end
        title=if dob.ocn ==0
          if dob.name =~/^meta/ \
          and dob.obj =~/Document Information/
            %{<a href="#docinfo">#{linkname}</a>}
          else linkname
          end
        else
          @@toc[:scr] <<  '<br />'
          link=if dob.ln; dob.ln
          else ''
          end
          %{<b><a href="##{link}">#{linkname}</a></b>}
        end
        txt_obj={ txt: title }
        format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
        toc[:scr]=if dob.name =~/^meta/ \
        and dob.obj =~/Document Information/
          format_toc.lev0
        else format_toc.lev1
        end
        toc
      end
      def level_2
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev2
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev2
        end
        toc
      end
      def level_3
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
        end
        txt_obj={ txt: linkname }
        format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev3
        if p_num
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev3
        end
        toc
      end
      def level_4
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn) if ocn
        if dob.ln==4
          seg_link=%{  <a href="#{dob.name}#{Sfx[:epub_xhtml]}">
    #{dob.obj}
  </a> }
          @@seg_url=dob.name
        elsif dob.obj =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
          seg_link=dob.obj.gsub(/^(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/,
            %{<a href="\\1#{Sfx[:epub_xhtml]}">} +
            %{\\1 \\2</a> })
        end
        p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn) if ocn
        txt_obj={ txt: seg_link }
        format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev4
        title=%{#{p_num.goto}#{linkname}</a>} if p_num
        txt_obj={ txt: title }
        format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev4
        toc
      end
      def level_5
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{@@seg_url}#{Sfx[:epub_xhtml]}#o#{ocn}">
    #{linkname}
  </a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev5
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev5
        end
        toc
      end
      def level_6
        dob=@data
        linkname,ocn=dob.obj.strip,dob.ocn
        toc={}
        if ocn \
        and ocn !~/#/
          p_num=SiSU_EPUB_Format::ParagraphNumber.new(@md,ocn)
          lnk_n_txt=%{  <a href="#{@@seg_url}#{Sfx[:epub_xhtml]}#o#{ocn}">
  #{linkname}
</a>}
          txt_obj={ txt: lnk_n_txt }
          format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev6
          title=%{#{p_num.goto}#{linkname}</a>}
          txt_obj={ txt: title }
          format_toc=SiSU_EPUB_Format::FormatToc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev6
        end
        toc
      end
    end
    class ScrollHeadAndSegToc < Toc
      def initialize(md='',toc='',links_guide_toc='')
        @md,@toc,@links_guide_toc=md,toc,links_guide_toc
        @vz=SiSU_Env::GetInit.instance.skin
      end
      def in_common
        toc_shared=[]
        segtoc=[]
        SiSU_Screen::Ansi.new(@md.opt.cmd,'Scroll & Segtoc').txt_grey if @md.opt.cmd =~/[MVv]/
        format_head_toc=SiSU_EPUB_Format::HeadToc.new(@md)
        dochead=format_head_toc.head
        dochead=dochead.gsub(/toc\.(html)/,'doc.\1') #kludge
        toc_shared << dochead #<< ads.div.major
        segtoc << format_head_toc.head #<< ads.div.major
        if SiSU_EPUB_Format::HeadToc.method_defined? :toc_head_escript
          toc_shared << format_head_toc.toc_head_escript
          segtoc << format_head_toc.toc_head_escript
        end
        if defined? @md.rights.all \
        and @md.rights.all
          rights=format_head_toc.rights.all
          rights=SiSU_EPUB_Tune::CleanXHTML.new(rights).clean
        end
        if defined? @md.notes.prefix_b \
        and @md.notes.prefix_b
          prefix_b=format_head_toc.prefix_b
          prefix_b=SiSU_EPUB_Tune::CleanXHTML.new(prefix_b).clean
        end
        seg_toc_band=format_head_toc.seg_head_navigation_band
        seg_toc_band_bottom=format_head_toc.seg_head_navigation_band_bottom
        tmp_head=nil
        doc_title_endnote=@md.title.full.gsub(/(\*+)/,'<sup><a href="#endnotes">\1</a></sup>')
        tmp_head=doc_title_endnote + "\n"
        txt_obj={ txt: tmp_head }
        format_txt_obj=SiSU_EPUB_Format::FormatTextObject.new(@md,txt_obj)
        toc_shared << format_txt_obj.center_bold
        segtoc << format_txt_obj.center_bold
        if defined? @md.creator.author \
        and @md.creator.author
          creator_endnote=@md.creator.author.gsub(/(\*+)/,%{&nbsp;<sup><a href="#notes">\\1</a></sup>})
          tmp_head=creator_endnote + "\n"
          txt_obj={ txt: tmp_head }
          format_txt_obj=SiSU_EPUB_Format::FormatTextObject.new(@md,txt_obj)
          toc_shared << format_txt_obj.center_bold
          segtoc << format_txt_obj.center_bold
        end
        segtoc << seg_toc_band
        tmp_head=nil
        if defined? @md.prefix_a \
        and @md.prefix_a
          tmp_head ||= %{#{@md.prefix_a}\n}
          toc_shared << tmp_head.dup
          segtoc << tmp_head.dup
        end
        tmp_head=nil
        toc_shared << @links_guide_toc
        if defined? @md.rights.all \
        and @md.rights.all
          toc_shared << rights
        end
        if defined? @md.prefix_b \
        and @md.prefix_b
          toc_shared << prefix_b
        end
        #Table of Contents added/appended here
        toc_shared << @toc[:scr]
        segtoc << @links_guide_toc
        segtoc << @toc[:seg]
        if defined? @md.rights.all \
        and @md.rights.all
          segtoc << rights
        end
        if defined? @md.prefix_b \
        and @md.prefix_b
          segtoc << prefix_b
        end
        #Segtoc tail added here
        segtoc << seg_toc_band_bottom
        segtoc << format_head_toc.xhtml_close
        segtoc=segtoc.flatten.compact #watch
        SiSU_EPUB::Source::Output.new(@md,segtoc).segtoc
        segtoc=[]
        @toc[:scr],@toc[:seg]=[],[]
        toc_shared
      end
    end
    class Table < SiSU_XHTML_Table::TableXHTML
    end
    class Seg < SiSU_EPUB_Seg::Seg
    end
    class Output
      def initialize(md,output='')
        @md,@output=md,output
        @epub_doc="#{@md.fnb}.epub"
        @epub_header=SiSU_EPUB_Format::HeadInformation.new(@md)
        @make=SiSU_Env::ProcessingSettings.new(@md)
        @make_file=SiSU_Env::CreateFile.new(@md.fns)
      end
      def songsheet
        mimetype
        metainf_container
        css
        images if @md.ec[:image]
       #concordance #uncomment to enable inclusion of concordance file
        output_zip
      end
      def mimetype
        out=@make_file.epub.mimetype
        out<<@epub_header.mimetype
        out.close
      end
      def metainf_container #container.xml file in META-INF directory
        out=@make_file.epub.metainf_cont
        out<<@epub_header.metainf_container
        out.close
      end
      def css
        out=@make_file.epub.xhtml_css
        out << SiSU_EPUB_Format::CSS.new.css_epub_xhtml
        out.close
      end
      def epub_toc_ncx
        begin
          out=@make_file.epub.toc_ncx
          @output.each do |para|
            unless para =~/\A\s*\Z/
              out.puts para
            end
          end
          out.close
        rescue
          SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
            __LINE__.to_s + ':' + __FILE__
          end
        end
      end
      def epub_metadata_opf
        begin
          out=@make_file.epub.metadata
          @output.each do |para|
            unless para =~/\A\s*\Z/
              out.puts para
            end
          end
          out.close
        rescue
          SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
            __LINE__.to_s + ':' + __FILE__
          end
        end
      end
      def images
        img_pth=@md.env.path.image_source_include
        img_src_pth=unless @md.opt.f_pth[:pth] =~/\/\S+?\/sisupod\/\S+?\/sisupod\/doc/
          @md.file.output_path.epub.rel_image
        else
          pt=/(\/\S+?\/sisupod\/\S+?\/sisupod)\/doc/.match(@md.opt.f_pth[:pth])[1]
          pt + '/image'
        end
        @md.ec[:image].each do |x|
          if FileTest.directory?("#{@md.env.processing_path.epub}/#{Ep[:d_oebps]}/image") \
          && FileTest.file?("#{img_src_pth}/#{x}")
            FileUtils::cp("#{img_src_pth}/#{x}","#{@md.env.processing_path.epub}/#{Ep[:d_oebps]}/image")
          elsif FileTest.directory?("#{@md.env.processing_path.epub}/#{Ep[:d_oebps]}/image") \
          && FileTest.file?("#{img_pth}/#{x}")
            FileUtils::cp("#{img_pth}/#{x}","#{@md.env.processing_path.epub}/#{Ep[:d_oebps]}/image")
          else STDERR.puts %{\t*WARN* did not find image - "#{x}" in #{img_src_pth} or #{img_pth} [#{__FILE__}:#{__LINE__}]}
          end
        end
      end
      def concordance
        SiSU_EPUB_Concordance::Source.new(@md.opt).read
      end
      def output_zip
        FileUtils::mkdir_p(@md.file.output_path.epub.dir) unless FileTest.directory?(@md.file.output_path.epub.dir)
        if FileTest.directory?(@md.env.processing_path.epub)
          pwd=Dir.pwd
          Dir.chdir(@md.env.processing_path.epub)
          system("
            zip -qXr9D #{@epub_doc} *
          ")
          FileUtils::mv(@epub_doc, @md.file.place_file.epub.dir)
          Dir.chdir(pwd)
          unless @md.opt.cmd.inspect =~/M/
            FileUtils::rm_r(@md.env.processing_path.epub)
          end
        end
      end
      def segtoc
        begin
          if @make.build.toc?
            filename_html_index=@make_file.epub.xhtml_index
            @output.each do |para|
              para=para.strip
              unless para =~/\A\s*\Z/
                filename_html_index.puts para,"\n"
              end
            end
            filename_html_index.close
          end
        rescue
          SiSU_Errors::InfoError.new($!,$@,@md.opt.cmd,@md.fns).error do
            __LINE__.to_s + ':' + __FILE__
          end
        end
      end
    end
  end
end
__END__
