# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
    sqlite

=end
module SiSU_DB_columns
  class Column_size
    def lt_title
      600
    end
    def lt_subtitle
      600
    end
    def lt_author
      600
    end
    def lt_author_title
      100
    end
    def lt_author_nationality
      100
    end
    def lt_illustrator
      600
    end
    def lt_translator
      600
    end
    def lt_prepared_by
      600
    end
    def lt_digitized_by
      600
    end
    def lt_subject
      600
    end
    def lt_date
      10
    end
    def lt_type
      600
    end
    def lt_description
      2000
    end
    def lt_publisher
      600
    end
    def lt_contributor
      600
    end
    def lt_format
      600
    end
    def lt_identifier
      256
    end
    def lt_source
      200
    end
    def lt_language
      30
    end
    def lt_language_char
      3
    end
    def lt_language_original
      30
    end
    def lt_language_original_char
      3
    end
    def lt_relation
      100
    end
    def lt_coverage
      100
    end
    def lt_rights
      2000
    end
    def lt_copyright
      2000
    end
    def lt_owner
      600
    end
    def lt_keywords
      600
    end
    def lt_comment
      600
    end
    def lt_loc
      30
    end
    def lt_dewey
      30
    end
    def lt_isbn
      16
    end
    def lt_pg
      10
    end
    def lt_abstract
      600
    end
    def lt_skin
      100
    end
    def lt_markup
      100
    end
    def lt_links
      100
    end
    def lt_information
      100
    end
    def lt_contact
      100
    end
    def lt_suffix
      600
    end
    def lt_filename
      256
    end
    def lt_types
      1
    end
    def lt_subj
      64
    end
    def lt_orig_pub
      400
    end
    def lt_orig_pub_date
      400
    end
    def lt_orig_pub_institution
      200
    end
    def lt_orig_pub_nationality
      200
    end
    def lt_writing_focus_nationality
      100
    end
    def lt_topic_register
      2000
    end
    def document_clean # restriction not necessary #12000 #2712
      60000
    end
    def document_body
      16000
    end
    def document_seg
      120
    end
    def document_seg_full
      120
    end
    def endnote_clean # restriction not necessary #12000 #2712
      60000
    end
    def endnote_body
      16000
    end
  end
end
__END__
