# coding: utf-8
=begin

 * Name: SiSU

 * Description: extract and print an XML rendition of document structure to screen

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, processing

=end
module SiSU_XML_Fictionbook
  require "#{SiSU_lib}/dal"
  require "#{SiSU_lib}/sysenv"
  require "#{SiSU_lib}/shared_txt"
  require "#{SiSU_lib}/shared_xml"
  include SiSU_Env
  include SiSU_Param
  include SiSU_text_utils
  include SiSU_XML_munge
  pwd=Dir.pwd
  class Source
    def initialize(opt)
      @opt=opt
      @sp='  '
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @dal_array=SiSU_DAL::Source.new(@opt).get
        SiSU_XML_Fictionbook::Source::Scroll.new(@dal_array,@md).songsheet
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Scroll <Source
      def initialize(data='',md='')
        @data,@md=data,md
        @trans=SiSU_XML_munge::Trans.new(@md)
        @dp=SiSU_Env::Info_env.new.digest.pattern
        @file_fictionbook=SiSU_Env::SiSU_file.new(@md,'fictionbook.xml').mkfile
        #@file_fictionbook=SiSU_Env::SiSU_file.new(@md,@md.fn[:fictionbook]).mkfile
      end
      def songsheet
        @t='fictionbook'
        @s=['section',          #@s=['body',
          'section',
          'section',
          'section',
          'section',
          'section',
          'section'
        ]
        head
        extract_endnotes
        structure
        #endnotes
        tail
      end
      def head
        version=SiSU_Env::Info_version.new.get_version
        rb_ver=SiSU_Env::Info_version.new.rbversion
        date_available=if defined? @md.date_available; "\n     <p>#{@md.date_available} Initial version</p>"
        else ''
        end
        date_modified=if defined? @md.date_available; "\n      <p>#{@md.date_modified} Last Modified</p>"
        else ''
        end
        head=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<FictionBook xmlns:xlink="http://www.w3.org/1999/xlink"
 xmlns="http://www.gribuser.ru/xml/fictionbook/2.0">
<description>
  <title-info>
    <genre match="100">***</genre>
    <author>
      <first-name>***</first-name>
      <middle-name>***</middle-name>
      <last-name>***</last-name>
    </author>
    <book-title>#{@md.full_title}</book-title>
    <annotation>
    </annotation>
    <date value="#{@md.date}">yyyy</date>
  </title-info>
     <document-info>
    <author>
      <first-name/>
      <last-name/>
      <nickname/>
    </author>
    <program-used>#{version[:project]} #{version[:version]} and #{rb_ver}</program-used>
    <date value="#{version[:date]}">#{version[:date]}</date>
    <src-ocr/>
    <version>1.0</version>
    <history>#{date_available}#{date_modified}
    </history>
  </document-info>
</description>
<body>
WOK
        put(head)
      end
      def extract_endnotes
        @endnotes=[]
        @data.each do |para|
          @endnotes << para.scan(/~\{(.+?)<#{@dp}>\}~/m)
        end
        @endnotes.flatten!
      end
      def endnotes
        @endnotes.each do |endnote|
          endnote.strip!
          endnote=@trans.markup_fictionbook(endnote)
          endnote="<p>#{endnote}</p>"
          util=SiSU_text_utils::Wrap.new(endnote,80,10)
          endnote=util.line_wrap
          put(endnote)
        end
      end
      def tail
        tail=<<WOK
</body>
</FictionBook>
WOK
        put(tail)
      end
      def markup(para,type='')
        para.strip!
        para=para.gsub(/^#{Mx[:lv_o]}[1-9]:\S*?#{Mx[:lv_c]}\s*/,'')
        para=para.gsub(/#{Mx[:id_o]}~(\d+);(?:\d:\d+|\S\d+);\S\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'[(\1)]')
        para=@trans.markup_fictionbook(para)
        para=if type.empty?; "<p>#{para}</p>"
        else "<#{type}><p>#{para}</p></#{type}>"
        end
        util=SiSU_text_utils::Wrap.new(para,80,10)
        wrap=util.line_wrap
      end
      def put(line)
        @file_fictionbook.puts line
        puts line if @md.cmd =~/V/
      end
      def structure_build_tag_close(lev,h)
        @sp='  '
        case h[0]
        when 1
          put("#{@sp*1}</#{@s[1]}>") if (lev <= 1) and h[1]
          put("</#{@s[0]}>")         if (lev == 0)
        when 2
          put("#{@sp*2}</#{@s[2]}>") if (lev <= 2) and h[2]
          put("#{@sp*1}</#{@s[1]}>") if (lev <= 1) and h[1]
          put("</#{@s[0]}>")         if (lev == 0)
        when 3
          put("#{@sp*3}</#{@s[3]}>") if (lev <= 3) and h[3]
          put("#{@sp*2}</#{@s[2]}>") if (lev <= 2) and h[2]
          put("#{@sp*1}</#{@s[1]}>") if (lev <= 1) and h[1]
          put("</#{@s[0]}>")         if (lev == 0)
        when 4
          put("#{@sp*4}</#{@s[4]}>") if (lev <= 4)
          put("#{@sp*3}</#{@s[3]}>") if (lev <= 3) and h[3]
          put("#{@sp*2}</#{@s[2]}>") if (lev <= 2) and h[2]
          put("#{@sp*1}</#{@s[1]}>") if (lev <= 1) and h[1]
          put("</#{@s[0]}>")         if (lev == 0)
        when 5
          put("#{@sp*5}</#{@s[5]}>") if (lev <= 5)
          put("#{@sp*4}</#{@s[4]}>") if (lev <= 4)
          put("#{@sp*3}</#{@s[3]}>") if (lev <= 3) and h[3]
          put("#{@sp*2}</#{@s[2]}>") if (lev <= 2) and h[2]
          put("#{@sp*1}</#{@s[1]}>") if (lev <= 1) and h[1]
          put("</#{@s[0]}>")         if (lev == 0)
        when 6
          put("#{@sp*6}</#{@s[6]}>") if (lev <= 6)
          put("#{@sp*5}</#{@s[5]}>") if (lev <= 5)
          put("#{@sp*4}</#{@s[4]}>") if (lev <= 4)
          put("#{@sp*3}</#{@s[3]}>") if (lev <= 3) and h[3]
          put("#{@sp*2}</#{@s[2]}>") if (lev <= 2) and h[2]
          put("#{@sp*1}</#{@s[1]}>") if (lev <= 1) and h[1]
          put("</#{@s[0]}>")         if (lev == 0)
        end
      end
      def structure_build(ds)
        @h=[0,false,false,false]
        put("<#{@s[0]}>")
        ds.each_with_index do |x,i|
          @ef=false
          case x[:lev]
          when /^1/
            structure_build_tag_close(1,@h)
            #put("#{@sp*1}<#{@s[1]}>\n#{x[:para]}\n#{@sp*1}#{x[:ocn]} #{x[:lev]} #{x[:hdr]}")
            y="#{@sp*1}<#{@s[1]}>\n#{x[:para]}"
            @h=[1,true,false,false]
          when /^2/
            structure_build_tag_close(2,@h)
            y="#{@sp*2}<#{@s[2]}>\n#{x[:para]}"
            @h=[2,true,true,false]
          when /^0:0/ #endnotes and metadata
            structure_build_tag_close(2,@h)
            y="#{@sp*2}<#{@s[2]}>\n#{x[:para]}"
            @h=[2,true,true,false]
            @ef=true if x[:hdr] =~/u0/
          when /^3/
            structure_build_tag_close(3,@h)
            y="#{@sp*3}<#{@s[3]}>\n#{x[:para]}"
            @h=[3,true,true,true]
          when /^4/
            structure_build_tag_close(4,@h)
            y="#{@sp*4}<#{@s[4]}>\n#{x[:para]}"
            @h[0]=4
          when /^m2/ #metadata
            structure_build_tag_close(4,@h)
            y="#{@sp*4}<#{@s[4]}>\n#{x[:para]}"
            @h[0]=4
          #when /^0:0/ #endnotes
          #  structure_build_tag_close(4,@h)
          #  y="#{@sp*4}<#{@s[4]}>\n#{x[:para]}"
          #  @h[0]=4
          #  @ef=true
          when /^5/
            structure_build_tag_close(5,@h)
            y="#{@sp*5}<#{@s[5]}>\n#{x[:para]}"
            @h[0]=5
          when /^6/
            structure_build_tag_close(6,@h)
            y="#{@sp*6}<#{@s[6]}>\n#{x[:para]}"
            @h[0]=6
          else
            y=if @md.cmd =~/V/; "#{x[:para]}"
            else nil
            end
          end
          put(y) if y
          endnotes if @ef
        end
        structure_build_tag_close(0,@h)
      end
      def structure
        data=@data
        @ds=[]
        c=0
        data.each do |para|
          rgx_headers=/#{Mx[:id_o]}~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)#{Mx[:id_c]}/
          if para =~rgx_headers
            x=(rgx_headers).match(para)
            if x[3] =~/^[hum]\d+/
              @ds[c]={}
              @ds[c][:ocn]=x[1]
              @ds[c][:lev]=x[2]
              @ds[c][:hdr]=x[3]
              @ds[c][:para]=markup(para,'title')
              #puts "#{x[1]} #{x[2]} #{x[3]}"
            else
              @ds[c]={}
              @ds[c][:para]=markup(para) if @md.cmd =~/V/
            end
            c+=1
            #puts "#{para} #{x[1]} #{x[2]} #{x[3]}"
          end
        end
        structure_build(@ds)
        @ds
      end
    end
  end
end
__END__
