# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: modules shared by the different db types, dbi, postgresql,
   sqlite

=end
module SiSU_DB_index
  class Index                                           # create documents Indexes def initialize(opt,conn='',sql_type='')
    def initialize(opt,conn,file,sql_type='')
      @opt,@conn,@file,@sql_type=opt,conn,file,sql_type
    end
    def create_indexes                                                           # check added from pg not tested
      def base
        print "\n          create documents common indexes\n" unless @opt.cmd =~/q/
        @conn.execute('
          CREATE INDEX object_nr ON documents(ocn);
          CREATE INDEX digest_clean ON documents(digest_clean);
          CREATE INDEX digest_all ON documents(digest_all);
          CREATE INDEX lev1 ON documents(lev1);
          CREATE INDEX lev2 ON documents(lev2);
          CREATE INDEX lev3 ON documents(lev3);
          CREATE INDEX lev4 ON documents(lev4);
          CREATE INDEX lev5 ON documents(lev5);
          CREATE INDEX lev6 ON documents(lev6);
          CREATE INDEX endnote_nr ON endnotes(nr);
          CREATE INDEX digest_en ON endnotes(digest_clean);
          CREATE INDEX endnote_nr_asterisk ON endnotes_asterisk(nr);
          CREATE INDEX endnote_asterisk ON endnotes_asterisk(clean);
          CREATE INDEX digest_en_asterisk ON endnotes_asterisk(digest_clean);
          CREATE INDEX endnote_nr_plus ON endnotes_plus(nr);
          CREATE INDEX endnote_plus ON endnotes_plus(clean);
          CREATE INDEX digest_en_plus ON endnotes_plus(digest_clean);
          CREATE INDEX title ON metadata(title);
          CREATE INDEX filename ON metadata(filename)
        ') unless @opt.cmd =~/q/
      end
      def text
        print "\n          create documents text indexes\n" unless @opt.cmd =~/q/
        @conn.execute('
          CREATE INDEX clean ON documents(clean);
          CREATE INDEX endnote ON endnotes(clean);
        ') unless @opt.cmd =~/q/
      end
      base
      @opt.cmd=~/D/ || @opt.mod=~/psql/ ? '' : text
    end
  end
end
__END__
