=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: zap wipe clean previous output of the type specified

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Zap
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  pwd=Dir.pwd
  class Source
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new(@opt.fns)
      @zap_path="#{@env.path.output}/#{@env.fnb}"
      @zap=SiSU_Env::Clean_output.new(@opt)
    end
    def read
      if SiSU_Env::Info_settings.new.permission?('zap')
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"Clean files related to processing #{@opt.cmd} ->","#{@opt.fns} -> #@zap_path")
        @zap.zap
        @zap.zap_map
      else tell=SiSU_Screen::Ansi.new(@opt.cmd,'use of -Z (zap) has not enabled in sisurc.yml')
      end
      tell.warn unless @opt.cmd =~/q/
    end
  end
end
__END__
