=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: modules shared by db and flatfile output generators, mostly xml/xhtml/html formatting

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Format_Shared
  require "#{SiSU_lib}/defaults"
  include SiSU_Viz
  class CSS_Format
    require "#{SiSU_lib}/defaults"
    def initialize(content=nil,id=nil,ocnd='',ocns='',lv='',hname=nil)
      content.gsub!(/<:i[12]>/,'')
      @content=content
      @id=@ocn=id
      @ocnd,@ocns=ocnd,ocns
      @lv=@notenumber=lv.to_s
      @hname=hname.to_s
      @tab="\t"
      @url_brace=SiSU_Viz::Skin.new.url_decoration
      # lots introduced to do html tables in db
      @@tablehead,@@tablefoot=[],[]
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def urls(data)
      @words=[]
      data.each do |word|
        @words << if word=~/\{(.+?)\}((?:https?|ftp)\S+|image)/
          if word =~/\{(.+?)\}((?:https?|ftp)\S+|image)([.,](?:\s|$))/
            m,u,d=/\{(.+?)\}((?:https?|ftp)\S+|image)([.,](?:\s|$))/.match(word).captures
          else m,u=/\{(.+?)\}((?:https?|ftp)\S+|image)/.match(word).captures
            d=''
          end
          case m
          when /\.png|\.jpg|\.gif|c=|\d+x\d+/
            w,h=/(\d+)x(\d+)/.match(m).captures if m =~/\d+x\d+/
            w=%{width="#{w}"} if w
            h=%{height="#{h}"} if h
            c=m[/"(.+?)"/m,1]
            caption=%{<br /><p class="caption">#{c}</p>} if c
            png=m.scan(/\S+/)[0]
            #image_path=if @md.fns =~/\.-ss[tm]$/; @env.url.images_external
            #else                                  @env.url.images_local
            #end
            ins=if u and u.strip !~/^image$/
              %{<a href="#{u}">[#{png}]</a>#{caption}}
            else %{[#{png}] #{caption}}
            end
            word.gsub!(/\{.+?\}((?:https?|ftp)\S+|image)/,ins)
          else
            link=m[/(.+)/m]
            png=m.scan(/\S+/)[0].strip
            link=link.strip
            ins=%{<a href="#{u}">#{link}</a>#{d}}
            #ins=%{#{link} <a href="#{u}">[link]</a>#{d}}
            word.gsub!(/\{.+?\}(?:https?|ftp)\S+/,ins)
          end
          word
        else word
        end
        word
      end
      @words
    end
    def markup(para)
      if para =~/\{.+?\}((?:http|ftp)\S+|image)/
        @word_mode=para.scan(/\{.+?\}(?:(?:https?|ftp)\S+|image)|\S+/)
        word_mode=urls(para)
        words=word_mode.join(' ')
        para.gsub!(/.+/,words)
      end
      if (para !~/(\"\w+:\/\/\S+?\"|>\s*\w+:\/\/\w+?\S*<)/) #url markup http etc.
        if para=~/\w+:\/\/\S+?\.\S+?[.,] /
          para.gsub!(/(\w+:\/\/\S+?\.\S+?)([.,] )/,%{#{@url_brace.xml_open}<a href="\\1" target="_top">\\1</a>#{@url_brace.xml_close}\\2}) #full stops ! have been a bother
        else
          para.gsub!(/(\w+:\/\/\S+?\.\S+)/,%{#{@url_brace.xml_open}<a href="\\1" target="_top">\\1</a>#{@url_brace.xml_close}})
        end
      end
      if (para =~/[ ^](?:https?|ftp):\/\/\S+/) #url markup http leftovers watch carefully may accept too much 2004w46
        if para=~/([ ^])((?:https?|ftp):\/\/\S+?)([\.,] )/
        para.gsub!(/([ ^])((?:https?|ftp):\/\/\S+?)([\.,] )/,%{\\1#{@url_brace.xml_open}<a href="\\2" target="_top">\\2</a>#{@url_brace.xml_close}\\3}) #full stops ! have been a bother
        else
          para.gsub!(/([ ^])((?:https?|ftp):\/\/\S+)/,%{\\1#{@url_brace.xml_open}<a href="\\2" target="_top">\\2</a>#{@url_brace.xml_close}})
        end
      end
      para
    end
    def paragraph
      %{#{@tab*1}<p class="h#@lv" id="#@ocn" type="substantive" header="#@hname">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def endnote
      @content=markup(@content)
      <<GSUB
#{@tab*1}<p class="endnote" name="note_#@notenumber" from="#@ocn">
#{@tab*2}<a name="_#@notenumber" href="#-#@notenumber">#@notenumber.</a> <note>#@content</note>
#{@tab*1}</p>
GSUB
    end
    def lev_toc_hname
      %{#{@tab*1}<p class="toc#@lv" header="#@hname"><a href="##@ocn">\n#{@tab*2}#@content\n#{@tab*1}</a></p>\n}  << "\n"
    end
    def lev_toc
      %{#{@tab*1}<p class="toc#@lv"><a href="##@ocn">\n#{@tab*2}#@content\n#{@tab*1}</a></p>\n}  << "\n"
    end
    def lev4_plus
      %{#{@tab*1}<p class="h#@lv" id="#@ocn" type="substantive" header="#@hname">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def lev4_minus
      %{#{@tab*1}<p class="h#@lv" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def norm_comment
      %{#{@tab*1}<p class="norm" id="none" type="comment">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}
    end
    def norm
      @content=markup(@content)
      %{#{@tab*1}<p class="norm" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}
    end
    def indent1
      @content=markup(@content)
      %{#{@tab*1}<p class="indent1" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}
    end
    def indent2
      @content=markup(@content)
      %{#{@tab*1}<p class="indent2" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}
    end
    def para_table
      %{<p class="norm" align="left"><font #{@vz.font_small} #{@vz.font_color} #{@vz.font_face}>}
    end
    def ocn
      %{#{@tab*1}<p class="ocn">#@ocn</p>} << "\n"
    end
   def html_table # get rid of use html_table
      @new_content=[]
      @content.split(/\n/).each do |parablock|
        m=parablock[/<!f(.+?)!>/,1]
        @@tablefoot<<m if m
        parablock.gsub!(/<!f.+?!>/,'')
        @@tablehead=1 if parablock =~/<!Th¡/
        parablock.gsub!(/<!Th?¡.+?!~(\d+)>/,
           #%{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center"><tr><td valign="top" align="justify"><p class="norm" id="\\1">  </p> </td><td>\n} +
           %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">})
        if parablock =~/<!TZ!>/
          tablefoot=[]
          @@tablefoot.each {|x| tablefoot << %{<p align="center"><font size=2><i>#{x}</i></font></p>\n}}
          @@tablefoot=[]
          parablock.gsub!(/<!TZ!>/,
            %{#{@vz.table_close}\n}) # +
            #%{#{tablefoot}})
        end
        if @@tablehead == 1
          if parablock =~/¡¡/
            parablock.gsub!(/<!¡¡(\d+?)¡/,
              %{\n<tr>} +
              %{\n<td width="\\1%" valign="top">} +
              %{#{para_table}<b>})
            parablock.gsub!(/¡¡(\d+?)¡/,
              %{</b></td><td width="\\1%" valign="top">} +
              %{#{para_table}<b>})
            parablock.gsub!(/!>/, '</b></td></tr>')
            @@tablehead=0 #if parablock =~/!>/
          end
          parablock
        else
          parablock.gsub!(/<!¡¡(\d+?)¡/,
            %{\n<tr>} +
            %{\n<td width="\\1%" valign="top">} +
            %{#{para_table}})
          parablock.gsub!(/¡¡(\d+?)¡/,
            %{</td><td width="\\1%" valign="top">} +
            %{#{para_table}})
          parablock.gsub!(/!>/, '</td></tr>')
          parablock
        end
        @new_content << parablock
      end
      @new_content.join
    end
  end
  class CSS_Format_generic #does CSS_Format in one definition, needs to be told about class, despite brevity of generic, easier to see structure with CSS_Format
    def initialize(css_class='',content='',id=nil,ocnd=nil,ocns=nil,lv='',hname=nil)
      @tab="\t"
      @class=css_class
      @content=content
      @lv=@notenumber=lv.to_s
      #@ocn=ocn.to_s
      @hname=hname.to_s
      @id=@ocn=id
    end
    def paragraph
      css_class=%{class="#@class" }
      if @ocn
        id=%{id="#@ocn" }
        type=%{type="substantive" }
      else
        id=%{id="none" }
        type=%{type="comment" }
      end
      header=%{header="#@hname" } if @hname
      %{#{@tab*1}<p #{css_class}#{id}#{type}#{header}>\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def para
      paragraph
    end
  end
end
__END__

