=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: modules shared by the different db types, dbi, postgresql, sqlite

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_DB_remove
  class Remove
    def initialize(opt,conn='' )
      @opt,@conn=opt,conn
      @md=SiSU_Param::Parameters.new(@opt).get
      @fnb=@md.fnb
      @db=SiSU_Env::Info_db.new
    end
    def remove
      del=@conn.select_one(%{ SELECT tid FROM metadata WHERE filename LIKE '#{@opt.fns}'; })
      if del
        del_id=del.join
        #@conn.execute("BEGIN")
        @conn.execute(%{
          DELETE FROM endnotes WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM endnotes_asterisk WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM endnotes_plus WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM documents WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM urls WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM metadata WHERE tid LIKE '#{del_id}';
          /*
          DELETE FROM documents WHERE documents.metadata_tid LIKE '#{del_id}';
          DELETE FROM endnotes WHERE endnotes.metadata_tid LIKE '#{del_id}';
          DELETE FROM endnotes_asterisk WHERE endnotes_asterisk.metadata_tid LIKE '#{del_id}';
          DELETE FROM endnotes_plus WHERE endnotes_plus.metadata_tid LIKE '#{del_id}';
          DELETE FROM urls WHERE urls.metadata_tid LIKE '#{del_id}';
          DELETE FROM metadata WHERE metadata.tid LIKE '#{del_id}';
          */
        })
        #@conn.execute("COMMIT")
      else
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"no such file in database #{@db.db_psql}::#{@opt.fns}")
        tell.puts_grey #if @opt.cmd.include? ?v
      end
    end
  end
end
__END__
