=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: css stylesheets

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Style
  require "#{SiSU_lib}/sysenv"
  require "#{SiSU_lib}/defaults"
  class CSS
    def initialize
      @vz=SiSU_Env::Get_init.instance.skin
      #@vz=SiSU_Viz::Skin.new
    end
    def fonts
      @vz.font_fonts
    end
    def html_tables                               #stylesheet for css table_pages
<<WOK
/* SiSU table output stylesheet */
  body {
    color: black;
    background: #{@vz.color_white};
  }
  p {
    display: block;
    line-height: 1.5;
    font-family: #{fonts};
  }
  a:link {
    color: #{@vz.color_blue_ink};
    text-decoration: none;
  }
  a:visited {
    color: #{@vz.color_blue_ink};
    text-decoration: none;
    /* background-color: #{@vz.color_blue_tinge}; */
  }
  a:hover {
    color: #{@vz.color_black};
    text-decoration: underline;
    background-color: #{@vz.color_yellow_light};
  }
  a:active {
    color: #{@vz.color_blue_ink};
    text-decoration: underline;
  }
WOK
    end
    def html                                      #stylesheet for css html pages == html.css
<<WOK
/* SiSU css default stylesheet */
  body {
    color: black;
    background: #{@vz.color_white};
  }
/*
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th, td {
      display: inline;
    }
*/
  a:link {
    color: #{@vz.color_blue_ink};
    text-decoration: none;
  }
  a:visited {
    color: #{@vz.color_blue_ink};
    text-decoration: none;
  }
/*
  a:hover {
    color: #{@vz.color_black};
    border-bottom: 2px solid #777777;
    background-color: #{@vz.color_yellow_light};
  }
*/
  a:hover img {
    background-color: #{@vz.color_white};
  }
  a:active {
    color: #{@vz.color_blue_ink};
    text-decoration: underline;
  }
  div {
    margin-left: 0;
    margin-right: 0;
  }
  div.p {
    margin-left: 5%;
    margin-right: 1%;
  }
  #top_band {
    position: absolute;
    top: 0;
    bottom: 80px;
    width: 100%;
  }
  #top_band_search {
    position: absolute;
    top: 0px;
    right: 0px;
    margin-left: 75%;
    width: 20%;
  }
  #column_left {
    position: absolute;
    top: 80px;
    left: 0;
    margin-left: 0;
    width: 20%;
  }
  #column_center {
    position: absolute;
    top: 80px;
    margin-left: 20%;
    width: 55%;
  }
  #column_right {
    position: absolute;
    top: 80px;
    right: 0px;
    margin-left: 75%;
    width: 25%;
  }
  #pane_major {
    position: absolute;
    top: 0px;
    left: 0;
    margin-left: 0;
    width: 80%;
  }
  #pane_minor {
    position: absolute;
    top: 0px;
    right: 0px;
    margin-left: 75%;
    width: 20%;
  }
  p {
    display: block;
    font-family: #{fonts};
    font-size: 100%;
    font-weight: normal;
    line-height: 150%;
    text-align: left;
    margin-left: 10mm;
    text-indent: 0mm;
    margin-top: 3px;
    margin-bottom: 3px;
    margin-right: 5mm;
  }
  p.norm {
    text-align: justify;
  }
  p.code {
    font-family: monospace;
    text-align: left;
  }
  p.caption {
    text-align: left;
    font-size: 80%;
    display: inline;
  }
  p.endnote {
    font-family: #{fonts};
    font-size: 96%;
    font-weight: normal;
    line-height: 120%;
    text-align: left;
    margin-left: 10mm;
    text-indent: 0mm;
    margin-top: 3px;
    margin-bottom: 3px;
    margin-right: 15mm;
  }
  p.endnote_indent {
    font-family: #{fonts};
    font-size: 96%;
    font-weight: normal;
    line-height: 120%;
    text-align: left;
    margin-left: 15mm;
    text-indent: 0mm;
    margin-top: 3px;
    margin-bottom: 3px;
    margin-right: 15mm;
  }
  p.center {
    text-align: center;
  }
  p.bold {
    font-weight: bold;
  }
  p.centerbold {
    text-align: center;
    font-weight: bold;
  }
  p.em {
    font-weight: bold;
    font-style: normal;
    background: #fff3b6;
  }
  p.ocn, p.paranum {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 5px;
    color: #777777;
    margin-right: 5px;
    text-align: right;
  }
  p.ocn_off, p.no_paranum {
    display: none;
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 5px;
    color: #777777;
    margin-right: 5px;
    text-align: right;
  }
  p.small {
    font-size: 80%;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 6px;
    text-align: left;
  }
  p.tiny {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-right: 6px;
    text-align: left;
  }
  p.tiny_left {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-left: 0px;
    margin-right: 0px;
    text-align: left;
  }
  p.tiny_right {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-right: 5mm;
    text-align: right;
  }
  p.pane {
    font-size: 80%;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 2mm;
    margin-right: 4px;
    text-align: left;
  }
  p.pane_title {
    font-weight: bold;
    font-size: 80%;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 2mm;
    margin-right: 4px;
    text-align: left;
  }
  p.pane_blurb {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 2mm;
    margin-right: 4px;
    text-align: left;
  }
  p.pane_link {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 4mm;
    margin-right: 4px;
    text-align: left;
  }
  p.pane_indent {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 4mm;
    margin-right: 4px;
    text-align: left;
  }
  p.concordance_word {
    line-height: 150%;
    font-weight: bold;
    display: inline;
    margin-top: 4px;
    margin-bottom: 1px;
  }
  p.concordance_count {
    font-size: 80%;
    color: #777777;
    display: inline;
    margin-left: 0mm;
    text-indent: 0mm;
  }
  p.concordance_object {
    font-size: 80%;
    font-weight: normal;
    line-height: 120%;
    text-align: left;
    margin-left: 15mm;
    text-indent: 0mm;
    margin-top: 1px;
    margin-bottom: 3px;
  }
  p.quickref{
    font-size: 10px;
    font-style: italic;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-right: 5px;
    text-align: left;
  }
  p.bigref{
    font-size: 11px;
    font-weight: bold;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-right: 5px;
    text-align: center;
  }
  p.i1 {margin-left: 20mm;}
  p.i2 {margin-left: 25mm;}
  p.i3 {margin-left: 30mm;}
  p.i4 {margin-left: 35mm;}
  p.i5 {margin-left: 40mm;}
  p.i6 {margin-left: 45mm;}
  p.i7 {margin-left: 50mm;}
  p.i8 {margin-left: 55mm;}
  p.i9 {margin-left: 60mm;}

  table { }
  tr { }
  th, td { }
  p.left, th.left, td.left {
    text-align: left;
  }
  p.right, th.right, td.right {
    text-align: right;
  }

  h1, h2, h3, h4, h5, h6 {
    display: block;
    font-family: #{fonts};
    font-weight: bold;
    line-height: 120%;
    margin-left: 10mm;
    margin-right: 10mm;
    text-align: left;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h1.center, h2.center, h3.center, h4.center, h5.center, h6.center {
    text-align: center;
  }
  ul {
    list-style: none;
  }
  ul.horizontal {
    list-style: none;
  }
  ul.vertical {
    list-style: none;
  }
  li {
    background: url(../image/bullet_red.png) no-repeat 0px 6px;
    padding-left: 20px;
    display: block;
    font-family: #{fonts};
    /* font-size: 100%; */
    font-weight: normal;
    line-height: 100%;
    text-align: left;
    margin-left: 10mm;
    text-indent: 0mm;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 5mm;
  }
  li.bullet {
    line-height: 150%;
    margin-left: 0mm;
    margin-right: 0mm;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i1 {
    margin-left: 20mm;
    line-height: 150%;
    margin-left: 5mm;
    margin-right: 5mm;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i2 {
    margin-left: 25mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i3 {
    margin-left: 30mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i4 {
    margin-left: 35mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i5 {
    margin-left: 40mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i6 {
    margin-left: 45mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i7 {
    margin-left: 50mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i8 {
    margin-left: 55mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  li.i9 {
    margin-left: 60mm;
    line-height: 150%;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  #horizontal_links {
    background: #eeeeee;
    margin-left: 5%;
    margin-right: 5%;
  }
  #horizontal {
    margin: 0;
    padding: 0 0 0 10px;
    border-top: 1px solid #000077;
    border-bottom: 1px solid #000077;
  }
  #horizontal li {
    margin: 0 0 0 0;
    padding: 0 16px 0 0;
    display: inline;
    list-style-type: none;
    text-align: left;
    background: none;
  }
  #horizontal a {
    /* font-weight: normal; */
    /* float: left; */
    line-height: 12px;
    margin: 0 0 0 0;
    text-decoration: none;
    color: #000077;
  }
  #horizontal a.active, #horizontal a:hover {
    border-bottom: 2px solid #777777;
    padding-bottom: 2px;
    /* font-weight: bold; */
    color: #000077;
  }
  #horizontal a:hover {
    color: #000077;
  }
  #document_versions {
    position: absolute;
    top: 10mm;
    right: 2%;
    width: 12%;
    /* background: #ffffff; */
    float: right;
  }
  #vertical_links {
    position: absolute;
    top: 10mm;
    right: 0px;
    width: 20%;
    background: #dddddd;
    float: right;
  }
  #vertical {
    /* background: none; */
    padding: 0 12px 0px 0px;
    /* border-top: 2px solid #000077; */
    /* border-bottom: 2px solid #000077; */
    /* margin-left: 33%; */
    margin-left: 2%;
    margin-right: 2%;
  }
/*
  #vertical {
    padding: 0 12px 0px 0px;
    border-top: 2px solid #000077;
    border-bottom: 2px solid #000077;
    margin-left: 33%;
    margin-right: 33%;
  } */
  #vertical li {
    display: block;
    list-style-type: none;
  }
  #vertical a {
    /* font-weight: normal; */
    line-height: 12px;
    text-decoration: none;
    color: #000077;
  }
  #vertical a.active, #vertical a:hover {
    border-bottom: 2px solid #777777;
    padding-bottom: 2px;
    /* font-weight: bold; */
    color: #000077;
  }
  li.doc {
    background: url(../image/bullet_doc.png) no-repeat 0 0;
    padding-left: 16px;
    margin-left: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 0px;
    font-size: 8px;
    font-style: normal;
    text-align: left;
  }
  li.ref {
    background: none;
    padding-left: 0;
    margin-left: 0;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    font-size: 8px;
    font-style: normal;
    text-align: left;
  }
  li.refcenter {
    /* background: url(../image/bullet_doc.png) no-repeat 0 0; */
    background: none;
    padding-left: 20px;
    margin-left: 10%;
    font-size: 9px;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    text-align: center;
  }
  li.refbold {
    background: url(../image/bullet_doc.png) no-repeat 0 0;
    /* padding-left: 0px; */
    padding-left: 16px;
    margin-left: 0;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 10mm;
    font-size: 8px;
    font-weight: bold;
    text-align: left;
  }
  h1 {
    font-size: 120%;
    margin-top: 20px;
  }
  h2 {
    font-size: 115%;
    margin-top: 20px;
  }
  h3 {
    font-size: 110%;
    margin-top: 20px;
  }
  h4 {
    font-size: 105%;
  }
  h5 {
    font-size: 100%;
  }
  h6 {
    font-size: 100%;
  }
  h1.norm, h2.norm, h3.norm {
    font-size: 110%;
    margin-left: 10mm;
    margin-right: 15mm;
    text-align: left;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h1.top_band {
    display: inline;
    text-align: left;
    margin-top: 0;
    margin-left: 4mm;
    text-indent: 0mm;
    font-weight: bold;
    font-size: 120%;
  }
  h2.top_band_tiny {
    font-size: 10px;
    font-weight: normal;
    margin-top: 0px;
    margin-left: 4mm;
    text-indent: 0mm;
    margin-bottom: 0px;
    color: #777777;
    margin-left: 140px;
    margin-right: 0px;
    text-align: left;
  }
  p.top_band {
    display: inline;
    text-align: left;
    margin-top: 0;
    margin-left: 140px;
    text-indent: 0mm;
    font-weight: bold;
    font-size: 120%;
  }
  p.top_band_tiny {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-left: 140px;
    margin-right: 0px;
    text-align: left;
  }
  p.top_band_image {
    float: left;
    display: inline;
    text-align: left;
    margin-top: 0;
    margin-left: 1mm;
    text-indent: 0mm;
    margin-right: 1mm;
  }
  h4.norm, h5.norm, h6.norm {
    font-size: 100%;
    margin-left: 10mm;
    margin-right: 15mm;
    text-align: left;
    margin-top: 10px;
    margin-bottom: 0px;
  }
  h1.i {margin-left: 10mm;}
  h2.i {margin-left: 15mm;}
  h3.i {margin-left: 20mm;}
  h4.i {margin-left: 25mm;}
  h5.i {margin-left: 30mm;}
  h6.i {margin-left: 35mm;}
  h1.banner {
    font-weight: bold;
    text-align: center;
    font-size: 120%;
    margin-left: 10mm;
    margin-right: 15mm;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h1.subbanner {
    font-weight: bold;
    text-align: center;
    font-size: 115%;
    margin-left: 10mm;
    margin-right: 15mm;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h2.banner {
    font-weight: bold;
    text-align: center;
    font-size: 110%;
    margin-left: 10mm;
    margin-right: 15mm;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h3.banner {
    font-weight: bold;
    text-align: center;
    color: #990000;
    font-size: 105%;
    margin-left: 10mm;
    margin-right: 15mm;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h4.banner {
    font-weight: bold;
    text-align: center;
    color: #ff0000;
    font-size: 100%;
    margin-left: 10mm;
    margin-right: 15mm;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h5.banner {
    font-weight: bold;
  }
  h6.banner {
    font-weight: bold;
  }
  h1.toc {
    margin-left: 0mm;
    font-size: 115%;
    margin-top: 6px;
    margin-bottom: 6px;
    line-height: 150%;
  }
  h2.toc {
    margin-left: 5mm;
    font-size: 110%;
    margin-top: 6px;
    margin-bottom: 6px;
    line-height: 140%;
  }
  h3.toc {
    margin-left: 10mm;
    font-size: 105%;
    margin-top: 6px;
    margin-bottom: 6px;
    line-height: 120%;
  }
  h4.toc {
    margin-left: 15mm;
    font-weight: normal;
    font-size: 100%;
    margin-top: 6px;
    margin-bottom: 6px;
    line-height: 120%;
  }
  h5.toc {
    margin-left: 20mm;
    font-weight: normal;
    font-size: 95%;
    margin-top: 6px;
    margin-bottom: 6px;
    line-height: 110%;
  }
  h6.toc {
    margin-left: 25mm;
    font-weight: normal;
    font-size: 90%;
    margin-top: 6px;
    margin-bottom: 6px;
    line-height: 110%;
  }
/* microtoc (for later) --> */
  h1.microtoc {
    margin-left: 0mm;
    font-size: 115%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h2.microtoc {
    margin-left: 5mm;
    font-size: 110%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h3.microtoc {
    margin-left: 10mm;
    font-size: 105%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h4.microtoc {
    margin-left: 15mm;
    font-weight: normal;
    font-size: 100%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h5.microtoc {
    margin-left: 20mm;
    font-weight: normal;
    font-size: 95%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h6.microtoc {
    margin-left: 25mm;
    font-weight: normal;
    font-size: 90%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
/* subtoc --> */
  h5.subtoc {
    margin-left: 20mm;
    margin-right: 34%;
    font-weight: normal;
    font-size: 80%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h6.subtoc {
    margin-left: 25mm;
    margin-right: 34%;
    font-weight: normal;
    font-size: 75%;
    margin-top: 0px;
    margin-bottom: 0px;
  }
  h1.c, h2.c, h3.c, h4.c, h5.c, h6.c, p.c {
    text-align: center
  }
  h1.red, h2.red, h3.red, h4.red, h5.red, h6.red {
    text-align: center;
    color: #ff0000;
    margin-left: 5mm;
    text-indent: 5mm;
    margin-top: 30px;
    margin-bottom: 20px;
    margin-right: 15mm;
  }
  h1.ruby, h2.ruby, h3.ruby, h4.ruby, h5.ruby, h6.ruby {
    text-align: center;
    color: #990000;
    margin-left: 5mm;
    text-indent: 5mm;
    margin-top: 30px;
    margin-bottom: 20px;
    margin-right: 15mm;
  }
/*
  table.hidden {
    color: #ffffff;
    text-decoration: none;
  }
  td.hidden {
    color: #ffffff;
    background-color: #000000;
  }
  td.hidden a.active, div.hidden a:hover {
    color: #ffffff;
    background-color: #000000;
  }
  td.hidden a:hover {
    text-decoration: none;
  }
  div.hidden a {
    line-height: 12px;
    margin: 0 0 0 0;
    text-decoration: none;
    color: #000077;
  }
  div.hidden a.active, div.hidden a:hover {
    text-decoration: none;
  }
  div.hidden a:hover {
    text-decoration: none;
  }
*/
WOK
    end
    def homepage                                  #stylesheet for index, home page
<<WOK
  body {color: black; background: #{@vz.color_white}; margin:10px 10px 0px 10px; padding:0px;}
  p { line-height: 1.5 }
  a:link      {color: #{@vz.color_blue_ink};   text-decoration: none; }
  a:visited       {color: #{@vz.color_blue_ink};   text-decoration: none; }
  a:hover {color: #{@vz.color_black}; text-decoration: underline; background-color: #{@vz.color_yellow_light};}
  a:active {color: #{@vz.color_blue_ink}; text-decoration: underline;}
  #banner {
    background:#{@vz.color_white};
  }
  #column_left {
    width:25%;
    float:left;
    background:#b9d4dd;
    padding-bottom:10px;
  }
  #column_center {
    width:55%;
    float:left;
    background:#{@vz.color_white};
    padding-bottom:10px;
  }
  #column_right {
    width:20%;
    float:left;
    background:#b9d4dd;
    padding-bottom:10px;
  }
  p,h1,pre {
    font-family: #{fonts};
    margin:0px 10px 10px 10px;
  }
  h1 {
    font-size:14px;
    padding-top:10px;
  }
  #column_right p { font-size:12px}
  #banner h1 { margin:0px; padding:10px}
WOK
    end
    def html_bk                                   #stylesheet for html... check use
<<WOK
    document {
      display: block;
      margin-left: 0mm;
      margin-right: 0mm;
    }
    head {
      display: block;
      margin-bottom: 20px;
      background-color: #dddddd;
    }
    dc,keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: blue;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small%;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: red;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small%;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th, td {
      display: inline;
    }
    th.left {
      text-align: left;
    }
    td.right {
      text-align: right;
    }
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    p {
      display: block;
      font-family: #{fonts};
      font-weight: normal;
      text-align: justify;
      font-size: 100%;
      line-height: 150%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 2px;
      margin-bottom: 0px;
    }
    p.norm {
    }
    p.h1 {
      font-family: #{fonts};
      font-size: 120%;
      font-weight: bold;
      text-align: left;
      line-height: 120%;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    p.h2 {
      font-weight: bold;
      font-size: 110%;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    p.h3 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    p.h4 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    p.h5 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    p.h6 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    p.toc1 {
      font-weight: bold;
      font-size: small;
      text-align: left;
      line-height: 100%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 10px;
      margin-bottom: 5px;
    }
    p.toc2 {
      font-weight: bold;
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 5%;
      margin-right: 10%;
      margin-top: 10px;
      margin-bottom: 5px;
    }
    p.toc3 {
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 5%;
      margin-right: 10%;
      margin-top: 10px;
      margin-bottom: 5px;
    }
    p.toc4 {
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 10%;
      margin-right: 10%;
      margin-top: 5px;
      margin-bottom: 5px;
    }
    p.toc5 {
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 15%;
      margin-right: 10%;
      margin-top: 5px;
      margin-bottom: 5px;
    }
    p.toc6 {
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 20%;
      margin-right: 10%;
      margin-top: 5px;
      margin-bottom: 5px;
    }
/* microtoc for use later -->  */
/*

*/
/* subtoc --> */
    p.subtoc4 {
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 10%;
      margin-right: 10%;
      margin-top: 5px;
      margin-bottom: 5px;
    }
    p.subtoc5 {
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 15%;
      margin-right: 10%;
      margin-top: 5px;
      margin-bottom: 5px;
    }
    p.subtoc6 {
      font-size: x-small;
      text-align: left;
      line-height: 100%;
      margin-left: 20%;
      margin-right: 10%;
      margin-top: 5px;
      margin-bottom: 5px;
    }
    p.ocn {
      display: block;
      text-align: right;
      vertical-align: super;
      color: #999999;
      font-size: xx-small;
      margin-right: 0mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    p.note {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
    def xhtml                                     #stylesheet for xhtml
<<WOK
/* SiSU css xhtml & sax.xml default style */
    document {
      display: block;
      margin-left: 0mm;
      margin-right: 0mm;
    }
    head {
      display: block;
      margin-bottom: 20px;
      background-color: #dddddd;
    }
    meta {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #990000;
      margin-right: 2mm;
      margin-top: 0px;
      margin-bottom: 0px;

    }
    title,subtitle,creator,author,translator,translated_by,illustrator,illustrated_by,prepared_by,digitized_by,type,subject,description,contributor,publisher,format,identifier,source,language,relation,coverage,rights,keywords,comment,comments,abastract,tags,catalogue,date,date_created,date_issued,date_available,date_modified,date_valid,structure,sc {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #000099;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    source_control {
      display: block;
    }
    dc {
      display: block;
      font-family: #{fonts};
      color: blue;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    sc {
      display: inline;
      color: green;
    }
    keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: red;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th,td {
      display: inline;
    }
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-left: 2mm;
      margin-right: 2mm;
      margin-top: 4px;
      margin-bottom: 8px;
    }
    text,text[class|="norm"] {
      display: block;
      font-family: #{fonts};
      text-align: justify;
      font-weight: normal;
      font-size: 100%;
      line-height: 150%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 2px;
      margin-bottom: 0px;
    }
    text[class|="h1"] {
      font-size: 120%;
      font-weight: bold;
      text-align: left;
      line-height: 120%;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h2"] {
      font-weight: bold;
      font-size: 110%;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h3"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h4"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h5"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h6"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="indent1"] {
      margin-left: 10%;
    }
    text[class|="indent2"] {
      margin-left: 15%;
    }
    text[class|="indent3"] {
      margin-left: 20%;
    }
    text[class|="indent4"] {
      margin-left: 25%;
    }
    text[class|="indent5"] {
      margin-left: 30%;
    }
    text[class|="indent6"] {
      margin-left: 35%;
    }
    text[class|="indent7"] {
      margin-left: 40%;
    }
    text[class|="indent8"] {
      margin-left: 45%;
    }
    text[class|="indent9"] {
      margin-left: 50%;
    }
    text[class|="indent_bullet1"] {
      margin-left: 10%;
    }
    text[class|="indent_bullet2"] {
      margin-left: 15%;
    }
    text[class|="indent_bullet3"] {
      margin-left: 20%;
    }
    text[class|="indent_bullet4"] {
      margin-left: 25%;
    }
    text[class|="indent_bullet5"] {
      margin-left: 30%;
    }
    text[class|="indent_bullet6"] {
      margin-left: 35%;
    }
    text[class|="indent_bullet7"] {
      margin-left: 40%;
    }
    text[class|="indent_bullet8"] {
      margin-left: 45%;
    }
    text[class|="indent_bullet9"] {
      margin-left: 50%;
    }
    text[class|="verse"], text[class|="group"], text[class|="code"] {
      text-align: left;
    }
    ocn {
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-right: 0mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    endnote {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    endnote_indent {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 15%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
    def xml_sax                                   #stylesheet for xml sax
      xhtml
    end
    def xml_dom                                   #sylesheet for xml dom, work on, starts from copy of css_xhtml
<<WOK
/* SiSU css dom.xml default style */
    document {
      display: block;
      margin-left: 0mm;
      margin-right: 0mm;
    }
    head {
      display: block;
      margin-bottom: 20px;
      background-color: #dddddd;
    }
    header {
      display: block;
    }
    meta {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #990000;
      margin-right: 2mm;
      margin-top: 0px;
      margin-bottom: 0px;

    }
    title,subtitle,creator,author,translator,translated_by,illustrator,illustrated_by,prepared_by,digitized_by,type,subject,description,contributor,publisher,format,identifier,source,language,relation,coverage,rights,keywords,comment,comments,abastract,tags,catalogue,date,date_created,date_issued,date_available,date_modified,date_valid,structure,sc {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #000099;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    source_control {
      display: block;
    }
    dc {
      display: block;
      font-family: #{fonts};
      color: blue;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    sc {
      display: inline;
      color: green;
    }
    keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: red;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-left: 2mm;
      margin-right: 2mm;
      margin-top: 4px;
      margin-bottom: 8px;
    }
    heading {
      font-weight: bold;
    }
    contents {
      font-weight: normal;
    }
    text {
      display: block;
      font-family: #{fonts};
      text-align: justify;
      font-size: 100%;
      line-height: 150%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 2px;
      margin-bottom: 0px;
    }
    text[class|="norm"] {
      font-weight: normal;
    }
    text[class|="h1"] {
      font-size: 120%;
      font-weight: bold;
      text-align: left;
      line-height: 120%;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h2"] {
      font-weight: bold;
      font-size: 110%;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h3"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h4"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h5"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h6"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="indent1"] {
      margin-left: 10%;
    }
    text[class|="indent2"] {
      margin-left: 15%;
    }
    text[class|="indent3"] {
      margin-left: 20%;
    }
    text[class|="indent4"] {
      margin-left: 25%;
    }
    text[class|="indent5"] {
      margin-left: 30%;
    }
    text[class|="indent6"] {
      margin-left: 35%;
    }
    text[class|="indent7"] {
      margin-left: 40%;
    }
    text[class|="indent8"] {
      margin-left: 45%;
    }
    text[class|="indent9"] {
      margin-left: 50%;
    }
    text[class|="indent_bullet1"] {
      margin-left: 10%;
    }
    text[class|="indent_bullet2"] {
      margin-left: 15%;
    }
    text[class|="indent_bullet3"] {
      margin-left: 20%;
    }
    text[class|="indent_bullet4"] {
      margin-left: 25%;
    }
    text[class|="indent_bullet5"] {
      margin-left: 30%;
    }
    text[class|="indent_bullet6"] {
      margin-left: 35%;
    }
    text[class|="indent_bullet7"] {
      margin-left: 40%;
    }
    text[class|="indent_bullet8"] {
      margin-left: 45%;
    }
    text[class|="indent_bullet9"] {
      margin-left: 50%;
    }
    text[class|="verse"], text[class|="group"], text[class|="code"] {
      text-align: left;
    }
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th, td {
      display: inline;
    }
    nametag {
      display: none;
    }
    number {
      padding-right: 4px;
    }
    ocn {
      font-weight: normal;
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-right: 0mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    endnote {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    endnote_indent {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 15%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
    def docbook_xml                               #stylesheet for docbook
<<WOK
/* SiSU css docbook.xml default style */
    book {
      display: block;
      margin-left: 0mm;
      margin-right: 0mm;
    }
    bookinfo {
      display: block;
      margin-bottom: 20px;
      background-color: #dddddd;
    }
    source_control {
      display: block;
    }
    dc,sc {
      display: block;
      font-family: #{fonts};
      color: blue;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    sc {
      color: green;
    }
    keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: red;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-left: 2mm;
      margin-right: 2mm;
      margin-top: 4px;
      margin-bottom: 8px;
    }
    part {
      display: block;
      /* font-weight: bold; */
    }
    contents {
      font-weight: normal;
    }
    para {
      display: block;
      font-family: #{fonts};
      /* font-weight: normal; */
      text-align: justify;
      font-size: 100%;
      line-height: 150%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 2px;
      margin-bottom: 0px;
    }
    para.verse, para.group, para.code {
      text-align: left;
    }
    para.norm {
      font-family: #{fonts};
      font-weight: normal;
    }
    para.h1, title {
      display: block;
      font-family: #{fonts};
      font-size: 120%;
      font-weight: bold;
      text-align: left;
      line-height: 120%;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    para.h2 {
      font-weight: bold;
      font-size: 110%;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    para.h3 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    para.h4 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    para.h5 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    para.h6 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th, td {
      display: inline;
    }
    nametag {
      display: none;
    }
    number {
      padding-right: 4px;
    }
    ocn {
      font-weight: normal;
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-right: 0mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    endnote {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    endnote_indent {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 15%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
    def css_xhtml_p                               #stylesheet for ...
<<WOK
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-top: 3px;
      margin-bottom: 3px;
      margin-right: 5mm;
    }
    p {
      display: block;
      font-family: #{fonts};
      font-size: 100%;
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10mm;
      margin-top: 3px;
      margin-bottom: 0px;
      margin-right: 5mm
    }
    p.norm {
    }
    p.endnote {
      font-size: 100%;
      margin-left: 20%;
      text-indent: 5%
    }
    p.endnote_indent {
      font-size: 100%;
      margin-left: 25%;
      text-indent: 5%
    }
    p.h1 {
      font-family: #{fonts};
      font-weight: bold;
      line-height: 120%;
      margin-left: 10mm;
      margin-right: 10mm;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    p.h2 {
      font-weight: bold;
      font-size: 110%;
      margin-left: 10mm;
      margin-right: 15mm;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    p.h3 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    p.h4 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    p.h5 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    p.h6 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    ocn {
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-top: 0px;
      margin-bottom: 6px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
  end
end

__END__

