=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: LaTeX generation

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_TeX
  require 'pstore'
  require SiSU_lib + '/defaults'
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  require SiSU_lib + '/texpdf_format'
  include SiSU_TeX_Pdf
  @tex_file=@@tex_footnote_array=@@tex_col_w=[]
  @@tex_backslash ||="\\\\"
  @@tex_3='\\\\\\{\\\\\\{' #?? debug crazy
  @@tex_1='\\\\\\~' #?? debug crazy
  @@tex_2='\\\\\\{\\\\\\{' #?? debug crazy
  @@tabular="{tabular}"
  @@column_instruct=@@squigle_close=@@tex_line_mode=@@tex_word_mode=@@line_mode=''
  @@tex_debug_counter=@@table_pagebreak_counter=@@tex_footnote_call_counter=@@tex_table_flag=@@tex_counter=@@tex_column=@@tex_columns=@@tex_columns=@@counting=0
  @@tex_pattern_margin_number="\\\\begin\\\{tiny\\\}~\\\\end\\\{tiny\\\}\\\{\\\\marginpar.+?\s+"
  #@@tex_pattern_margin_number="\\\\marginpar.+?\s+"
  @@n=@@tableheader=@@rights=nil
  @@date ||=SiSU_Env::Info_date.new
  class Source #Songsheet #<SiSU_Param::MyFiles
    require 'pstore'
    require SiSU_lib + '/sysenv'
    require SiSU_lib + '/param'
    include SiSU_Env
    include SiSU_Param
    include SiSU_Viz
    require SiSU_lib + '/metaverse'
    include SiSU_Metaverse
    include SiSU_TeX
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new(@opt.fns)
    end
    def directories
      begin
        @dir_out_root=@env.path.output
        case @opt.fns
        when /\.[_-]?sst$/
          Dir.mkdir(@env.path.output) unless FileTest.directory?(@env.path.output)
          Dir.mkdir(@env.path.tex) unless FileTest.directory?(@env.path.tex)
        end
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'LaTeX/PDF')
        tell.green_title_hi unless @opt.cmd =~/q/
        path=@env.url.output_tell
        tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.program.pdf_viewer} #{path}/#{@md.fnb}/#{@md.fn[:pdf_l]}")
        tell.flow if @opt.cmd =~/[MVv]/
        tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.program.pdf_viewer} #{path}/#{@md.fnb}/#{@md.fn[:pdf_p]}")
        tell.flow if @opt.cmd =~/[MVv]/
        data=IO.readlines(@opt.fns,'')                                             #wasteful, revisit
        @md=SiSU_Param::Parameters.new(@opt).get
        my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
        if @md.flag_pdf
          $flag=@md.cmd                                                         #introduced to pass 0 for no object citation numbers... to texpdf_format
          @dir_o="#{@env.path.output}/#{@opt.fnb}"
          directories
          @md.txt_path="#@dir_o/#{@opt.fnb}"
          Dir.mkdir(@dir_o) unless FileTest.directory?(@dir_o)
          filename_index="#{@md.txt_path}/pdf"
          newfilename=filename_index
                                                                               #% needed needs to be reprogrammed !!!
          SiSU_Env::Info_skin.new(@md).select
          SiSU_Viz::Url.new
          metaverse_array=SiSU_Metaverse::Source.new(@opt).get             # metaverse file drawn here
          SiSU_TeX::Source::LaTeX_create.new(metaverse_array,@md,'landscape').songsheet
          SiSU_TeX::Source::LaTeX_create.new(metaverse_array,@md,'portrait').songsheet
          metaverse_array=''
          pwd=Dir.pwd
          SiSU_TeX::Source::LaTeX_to_pdf.new(@md).latexrun_selective
          Dir.chdir(pwd)
        else
          tell=SiSU_Screen::Ansi.new(@opt.cmd,'instructed NOT to produce LaTeX/PDF')
          tell.warn unless @opt.cmd =~/q/
        end
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        unless @opt.cmd =~/[MV]/ #check maintenance flag
          texfiles = Dir["#{@env.path.tex}/#{@opt.fns}*"]
          texfiles.each do |f| 
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        @tex_file=@@tex_footnote_array=[]
        @@column_instruct=''
        @@squigle_close=@@tex_line_mode=@@tex_word_mode=@@line_mode=''
        @@tex_debug_counter=@@table_pagebreak_counter=@@tex_footnote_call_counter=@@tex_table_flag=@@tex_counter=@@tex_column=@@tex_columns=@@tex_columns=@@counting=0
        @@tex_col_w=[]
        @@n=@@tableheader=@@rights=nil
        @@date=SiSU_Env::Info_date.new
        @@flag={}
        $flag=1 #remove at some stage
        SiSU_Env::Create_file.new(@opt.cmd,@opt.fns).param_instantiate
      end
    end
    private
    class LaTeX_to_pdf #<Songsheet
      require 'fileutils'
      include FileUtils #::Verbose
      @@n_lpdf||=0 #change
      def initialize(md)
        @md=md
        @env=SiSU_Env::Info_env.new(@md.fns)
      end
      def latex_do(texfilename)
        @texfilename=texfilename
        @@n_lpdf=@@n_lpdf+1
        tell=SiSU_Screen::Ansi.new(@md.cmd,'portrait ->')
        tell.dark_grey_title_hi if @md.cmd =~/[MVv]/
        tex_fn_base=@texfilename.gsub(/\.tex$/,'')
        cmd=SiSU_Env::System_call.new("#{tex_fn_base}.tex",'',@md.cmd)
        tell=SiSU_Screen::Ansi.new(@md.cmd)
        tell.grey_open unless @md.cmd =~/q/
        2.times { |i| cmd.latex2pdf unless ("#{tex_fn_base}.tex" !~/\w+/) }
        tell.p_off unless @md.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@md.cmd,'landscape ->')
        tell.dark_grey_title_hi if @md.cmd =~/[MVv]/
        cmd=SiSU_Env::System_call.new("#{tex_fn_base}.landscape.tex",'',@md.cmd)
        tell.grey_open
        2.times { |i| cmd.latex2pdf unless ("#{tex_fn_base}.landscape.tex" !~/\w+/) }
        tell.p_off unless @md.cmd =~/q/
        pwd=Dir.pwd
        portrait_pdf="#{pwd}/#{tex_fn_base}.pdf"
        landscape_pdf="#{pwd}/#{tex_fn_base}.landscape.pdf"
        if FileTest.file?(portrait_pdf)
          File.install(portrait_pdf,"#@dir_sisu/#{@md.fnb}/#{@md.fn[:pdf_p]}")
          File.unlink(portrait_pdf)
        end
        if FileTest.file?(landscape_pdf)
          File.install(landscape_pdf,"#@dir_sisu/#{@md.fnb}/#{@md.fn[:pdf_l]}")
          File.unlink(landscape_pdf)
        end
        tell=SiSU_Screen::Ansi.new(@md.cmd,@@n_lpdf,'processed (SiSU LaTeX to pdf - using pdfetex aka. pdftex or pdflatex)')
        tell.generic_number unless @md.cmd =~/q/
      end
      def latexrun_selective
        begin
          ep_dir=Dir.pwd
          Dir.chdir(ep_dir)
          @tex_f_no=0
          info={}
          if FileTest.file?("#{ep_dir}/#{@md.fns}")
            if @md.fns =~/\.[_-]?sst$/
              @dirout=SiSU_Env::Info_env.new(@md.fns)
              case @md.fns
              when /\.[_-]?sst$/
                if FileTest.directory?(@env.path.tex)==true
                  Dir.chdir(@env.path.tex)
                  @dir_sisu=@dirout.path.output
                  texfile=@md.fns.gsub(/$/,'.tex')
                  texfile=texfile.gsub(/~/,'-')
                  if File.exists?(texfile) and File.size(texfile) > 0
                    @tex_f_no+=1
                    latex_do(texfile)
                  else
                    puts "\tzero file size #{@env.path.tex}/#{@md.fns}"
                  end
                end
              end
            end
          else
            puts "\n#{@cX.fuschia}FILE NOT FOUND:#{@cX.off} << #{file} >> - requested latex system processing skipped\n"
          end
          lst=Dir["*.{aux,log,out}"]
          lst.each {|file| File.unlink(file)} if lst
          #touch("#{@dir_pdf}index.html") #correct @dir_pdf appears to contain slash / and should not
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.fns,@md.cmd).error
        end
      end
    end
    class LaTeX_create
      include SiSU_Param
      @@tex_backslash ||="\\\\"
      @@tex_3='\\\\\\{\\\\\\{' #?? debug crazy
      @@tex_1='\\\\\\~' #?? debug crazy
      @@tex_2='\\\\\\{\\\\\\{' #?? debug crazy
      @@tex_head_portrait,@@tex_head_landscape=[],[]
      @@flag_group,@@flag_code=false,false
      @@dp,@@prefix_b=nil,nil
      def initialize(data,md,orientation)
        @data,@md,@orientation=data,md,orientation
        @env=SiSU_Env::Info_env.new(@md.fns)
        @vz={ :tex=>{} }
        @tex=SiSU_TeX_Pdf::Use_TeX.new(@md,@orientation)
        @url=SiSU_Viz::Url.new
        @txt=SiSU_Viz::Txt.new
        @@dp ||=SiSU_Env::Info_env.new.digest.pattern
      end
      def songsheet
        begin
          @@tex_footnote_array=[] #check
          SiSU_Viz::Url.new
          data=@data
          @@rights=nil
          tell=SiSU_Screen::Ansi.new(@md.cmd,"pdfTex #@orientation")
          tell.txt_grey unless @md.cmd =~/q/
          if @md.dc_rights
            use=@md.dc_rights.dup #dup is necessary, else contents of :rights changed
            do_mono=SiSU_TeX_Pdf::Format_text_object.new(@md,use)
            copymark=if @md.creator_copymark; '{\\begin{small}\\raisebox{1ex}{\\copyright}\\end{small}} '
            else ''
            end
            copyright=do_mono.special_characters_safe.gsub(/^\s*Copyright/, copymark)
            @@rights||="\n #{@@tex_backslash*2}[3]\\ \\linebreak #{copyright}"
          end
          if @md.prefix_b
            do_mono=SiSU_TeX_Pdf::Format_text_object.new(@md,@md.prefix_b)
            prefix_b=do_mono.special_characters_safe
            @@prefix_b="\n #{@@tex_backslash*2}[3]\\ \\linebreak \\ #{prefix_b}\n" unless @@prefix_b
          end
          if @md.markup.to_s !~/url_png/
            @data=pre
            @data=footnote
            if @md.flag_tables
              @data=tables
            end
            @data=numbering
            @data=markup
            output
          end
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.fns,@md.cmd).error
        ensure
        end
      end
    protected
      def pre
        @tex_file=[]
        data=@data
        data.each do |para|
          # DEBUG 2003w16 this is a kludge, because i could not get parameters
          # from param, Sort out ... revert to more elegant solution
          # even more of a kludge as had to insert newlines where code is used not satisfactory, think about 
          pg=if para =~/<:br>/; para.split(/<:br>/)
          else                   para
          end
          pg.each do |pg|
          if pg =~/<!Th?¡\s+c/; @md.flag_tables=true # KLUDGE get from param
          end
          do_mono=SiSU_TeX_Pdf::Format_text_object.new(@md,pg)
          @tex_file << do_mono.special_characters
          end
        end
        data=@tex_file.delete_if {|x| x =~/^\s*0#{@@tex_1}/}
        @tex_file
      end
      def footnote
        data=@data.dup
        @tex_file=[]
        data.each do |para|
          para2=para.dup
          if para2 =~/(?:-#{@@tex_2}\\~\d+|<!e\\_\d+!>)/
            para2.gsub!(/(?:-#{@@tex_2}\\~\d+|<!e\\_\d+!>)/,' ')  # \1
            para2.chomp!
            @@tex_footnote_array << para2
          end
          # EMBEDDED FOOTNOTES / ENDNOTES should be straightforward but not quite a synch.
          footnote=[]
          if para =~/~\\\{[\d*+]+\s|\\\~\[([*+]\d+)\s/                                                # note escape not necessary in front of ~ has implications for many other matches #debug note
            para.gsub!(/\\~\\\{(\d+)\s+(.+?)<#{@@dp}>\\\}\\~/m,"\\footnote[\\1]{%\n \\2} ") #removed space before \\footnote 2004w21, watch
            para.gsub!(/\\~\[([*+]\d+)\s+(.+?)<#{@@dp}>\]\\~/m,"\\FootnoteA{\\1}{%\n \\2} ") #work on asterisk footnotes
            para.gsub!(/\\~\\\{([*+]+)\s+(.+?)<#{@@dp}>\\\}\\~/m,"\\FootnoteA{\\1}{%\n \\2} ") #work on asterisk footnotes
          end
          @tex_file << para
        end
        @tex_file
      end
      def tables
        data=@data
        @tex_file=[]
        @@tableheader=0
        data.each do |para|
          if para =~/¡|<!T/
            do_mono=SiSU_TeX_Pdf::Format_text_object.new(@md,para)
            para=do_mono.longtable_landscape if @orientation =~/landscape/ # using longtable latex package
            para=do_mono.longtable_portrait if @orientation =~/portrait/ # using longtable latex package
          end
          @tex_file << para 
        end
      end
      def tables_portrait
        data=@data
        @tex_file=[]
        @@tableheader=0
        data.each do |para|
          if para =~/¡|<!T/
            do_mono=SiSU_TeX_Pdf::Format_text_object.new(@md,para)
          end
          @tex_file << para 
        end
      end
      def enclose(para,type='')
        para.strip!
        if type =~/code/; para
          #para = '\begin{footnotesize} \begin{ttfamily} ' + para + ' \end{ttfamily} \end{footnotesize}'
        elsif para !~/(\\begin\{tabular\}.*|\\end\{tabular\}|&|#{@@tex_backslash*2})\s*$/ #check
          para.gsub!(/(.+)/m,"\n#{@tex.skip_small} \\1 #{@tex.skip_small}\n")
        else para
        end
      end
      def markup
        data=@data
        @tex_file=[]
        md={}
        #% document headers watch special characters in title & subtitle: glark "\{\{~(sub)?title.+?[$&%#_\{\}]" *.(lm|er)??  
        home=@txt.home.gsub(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>|\\\\/,' - ') #no line splitting in heading neither html nor latex
        title=@md.title.gsub(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>|\\\\/,' - ') #no line splitting in heading neither html nor latex 
        subtitle=@md.subtitle.gsub(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>|\\\\/,' - ') if @md.subtitle #no line splitting in heading neither html nor latex
        orient=SiSU_TeX_Pdf::Format_text_object.new(@md,@orientation,"#{home}: - #{title} #{subtitle}") #.new
        if @orientation =~/portrait/
          @@tex_head_portrait << orient.document_head_with_orientation
        elsif @orientation =~/landscape/
          @@tex_head_landscape << orient.document_head_with_orientation
        end
        @tex_file <<<<WOK
#{@tex.header}#{@tex.footer}
\\makeatother
\\makeatother
\\begin{document}
WOK
        sisu_rc_footnote=if @md.sc_info; @tex.doc_sc_info_footnote_full
        else                             @tex.doc_sc_info_footnote_brief
        end
        @copymark=if @md.creator_copymark; '^\copyright'
        else                               ''
        end
        if @orientation =~/landscape/ # using longtable latex package
          @tex_file << SiSU_TeX_Pdf::Format_text_object.new(@md,@md.title,@md.subtitle).title_landscape
          if @md.dc_creator
            do_mono=SiSU_TeX_Pdf::Format_text_object.new(@md,@md.dc_creator)
            creator=do_mono.special_characters
            @tex_file << if @md.creator_home
              <<WOK

\\author{\\href{#{@md.creator_home}}{#@copymark \\textnormal{#{creator}}}}
WOK
            else "\n\\author{#@copymark \\textnormal{#{creator}}}" 
            end
          end
          @tex_file << unless @md.fnb =~/^mail\s*$/
            "\n\\date{copy @ #{@tex.site} #{sisu_rc_footnote}}"
          else "\\date"
          end
        else #portrait
          @tex_file << SiSU_TeX_Pdf::Format_text_object.new(@md,@md.title,@md.subtitle).title_portrait
          if @md.dc_creator
            creator=@md.dc_creator
            @tex_file << if @md.creator_home
              <<WOK

\\author{\\href{#{@md.creator_home}}{#@copymark \\textnormal{#{creator}}}}
WOK
            else "\n\\author{#@copymark \\textnormal{#{creator}}}" 
            end
           end
          @tex_file << unless @md.fnb =~/^mail\s*$/; "\n\\date{copy @ #{@tex.site} #{sisu_rc_footnote}}"
          else                                       "\\date"
          end
        end
        @tex_file <<<<WOK
\\pagenumbering{roman}\\maketitle
\\pagestyle{fancy}
WOK
        #@tex_file << @tex.newpage #newpage clearpage depending on portrait or landscape
        @tex_file << "\\newpage\n"
        @tex_file << @@rights if @md.dc_rights #if @orientation =~/landscape/
        @tex_file << @@prefix_b if @md.prefix_b
        @tex_file << @tex.sisu_rights
        @tex_file << if @md.sc_info; @tex.doc_sc_info
        else                         @tex.doc_no_sc_info
        end
        @tex_file << @tex.newpage 
        @tex_file <<<<WOK
\\pagestyle{fancy}
\\tableofcontents
#{@tex.newpage}
\\pagenumbering{arabic}
#{@tex.paraskip_normal}
WOK
        @tex_file << @tex.newpage 
        @group_collect=[]
        data.each do |para|                                                      #% case follows with levels 1-6 indents & graphics
          mono=SiSU_TeX_Pdf::Format_text_object.new(@md,para)
          if para =~/<:(code|alt|verse|group)>/ or @@flag_group==true
            if para =~/<:(code|alt|verse|group)>/
              @lineone=case para 
              when /<:(alt|verse|group)>/; para 
              when /<:code>/; "#{@tex.paraskip_small} \\begin{footnotesize} \\begin{ttfamily} " + para
              else 'error' #should never occur
              end
            end
            regx=/<:((?:code|alt|verse|group)(?:-end)?)>/
            x=regx.match(para)[1] if para =~regx
            x=$1
            para.gsub!(/\n<:(?:code|alt|verse|group)>\n/m,'')
            para=enclose(para,'code') unless para =~/^$/
            if x =~/(?:alt|verse|group)/; @@flag_group=true
            elsif x =~/code/; @@flag_group,@@flag_code=true,true
            elsif @@flag_group==true;    @group_collect << para #<< "\n\n"
            end
            if x =~/(?:code|alt|verse|group)-end/
              regx=/(\\+marginpar\{\\+begin\{tiny\}\d+\\+end\{tiny\}\})/ 
              y=if para =~regx
                regx.match(para)[1] 
              else ''
              end
              para.gsub!(regx,'')
              @group_collect.each{ |x| x.gsub!(/(.#{@@tex_1}\S*\s*|<:\S+>|<!.*?!>|<!>)/,' ') }
              @lineone.gsub!(/(.#{@@tex_1}\S*\s*|<:\S+>|<!.*?!>|<!>)/,' ')
              insert=[]
              if para =~/<:code-end>/
                insert << y + @lineone << @group_collect << ' \end{ttfamily} \end{footnotesize}' << " #{@tex.paraskip_normal}"
              else insert << y + @lineone << @group_collect
              end
              @@flag_group,@@flag_code=false,false
              @group_collect=[]
              para.gsub!(/(.#{@@tex_1}\S*\s*|<:\S+>|<!.*?!>|<!>)/,' ')
              @tex_file << insert.flatten
            end
          else
            if para =~ /\}(?:https?|ftp)/
              para=mono.http(@orientation)
            end
            case para
            when /^1#{@@tex_1}/;       mono.level1
            when /^2#{@@tex_1}/;       mono.level2
            when /^3#{@@tex_1}/;       mono.level3
            when /^4#{@@tex_1}/;       mono.level4
            when /^5#{@@tex_1}/;       mono.level5
            when /^6#{@@tex_1}/;       mono.level6
            when /^<:i1>/;             mono.indent1 
            when /^<:i2>/;             mono.indent2
            when /<:=/;                mono.symbol_graphic #watch
            when /^\s*<:image\s+/;     mono.image
            when /\}image/;            mono.png
            else
              para.strip!
              para=enclose(para) unless para =~/^$/
            end
            para.gsub!(/(\.#{@@tex_1}\S*\s*|<:\S+>|<!.*?!>|<!>)/,' ')   #% tread with care
            #para.gsub!(/(.#{@@tex_1}(?:\\~\S+)?\s*|<:\S+>|<!.*?!>|<!>)/,' ')  #KEEP reference, problem escaping open curly braces \{
            @tex_file << para
          end
        end
        @tex_file << "\n\\newpage\n" # was \\pagebreak\n
        @md.subtitle_tex=@md.subtitle.dup if @md.subtitle
        # kludge ... look again later
        @tex_file << if @md.doc_skin !~/skin_mail/; @tex.doc_tail 
        else                                        @tex.mail_tail
        end
        if defined? @md.lnk and @md.lnk
          @md.lnk.each do |l|
            if l[:say]
              url=%<#{l[:url]}>
              url.gsub!(/(?:\\)*([$&~%_#}{^])/,"\\\\\\1")                         #latex special chars
              s_lnk=l[:say]
              s_lnk.gsub!(/(<br>|<br \/>|<p>|<p \/>)/,'')
              s_lnk.gsub!(/(?:\\)*([$&~%_#}{^])/,"\\\\\\1")                       #latex special chars
              if url !~/^\.(\.)?\//
                s_lnk_url=%<\\begin{scriptsize}\\href{#{url}}{#{url}}\\end{scriptsize}>  # note this bit of dereferencing magic
              else
                url.gsub!(/\.\.\//,'')
                s_lnk_url="(#{@tex.site}) \\\\\n" + ' ' +
                  "\\begin{scriptsize}" +
                  %<\\href\{#{@url.root_http}/#{url}\}\{#{@url.root_http}/#{url}\}> + # note this bit of dereferencing magic
                  "\\end{scriptsize}"
              end
              @tex_file << " #{s_lnk} \\\\\n #{s_lnk_url} \n" unless  @md.doc_skin =~/skin_mail/
              s_lnk=s_lnk_url=nil
            end
          end
        end
        @tex_file << " #{@tex.sitename} home: \\\\ 
\\begin{bfseries}#{@tex.site}\\end{bfseries}
"
        #Stamp.stamp #removed 200408 but watch
        #% code for inclusion of addresses of promulgating authority
        @vz[:tex][:stmp]||=@md.stmpd
        stamp=@vz[:tex][:stmp] if @vz[:tex][:stmp]
        if stamp
          use=stamp.gsub(/\n/,"#{@@tex_backslash*2}\n")
          @tex_file << "\n\\newpage\n"
          @tex_file << "\\section*" +
            "{#{@tex.owner_chapter}}\n" +
            "\\addcontentsline{toc}" +
            "{section}{#{@tex.owner_chapter}}\n"
          @tex_file << "#{use}\n"
          @tex_file << @@rights if @@rights
        end
        @tex_file << "\n\\end{document}"
      end
      def footnote_call_number
        data=@data
        data.each do |word|
          if word =~/<:e>/
            @@tex_footnote_array[@@tex_footnote_call_counter].strip!  if @@tex_footnote_array[@@tex_footnote_call_counter]
            word.gsub!(/<:e>/,
              " \\footnote{%\n #{@@tex_footnote_array[@@tex_footnote_call_counter]}} ")
            @@tex_footnote_call_counter+=1
          end
        end
      end
      def numbering
        data=@data
        data=LaTeX_create.new(data,@md,@orientation).number_titles
        #TOGGLE to SWITCH PARAGRAPH NUMBERING (ON & OFF)
        LaTeX_create.new(data,@md,@orientation).number_paras if @md.markup !~/not_to/
      end
      def number_titles
        data=@data
        @tex_file=[]
        input=@md.num_top
        num_top=input.to_i
        data.each do |para|
          if @md.markup =~/num_top/ and para !~/0#{@@tex_1}/
            if para =~/[1-6]#{@@tex_1}\S*\s*<!h-.+?-!>/ and para !~/<:\d-endnotes>/
              header=para[/<!h-(.+?)-!>/m, 1].gsub!(/-/m,'.')
              para.gsub!(/[1-6]#{@@tex_1}(?:\S+)\s*<!h-.+?-!>/,"\\1 #{header} ")
            end
          elsif para =~/<!h!>|<!h\d!>|<!h.+?!>|<!!h.+?!>/
            if para =~/<!h-.+?-!>/; para.gsub!(/<!h-(.+?)-!>/,'\1 ')
            end
          end
          @tex_file << para
        end
        @tex_file
      end
      def number_paras
        data=@data
        @tex_file=[]
        data.each do |para|
          if para =~/<\\~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/ and para !~/\\end\{longtable\}|<EOF>/ #catch <!TZ!>
            m=/(.+?)<\\~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m
            parablock=para[m,1]
            paranum=para[m,2]
            do_duo=SiSU_TeX_Pdf::Format_text_object.new(@md,parablock,paranum)
            para=do_duo.para_num if parablock
          elsif para =~/^<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/ #2005 this is added for tables, rationalise
            m=/<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m
            paranum=para[m,1]
            para.gsub!(/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
            para="\\marginpar{\\begin{tiny}#{paranum}\\end{tiny}}" + para
            #para="\\marginpar{\\begin{tiny}#{paranum}\\end{tiny}}"
          #elsif para =~/<!T.+?!~\d+?>/
          elsif para =~/^<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+>/ #extra 2005 this is added for tables, rationalise
            m=/<~(\d+);[oh]\d+;\w\d+>/m
            paranum=para[m, 1]
            para.gsub!(/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+>/,'')
            para="\\marginpar{\\begin{tiny}#{paranum}\\end{tiny}}" + para
          elsif para =~/\\end\{longtable\}/ #catch <!TZ!>
            para.gsub!(/<\\~\d+>|<\\~(\d+);(?:[ohm]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
            para.gsub!(/<\\~\d+>|<\\~(\d+);(?:[ohm]|[0-6]:)\d+;\w\d+>/,'') #extra
          end
          @tex_file << para
        end
        @tex_file
      end
      def output
        data=@data
        @tex_file=[]
        data.flatten!
        data.compact!
        data.each do |para|
          para.gsub!(/^\s+/,'')
          @tex_file << para
        end
        fns_l=@md.fns.gsub(/~/,'-') #this is a sorry fix, but necessary as it appears latex programs like not ~
        if @orientation =~/landscape/    #@tex_file << "\n<!EOF!>"
          filename_tex_landscape=File.new("#{@env.path.tex}/#{fns_l}.landscape.tex",'w+')
          filename_tex_landscape << @@tex_head_landscape 
          @tex_file.each {|para| filename_tex_landscape.puts para,"\n" unless para.empty?}
          filename_tex_landscape.close
          @@tex_head_landscape=[]
        elsif @orientation =~/portrait/
          filename_tex_portrait=File.new("#{@env.path.tex}/#{fns_l}.tex",'w+')
          filename_tex_portrait << @@tex_head_portrait
          @tex_file.each {|para| filename_tex_portrait.puts para,"\n" unless para.empty?} 
          filename_tex_portrait.close
          @@tex_head_portrait=[]
        end
        @tex_file=[]
      end
    end
  end
end
__END__
