=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: configuration

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Initialize
  require SiSU_lib + '/sysenv'
  include SiSU_Env
  include SiSU_Screen
  require SiSU_lib + '/relaxng'
  include SiSU_relaxng
  require SiSU_lib + '/css'
  include SiSU_Style
  class Source
    def initialize(opt)
      @opt=opt
    end
    def read
      SiSU_Config.new(@opt).make_homepage
      SiSU_Config.new(@opt).css
      SiSU_Config.new(@opt).dtd
      SiSU_Config.new(@opt).cp_local_images
      SiSU_Config.new(@opt).cp_external_images
      SiSU_Config.new(@opt).cp_webserver_images if @opt.mod.inspect =~/--init(?:ialize)?=site/
    end
  end
  class SiSU_Config #config files such as css are not updated if they already exist unless forced using the --init=site modifier
    require 'fileutils'
    require SiSU_lib + '/sysenv'
    include FileUtils #::Verbose
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new(@opt.fns)
      @path_dtd="#{@env.path.output}/_sisu/dtd"
      @pwd,@home=Dir.pwd,@env.path.home
    end
    def make_homepage
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Make homepage','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).homepage
    end
    def cp_local_images
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Copy images','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).cp_local_images
      SiSU_Env::Create_site.new(@opt.cmd).cp_base_images #base images (nav etc.) used by all html
    end
    def cp_external_images
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Copy external images','')
      tell.colorize if @opt.cmd =~/V/
      SiSU_Env::Create_site.new(@opt.cmd).cp_external_images
    end
    def cp_webserver_images
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Copy webserver/output file images','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).cp_webserver_images
    end
    def css
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Configuring CSSs','')
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::Create_site.new(@opt.cmd).cp_css
    end
    def dtd
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Configuring DTDs','')
      tell.colorize unless @opt.cmd =~/q/
      @rxng=SiSU_relaxng::RelaxNG.new
      File.mkpath(@path_dtd) unless FileTest.directory?(@path_dtd)
      #ugly code, sort later
      if @rxng.methods.join =~/[^_]dtd_sax\b/
        if @rxng.dtd_sax.length > 200
          dtd=File.new("#{@env.path.output}/#{@env.path.style}/#{@rxng.fn_dtd_sax}","w")
          dtd << @rxng.dtd_sax
          dtd.close
        else trang_rnc_sax
        end
      else trang_rnc_sax
      end
      if @rxng.methods.join =~/[^_]dtd_dom\b/
        if @rxng.dtd_dom.length > 200
          dtd=File.new("#{@env.path.output}/#{@env.path.style}/#{@rxng.fn_dtd_dom}","w")
          dtd << @rxng.dtd_dom
          dtd.close
        else trang_rnc_dom
        end
      else trang_rnc_dom
      end
      if @rxng.methods.join =~/[^_]dtd_xhtml\b/
        if @rxng.dtd_xhtml.length > 200
          #use dtd
          dtd=File.new("#{@env.path.output}/#{@env.path.style}/#{@rxng.fn_dtd_xhtml}","w")
          dtd << @rxng.dtd_xhtml
          dtd.close
        else trang_rnc_xhtml
        end
      else trang_rnc_xhtml
      end
    end
    def trang_rnc_sax
      rnc_file="#{@env.path.metaverse}/sax.rnc"
      dtd_file="#@path_dtd/#{@rxng.fn_dtd_sax}"
      rnc=File.new(rnc_file,"w")
      rnc << @rxng.rnc_sax
      rnc.close
      schema=SiSU_Env::System_call.new(rnc_file,dtd_file)
      schema.relaxng(@opt.cmd)
    end
    def trang_rnc_dom
      rnc_file="#{@env.path.metaverse}/dom.rnc"
      dtd_file="#@path_dtd/#{@rxng.fn_dtd_dom}"
      rnc=File.new(rnc_file,"w")
      rnc << @rxng.rnc_sax
      rnc.close
      schema=SiSU_Env::System_call.new(rnc_file,dtd_file)
      schema.relaxng(@opt.cmd)
    end
    def trang_rnc_xhtml
      rnc_file="#{@env.path.metaverse}/xhtml.rnc"
      dtd_file="#@path_dtd/#{@rxng.fn_dtd_xhtml}"
      rnc=File.new(rnc_file,"w")
      rnc << @rxng.rnc_sax
      rnc.close
      schema=SiSU_Env::System_call.new(rnc_file,dtd_file)
      schema.relaxng(@opt.cmd)
    end
  end
end
__END__
