=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: plaintext formatting template

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module Format
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(paranum)
      @paranum=/(\d+)/im.match(paranum)[1]
    end
    def display
      @paranum.gsub(/(\d+)/,%{<font size="1" color="#777777">&nbsp;&nbsp;\\1</font>})
    end
    def name
      @paranum.gsub(/(\d+)/,%{<a name="\\1"></a>})
    end
    def goto
      @paranum.gsub(/(\d+)/,%{<a href="#\\1">})
    end
  end
  class Format_text_object
    @@dp=nil
    def initialize(one,two,three)
      one.gsub!(/\.(html|pdf|php)/,'') if one =~/\.\.\/\S+/
      @one,@two,@three=one,two,three
      rgx=/[1-6-]~/
      @one.gsub!(rgx,'') if @one =~rgx
      @@dp ||=SiSU_Env::Info_dir.new.digest_pattern
      rgx=/~\{[\d*+]+\s+(.+?)<#{@@dp}>\}~/
      @one.gsub!(rgx,'\1') if @one =~rgx
      @link,@linkname=one,two
      @margin=SiSU_Viz::Margin.new
      @paragraph=SiSU_Viz::Paragraph.new
      @table=SiSU_Viz::Table.new
      @banner=SiSU_Viz::Banner.new
      @url=SiSU_Viz::Url.new
      @icon=SiSU_Viz::Icon.new
      @font=SiSU_Viz::Font.new
    end
    def scr_endnote_body
      %{<endnote>#@one</endnote> }
    end
    def heading_body1
    end
    def heading_body2
    end
    def heading_body3
    end
    def heading_body4
    end
    def heading_body5
    end
    def heading_body6
    end
  end
  class XML
  end
end
__END__

