=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: php (formating) template

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module Format
  require SiSU_lib + '/html_format'
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(paranum)
      @paranum=paranum[/(\d+)/im,1]
    end
    def display
      p_num_display=@paranum.gsub(/(\d+)/,%{<font size="1" color="#777777" align="right">&nbsp;\#\\1&nbsp;</font>})
    end
    def name
      p_num_name=@paranum.gsub(/(\d+)/,%{<a name="\\1"></a>})
    end
    def goto
      p_num_goto=@paranum.gsub(/(\d+)/,%{<a href="#\\1">})
    end
  end
  class Head_information
    def toc_head_escript #embedded script in this case PHP
      %{#{@php.persist}}
    end
    def seg_head_escript #embedded script in this case PHP 
      %{#{@php.persist}}
    end
    def x
      ''
    end
  end
  class MonoSiSU
    def gsub_body
      case @parablock
        when /^(?:<:i[12]>\s*)?\((i+|iv|v|vi+|ix|x|xi+)\)/
          @parablock.gsub!(/^\((i+|iv|v|vi+|ix|x|xi+)\)/,
            %{<b>(\\1)</b>})
          @parablock.gsub!(/^(<:i[12]>)\s*\((i+|iv|v|vi+|ix|x|xi+)\)/,
            %{\\1<b>(\\2)</b>})
        when /^(?:<:i[12]>\s*)?\(?(\d|[a-z])+\)/
          @parablock.gsub!(/^\((\d+|[a-z])+\)/,
            %{<b>(\\1)</b>})
          @parablock.gsub!(/^(<:i[12]>)\s*\((\d+|[a-z])+\)/,
            %{\\1<b>(\\2)</b>})
        when /^\s*\d{1,3}\.\s/
          @parablock.gsub!(/^\s*(\d+\.)/,
            %{<b>\\1</b>})
        when /^\s*[A-Z]\.\s/
          @parablock.gsub!(/^\s*([A-Z]\.)/,
            %{<b>\\1</b>})
      end
    end
    def table
      @@tablefoot=@parablock[/<!f(.+?)!>/,1]
      @parablock.gsub!(/<!f.+?!>/,
        %{})
      @@tablehead=1 if @parablock =~/<!Th¡/i
      @parablock.gsub!(/<!Th?¡.+/,
        %{#{@margin.txt_0}} +
        %{<table width="100%">})
      if @parablock =~/<!TZ!>/
        @parablock.gsub!(/<!TZ!>/,
          %{</table>} +
          %{#{@margin.num}} +
          %{#{@margin.num}&nbsp;} +
          %{#{@table.close}\n} +
          %{<p align="center"><font size=2><i>#{@@tablefoot}</i></font></p>\n})
          @@tablefoot=""
      end
      if @@tablehead == 1
        if @parablock =~/¡¡/
          @parablock.gsub!(/<!¡¡(\d+?)¡/,
            %{<tr>} +
            %{<td width="\\1%" valign="top">} +
            %{#{@paragraph.table}<b>})
          @parablock.gsub!(/¡¡(\d+?)¡/,
            %{</b></td><td width="\\1%" valign="top">} +
            %{#{@paragraph.table}<b>})
          @parablock.gsub!(/!>/,
            %{</b></td></tr>})
          @@tablehead=0 #if @parablock =~/!>/
        end
        @parablock
      else
        @parablock.gsub!(/<!¡¡(\d+?)¡/,
          %{<tr>} +
          %{<td width="\\1%" valign="top">} +
          %{#{@paragraph.table}})
        @parablock.gsub!(/¡¡(\d+?)¡/,
          %{</td><td width="\\1%" valign="top">} +
          %{#{@paragraph.table}})
        @parablock.gsub!(/!>/,
          %{</td></tr>})
        @parablock
      end
    end
    def toc_head_copy_at
      %{<p class="center">} +
        %{#@one} +
      %{</p>\n}
    end
    def center
      %{<p class="center">} +
        %{#@one} +
      %{</p>\n}
    end
    def bold_para
      %{#{@margin.txt_0}} +
      %{#{@paragraph.txt}} +
      %{<b>#@one</b> } +
      %{#{@margin.num}} +
      %{&nbsp;&nbsp;&nbsp;} +
      %{#{@table.close}\n}
    end
  end
  class Format_text_object
    #def initialize(one,two,doc='')
    #  one.gsub!(/\.(html|pdf|php)/,'') if one =~/\.\.\/\S+/
    #  @one=one
    #  rgx=/[1-6-]\{/
    #  @one.gsub!(rgx,'') if @one =~rgx
    #  rgx=/~\{\d+\s+(.+?)\}~/
    #  @one.gsub!(rgx,'\1') if @one =~rgx
    #  @two=two
    #  @doc=doc
    #  @link=one
    #  @linkname=two
    #  @margin=SiSU_Viz::Margin.new
    #  @paragraph=SiSU_Viz::Paragraph.new
    #  @table=SiSU_Viz::Table.new
    #  @banner=SiSU_Viz::Banner.new
    #  @url=SiSU_Viz::Url.new
    #  @icon=SiSU_Viz::Icon.new
    #  @font=SiSU_Viz::Font.new
    #end
    def scr_no_paranum
      %{#{@margin.txt_0}} +
      %{#{@paragraph.txt} } +
      %{#@one #@two } +
      %{#{@margin.num} } +
      %{#{@table.close}\n}
    end
    def seg_no_paranum
      %{#{@margin.txt_0}} +
      %{#{@paragraph.txt} } +
      %{#@one #@two } +
      %{#{@margin.num} } +
      %{#{@table.close}\n}
    end
    def seg_nav_para
      %{#{@margin.txt_0}} +
      %{#{@paragraph.txt_00}} +
      %{#@one } +
      %{#{@table.close}\n}
    end
    def scr_indent_one_no_paranum
      %{#{@margin.txt_1}} +
      %{#{@paragraph.txt}} +
      %{#@one } +
      %{#{@margin.num} } +
      %{#{@table.close}\n}
    end
    def scr_indent_two_no_paranum
      %{#{@margin.txt_1}} +
      %{#{@paragraph.txt}} +
      %{#@one } +
      %{#{@margin.num} } +
      %{#{@table.close}\n}
    end
    def toc_lev1
      %{#{@margin.txt_0} } +
      %{#{@paragraph.font_small}} +
      %{#@one</font> } +
      %{#{@table.close}\n}
    end
    def toc_lev2
      %{#{@margin.txt_1} } +
      %{#{@paragraph.font_small}} +
      %{#@one</font> } +
      %{#{@table.close}\n}
    end
    def toc_lev3
      %{#{@margin.txt_2} } +
      %{#{@paragraph.font_small}} +
      %{#@one</font> } +
      %{#{@table.close}\n}
    end
    def toc_lev4
      %{#{@margin.txt_3} } +
      %{#{@paragraph.font_small}} +
      %{#@one</font> } +
      %{#{@table.close}\n}
    end
    def toc_lev5
      %{#{@margin.txt_4} } +
      %{#{@paragraph.font_small}} +
      %{#@one</font> } +
      %{#{@table.close}\n}
    end
    def toc_lev6
      %{#{@margin.txt_5} } +
      %{#{@paragraph.font_small}} +
      %{#@one</font> } +
      %{#{@table.close}\n}
    end
    def seg_toc_lev1
      @one=@linkname
      toc_lev1
    end
    def seg_toc_lev2
      @one=@linkname
      toc_lev2
    end
    def seg_toc_lev3
      @one=@linkname
      toc_lev3
    end
    def seg_nav_toc_lev1_advert
      %{#{@banner.home_button}\n} +
      %{<center>} +
      %{#@one} +
      %{#@two} +
      %{</a></center><p />\n}
    end
    def seg_nav_toc_lev1
      %{#{@banner.nav_toc}\n}
    end
    def seg_nav_toc_lev2
      %{<table summary="navigation segment level 2">
<tr>
<td width ="20"></td>
<td> <font size="3" #{@font.face}><b>#@one</b></font> 
#{@table.close}
}
    end
    def seg_nav_toc_lev3
      %{<table summary="navigation segment level 3">
<tr>
<td width ="20"></td>
<td> <font size="3" #{@font.face}><b>#@one</b></font> 
#{@table.close}
}
    end
    def seg_nav_toc_lev4
      %{<table summary="navigation segment level 4">} +
      %{\n<tr>} +
      %{\n<td width ="80">} +
      %{</td><td>} +
      %{#@one</font> } +
      %{#{@table.close}\n}
    end
    def seg_nav_toc_lev5
    end
    def seg_nav_toc_lev6
    end
    def scr_endnote_body
      %{#{@margin.txt_0}} +
      %{#{@paragraph.endnote}} +
      %{#@one } +
       %{#{@margin.num}} +
      %{&nbsp;} +
      %{#{@table.close}\n}
    end
    def seg_endnote_body_seg_tail
      %{#{@margin.txt_0}} +
      %{#{@paragraph.endnote}} +
      %{#@one  } +
      %{#{@margin.num}&nbsp;} +
      %{#{@table.close}\n}
    end
    def seg_endnote_seg_body(fn='') #BUG WATCH 200408
      %{#{@margin.txt_0}} +
      %{#{@paragraph.txt}} +
       %{#@one} +
      %{#{fn}\.#{@doc[:sfx]}} +
      #%{#{fn}\.#{@doc[:file_type]}} +
      %{#@two } +
      %{#{@margin.num}&nbsp;} +
      %{#{@table.close}\n}
    end
    def seg_title_header1
      %{#{@margin.txt_00_0}} +
      %{\n#{@paragraph.header_1} } +
      %{<b> #@one</b>} +
      %{</font></p>\n} +
      %{#{@margin.num_header}&nbsp;} +
      %{#@two} +
      %{#{@table.close}\n} #+
    end
    def seg_title_header2
      %{#{@margin.txt_00_0}} +
      %{\n#{@paragraph.header_2} } +
      %{<b> #@one </b></font></p>\n} +
      %{#{@margin.num_header}&nbsp;} +
      %{#@two} +
      %{#{@table.close}\n}
    end
    def seg_title_header3
      %{#{@margin.txt_00_0}} +
      %{\n#{@paragraph.header_3} } +
      %{<b> #@one  </b></font></p>\n} +
      %{#{@margin.num_header}&nbsp;} +
      %{#@two} +
      %{#{@table.close}\n}
    end
    def seg_title_header4
      %{#{@margin.txt_00_0}} +
      %{\n#{@paragraph.header_4} } +
      %{<b> #@one  </b></font></p>\n} +
      %{#{@margin.num_header}&nbsp;} +
      %{#{@table.close}\n}
    end
    def seg_sub_toc_lev5
      %{#{@margin.txt_3} } +
      %{#{@paragraph.font_small}} +
       %{<a href="##@two">} +
      %{<i>#@one</i>} +
      %{</a></font> } +
      %{#{@table.close}\n}
    end
    def seg_sub_toc_lev6
      %{#{@margin.txt_4} } +
      %{#{@paragraph.font_small}} +
      %{<a href="##@two">} +
      %{<i>#@one</i>} +
      %{</a></font> } +
      %{#{@table.close}\n}
    end
  end
  #class TrioSiSU
  #  def tocLinksGuide
  #    %{ <a href="#@link" Target="#@three">
  #    %{<img border="0" height="8" width="8" src="#{@url.path_png} #{@icon.doc}" alt="Section on #@linkname"> } +
  #    %{#@linkname</a> \n}
  #  end
  #end
  class ParaSiSU
    def para
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{#{@parablock} } +
      %{#{@margin.num}} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_header_body
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{&nbsp;<br /><b>} +
      %{#{@headname}} +
      %{#{@parablock}} +
      %{</b>} +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_header_body1
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{&nbsp;<br /><b>} +
      %{#{@headname}} +
      %{#{@parablock}} +
      %{</b>} +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_header_body2
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{&nbsp;<br /><b>} +
      %{#{@headname}} +
      %{#{@parablock}} +
      %{</b>} +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_header_body3
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{&nbsp;<br /><b>} +
      %{#{@headname}} +
      %{#{@parablock}} +
      %{</b>} +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_header_body4
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{&nbsp;<br /><b>} +
      %{#{@headname}} +
      %{#{@parablock}} +
      %{</b>} +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_header_body5
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{&nbsp;<br /><b>} +
      %{#{@headname}} +
      %{#{@parablock}} +
      %{</b></font> } +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_header_body6
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{&nbsp;<br /><b>} +
      %{#{@headname}} +
      %{#{@parablock}} +
      %{</b></font> } +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_indent1
      %{#{@margin.txt_1}} +
      %{#{@para_id.txt}} +
      %{#{@parablock}} +
      %{</font> } +
      %{#{@margin.num}} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def scr_indent2
      %{#{@margin.txt_2}} +
      %{#{@para_id.txt}} +
      %{#@parablock} +
      %{</font> } +
      %{#{@margin.num}} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def seg_header4
      %{#@format } +
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}} +
      %{<b>#@format } +
      %{#@parablock</b> } +
      %{#{@margin.num}} +
      %{#{@p_num.display} } +
      %{#{@table.close}}
    end
    def seg_header5
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}<br />} +
      %{<b>#@parablock</b> } +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def seg_header6
      %{#{@margin.txt_0}} +
      %{#{@para_id.txt}<br />} +
      %{<b>#@parablock</b> } +
      %{#{@margin.num}} +
      %{&nbsp;<br />} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def indent1
      %{#{@margin.txt_1}} +
      %{#{@para_id.txt}} +
      %{#@parablock</font> } +
      %{#{@margin.num}} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def indent2
      %{#{@margin.txt_2}} +
      %{#{@para_id.txt}} +
      %{#@parablock</font> } +
      %{#{@margin.num}} +
      %{#{@p_num.display} } +
      %{#{@table.close}\n}
    end
    def seg_nav_header4                                                            #segNavHeader4 |html.rb|@|#navSegLev4|
      %{<table summary="navigation segment header 4" width=100% bgcolor="#08163f" border="0">} +
      %{\n<tr>} +
      %{\n<td align="center">} +
      %{<p><b><font size="4" color="#ffffff">} +
      %{<b>#@parablock</b>} +
      %{</font></b></p>} +
      %{#{@table.close}\n}
    end
    def seg_nav_header5                                                            # see instead |html_tune_nav.rb|@|#navSegLev5|
      %{<center><table summary="navigation segment header 5" width="100%" } +
        %{border="1" } +
        %{cellpadding="12" } +
        %{bgcolor=#{@color.lev5}>} +
      %{\n<tr align=center>} +
      %{\n<td>} +
      %{<b>#@parablock</b>  } +
      %{#{@table.close}</center>\n}
    end
    def seg_nav_header6
      %{<center><table summary="navigation segment header 6" width="100%" } +
      %{border="1" } +
      %{cellpadding="12" } +
      %{bgcolor=#{@color.lev6}>} +
      %{\n<tr align=center>} +
      %{\n<td>} +
      %{<b>#@parablock</b> } +
      %{#{@table.close}</center>\n}
    end
    def seg_nav_indent1
      %{#{@margin.txt_00_1}} +
      %{#{@paragraph.txt_00}} +
      %{#@parablock</font> } +
      %{#{@margin.num}&nbsp;} +
      %{#{@table.close}\n}
    end
    def seg_nav_indent2
    end
    def seg_nav_bold
      %{<b>#@parablock</b>}
    end
    def seg_nav_center
      %{<center>#@parablock</center>}
    end
  end
end
__END__
