=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: document summary processing, available outputs and metadata

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Notes: tidy -ascii index.xml >> index.tidy

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Manifest
  require SiSU_lib + '/sysenv'
  require SiSU_lib + '/babel'
  include SiSU_Env
  include SiSU_Param
  include SiSU_Viz
  class Source
    def initialize(opt)
      @opt=opt
      @md=SiSU_Param::Parameters.new(@opt).get
      @fnb=@md.fnb
      l=SiSU_Env::Standardise_language.new.file_to_language(@opt.fns)
      @doc_language=l[:l]
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @env=SiSU_Env::Info_dir.new(@opt.fns)
        path=SiSU_Env::Info_dir.new(@opt.fns)
        xbrowser=@env.web_browser
        browser=@env.console_web_browser
        webserv_url=path.tell_output_location
        url_html="#{webserv_url}/#{@md.fnb}/#{@md.fn[:manifest]}"
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'Manifest',"#{xbrowser} #{url_html}")
        tell.green_hi_blue unless @opt.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"#{browser} #{url_html}")
        tell.grey_tab if @opt.cmd =~/v/i
        Output_Info.new(@md).check_output
      rescue: SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Output_Info <Source
      def initialize(md)
        @manifest=Hash.new
        @manifest[:txt],@manifest[:html]=Array.new,Array.new
        @md,@fns=md
        @env=SiSU_Env::Info_dir.new(@md.fns)
        @fnb=@md.fnb
        out=@env.data_o
        @base_url="#{@env.output_links_path[:url_root]}/#@fnb"
        @base_path="#{out}/#@fnb"
        @@dg ||=SiSU_Env::Info_dir.new.digest
        @dg=@@dg
        l=SiSU_Env::Standardise_language.new.file_to_language(@md.fns)
        @language=l[:l]
        @translate=SiSU_Translate::Source.new(@md,@language)
      end
      def output
        SiSU_Env::SiSU_file.new(@md).mkdir
        manifest=SiSU_Env::SiSU_file.new(@md,@md.fn[:manifest]).mkfile
        @manifest[:html].each do |x|
          manifest << x
        end
      end
      def summarize(id,file)
        size=(File.size("#{@base_path}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/im.match(size)[1]
        @manifest[:txt] << "#{file} #{id} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="bold"><a href="#{file}">#{file}</a></p></th><td><p class="norm">#{id}</p><p class="tiny"><a href="#@base_url/#{file}">#@base_url/#{file}</a></p></td><td class="right"><p class="right">#{kb}</p></td></tr>\n}
      end
      def summarize_source(id,file)
        sys=SiSU_Env::System_call.new
        dgst =if @dg =~/^sha(?:2|256)$/: sys.sha256("#{@base_path}/#{file}")
        else                             sys.md5("#{@base_path}/#{file}")
        end
        tell=SiSU_Screen::Ansi.new(@md.cmd,"#{dgst[1]} #{file}")
        tell.warn if @md.cmd =~/[vVM]/
        size=(File.size("#{@base_path}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/im.match(size)[1]
        @manifest[:txt] << "#{file} #{id} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="tiny">#{id}:</p> <p class="norm"><a href="#{file}">#{file}</a></p><p class="tiny"><a href="#@base_url/#{file}">#@base_url/#{file}</a></p></th><td class="right"><p class="tiny">#{dgst[1]}</p></td><td class="right"><p class="right">#{kb}</p></td></tr>\n}
      end
      def languages(id,file)
        flv=@env.published_manifests?(@base_path)
        @manifest[:html] << %{<tr><th class="left"><p class="bold"><p class="bold">\n}
        flv.each do |l|
          lang=SiSU_Translate::Source.new(@md,@language,l[:l]).language_list
          @manifest[:txt] << "#{l[:m]} #{lang}\n"
          @manifest[:html] << %{<a href="#{l[:m]}">#{lang}</a>&nbsp;&nbsp;&nbsp; }
        end
        @manifest[:html] << %{</p></th></tr>\n}
      end
      def published_languages(id,file)
        flv=@env.published_manifests?(@base_path)
        flv.each do |l|
          lang=SiSU_Translate::Source.new(@md,@language,l[:l]).language_list
          @manifest[:txt] << "#{l[:m]} #{lang}\n"
          @manifest[:html] << %{<tr><th class="left"><p class="bold"><a href="#{l[:m]}">#{lang}</a></p></th><td><p class="norm">#{lang}</p><p class="tiny"><a href="#@base_url/#{l[:m]}">#@base_url/#{l[:m]}</a></p></td><td class="right"><p class="right">&nbsp;</p></td></tr>\n}
        end
      end
      def metadata(id,info)
        @manifest[:html] << %{<tr><th class="left"><p class="bold">#{id}:</p></th><td><p class="left">#{info}</p></td></tr>\n}
      end
      def links(url,lnk,target)
        static=if url =~/^\.\//: url.gsub(/^\.(\.)?/,@base_url)
        elsif url =~/^\.\.\//:   url.gsub(/^\.(\.)?/,@env.output_links_path[:url_root])
        else                     url                            
        end
        @manifest[:html] << %{<tr><th class="left"><p class="norm"><a href="#{url}">#{lnk}</a></p><p class="tiny"><a href="#{static}">#{static}</a></p></th></tr>\n}
      end
      def output_tests
        if FileTest.file?("#@base_path/#{@md.fn[:toc]}")==true
          id,file='HTML table of contents (linked to segmented text)',@md.fn[:toc]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:doc]}")==true
          id,file='HTML document (scroll)',@md.fn[:doc]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:xhtml]}")==true
          id,file='XHTML',@md.fn[:xhtml]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:sax]}")==true
          id,file='XML (SAX)',@md.fn[:sax]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:dom]}")==true
          id,file='XML (DOM)',@md.fn[:dom]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:odf]}")==true
          id,file='ODF:ODT (Open Document Format)',@md.fn[:odf]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p]}")==true
          id,file='PDF (portrait)',@md.fn[:pdf_p]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_l]}")==true
          id,file='PDF (landscape)',@md.fn[:pdf_l]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:plain]}")==true
        if    @md.cmd =~/a/: id,file='plaintext Unix (UTF-8) (footnotes)',@md.fn[:plain]
        elsif @md.cmd =~/e/: id,file='plaintext Unix (UTF-8) (endnotes)',@md.fn[:plain]
        elsif @md.cmd =~/A/: id,file='plaintext dos (UTF-8) (footnotes)',@md.fn[:plain]
        elsif @md.cmd =~/E/: id,file='plaintext dos (UTF-8) (endnotes)',@md.fn[:plain]
        else                id,file='plaintext (UTF-8)',@md.fn[:plain]
        end
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:concordance]}")==true
          id,file='Concordance (wordmap)',@md.fn[:concordance]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fns}.tex")==true
          id,file='LaTeX (portrait)',"#{@md.fns}.tex"
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fns}.tex")==true
          id,file='LaTeX (landscape)',"#{@md.fns}.landscape.tex"
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:digest]}")==true
          id,file="Digest/DCC - Document Content Certificate (#@dg)",@md.fn[:digest]
          summarize(id,file)
        end
      end
      def published_versions
        if FileTest.file?("#@base_path/sisu_manifest.html")==true
          id,file='Markup (SiSU source)',@md.fns
          languages(id,file)
        end
      end
      def language_versions
        if FileTest.file?("#@base_path/sisu_manifest.html")==true
          id,file='Markup (SiSU source)',@md.fns
          published_languages(id,file)
        end
      end
      def source_tests
        if @md.fns =~/\._sst$/                                                  #% decide whether to extract and include requested/required documents
          req=@md.fns.gsub(/(.+)?\._sst$/,"\\1.composite.sst") #watch strange
          if FileTest.file?("#@base_path/#{req}")==true
            id,file='Markup Composite File (SiSU source)',req
            summarize_source(id,file)
          end
        end
        if FileTest.file?("#@base_path/#{@md.fns}")==true
          id,file='Markup (SiSU source)',@md.fns
          summarize_source(id,file)
        end
        if FileTest.file?("#@base_path/sisupod.tgz")==true
          id,file='SiSU doc (tar gzip)','sisupod.tgz'
          summarize_source(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fnb}")==true and @md.fnb =~/\.kdi$/
          id,file='Kdissert (.kdi source)',@md.fnb
          summarize_source(id,file)
        end
        #if FileTest.file?("#@base_path/#{@md.fns}.meta")==true
        #  id,file='Markup (SiSU source)','#{@md.fns}.meta'
        #  summarize(id,file)
        #end
        #if FileTest.file?("#@base_path/#{@md.fns}.tgz")==true
        #  id,file='sisupod (tar gzip)','#{@md.fns}.tgz'
        #  summarize(id,file)
        #end
      end
      def metadata_tests
        if @md.dc_title
          id,info=@translate.dc_title,@md.dc_title
          metadata(id,info)
        end
        if @md.title
          id,info=@translate.title,@md.title
          metadata(id,info)
        end
        if @md.subtitle
          id,info=@translate.subtitle,@md.subtitle
          metadata(id,info)
        end
        if @md.dc_creator
          id,info=@translate.creator,@md.dc_creator
          metadata(id,info)
        end
        if @md.dc_contributor
          id,info=@translate.contributor,@md.dc_contributor
          metadata(id,info)
        end
        if @md.translator
          id,info=@translate.translator,@md.translator
          metadata(id,info)
        end
        if @md.illustrator
          id,info=@translate.illustrator,@md.illustrator
          metadata(id,info)
        end
        if @md.dc_publisher
          id,info=@translate.publisher,@md.dc_publisher
          metadata(id,info)
        end
        if @md.prepared_by
          id,info=@translate.prepared_by,@md.prepared_by
          metadata(id,info)
        end
        if @md.digitized_by
          id,info=@translate.digitized_by,@md.digitized_by
          metadata(id,info)
        end
        if @md.dc_subject
          id,info=@translate.subject,@md.dc_subject
          metadata(id,info)
        end
        if @md.dc_description
          id,info=@translate.dc_description,@md.dc_description
          metadata(id,info)
        end
        if @md.abstract
          id,info=@translate.abstract,@md.abstract
          metadata(id,info)
        end
        if @md.dc_type
          id,info=@translate.type,@md.dc_type
          metadata(id,info)
        end
        #if @md.owner
        #  id,info='Owner',@md.owner
        #  metadata(id,info)
        #end
        #if @md.copyright
        #  id,info='Copyright',@md.copyright
        #  metadata(id,info)
        #end
        if @md.dc_rights
          id,info=@translate.rights,@md.dc_rights
          metadata(id,info)
        end
        if @md.dc_date
          id,info=@translate.date,@md.dc_date
          metadata(id,info)
        end
        if @md.dc_date_created
          id,info=@translate.date_created,@md.dc_date_created
          metadata(id,info)
        end
        if @md.dc_date_issued
          id,info=@translate.date_issued,@md.dc_date_issued
          metadata(id,info)
        end
        if @md.dc_date_available
          id,info=@translate.date_available,@md.dc_date_available
          metadata(id,info)
        end
        if @md.dc_date_modified
          id,info=@translate.date_modified,@md.dc_date_modified
          metadata(id,info)
        end
        if @md.dc_date_valid
          id,info=@translate.date_valid,@md.dc_date_valid
          metadata(id,info)
        end
        if @md.dc_language and @md.dc_language[:name]
          id,info=@translate.language,@md.dc_language[:name]
          metadata(id,info)
        end
        if @md.language_original and @md.language_original[:name]
          id,info=@translate.language_original,@md.language_original[:name]
          metadata(id,info)
        end
        if @md.dc_format
          id,info=@transate.format,@md.dc_format
          metadata(id,info)
        end
        if @md.dc_identifier
          id,info=@translate.identifier,@md.dc_identifier
          metadata(id,info)
        end
        if @md.dc_source
          id,info=@translate.source,@md.dc_source
          metadata(id,info)
        end
        if @md.dc_relation
          id,info=@translate.relation,@md.dc_relation
          metadata(id,info)
        end
        if @md.dc_coverage
          id,info=@translate.coverage,@md.dc_coverage
          metadata(id,info)
        end
        if @md.keywords
          id,info=@translate.keywords,@md.keywords
          metadata(id,info)
        end
        if @md.comments
          id,info=@translate.comments,@md.comments
          metadata(id,info)
        end
        if @md.cls_loc
          id,info=@translate.cls_loc,@md.cls_loc
          metadata(id,info)
        end
        if @md.cls_dewey
          id,info=@translate.cls_dewey,@md.cls_dewey
          metadata(id,info)
        end
        if @md.cls_pg
          id,info=@translate.cls_gutenberg,@md.cls_pg
          metadata(id,info)
        end
        if @md.cls_isbn
          id,info=@translate.cls_isbn,@md.cls_isbn
          metadata(id,info)
        end
        if @md.prefix_a
          id,info=@translate.prefix_a,@md.prefix_a
          metadata(id,info)
        end
        if @md.prefix_b
          id,info=@translate.prefix_b,@md.prefix_b
          metadata(id,info)
        end
        if @md.fns
          id,info=@translate.sourcefile,@md.fns
          metadata(id,info)
        end
        if @md.en[:mismatch] > 0
          id,info='WARNING document error in endnote markup, number mismatch',"endnotes: #{@md.en[:note]} != endnote reference marks: #{@md.en[:mark]} (difference = #{@md.en[:mismatch]})"
          metadata(id,info)
        end
        if @md.wc_words
          id,info=@translate.word_count,@md.wc_words
          metadata(id,info)
        end
        if @md.dgst
          id,info="#{@translate.sourcefile_digest} (#@dg)",@md.dgst[1]
          metadata(id,info)
        end
        if @md.sc_number
          id,info=@translate.sc_number,@md.sc_number
          metadata(id,info)
        end
        if @md.sc_date
          id,info=@translate.sc_date,"#{@md.sc_date} at #{@md.sc_time}"
          metadata(id,info)
        end
        if @md.generated
          id,info=@translate.last_generated,@md.generated
          metadata(id,info)
        end
        if @md.sisu_version
          id,info=@translate.sisu_version,"#{@md.sisu_version[:project]} #{@md.sisu_version[:version]} #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"
          metadata(id,info)
        end
        if @md.ruby_version
          id,info=@translate.ruby_version,@md.ruby_version
          metadata(id,info)
        end
      end
      def links_tests
        if defined? @md.lnk and @md.lnk
          @md.lnk.each do |l|
            if defined? l[:say]
              target=if l[:url] !~/^\.(\.)?\//: 'external'
              else                              '_top'
              end
              url,lnk=l[:url],l[:say]
              unless url.nil? or url.empty?: links(url,lnk,target)
              end
            end
          end
        end
      end
      def check_output
        begin
          id,file='',''
          url=SiSU_Viz::Url.new
          @manifest[:html] <<<<WOK
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">          
<head>
<title>
SiSU manifest: #{@md.title}
</title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="sourcefile" content="#{@md.fns}" />
<link rel="generator" href="http://www.jus.uio.no/sisu" />
<link rel="shortcut icon" href="../_sisu/image/rb7.ico" />
<link rel="stylesheet" href="../#{@env.style}/html.css" type="text/css" />
</head>
<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">
<table summary="band" border="0" cellpadding="3" cellspacing="0">
<tr><td align="left" bgcolor="#ffffff"><a href="http://www.jus.uio.no/sisu/" target="_top"><img border="0" src="#{url.path_image}/sisu.png" alt="SiSU --&gt;" /></a></td><td><p class="tiny"><a href="#@base_url/#{file}"><img border="0" height="12" width="12" src="#{url.path_image}/bullet_red.png"  alt="TOC linked" />&nbsp;#@base_url/#{file}</a></p></td></tr>
</table>
<h1 class="small">#{@md.dc_title}</h1>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
WOK
          published_versions
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="output">#{@translate.manifest_description_output}</a></h2>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.filename}</p></th><th class="left"><p class="bold">#{@translate.description}</p></th><th class="right"><p class="right"><b>#{@translate.file_size}</b></p><p class="tiny_right">(kB)</p></th></tr>

WOK
          output_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
WOK
          source_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="metadata">#{@translate.manifest_description_metadata}</a></h2>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.metadata}</p></th><th class="left"><p class="bold">#{@translate.description}</p></th></tr>
WOK
          metadata_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<table summary="normal text css" width="90%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr><th class="left"><p class="bold"><a name="links">#{@translate.suggested_links}:</a></p></th></tr>
WOK
          links_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="languages">#{@translate.language_version_list}</a></h2>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.filename}</p></th><th class="left"><p class="bold">#{@translate.description}</p></th><th class="right"><p class="right">&nbsp;</p></th></tr>

WOK
          language_versions
          @manifest[:html] <<<<WOK
</table>
</body>
</html>
WOK
          output
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    end
  end
end
__END__
