=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: SiSU information Structuring Universe, processing

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

=end
module SiSU
  require SiSU_lib + '/sysenv'
  include SiSU_Screen
  class Op
    def initialize(opt,x,tell)
      @opt,@x,@tell=opt,x,tell
      @n_do=0
    end
    def select
      require SiSU_lib + "/#@x"
      if @x =~/^conf$/:           SiSU_Initialize::Source.new(@opt).read    # -C
      end
      if not @opt.files.empty?
        @opt.files.each do |fns|
          put=fns.gsub(/(.+)?\._sst$/,'\1.ssm')
          @opt.fns=fns
          if @x !~/(?:urls|remote_put)$/
            if FileTest.file?(@opt.fns)
        	    case @opt.fns
        	    when /\.(?:[_-]?sst|ssm)$/
                case @x
                when /^metaverse$/
        	        if fns =~ /\.ssm$/: require SiSU_lib + '/composite'  #pre-processing
                    SiSU_Assemble::Composite.new(@opt).read
                    @opt.fns=fns.gsub(/\.ssm$/,'._sst')
                  end
                                          SiSU_Metaverse::Source.new(@opt).read     # -m
                when /^concordance$/:     SiSU_Concordance::Source.new(@opt).read   # -w
                when /^source$/:          SiSU_Markup::Source.new(@opt).read        # -s
                when /^sisudoc$/:         SiSU_Doc::Source.new(@opt).read           # -S
                when /^source_kdissert$/: SiSU_Kdi_source::Source.new(@opt).read    # -S
                when /^digests$/:         SiSU_Digest_view::Source.new(@opt).read   # -N
                when /^plaintext$/:       SiSU_Plaintext::Source.new(@opt).read     # -a -e -f
                when /^odf$/:             SiSU_ODF::Source.new(@opt).read           # -o
                when /^texpdf$/:          SiSU_TeX::Source.new(@opt).read           # -p
                when /^texinfo$/:         SiSU_TexInfo::Source.new(@opt).read       # -I
                when /^docbook$/:         SiSU_Docbook::Source.new(@opt).read       # -B
                when /^html$/:            SiSU_HTML::Source.new(@opt).read          # -h -H
                when /^xml$/:             SiSU_XML_SAX::Source.new(@opt).read       # -x
                when /^xml_dom$/:         SiSU_XML_DOM::Source.new(@opt).read       # -X
                when /^xhtml$/:           SiSU_XHTML::Source.new(@opt).read         # -b
                when /^manifest$/:        SiSU_Manifest::Source.new(@opt).read      # -y
                when /^zap$/:             SiSU_Zap::Source.new(@opt).read           # -Z
                when /^dbi$/:             SiSU_DBI::SiSU_SQL.new(@opt).connect      # -D -d
                end
    	          @n_do=@n_do+1
                tell=SiSU_Screen::Ansi.new(@opt.cmd,@n_do,"#{@x.upcase} processed")
                tell.files_processed unless @opt.cmd =~/q/
                ObjectSpace.garbage_collect
        	    else                    #print "not processed --> ", fns, "\n"
        	    end
            else                      Operations.new(@opt).not_found
            end
          elsif FileTest.file?(put)
            case @x
            when /^urls$/:           SiSU_urls::Source.new(@opt).read           # -u -v -V -M
            when /^remote_put$/
              case @tell
              when /scp/:            SiSU_Remote::Put.new(@opt).scp             # -r
              when /rsync/:          SiSU_Remote::Put.new(@opt).rsync           # -R
              else                   #SiSU_Remote::Put.new(put,@opt.cmd).scp
              end
            end
          else                       Operations.new(@opt).not_found
          end
        end
      elsif @x =~/^dbi$/:            SiSU_DBI::SiSU_SQL.new(@opt).connect      # -D -d
      end
      Operations.new.counter
    end
  end
  class Operations
    @@n_do=0
    def initialize(opt='')
      @opt=opt
      @cX=SiSU_Screen::Ansi.new(@opt).cX
    end
    def counter
      @@n_do=0
    end
    def remote_put_base_site_rsync                                               # -CR
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).rsync_base
    end
    def remote_put_base_site_rsync_match                                         # -CCRZ
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
exit
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).rsync_base_sync
    end
    def remote_put_base_site                                                     # -Cr
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).scp_base
    end
    def remote_put_base_site_all                                                 # -CCr
p "here #{__FILE__} #{__LINE__}" if @opt =~/M/
      require SiSU_lib + '/remote_put'
      SiSU_Remote::Put.new(@opt).scp_base_all
    end
    def cgi                                                                      # -F
      require SiSU_lib + '/cgi'
      SiSU_CGI::SiSU_search.new(@opt).read
    end
    def encoding                                                                 # -K build character encoding db (uses KirbyBase)
      require SiSU_lib + '/character_encoding'
      SiSU_character_encode::Create.new.db
      #x=SiSU_character_encode::Query.new
      #x.report
      #x.table
      #y=x.hex('55','dec')
      #y=x.name(' A','name')
      #puts y
    end
    def termsheet                                                                # -t
      system("sisu_termsheet #{@opt.cmd} #@fns\n")
    	@@n_do=@@n_do+1
      tell=SiSU_Screen::Ansi.new(@opt.cmd,@@n_do,'Termsheet(s) processed')
      tell.term_sheet_title unless @opt.cmd =~/q/
    end
    def webrick                                                                  # -W
      port=prt=@fns
      dir=SiSU_Env::Info_dir.new #(@fns)
      prt=if prt !~/\d+/: 'webrick default (sysenv)' 
      else                "webrick port set to #{prt}"
      end
    	puts 	%{#{@cX.blue}<<#{@cX.off}#{@cX.green}Start Webrick web server on port: #{prt}#{@cX.off}#{@cX.blue}>> #{@cX.off*2} }
      system(%{sisu_webrick #{port}&\n} )
    end
    def semantics                                                                # not used
    #  @inst=@fns
    #  system(%{semantics.rb #@inst\n})
    #  tell=SiSU_Screen::Ansi.new(@opt.cmd,@@n_ym,'files processed for YAML semantic Info')
    #  tell.files_processed unless @opt.cmd =~/q/
    end
    def not_found
      puts "\n#{@cX.fuschia}FILE NOT FOUND:#{@cX.off} << #{@opt.fns} >> - requested #{@opt.cmd} processing skipped\n"
    end
    def convert_name_message(fns,type,i,o,rune)
      %{\nIn filename: "#{@cX.fuschia}#{fns}#{@cX.off}" << #{type} >> #{@cX.fuschia}is apre 0.36 markup filename.#{@cX.off} #{@cX.brown}Please rename your file.#{@cX.off}\n\tAs of sisu-0.37, SiSU markup files with #{@cX.brown}the extensions #{i} should be re-named #{o}#{@cX.off}\n\tif you have the program called 'rename' installed, the following rune should do the trick:\n\t\t#{rune}\n\talternatively try:\n\t\tsisu --convert --36to37 #{fns}\n\trequested #{@opt.cmd} processing skipped\n}
    end
    def not_recognised
      case @opt.fns
      when /(\.s[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,"\\1")
        rune=%q{rename 's/\.s[123]$/\.sst/' *.s{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.s1 .s2 and .s3','.sst',rune)
      when /(\.r[123])$/
        type=@opt.fns.gsub(/\S+?(#{$1})/,"\\1")
        rune=%q{rename 's/\.r[123]$/\.ssm/' *.r{1,2,3}}
        puts convert_name_message(@opt.fns,type,'.r1 .r2 and .r3','.sst',rune)
        puts %{\n\tNote also that you will need to change the names of the files called/required\n\twithin the document text to build the composite document\n\t\t.s1 .s2 .s3 should be .sst \n\t\t.si should be .ssi\n\trequested #{@opt.cmd} processing skipped\n}
      when /(\.ssi)$/
        puts "\n#{@cX.fuschia}component filetype:#{@cX.off} << #{@opt.fns} >> - is not a processed filetype, (it may be used as a component of a .ssm markup file)\n\trequested #{@opt.cmd} processing skipped\n"
      else
        puts "\n#{@cX.fuschia}FILETYPE NOT RECOGNISED:#{@cX.off} << #{@opt.fns} >> - is not a recognized filetype,\n\trequested #{@opt.cmd} processing skipped\n"
      end
    end
  end
  class Processing
    require 'fileutils'
    include FileUtils
    def initialize(opt)
      @opt=opt
    end
    def actions
      if @opt.mod_s =~/--convert/: require SiSU_lib + '/convert_markup'
      end
      if @opt.cmd =~/([AabCcDdEeFfGHhIiLMmNnoprRSsTtQqUuVvwWXxyZ_0-9])/ and
         @opt.cmd =~/^-/ #and
        @@tell=SiSU_Screen::Ansi.new(@opt.cmd)
        @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
        flag=SiSU_Env::Info_processing_flag.new
        if @opt.cmd =~/(all|sisu)/: system(%{nohup nice sisu -hwp *&\n})
        end
        extra=''
        if @opt.cmd !~/[mn]/
          extra+=if @opt.cmd =~/[abBehHhINoptwXxz]/ and @opt.cmd !~/[mn]/: 'm'           #% add metaverse
          elsif @opt.cmd =~/[Dd]/ and @opt.mod_s !~/^(?:remove|(?:re)?create(?:all)?|dropall|drop)$/ and @opt.cmd !~/[mn]/
            'm'       #% add metaverse
          else ''
          end
        end
        if @opt.cmd !~/y/
          extra+=if @opt.cmd =~/[abehHhINopsSstwXxz]/ and @opt.cmd !~/y/: 'y'            #% add manifest
          elsif @opt.cmd =~/[Dd]/ and @opt.files[0] !~/^remove$/ and @opt.cmd !~/y/: 'y' #% add manifest
          else ''
          end
        end
        @opt.cmd=@opt.cmd + extra  
        if @opt.cmd =~/[vVM]/                                                            #% version information
          version=Hash.new
          version=SiSU_Env::Info_version.new.get_version
          rb_ver=SiSU_Env::Info_version.new.rbversion
          if version[:version]
            tell=SiSU_Screen::Ansi.new(@opt.cmd,version[:project],version[:version],version[:date_stamp],version[:date],rb_ver)
          tell.version
          else puts 'SiSU version information not available'
          end
        end
        if @opt.cmd =~/^-L$/: SiSU_Help::Help.new('license',opt).help_request            #% version information
        end
        if @opt.cmd =~/m/i                                                     #% -m for -C
          dir=SiSU_Env::Info_dir.new
          path_css="#{dir.data_o}/_sisu/css"
          path_dtd="#{dir.data_o}/_sisu/dtd"
          unless FileTest.directory?(path_css) and FileTest.directory?(path_dtd)
            @opt.cmd=@opt.cmd +='C' unless @opt.cmd =~/C/
            #@opt.mod_s=@opt.mod_s +='--initialize=site' unless @opt.mod_s =~/--init(?:ialize)?=site/
          end
          if @opt.cmd =~/M/: $VERBOSE=false                                    #debug $VERBOSE=true
            # -M test other expected directories including images
          end
        end
        if @opt.cmd =~/C/                                                      #% -C initialize/configure
          Op.new(@opt,'conf','configure site').select
          if @opt.cmd =~/R/
            if @opt.mod_s =~/--init(?:ialize)?=site/ and
               @opt.cmd =~/RZ/
              Operations.new(@opt).remote_put_base_site_rsync_match
            else Operations.new(@opt).remote_put_base_site_rsync
            end
          elsif @opt.cmd =~/r/
            if @opt.mod_s =~/--init(?:ialize)?=site/ and
               @opt.cmd =~/CCr/
              Operations.new(@opt).remote_put_base_site_all
            else Operations.new(@opt).remote_put_base_site
            end
          end
        end
        if @opt.cmd =~/F/                                                      #% -F cgi sample search form
          Operations.new(@opt).cgi
        end
        if @opt.cmd =~/W/: Operations.new(@opt).webrick                        #% -W webrick #@argv==port
        end
        if @opt.cmd =~/k/                                                      #% -k dummy, build character encoding table
          #Operations.new(@opt.cmd).encoding
        end
        if @opt.cmd =~/Z/: Op.new(@opt,'zap','Zap, deletions').select          #% -Z wipe previous output clean
        end
        if @opt.cmd =~/s/: Op.new(@opt,'source','SiSU markup source').select   #% -s sisu source
        end
        if @opt.cmd =~/m/                                                      #% -m remote url requested? check whether (and download if) remote files requested for processing
          @retry_count= -1
          begin
            path_image='./_sisu/processing/external_document/image'
            path_skin='./_sisu/processing/external_document/skin/doc'
            #File.mkpath(path_image) unless FileTest.directory?(path_image)
            #File.mkpath(path_skin) unless FileTest.directory?(path_skin)
            @get=Array.new
            re=/(http:\/\/\S+?\.sst)/
        	  @opt.files.each do |fns|
              if fns =~re
                #fnu=URI.parse(fns)
                @get << re.match(fns)[1] if re 
              end
            end
            if @get.length > 0
              require 'open-uri'
              require 'pp'
              require SiSU_lib + '/composite'
              @rgx_image=/\{\s*(\S+?\.(?:png|jpg))/
              @rgx_skin=/0~skin\s+(\S+)/
              #ext_doc="#{Dir.pwd}/_sisu/processing/external_document/"
              #File.mkpath("#{ext_doc}/skin/doc") unless FileTest.directory?("#{ext_doc}/skin/doc")
              #File.mkpath("#{ext_doc}/image") unless FileTest.directory?("#{ext_doc}/image")
              threads = []
              for requested_page in @get
                threads << Thread.new(requested_page) do |url|
                  open(url) do |f|
                    raise "#{url} not found" unless f
                    re_fnb=/(http:\/\/[^\/ ]+?\/[^\/ ]+?)\/\S+?\/([^\/]+?)\.ss(t)/ #revisit and remove DO
                    #re_fnb=/(http:\/\/[^\/ ]+?\/[^\/ ]+?)\/\S+?\/([^\/]+?)\.s([1-3])/
                    base_uri,fnb,instr=re_fnb.match(url)[1..3] if re_fnb
                    imagedir = base_uri + '/_sisu/image_local' #check on
                    doc_skin_dir = /(http:\/\/\S+?)\/[^\/]+?\.sst$/i.match(url).captures.join + '/_sisu/skin/doc'
                    #"Got file, and ready to process: #{fnb}.t#{instr}"
                    downloaded_file=File.new("#{fnb}.-sst",'w+')
                    images=SiSU_Assemble::Remote_image.new.image(imagedir)
                    skin=SiSU_Assemble::Remote_image.new.image(doc_skin_dir)
                    f.collect.each do |r|                                          #% work area
                      skin << r.scan(@rgx_skin).uniq if r =~@rgx_skin     
                      images << r.scan(@rgx_image).uniq if r =~@rgx_image     
                      downloaded_file << r
                    end
                    if skin and skin.length > 0
                      SiSU_Assemble::Remote_image.new.download_doc_skin(skin)
                    end
                    if images and images.length > 1
                      images.flatten!.uniq! 
                      tell=SiSU_Screen::Ansi.new('','downloading images:',images.join(','))
                      tell.warn unless @opt.cmd =~/q/
                      SiSU_Assemble::Remote_image.new.download_images(images)
                      tell=SiSU_Screen::Ansi.new('','downloading done')
                      tell.warn unless @opt.cmd =~/q/
                    end
                    downloaded_file.close
                  end
                end
              end
              Operations.new.counter
            end
            threads.each {|thr| thr.join} if threads #and threads.length > 0
          rescue: SiSU_Errors::Info_error.new($!,$@,@opt,@fns).error #ok
            @retry_count +=1
            retry unless @retry_count > 1
          ensure
          end
          @opt.files=@opt.files.collect {|x| x=x.gsub(/http:\/\/\S+\/(\S+)\.sst/,"\\1.-sst") }
        end
        if @opt.cmd=~/m/: Op.new(@opt,'metaverse','metaverse').select          #% -m metaverse
        end
        @opt.files=@opt.files.collect {|x| x=x.gsub(/\.ssm$/,'._sst') }
        if @opt.cmd =~/S/
          Op.new(@opt,'sisudoc','sisupod (tgz)').select                        #% -S make sisupod
          if @opt.fns=~/\.kdi._sst/
            Op.new(@opt,'source_kdissert','kdissert (kdi)').select            #% -S share kdissert source
          end
        end
        if @opt.cmd =~/N/: Op.new(@opt,'digests','digests').select             #% -N digest tree
        end
        if @opt.cmd =~/[hHz]/: Op.new(@opt,'html','html').select               #% -h -H -z html css
        end
        if @opt.cmd =~/[aAfeE]/: Op.new(@opt,'plaintext','plaintext').select   #% -a -A -f -e -E plaintext -a creates ms-dos type; -A creates unix type, plaintext file
        end
        if @opt.cmd =~/o/: Op.new(@opt,'odf','OpenDocument').select            #% -o opendocument
        end
        if @opt.cmd =~/x/: Op.new(@opt,'xml','xml sax').select                 #% -x xml sax type
        end
        if @opt.cmd =~/X/: Op.new(@opt,'xml_dom','xml dom').select             #% -X xml dom type
        end
        if @opt.cmd =~/b/: Op.new(@opt,'xhtml','xhtml sax').select             #% -b xhtml sax type
        end
        if @opt.cmd =~/B/: Op.new(@opt,'docbook','docbook xml').select         #% -B docbook xml
        end
        if @opt.cmd =~/w/: Op.new(@opt,'concordance','Concordance').select     #% -w concordance
        end
        if @opt.cmd =~/t/                                                      #% -t termsheet/standard form
          @help.termsheet if @opt.files.length==0
        	@opt.files.each do |fns|
            if FileTest.file?(fns)
              @opt.fns=fns
        		  case @opt.fns
        		  when /\.(termsheet.rb)$/:            Operations.new(@opt).termsheet
        		  else              		  	           #print "not processed --> ", fns, "\n"
        		  end
            else                                   Operations.new(@opt).not_found
            end
        	end
          Operations.new.counter
        end
        if @opt.cmd =~/p/: Op.new(@opt,'texpdf','LaTeX pdf').select            #% -p latex/ texpdf
        end
        if @opt.cmd =~/I/: Op.new(@opt,'texinfo','TeX Info').select            #% -I texinfo (i taken by db import)
        end
        if @opt.cmd =~/D/: Op.new(@opt,'dbi','postgresql').select              #% -D DB postgresql
        end
        if @opt.cmd =~/d/: Op.new(@opt,'dbi','sqlite').select                  #% -d DB sqlite
        end
        if @opt.cmd =~/G/: Operations.new(@opt).cgi                            #% -G cgi - used to make dbi intecface
        end
        if @opt.cmd =~/y/: Op.new(@opt,'manifest','Manifest').select           #% -y manifest
        end
        if @opt.cmd =~/r/: Op.new(@opt,'remote_put','scp').select              #% -r copy to remote server
        end
        if @opt.cmd =~/R/: Op.new(@opt,'remote_put','rsync').select            #% -R copy to remote server
        end
        if @opt.cmd =~/[QuUvVM]/: Op.new(@opt,'urls','urls').select            #% -Q -u -v -V -M urls
        end
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"\tsisu -W [to start ruby web-server on output directory]\n")
        tell.print_brown if @opt.cmd =~/[uUvVM]/ unless @opt.files.join.empty?
        if defined? dir.processing and FileTest.directory?(dir.processing) and dir.processing =~/#{dir.user}$/ #clean temporary processing directory of content as is located in public area
          cd(dir.processing_path_tmp_base) do
            rm_rf(dir.user) unless @opt.cmd =~/M/
          end
        end
      elsif @opt.mod_s =~/--query/
        require SiSU_lib + '/identify_markup'
        puts SiSU_Markup::Markup_history.new(@opt).query
      elsif @opt.mod_s =~/--identify/
        require SiSU_lib + '/identify_markup'
        markup_version=SiSU_Markup::Markup_identify.new(@opt).markup_version?
      elsif  @opt.mod_s =~/--about/                                                   #% help instructions
        if @opt.mod_s =~/--about/ and not @opt.what.empty?: SiSU_Help::Help.new(@opt.what,'color_off').help_request 
        else SiSU_Help::Help.new('list','color_off').help_request 
        end
      else                                                                         #% help instructions
        unless @opt.mod_s =~/--convert/
          if @opt.mod_s =~/--help/ and not @opt.what.empty?: SiSU_Help::Help.new(@opt.what).help_request 
          else SiSU_Help::Help.new('list').help_request 
          end
        end
      end
      @opt.files.each do |fns|
        if FileTest.file?(fns)
          @opt.fns=fns
          unless @opt.fns =~ /\.([_-]?sst|termsheet.rb)$/
            if @opt.fns=~/\.kdi$/ and @opt.mod_s !~/--convert=kdi/
              Operations.new(@opt).not_recognised
            elsif @opt.fns=~/\.kdi$/ and @opt.mod_s =~/--convert=kdi/
            else Operations.new(@opt).not_recognised
            end
          end
          if @opt.fns =~/\._sst$/ and @opt.cmd !~/[S_M]/ # rework necessry, revist, the _ flag is a hack, to keep ._sst files
            tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"temporary file removed")
            tell.warn if @opt.cmd =~/V/
            File.unlink(@opt.fns) if File.exists?(@opt.fns) #CONSIDER
          end
        else                          #Operations.new(fns,'html').not_found
        end
      end
    end
  end
  begin                                                                            #% select what to do
    require 'jcode'
    $KCODE='UTF8'
    include SiSU
    require SiSU_lib + '/options'
    require SiSU_lib + '/sysenv'
    include SiSU_Env
    include SiSU_Screen
    require SiSU_lib + '/param'
    include SiSU_Param
    require SiSU_lib + '/defaults'
    include SiSU_Viz
    #require SiSU_lib + '/spell'
    #include Utility
    require SiSU_lib + '/help'
    include SiSU_Help
    require 'uri'
    home=ENV['HOME']
    argv=$*
    @opt=SiSU_commandline::Options.new(argv)
    #@op=Operations.new(@opt)
    Processing.new(@opt).actions
  rescue: STDERR.puts SiSU_Screen::Ansi.new(@opt,$!,$@,nil).rescue #fix
  ensure
    Dir.chdir(PWD)
  end
end
__END__
