=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: html generation, html pre-processing

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
require SiSU_lib + '/param'
module SiSU_Tune
  require SiSU_lib + '/sysenv'
  require SiSU_lib + '/param'
  require SiSU_lib + '/html_format' #watch
  include SiSU_Env
  include SiSU_Screen
  @@line_mode=''
  @@endnote_array=Array.new
  @@endnote_call_counter=1
  @@table_align=%{<table summary='' width="96%" border="0" bgcolor="white" cellpadding="0" col="3">
<tr ...><td width="2%" align="right">
&nbsp\;</td>
<td width="94%" valign="top" align="justify">}
  @@table_align_close=%{</td>
<td width="4%" align="right" valign="top"> 
<font size="1" color="#777777">
&nbsp;&nbsp;&nbsp;</font> </td></tr></table>}
  @@counter,@@column,@columns=0,0,0
  class MyOutput
    def initialize(data,md)
      @data,@md=data,md
      @cX=SiSU_Screen::Ansi.new(@md.cmd).cX
    end
    def hard_output
      my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      @filename_tune=my_make.file_tune
      data=Array.new
      @data.each{|x| x.strip; data << x if not x.empty?} #1.9 array?
      data.each do |para|
        @filename_tune.puts para, "\n" #if para !~/¡/
      end
    end
    def marshal
      my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
      @marshal_tune=my_make.marshal_tune
      File.open(@marshal_tune,'w') {|f| Marshal.dump(@data.to_a,f)}
    end
  end
  class Clean_html
    def initialize(html='')
      @html=html
    end
    def clean
      @html.gsub!(/¢/,'&cent;')    # &#162; 
      @html.gsub!(/£/,'&pound;')   # &#163;
      @html.gsub!(/¥/,'&yen;')     # &#165;
      @html.gsub!(/§/,'&sect;')    # &#167;
      @html.gsub!(/©/,'&copy;')    # &#169;
      @html.gsub!(/ª/,'&ordf;')    # &#170;
      @html.gsub!(/«/,'&laquo;')   # &#171;
      @html.gsub!(/®/,'&reg;')     # &#174;
      @html.gsub!(/°/,'&deg;')     # &#176;
      @html.gsub!(/±/,'&plusmn;')  # &#177;
      @html.gsub!(/²/,'&sup2;')    # &#178;
      @html.gsub!(/³/,'&sup3;')    # &#179;
      @html.gsub!(/µ/,'&micro;')   # &#181;
      @html.gsub!(/¶/,'&para;')    # &#182;
      @html.gsub!(/¹/,'&sup1;')    # &#185;
      @html.gsub!(/º/,'&ordm;')    # &#186;
      @html.gsub!(/»/,'&raquo;')   # &#187;
      @html.gsub!(/¼/,'&frac14;')  # &#188;
      @html.gsub!(/½/,'&frac12;')  # &#189;
      @html.gsub!(/¾/,'&frac34;')  # &#190;
      @html.gsub!(/×/,'&times;')   # &#215;
      @html.gsub!(/÷/,'&divide;')  # &#247;
      @html.gsub!(/¿/,'&iquest;')  # &#191;
      @html.gsub!(/À/,'&Agrave;')  # &#192;
      @html.gsub!(/Á/,'&Aacute;')  # &#193;
      @html.gsub!(/Â/,'&Acirc;')   # &#194;
      @html.gsub!(/Ã/,'&Atilde;')  # &#195;
      @html.gsub!(/Ä/,'&Auml;')    # &#196;
      @html.gsub!(/Å/,'&Aring;')   # &#197;
      @html.gsub!(/Æ/,'&AElig;')   # &#198;
      @html.gsub!(/Ç/,'&Ccedil;')  # &#199;
      @html.gsub!(/È/,'&Egrave;')  # &#200;
      @html.gsub!(/É/,'&Eacute;')  # &#201;
      @html.gsub!(/Ê/,'&Ecirc;')   # &#202;
      @html.gsub!(/Ë/,'&Euml;')    # &#203;
      @html.gsub!(/Ì/,'&Igrave;')  # &#204;
      @html.gsub!(/Í/,'&Iacute;')  # &#205;
      @html.gsub!(/Î/,'&Icirc;')   # &#206;
      @html.gsub!(/Ï/,'&Iuml;')    # &#207;
      @html.gsub!(/Ð/,'&ETH;')     # &#208;
      @html.gsub!(/Ñ/,'&Ntilde;')  # &#209;
      @html.gsub!(/Ò/,'&Ograve;')  # &#210;
      @html.gsub!(/Ó/,'&Oacute;')  # &#211;
      @html.gsub!(/Ô/,'&Ocirc;')   # &#212;
      @html.gsub!(/Õ/,'&Otilde;')  # &#213;
      @html.gsub!(/Ö/,'&Ouml;')    # &#214;
      @html.gsub!(/Ø/,'&Oslash;')  # &#216;
      @html.gsub!(/Ù/,'&Ugrave;')  # &#217;
      @html.gsub!(/Ú/,'&Uacute;')  # &#218;
      @html.gsub!(/Û/,'&Ucirc;')   # &#219;
      @html.gsub!(/Ü/,'&Uuml;')    # &#220;
      @html.gsub!(/Ý/,'&Yacute;')  # &#221;
      @html.gsub!(/Þ/,'&THORN;')   # &#222;
      @html.gsub!(/ß/,'&szlig;')   # &#223;
      @html.gsub!(/à/,'&agrave;')  # &#224;
      @html.gsub!(/á/,'&aacute;')  # &#225;
      @html.gsub!(/â/,'&acirc;')   # &#226;
      @html.gsub!(/ã/,'&atilde;')  # &#227;
      @html.gsub!(/ä/,'&auml;')    # &#228;
      @html.gsub!(/å/,'&aring;')   # &#229;
      @html.gsub!(/æ/,'&aelig;')   # &#230;
      @html.gsub!(/ç/,'&ccedil;')  # &#231;
      @html.gsub!(/è/,'&egrave;')  # &#232;
      @html.gsub!(/é/,'&eacute;')  # &#233;
      @html.gsub!(/ê/,'&ecirc;')   # &#234;
      @html.gsub!(/ë/,'&euml;')    # &#235;
      @html.gsub!(/ì/,'&igrave;')  # &#236;
      @html.gsub!(/í/,'&iacute;')  # &#237;
      @html.gsub!(/î/,'&icirc;')   # &#238;
      @html.gsub!(/ï/,'&iuml;')    # &#239;
      @html.gsub!(/ð/,'&eth;')     # &#240;
      @html.gsub!(/ñ/,'&ntilde;')  # &#241;
      @html.gsub!(/ò/,'&ograve;')  # &#242;
      @html.gsub!(/ó/,'&oacute;')  # &#243;
      @html.gsub!(/ô/,'&ocirc;')   # &#244;
      @html.gsub!(/õ/,'&otilde;')  # &#245;
      @html.gsub!(/ö/,'&ouml;')    # &#246;
      @html.gsub!(/ø/,'&oslash;')  # &#248;
      @html.gsub!(/ù/,'&ugrave;')  # &#250;
      @html.gsub!(/ú/,'&uacute;')  # &#251;
      @html.gsub!(/û/,'&ucirc;')   # &#252;
      @html.gsub!(/ü/,'&uuml;')    # &#253;
      @html.gsub!(/þ/,'&thorn;')   # &#254;
      @html.gsub!(/ÿ/,'&yuml;')    # &#255;   
      @html.gsub!(/ý/,'&yacute;')
      @html
    end
  end
  class MyTune
    @@dp=nil
    def initialize(data,md)
      @data,@md=data,md
      @url=SiSU_Viz::Url.new
      @color=SiSU_Viz::Color.new
      @icon=SiSU_Viz::Icon.new
      @env=SiSU_Env::Info_dir.new(@md.fns)
      @sys=SiSU_Env::System_call.new
      @@dp ||=SiSU_Env::Info_dir.new.digest_pattern
      #@utf8=SiSU_character_encode::UTF8 #.new
    end
    def songsheet
      begin
        @cX=SiSU_Screen::Ansi.new(@md.cmd).cX
        tell=SiSU_Screen::Ansi.new(@md.cmd,'Tune')
        tell.txt_grey unless @md.cmd =~/q/
        #print "\t#{@cX.grey}Tune#{@cX.off}\n" 
        data=MyTune.new(@data,@md).endnotes_html
        data=MyTune.new(data,@md).url_markup
        if @sys.locale =~/utf-?8/i
          data=MyTune.new(data,@md).utf8_markup 
        end
        MyTune.new(@data,@md).output
        #Hard Output Tune Optional on/off here (4 lines) ->
          data=MyOutput.new(data,@md).hard_output
          data=MyOutput.new(data,@md).marshal
      rescue: SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
    def para_numbers
      data=@data
      @tuned_file=Array.new
      data.each do |para|
        para.gsub!(/(\d~(\S+))/,%{\\1<a name="H#\\2">#\\2.</a>&nbsp;})
        @tuned_file << para
      end
    end
    def utf8_markup
      @tuned_file=Array.new
      @data.each do |para|
        #@utf8.new(para).html
        #@utf8.html(@para)
        if @sys.locale =~/utf-?8/i # instead ucs for utf8 #require 'iconv' ? Iñtërnâtiônàlizætiøn
          #¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûü
          #¢£¥§©ª«®°±²³µ¶¹º»¼½¾×÷
          ##para.gsub!(//, '&#;')
          ##para.gsub!(//, '&;')
          para=SiSU_Tune::Clean_html.new(para).clean
        end
        @tuned_file << para
      end
    end
    def url_markup
      data=@data
      @tuned_file=Array.new
      data.each do |para|
        para.gsub!(/<:name\#(\S+?)>/,%{<a name="\\1"></a>})
        para.gsub!(/<-#>/,'')
        para.gsub!(/<:p[bn]>/,'')
        para.gsub!(/<(p|br)>/i,%{<\\1 />})
        para.gsub!(/<:br>/i,%{<br />})
        if para =~/<::\s+/ #watch
          para.gsub!(/<::\s+(\S+?)\s+!>/i,
            %{<img src="#{@env.url_images}/c_\\1.png" alt="\\1" width="14" height="14" align="bottom" border="0">})
        end
        if para =~/<:image\s+/
          para.gsub!(/<:image\s+(http\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+>/i,
            %{<a href="\\1"><img src="#{@env.url_images_local}/\\2" \\3 \\4 naturalsizeflag="0" align="bottom" border="0"></a>})
          para.gsub!(/<:image\s+(http\S+)\s+(\S+)\s+>/i,
            %{<a href="\\1"><img src="#{@env.url_images_local}/\\2" naturalsizeflag="0" align="bottom" border="0"></a>})
          para.gsub!(/<:image\s+(\S+)\s+(\S+)\s+(\S+)\s+>/i,
            %{<img src="#{@env.url_images_local}/\\1" \\2 \\3 naturalsizeflag="0" align="bottom" border="0">})
          para.gsub!(/<:image\s+(\S+)\s+>/i,
            %{<img src="#{@env.url_images_local}/\\1" naturalsizeflag="0" align="bottom" border="0">})
        end
        if para =~/\{.+?\}((?:http|ftp)\S+|image)/
          @word_mode=para.scan(/\{.+?\}(?:(?:https?|ftp)\S+|image)|\S+/)
          word_mode=SiSU_Tune::MyUrls.new(@word_mode,@md).urls
          words=word_mode.join(' ')
          para.gsub!(/.+/,words)
        end
        if (para !~/^0~/)
          para.gsub!(/\\copyright/i,%{<sup>&copy;</sup>})
          if (para !~/\<:ad\s+\.\.\//)
            para.gsub!(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*!\>/i,
              %{\n<center><a href="http:\/\/\\1" target="external"><img src="#{@env.url_images_local}/\\2" alt="\\3"></a></center>\n})
          else
            para.gsub!(/\<:ad\s+(\S+)?\s+(\S+\.png)\s+(.+)?\;\s+(.+)?\;\s*\>/i,
              %{\n<center><a href="\\1" target="_top"><img src="#{@env.url_images_local}/\\2" alt="\\3"></a></center>\n})
          end
          para.gsub!(/!pick/i, %{<img border="0" height="15" width="15" src="#{@env.url_images}/#{@icon.choice}" alt="stellar">})
          para.gsub!(/!new/i, %{&nbsp;<img border="0" height="15" width="15" src="#{@env.url_images}/#{@icon.new}" alt="new">})
          para.gsub!(/<:h(.{1,7}?)>/i,%{<a href="#h\\1">\\1</a>})
          para.gsub!(/<:to(\d{1,7}?)>/i,%{<a href="#to\\1">to&nbsp;{&nbsp;\\1&nbsp;}</a> })
          if (para =~/\b\S+\@\S+?\.\S+/ and para !~/(\"\S+\@\S+?\.\S+\"|>\S+\@\S+?\.\S+?<)/)
            para.gsub!(/\b(\S+\@\S+?\.\S+)(\s)/i,%{\<a href="mailto:\\1">\\1</a>\\2})
          end
          if (para !~/(\"\w+:\/\/\S+?\"|>\s*\w+:\/\/\w+?\S*<)/) #url markup http etc.
            if para=~/\w+:\/\/\S+?\.\S+?[.,] /
              para.gsub!(/(\w+:\/\/\S+?\.\S+?)([.,] )/i,%{<a href="\\1" target="_top">\\1</a>\\2}) #full stops ! have been a bother
            else
              para.gsub!(/(\w+:\/\/\S+?\.\S+)/i, %{<a href="\\1" target="_top">\\1</a>})
            end
          end
          if (para =~/[ ^](?:https?|ftp):\/\/\S+/i) #url markup http leftovers watch carefully may accept too much 2004w46
            if para=~/([ ^])((?:https?|ftp):\/\/\S+?)([\.,] )/
            para.gsub!(/([ ^])((?:https?|ftp):\/\/\S+?)([\.,] )/i,%{\\1<a href="\\2" target="_top">\\2</a>\\3}) #full stops ! have been a bother
            else
              para.gsub!(/([ ^])((?:https?|ftp):\/\/\S+)/i,%{\\1<a href="\\2" target="_top">\\2</a>})
            end
          end
          if (para =~/..\/\S+/ and para !~/(\"..\/\S+?\"|>\s*..\/\S+<)/)
            para.gsub!(/(\.\.\/\S+)/i,%{<a href="\\1">\\1</a>})
          end
          para.gsub!(/<a href="\.\.\//i,%{<a href="#{@url.site}/})
        end
        @tuned_file << para
      end
    end
    def endnotes_html
      data=@data
      @tuned_file=Array.new
      data.each do |para|
        para.gsub!(/~\{(\d+) (.+?) <#{@@dp}>\}~/i,
          %{&nbsp;<a name="-\\1" href="#_\\1">&nbsp;<sup>\\1</sup>&nbsp;</a> } +  #note- endnote-
          %{~\{\\1 <a name="_\\1" href="#-\\1">&nbsp;<sup>\\1.</sup></a> \\2 \}~}) #endnote- note- (careful may have switched)
        para.gsub!(/~\{([*+]+) (.+?) <#{@@dp}>\}~/i,
          %{&nbsp;<a name="-\\1" href="#_\\1">&nbsp;<sup>\\1</sup>&nbsp;</a> } +  #note- endnote-
          %{~\{\\1 <a name="_\\1" href="#-\\1">&nbsp;<sup>\\1</sup></a> \\2 \}~}) #endnote- note- (careful may have switched)
          @tuned_file << para
        end
    end
    def output
      data=@data
      @tuned_file=Array.new
      data.each do |para|
        para.strip!
        para.chomp!
        @tuned_file << para
      end
      @tuned_file << "\n<EOF>" if (@md.fns =~/\.sst0/i) #remove
    end
  end
  class MyUrls
    def initialize(data,md)
      @data,@md=data,md
      @url=SiSU_Viz::Url.new
      @color=SiSU_Viz::Color.new
      @icon=SiSU_Viz::Icon.new
      @env=SiSU_Env::Info_dir.new(@md.fns)
    end
    def urls
      @words=Array.new
      @data.each do |word|
        @words << if word=~/\{(.+?)\}((?:https?|ftp)\S+|image)/
          if word =~/\{(.+?)\}((?:https?|ftp)\S+|image)([.,](?:\s|$))/
            m,u,d=/\{(.+?)\}((?:https?|ftp)\S+|image)([.,](?:\s|$))/.match(word).captures
          else m,u=/\{(.+?)\}((?:https?|ftp)\S+|image)/.match(word).captures
            d=''
          end
          case m 
          when /\.png|\.jpg|c=|\d+x\d+/
            w,h=/(\d+)x(\d+)/.match(m).captures if m =~/\d+x\d+/ 
            w=%{width="#{w}"} if w
            h=%{height="#{h}"} if h
            c=m[/"(.+?)"/im, 1]
            caption=%{<br /><p class="caption">#{c}</p>} if c
            png=m.scan(/\S+/)[0]
            image_path=if @md.fns =~/\.-ss[tm]$/: @env.url_images_external
            else                               @env.url_images_local
            end
            ins=if u and u.strip !~/^image$/ 
              %{<a href="#{u}"><img src="#{image_path}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0"></a>#{caption}}
            else %{<img src="#{image_path}/#{png}" #{w} #{h} naturalsizeflag="0" align="bottom" border="0">#{caption}}
            end
            word.gsub!(/\{.+?\}((?:https?|ftp)\S+|image)/,ins)
          else
            link=m[/(.+)/im]
            png=m.scan(/\S+/)[0].strip
            link=link.strip
            ins=%{<a href="#{u}">#{link}</a>#{d}}
            word.gsub!(/\{.+?\}(?:https?|ftp)\S+/,ins)
          end
          word
        else word
        end
        word
      end
      @words
    end
  end
end
__END__
