=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: miscellaneous utilities

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_text_utils
  class Paragraph
    def initialize(para='',n_char_max=76,n_indent=0,n_hang=nil)
      @para,@n_char_max,@n_indent=para,n_char_max,n_indent
      @br="\n"
      @n_hang=unless n_hang:  @n_hang=@n_indent
      else                    n_hang
      end
    end
    def line_wrap
      space=' '
      spaces_indent,spaces_hang="#@br#{space*@n_indent}",space*@n_hang
      line,out,out[line]=0,Array.new,''
      #@para.gsub!(/<br(?: \/)?>/i, "\n") #watch #added
      words=@para.scan(/\S+/)
      while words != ''
        word=words.shift
        if not word
          out[line].strip!.squeeze!(' ')
          break
        elsif (out[line].length + word.length) > (@n_char_max - @n_indent) and out[line] =~/\S+/
          out[line].strip!.squeeze!(' ')
          line += 1
        end
        out[line]="#{out[line]} #{word}" if word
      end
      out.join(spaces_indent).gsub(/\A\n+/m,'').insert(0,spaces_hang) 
    end
    def line_wrap_indent1
      @n_indent,@n_hang=2,2
      line_wrap
    end
    def line_wrap_endnote
      @n_indent,@n_hang=4,2
      line_wrap
    end
  end
end
module SiSU_scan
  class Header_scan
    def initialize(md,para)
      @regxcl=/<~\d+;\w\d+;\w\d+><(?:[0-9a-f]{32}|[0-9a-f]{64}):(?:[0-9a-f]{32}|[0-9a-f]{64})>/
      para=para.gsub(@regxcl,'').dup
      @md,@p=md,para
    end
    def extract(dc_tag,dc_content)
      dc=if dc_tag and dc_content
        [dc_tag,dc_content,{dc_tag=>dc_content}]
      else nil
      end
    end
    def start_is_zero
      dc=case @p
      when /^0~(title)\s+(.+?)$/:           extract($1,@md.dc_title) #dc 1
      #when /^0~(subtitle)\s+(.+?)$/:        extract($1,$2)
      when /^0~(creator|author)\s+(.+?)(?:#@regx_exclude)?$/:  extract('creator',$2) #dc 2
      when /^0~(subject)\s+(.+?)$/:         extract($1,$2)  #dc 3
      when /^0~(description)\s+(.+?)$/:     extract($1,$2)  #dc 4
      when /^0~(publisher)\s+(.+?)$/:       extract($1,$2)  #dc 5
      when /^0~(contributor)\s+(.+?)$/:     extract($1,$2)  #dc 6
      when /^0~(date)\s+(.+?)$/:            extract($1,$2)  #dc 7
      when /^0~(date\.created)\s+(.+?)$/:   extract($1,$2)
      when /^0~(date\.issued)\s+(.+?)$/:    extract($1,$2)
      when /^0~(date\.available)\s+(.+?)$/: extract($1,$2)
      when /^0~(date\.valid)\s+(.+?)$/:     extract($1,$2)
      when /^0~(date\.modified)\s+(.+?)$/:  extract($1,$2)
      when /^0~(type)\s+(.+?)$/:            extract($1,$2)  #dc 8
      when /^0~(format)\s+(.+?)$/:          extract($1,$2)  #dc 9
      when /^0~(identifier)\s+(.+?)$/:      extract($1,$2)  #dc 10
      when /^0~(source)\s+(.+?)$/:          extract($1,$2)  #dc 11
      when /^0~(language)\s+(.+?)$/:        extract($1,$2)  #dc 12
      when /^0~(relation)\s+(.+?)$/:        extract($1,$2)  #dc 13
      when /^0~(coverage)\s+(.+?)$/:        extract($1,$2)  #dc 14
      when /^0~(rights)\s+(.+?)$/:          extract($1,$2)  #dc 15
      when /^0~(keywords)\s+(.+?)$/:        extract($1,$2)
      when /^0~(copyright)\s+(.+?)$/:       extract($1,$2)
      else nil
      end
    end
    def start_is_at
      dc=case @p
      when /^@(title):\s+(.+?)$/:            extract($1,@md.dc_title) #dc 1
      #when /^@(subtitle):\s+(.+?)$/:         extract($1,$2)
      when /^@(creator|author):\s+(.+?)$/:   extract('creator',$2) #dc 2
      when /^@(subject):\s+(.+?)$/:          extract($1,$2)  #dc 3
      when /^@(description):\s+(.+?)$/:      extract($1,$2)  #dc 4
      when /^@(publisher):\s+(.+?)$/:        extract($1,$2)  #dc 5
      when /^@(contributor):\s+(.+?)$/:      extract($1,$2)  #dc 6
      when /^@(date):\s+(.+?)$/:             extract($1,$2)  #dc 7
      when /^@(date\.created):\s+(.+?)$/:    extract($1,$2)
      when /^@(date\.issued):\s+(.+?)$/:     extract($1,$2)
      when /^@(date\.available):\s+(.+?)$/:  extract($1,$2)
      when /^@(date\.valid):\s+(.+?)$/:      extract($1,$2)
      when /^@(date\.modified):\s+(.+?)$/:   extract($1,$2)
      when /^@(type):\s+(.+?)$/:             extract($1,$2)  #dc 8
      when /^@(format):\s+(.+?)$/:           extract($1,$2)  #dc 9
      when /^@(identifier):\s+(.+?)$/:       extract($1,$2)  #dc 10
      when /^@(source):\s+(.+?)$/:           extract($1,$2)  #dc 11
      when /^@(language):\s+(.+?)$/:         extract($1,$2)  #dc 12
      when /^@(relation):\s+(.+?)$/:         extract($1,$2)  #dc 13
      when /^@(coverage):\s+(.+?)$/:         extract($1,$2)  #dc 14
      when /^@(rights):\s+(.+?)$/:           extract($1,$2)  #dc 15
      when /^@(keywords):\s+(.+?)$/:         extract($1,$2)
      when /^@(copyright):\s+(.+?)$/:        extract($1,$2)
      else nil
      end
    end
    def dublin
      dc=if @p =~/^0~\S+\s/:               start_is_zero
      elsif @p =~/^@\S+:[+-]?\s/:          start_is_at
      else nil
      end
    end
  end
end
__END__
