=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: xml (dom style) output processing
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: tidy -xml dom.xml >> index.tidy
=end
module SiSU_XML_DOM
  require "#{SiSU_lib}/defaults"
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/metaverse"
  require "#{SiSU_lib}/common_xml"
  require "#{SiSU_lib}/xml_format"
  include SiSU_XML_format
  include SiSU_XML_character
  require "#{SiSU_lib}/rexml"
  include SiSU_Rexml
  include SiSU_XML_character
  @@alt_id_count,@@tablehead,@@number_of_cols=0,0,0
  @@tablefoot=''
  class Source
    def initialize(sf,cf)
      @fns,@cf=sf,cf
      @fnb=sf.gsub(/\.[_-]?sst$/,'')
      unless sf =~/\.[_-]?sst$/
        puts "#{sf} not a processed file type"
        jump
      end
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@fns,@cf).get
        @dir=SiSU_Env::Info_dir.new(@fns)
        path=SiSU_Env::Info_dir.new(@fns).tell_output_path
        loc=SiSU_Env::Info_dir.new(@fns).tell_output_location
        tool=if @cf =~/[MV]/: "#{@dir.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:dom]}\n\t#{@dir.xml_viewer} #{path}/#{@md.fnb}/#{@md.fn[:dom]}"
        elsif @cf =~/v/: "#{@dir.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:dom]}"
        else ''
        end
        tell=SiSU_Screen::Ansi.new(@cf,'invert','XML DOM',tool)
        tell.colorize unless @cf =~/q/
        tell=SiSU_Screen::Ansi.new(@cf,@fns,"#{@dir.tell_output_path}/#{@md.fnb}/#{@md.fn[:dom]}")
        tell.flow if @cf =~/[MV]/
        @metaverse_array=SiSU_Metaverse::Source.new(@fns,@cf).get # metaverse file drawn here
        SiSU_XML_DOM::Source::Songsheet.new(@metaverse_array,@md,@dir).songsheet
      rescue: SiSU_Errors::Info_error.new($!,$@,@cf,@fns).error
      ensure
        #file closed in songsheet
      end
    end
    private
    class Songsheet
      def initialize(data,md='',dir='')
        @data,@md,@dir=data,md,dir
      end
      def songsheet
        begin
          SiSU_XML_DOM::Source::Scroll.new(@data,@md).songsheet
          SiSU_XML_DOM::Source::Tidy.new(@md,@dir).xml if @md.cf =~/[VM]/i # test wellformedness, comment out when not in use
          SiSU_Rexml::Rexml.new(@md,@md.fn[:dom],@md.cf).xml if @md.cf =~/M/ # test rexml parsing, comment out when not in use #debug
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cf,@md.fns).error
        ensure
        end
      end
    end
    class Scroll
      @@xml=Hash.new
      @@xml[:body],@@xml[:open],@@xml[:close],@@xml[:head],@@xml[:vc]=Array.new,Array.new,Array.new,Array.new,Array.new
      require "#{SiSU_lib}/common_text"
      include SiSU_text_utils
      def initialize(data='',md='')
        @data,@md=data,md
        @margin=SiSU_Viz::Margin.new
        @regx=/^(?:(?:<:p[bn]>\s*)?\d~(?:(\S+))?\s+)?(.+?)\s*<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>$/ # 
        @tab="\t"
        @char_enc=SiSU_XML_character::Encode.new
        @sys=SiSU_Env::System_call.new
      end
      def songsheet
        Scroll.new(@data,@md).pre
        Scroll.new(@data,@md).markup
        Scroll.new(@data,@md).post
        Scroll.new(@data,@md).publish
      end
    protected
      def xml_markup(para='')
        para.gsub!(/~\{(\d+)\s+(.+?)\s*<[0-9a-f]{32}>\}~/, 
          "<endnote><number>\\1</number><note>\\2</note></endnote> ")
      end
      def xml_head(meta='',verse='')
        verse.gsub!(/<br(?: \/)?>/, '')
        verse.gsub!(/ & /, ' and ')
        @@xml[:head] <<<<WOK
#{@tab}<#{meta}>
#{@tab*2}#{verse}
#{@tab}</#{meta}>
WOK
      end
      def xml_vc(md='')
        vc=if @md.rc_info
          <<WOK
    <version_control>
      <vc class="sourcefile">
        #{@md.rc_filename}
      </vc>
      <vc class="number">
        #{@md.rc_vnumber}
      </vc>
      <vc class="date">
        #{@md.rc_date}
      </vc>
    </version_control>
WOK
        else ''
        end
        @@xml[:vc]=vc   #<<<<WOK
#WOK
      end
      def xmlElement(lv='',ocn='',para='',hname='',tag='',xml_element='',xml_content='')
        lv=lv.to_i
        n=lv - 1
        n1=lv
        n2=lv + 1
        n3=lv + 2
        v=lv - 3
        tag=''
        tag="\n#{@tab*n3}<nametag>#{hname}</nametag>\n" if hname #!=nil
        @@xml[:body] <<<<WOK
#{@tab*n}#{xml_element}
#{@tab*n1}<heading>
#{@tab*n2}<object id="#{ocn}">
#{@tab*n3}<ocn>#{ocn}</ocn>#{tag}
#{@tab*n3}<text>#{para[@regx, 2]}</text>
#{@tab*n2}</object>
#{@tab*n1}</heading>#{xml_content}
WOK
        if lv == 4
          @copen[1]=true
          @copen[2]=@copen[3]=false
        elsif lv == 5
          @copen[2]=true
          @copen[3]=false
        elsif lv == 6
          @copen[3]=true 
        end
      end
      def xml_structure(lv='',ocn='',para='',hname='' )
        lv=lv.to_i
        n=lv - 1
        n1=lv
        n2=lv + 1
        n3=lv + 2
        v=lv - 3
        tag=''
        tag="\n#{@tab*n3}<nametag>#{hname}</nametag>\n" if hname !=nil
        #if para[@regx]
        #  paragraph="#{para[@regx, 2]}"
        #  util=SiSU_text_utils::Paragraph.new(paragraph, 70)
        #  wrapped=util.line_wrap
        #end
        case lv
        when 1..3
          xml_element="<heading#{lv}>"
          3.downto(lv) do |x|
            y=x - 1
            @@xml[:body] << "#{@tab*5}</content>\n" if @cont[1] or @cont[2] or @cont[3]
            #@@xml[:body] << "#{@tab*5}</content>\n" if @cont[1] == true or @cont[2] == true or @cont[3] == true
            @cont[1]=false if @cont[1]
            @cont[2]=false if @cont[2]
            @cont[3]=false if @cont[3]
            ####### attempt to close contents
            if @copen[3] # 6{
              [3,2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
              @copen[1]=@copen[2]=@copen[3]=false
            elsif @copen[2] # 5{
              [2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
              @copen[1]=@copen[2]=@copen[3]=false
            elsif @copen[1] # 4{ 
              [1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
              @copen[1]=@copen[2]=@copen[3]=false
            end
            @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x]
            @level[x]=false
          end
        when 4..6
          6.downto(lv) do |x| 
            y=x - 1
            if @level[x] == true
              u=x - 3; 
              @xml_contents_close[x]=''
            end
          end
          cv=lv - 3
          xml_element="<contents#{cv}>"
          xml_content="\n#{@tab*5}<content>"
          case lv
          when 4
            @@xml[:body] << "#{@tab*5}</content>\n" if @cont[1]
            if @copen[3] == true # 6{
              [3,2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            elsif @copen[2] == true # 5{
              [2,1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            elsif @copen[1] == true # 4{ 
              [1].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            end
            @cont[1]=true
          when 5
            @@xml[:body] << "#{@tab*5}</content>\n" if @cont[2] or @cont[1]
            if @copen[3] == true  #6{
              [3,2].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            elsif @copen[2] == true #5{
              [2].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" }
            end
            @cont[2]=true
          when 6
            @@xml[:body] << "#{@tab*5}</content>\n" if @cont[3] or @cont[2] or @cont[1]
            [3].each { |v| @@xml[:body] << "#{@tab*n}</contents#{v}>\n" } if @copen[3] #6{
            @cont[3]=true
          end
        end
        xmlElement(lv,ocn,para,hname,tag,xml_element,xml_content)
        @level[lv]=true
        ((lv+1)..6).each { |x| @level[x]=false } 
      end
      def group_structure(para='',ocn='')
        para.gsub!(/<:group(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*6}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*7}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*7}<text class="group">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*8}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*7}</text>\n}
        @@xml[:body] << "#{@tab*6}</object>" << "\n"
      end
      def poem_structure(para='',ocn='')
        para.gsub!(/<:poem(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*6}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*7}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*7}<text class="poem">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*8}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*7}</text>\n}
        @@xml[:body] << "#{@tab*6}</object>" << "\n"
      end
      def code_structure(para='',ocn='')
        para.gsub!(/<:code(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*6}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*7}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*7}<text class="code">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*8}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*7}</text>\n}
        @@xml[:body] << "#{@tab*6}</object>" << "\n"
      end
      def table_structure(table='',ocn='') #tables
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n" #if para[@regx] 
        @@xml[:body] << %{#{@tab*1}#{table}\n#{@tab*1}\n} # unless lv  # main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" #if para[@regx]
        @endnotes=Array.new
      end
      def tidywords(wordlist)
        wordlist.each do |x|
          x.gsub!(/&/, '&amp;') unless x =~/&\S+;/
        end
      end
      def markup
        data=@data
        dir=SiSU_Env::Info_dir.new(@fns)
        xml_vc(@md)
        @rcdc=false
        @level=Array.new
        @cont=Array.new 
        @copen=Array.new
        @xml_contents_close=Array.new
        (0..6).each { |x| @cont[x]=@level[x]=false } 
        (4..6).each { |x| @xml_contents_close[x]='' } 
        data.each do |para|
          wordlist=para.scan(/\S+|\n/) #\n needed for tables, check though added 2005w17
          #wordlist=para.scan(/\S+/)
          para=tidywords(wordlist).join(' ').strip
          para.gsub!(/<[-~]#>/, '')
          para.gsub!(/<0;\w\d+;[um]\d+><[0-9a-f]{32}:[0-9a-f]{32}>/, '')
          para.gsub!(/<:pb>\s*/, '')
          para.gsub!(/\{(\S+?\.(?:png|jpg)) .+?\}(?:(?:https?|ftp):\/\/\S+|image)/, 
            "<image.path>#{dir.url_images_local}\/\\1</image.path>")
          #para.gsub!(/\{(\S+?\.png) \d+x\d+ \".+?\" \}(?:http:\/\/\S+|image)/, "<image>\\1</image>")
          para.gsub!(/&nbsp;/, ' ') #clean
          @char_enc.utf8(para) if @sys.locale =~/utf-?8/i #% utf8
          if para =~/^0~(\S+)\s+(.+?)$/ # for headers
            case para
            when /^0~(title)\s+(.+?)$/:             xml_head($1,$2)            #dc 1
            when /^0~(subtitle)\s+(.+?)$/:          xml_head($1,$2)
            when /^0~(creator|author)\s+(.+?)$/:    xml_head('creator',$2)     #dc 2
            when /^0~(subject)\s+(.+?)$/:           xml_head($1,$2)            #dc 3
            when /^0~(description)\s+(.+?)$/:       xml_head($1,$2)            #dc 4
            when /^0~(publisher)\s+(.+?)$/:         xml_head($1,$2)            #dc 5
            when /^0~(contributor)\s+(.+?)$/:       xml_head($1,$2)            #dc 6
            when /^0~(date)\s+(.+?)$/:              xml_head($1,$2)            #dc 7
            when /^0~(date\.created)\s+(.+?)$/:     xml_head($1,$2)
            when /^0~(date\.issued)\s+(.+?)$/:      xml_head($1,$2)
            when /^0~(date\.available)\s+(.+?)$/:   xml_head($1,$2)
            when /^0~(date\.valid)\s+(.+?)$/:       xml_head($1,$2)
            when /^0~(date\.modified)\s+(.+?)$/:    xml_head($1,$2)
            when /^0~(type)\s+(.+?)$/:              xml_head($1,$2)            #dc 8
            when /^0~(format)\s+(.+?)$/:            xml_head($1,$2)            #dc 9
            when /^0~(identifier)\s+(.+?)$/:        xml_head($1,$2)            #dc 10
            when /^0~(source)\s+(.+?)$/:            xml_head($1,$2)            #dc 11
            when /^0~(language)\s+(.+?)$/:          xml_head($1,$2)            #dc 12
            when /^0~(relation)\s+(.+?)$/:          xml_head($1,$2)            #dc 13
            when /^0~(coverage)\s+(.+?)$/:          xml_head($1,$2)            #dc 14
            when /^0~(rights)\s+(.+?)$/:            xml_head($1,$2)            #dc 15
            when /^0~(keywords)\s+(.+?)$/:          xml_head($1,$2)
            when /^0~(copyright)\s+(.+?)$/:         xml_head($1,$2)
            end
          end
          @rcdc=true if @rcdc ==false and (para =~/~metadata/ or para =~/1~\s+Document Information/)
          if para !~/(^0~|<ENDNOTES>|<EOF>)/ 
            if para =~/.+?<~\d+;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/
              paranum=para[@regx, 3]  #/.+?<~(\d+?)>.*/.match(para)[1]
              @p_num=SiSU_XML_format::Paragraph_number.new(@md,paranum)
            end
            @sto=SiSU_text_parts::Split_text_object.new(@md,para).lev_segname_para_ocn
            ### problem in scroll, it appears tables are getting paragraph numbers
            unless @rcdc
              m=/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
              if para =~m
                format_scroll=SiSU_XML_format::Format_scroll.new(@md,@sto.text) if @sto.format =~/i[12]|null/
                case @sto.format
                when /^(1)~(?:(\S+))?/
                  xml_markup(para)
                  xml_structure($1,@sto.ocn,para,$2)
                  para=@sto.lev_para_ocn.heading_body1 #if para =~m
                when /^(2)~(?:(\S+))?/
                  xml_markup(para)
                  xml_structure($1,@sto.ocn,para,$2)
                  para=@sto.lev_para_ocn.heading_body2 #if para =~m
                when /^(3)~(?:(\S+))?/
                  xml_markup(para)
                  xml_structure($1,@sto.ocn,para,$2)
                  para=@sto.lev_para_ocn.heading_body3 #if para =~m
                when /^(4)~(\S+)/ # work on see SiSU_text_parts::Split_text_object
                  xml_markup(para)
                  xml_structure($1,@sto.ocn,para,$2)
                  para=@sto.lev_para_ocn.heading_body4 #if para =~m
                when /^(5)~(?:(\S+))?/
                  xml_markup(para)
                  xml_structure($1,@sto.ocn,para,$2)
                  para=@sto.lev_para_ocn.heading_body5 #if para =~m
                when /^(6)~(?:(\S+))?/
                  xml_markup(para)
                  xml_structure($1,@sto.ocn,para,$2)
                  para=@sto.lev_para_ocn.heading_body6 #if para =~m
                #when /^(i1)$/i
                #  #format_scroll.gsubBody
                #  #para=@sto.lev_para_ocn.scrIndent1
                #when /^(i2)$/i
                #  format_scroll.gsubBody
                #  para=@sto.lev_para_ocn.scrIndent2
                #when /^(center)$/i
                #  para.gsub!(/(.+)/,
                #    %{<center>(\\1)</center>})
                #  para=@sto.lev_para_ocn.scrPara
                #when /^(b|bold)$/i
                #  para.gsub!(/(.+)/,
                #    %{<b>(\\1)</b>})
                #  para=@sto.lev_para_ocn.scrPara
                #when /null/ # see whether u can improve
                #    if (para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/)
                #      #format_scroll.gsubBody
                #      #para=@sto.lev_para_ocn.scrPara
                #    end
                else
                  matched=/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>$/mi.match(para)
                  stamp,ocn=matched[0],matched[1]
                  #ocn=/<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>$/i.match(para)[1]
                  if para =~ /<:poem>/
                    para.gsub!(/#{stamp}/,'')
                    poem_structure(para,ocn)
                  elsif para =~ /<:group>/
                    para.gsub!(/#{stamp}/,'')
                    group_structure(para,ocn)
                  elsif para =~ /<:code>/
                    para.gsub!(/</,'&lt;')
                    para.gsub!(/>/,'&gt;')
                    para.gsub!(/#{stamp}/,'')
                    code_structure(para,ocn)
                  elsif para =~/<!Th?.+/i # tables come as single block #work area 2005w13
                    table=SiSU_Tables::Table_xml.new(para,ocn)
                    para=table.table_split
                    @@xml[:body] << table_structure(para,ocn)
                  else #xml_structure(para, nil, nil, nil)
                    xml_markup(para)
                    @@xml[:body] << %{#{@tab*6}<object id="#{para[@regx, 3]}">} << "\n" if para[@regx] and para[@regx, 3]
                    @@xml[:body] << "#{@tab*7}<ocn>#{para[@regx, 3]}</ocn>" << "\n" if para[@regx, 3]
                    @@xml[:body] << "#{@tab*7}<text>#{para[@regx, 2]}</text>\n" if para[@regx, 2] # main text, contents, body KEEP
                    @@xml[:body] << "#{@tab*6}</object>" << "\n" if para[@regx]
                  end
                end
              elsif para =~/(Note|Endnotes?)/ and para !~/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
                #format_scroll=MonoSiSU.new('<br /><a name="notes">Note</a>')
                #para=format_scroll.boldPara
              elsif para =~/(MetaData)/ and para =~/<~\d+;[m]\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/ #debug 2003w46 add rc info
                format_scroll=Format_scroll.new(@md,'<br /><a name="metadata">MetaData</a>')
                para=format_scroll.boldPara
              elsif para =~/(Owner Details)/ and para !~/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
                format_scroll=Format_scroll.new(@md,'<br /><a name="owner.details">Owner Details</a>')
                @@xml[:owner_details]=format_scroll.boldPara
                para=''
              elsif para =~/(.*)<:#>(.*)/i
                one, two=$1,$2
                format_text=Format_text_object.new(one,two)
                para=format_text.segNoParanum
              end
              para='' if (para =~/<a name="n\d+">/ and para =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/) # -endnote
              if para =~/.*<:#>.*$/
                para=case para
                when /<:i1>/
                  format_text=Format_text_object.new(para, '')
                  format_text.scrIndenocneNoParanum
                when /<:i2>/
                  format_text=Format_text_object.new(para, '')
                  format_text.scrIndenocneNoParanum
                end
              end
              if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
                # i don't get the condition for no paranum
              end
              if para =~/<:center>/i
                one, two=/(.*)<:center>(.*)/i.match(para)[1,2]
                format_text=Format_text_object.new(one, two)
                para=format_text.center
              end
            else #
            end
            para.gsub!(/<:\S+?>/, '')
            para.gsub!(/<!.+!>/i, ' ') ## Clean Prepared Text
          end
        end
        @content_flag=true
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          if @level[x] == true #2004w36 bug fix? watch/test previous logic broke on free.for.all @coontent_flag introduced
            if @content_flag==true
              @@xml[:body] << "#{@tab*5}</content>\n#{@tab*y}</contents#{v}>\n"
              @content_flag=false
            else
              @@xml[:body] << "\n#{@tab*y}</contents#{v}>\n"
            end
          end
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x] == true
        end
        #6.downto(1) { |x| y=x - 1; @@xml[:body] << "#{@tab*y}</level #{x}>\n" if @level[x] == true } 
      end
      def pre
        rdf=SiSU_XML_tags::RDF.new(@md)
        dir=SiSU_Env::Info_dir.new
        #<?xml version="1.0"?>
        #<?xml version="1.0" encoding="UTF-8" standalone="no"?>
        #<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
        #<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
        #<?xml version="1.0" encoding="UTF-8" standalone="no"?>
        #<?xml version="1.0" encoding="UTF-16" standalone="no"?>
        css=SiSU_Env::CSS_select.new(@md).xml_dom
        encoding=if @sys.locale =~/utf-?8/i: '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else                                 '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @@xml[:open] =<<WOK
#{encoding}
<?xml-stylesheet type="text/css" href="../#{dir.style}/#{css}"?>
#{rdf.comment_xml}
<document>
WOK
        @@xml[:head] << "<head>\n"
        @@xml[:body] << "<body>\n"
      end
      def post
        @@xml[:head] << @@xml[:vc]
        @@xml[:head] << "</head>\n"
        @@xml[:body] << "</body>\n"
        @@xml[:close] = "</document>\n"
      end
      def publish
        content=Array.new
        data=@data
        content << @@xml[:open]
        content << @@xml[:head]
        content << @@xml[:body]
        content << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail]
        content << @@xml[:close]
        Output.new(content.to_s,@md).xml
        @@xml[:head]=Array.new # check whether should be nil
        @@xml[:body]=Array.new # check whether should be nil
        @@xml[:tail]=Array.new # check whether should be nil
      end
    end
    class Output
      include SiSU_Param
      def initialize(data,md)
        @data,@md=data,md
      end
      def xml
        @sisu=Array.new
        @data.each do |para| #p
          #para.strip!
          para.gsub!(/<:\S+?>/, '')
          para.gsub!(/<!.+?!>/, '')
          para="#{para}\n" unless para.empty?
          @sisu << para
        end
        new_file_data=@sisu.to_s
        @sisu=new_file_data.scan(/.+/)
        #@sisu.compact!
        filename_plaintext=SiSU_Env::SiSU_file.new(@md).mkdir
        filename_xml=SiSU_Env::SiSU_file.new(@md,@md.fn[:dom]).mkfile
        @sisu.each {|para| filename_xml.puts para}
        filename_xml.close
      end
    end
    class Tidy
      def initialize(md,dir)
        @md,@dir=md,dir
        @prog=SiSU_Env::Info_program.new #(md.fns) #if md
      end
      def xml
        if @prog.tidy !=false
          if @md.cf =~/[VM]/
            tell=SiSU_Screen::Ansi.new(@md.cf,'invert','Using XML Tidy','check document structure')
            tell.colorize unless @md.cf =~/q/
            tell.greyOpen unless @md.cf =~/q/
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy=SiSU_Env::System_call.new("#{@dir.data_o}/#{@md.fnb}/#{@md.fn[:dom]}",tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.cf =~/q/
          end
        end
      end
    end
  end
end
__END__

