=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: common file for xml generation
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_text_parts 
  class Split_text_object
    require "#{SiSU_lib}/param"
    require "#{SiSU_lib}/xml_format"
    include SiSU_Viz
    include SiSU_XML_format
    @@alt_id_count=0 #added
    attr_reader :format,:text,:ocn,:lev_para_ocn
    def initialize(md,para)
      @md,@para=md,para
      @format,@ocn='null','null'
    end
    def lev_segname_para_ocn #using common_flatfile instead, watch #% watch closely
      if @para =~/^(\d~|<:.+?>).+?<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>.*/
        if /([1-6])~(\S+)\s+(\S.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im.match(@para)
          @format,segname,@text,@ocn=$1,$2,$3,$4
          @format="#@format~#{segname}" # 
        elsif  /([1-6]~)\s+(\S.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im.match(@para)
          @format,@text,@ocn=$1,$2,$3 #,$4
        elsif /<:(.+?)>\s*(\S.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im.match(@para)
          @format,@text,@ocn=$1,$2,$3
        elsif /([1-6])~(\S+)\s+(\S.+?)<~(0);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im.match(@para)
          @@alt_id_count+=1
          @format,segname,@text,@ocn=$1,$2,$3,"x#{@@alt_id_count}"
          @format="#@format~#{segname}" # 
        elsif  /([1-6]~)\s+(\S.+?)<~(0);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im.match(@para)
          @@alt_id_count+=1
          @format,@text,@ocn=$1,$2,"x#{@@alt_id_count}"
        end
      else
        if /(.+?)<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/im.match(@para)
          @text,@ocn=$1,$2
        end
        if @para !~/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>|^$/ #added 2002w06
          @text=/(.+?)/im.match(@para)[1]
        end
        if /^(\d)~(?:\S+)?\s+(.+)/im.match(@para)
          @format,@text=$1,$2
        end
      end
      @lev_para_ocn=if @para =~/.+<~\d+;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/
        SiSU_XML_format::Format_scroll.new(@md,@format,@text,@ocn)
      else
        SiSU_XML_format::Format_scroll.new(@md,@format,@text,'<~0;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>')
        #@para.gsub!(/4~(\S+)?\s*/,"") # problem added 2002w06 if @para=~/4~/
      end
      self
    end
  end
end
module SiSU_XML_character
  class Encode
    def initialize
      @sys=SiSU_Env::System_call.new
    end
    def utf8(para='')
      if @sys.locale =~/utf-?8/i # instead ucs for utf8 #require 'iconv' ? Iñtërnâtiônàlizætiøn 
        #¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûü
        #¢£¥§©ª«®°±²³µ¶¹º»¼½¾×÷
        ##para.gsub!(//, '&#;')
        ##para.gsub!(//, '&;')
        para.gsub!(/¢/, '&#162;') # '&cent;'   # &#162; 
        para.gsub!(/£/, '&#163;') # '&pound;'  # &#163;
        para.gsub!(/¥/, '&#165;') # '&yen;'    # &#165;
        para.gsub!(/§/, '&#167;') # '&sect;'   # &#167;
        para.gsub!(/©/, '&#169;') # '&copy;'   # &#169;
        para.gsub!(/ª/, '&#170;') # '&ordf;'   # &#170;
        para.gsub!(/«/, '&#171;') # '&laquo;'  # &#171;
        para.gsub!(/®/, '&#174;') # '&reg;'    # &#174;
        para.gsub!(/°/, '&#176;') # '&deg;'    # &#176;
        para.gsub!(/±/, '&#177;') # '&plusmn;' # &#177;
        para.gsub!(/²/, '&#178;') # '&sup2;'   # &#178;
        para.gsub!(/³/, '&#179;') # '&sup3;'   # &#179;
        para.gsub!(/µ/, '&#181;') # '&micro;'  # &#181;
        para.gsub!(/¶/, '&#182;') # '&para;'   # &#182;
        para.gsub!(/¹/, '&#185;') # '&sup1;'   # &#185;
        para.gsub!(/º/, '&#186;') # '&ordm;'   # &#186;
        para.gsub!(/»/, '&#187;') # '&raquo;'  # &#187;
        para.gsub!(/¼/, '&#188;') # '&frac14;' # &#188;
        para.gsub!(/½/, '&#189;') # '&frac12;' # &#189;
        para.gsub!(/¾/, '&#190;') # '&frac34;' # &#190;
        para.gsub!(/×/, '&#215;') # '&times;'  # &#215;
        para.gsub!(/÷/, '&#247;') # '&divide;' # &#247;
        para.gsub!(/¿/, '&#191;') # '&iquest;' # &#191;
        para.gsub!(/À/, '&#192;') # '&Agrave;' # &#192;
        para.gsub!(/Á/, '&#193;') # '&Aacute;' # &#193;
        para.gsub!(/Â/, '&#194;') # '&Acirc;'  # &#194;
        para.gsub!(/Ã/, '&#195;') # '&Atilde;' # &#195;
        para.gsub!(/Ä/, '&#196;') # '&Auml;'   # &#196;
        para.gsub!(/Å/, '&#197;') # '&Aring;'  # &#197;
        para.gsub!(/Æ/, '&#198;') # '&AElig;'  # &#198;
        para.gsub!(/Ç/, '&#199;') # '&Ccedil;' # &#199;
        para.gsub!(/È/, '&#200;') # '&Egrave;' # &#200;
        para.gsub!(/É/, '&#201;') # '&Eacute;' # &#201;
        para.gsub!(/Ê/, '&#202;') # '&Ecirc;'  # &#202;
        para.gsub!(/Ë/, '&#203;') # '&Euml;'   # &#203;
        para.gsub!(/Ì/, '&#204;') # '&Igrave;' # &#204;
        para.gsub!(/Í/, '&#205;') # '&Iacute;' # &#205;
        para.gsub!(/Î/, '&#206;') # '&Icirc;'  # &#206;
        para.gsub!(/Ï/, '&#207;') # '&Iuml;'   # &#207;
        para.gsub!(/Ð/, '&#208;') # '&ETH;'    # &#208;
        para.gsub!(/Ñ/, '&#209;') # '&Ntilde;' # &#209;
        para.gsub!(/Ò/, '&#210;') # '&Ograve;' # &#210;
        para.gsub!(/Ó/, '&#211;') # '&Oacute;' # &#211;
        para.gsub!(/Ô/, '&#212;') # '&Ocirc;'  # &#212;
        para.gsub!(/Õ/, '&#213;') # '&Otilde;' # &#213;
        para.gsub!(/Ö/, '&#214;') # '&Ouml;'   # &#214;
        para.gsub!(/Ø/, '&#216;') # '&Oslash;' # &#216;
        para.gsub!(/Ù/, '&#217;') # '&Ugrave;' # &#217;
        para.gsub!(/Ú/, '&#218;') # '&Uacute;' # &#218;
        para.gsub!(/Û/, '&#219;') # '&Ucirc;'  # &#219;
        para.gsub!(/Ü/, '&#220;') # '&Uuml;'   # &#220;
        para.gsub!(/Ý/, '&#221;') # '&Yacute;' # &#221;
        para.gsub!(/Þ/, '&#222;') # '&THORN;'  # &#222;
        para.gsub!(/ß/, '&#223;') # '&szlig;'  # &#223;
        para.gsub!(/à/, '&#224;') # '&agrave;' # &#224;
        para.gsub!(/á/, '&#225;') # '&aacute;' # &#225;
        para.gsub!(/â/, '&#226;') # '&acirc;'  # &#226;
        para.gsub!(/ã/, '&#227;') # '&atilde;' # &#227;
        para.gsub!(/ä/, '&#228;') # '&auml;'   # &#228;
        para.gsub!(/å/, '&#229;') # '&aring;'  # &#229;
        para.gsub!(/æ/, '&#230;') # '&aelig;'  # &#230;
        para.gsub!(/ç/, '&#231;') # '&ccedil;' # &#231;
        para.gsub!(/è/, '&#232;') # '&egrave;' # &#232;
        para.gsub!(/é/, '&#233;') # '&acute;'  # &#233;
        para.gsub!(/ê/, '&#234;') # '&circ;'   # &#234;
        para.gsub!(/ë/, '&#235;') # '&euml;'   # &#235;
        para.gsub!(/ì/, '&#236;') # '&igrave;' # &#236;
        para.gsub!(/í/, '&#237;') # '&acute;'  # &#237;
        para.gsub!(/î/, '&#238;') # '&icirc;'  # &#238;
        para.gsub!(/ï/, '&#239;') # '&iuml;'   # &#239;
        para.gsub!(/ð/, '&#240;') # '&eth;'    # &#240;
        para.gsub!(/ñ/, '&#241;') # '&ntilde;' # &#241;
        para.gsub!(/ò/, '&#242;') # '&ograve;' # &#242;
        para.gsub!(/ó/, '&#243;') # '&oacute;' # &#243;
        para.gsub!(/ô/, '&#244;') # '&ocirc;'  # &#244;
        para.gsub!(/õ/, '&#245;') # '&otilde;' # &#245;
        para.gsub!(/ö/, '&#246;') # '&ouml;'   # &#246;
        para.gsub!(/ø/, '&#248;') # '&oslash;' # &#248;
        para.gsub!(/ù/, '&#250;') # '&ugrave;' # &#250;
        para.gsub!(/ú/, '&#251;') # '&uacute;' # &#251;
        para.gsub!(/û/, '&#252;') # '&ucirc;'  # &#252;
        para.gsub!(/ü/, '&#253;') # '&uuml;'   # &#253;
        para.gsub!(/þ/, '&#254;') # '&thorn;'  # &#254;
        para.gsub!(/ÿ/, '&#255;') # '&yuml;'   # &#255;   
      end
    end
    def html(para='')
      if @sys.locale =~/utf-?8/i # instead ucs for utf8 #require 'iconv' ? Iñtërnâtiônàlizætiøn 
        para.gsub!(/¢/, '&cent;')      # &#162; 
        para.gsub!(/£/, '&pound;')     # &#163;
        para.gsub!(/¥/, '&yen;')       # &#165;
        para.gsub!(/§/, '&sect;')      # &#167;
        para.gsub!(/©/, '&copy;')      # &#169;
        para.gsub!(/ª/, '&ordf;')      # &#170;
        para.gsub!(/«/, '&laquo;')     # &#171;
        para.gsub!(/®/, '&reg;')       # &#174;
        para.gsub!(/°/, '&deg;')       # &#176;
        para.gsub!(/±/, '&plusmn;')    # &#177;
        para.gsub!(/²/, '&sup2;')      # &#178;
        para.gsub!(/³/, '&sup3;')      # &#179;
        para.gsub!(/µ/, '&micro;')     # &#181;
        para.gsub!(/¶/, '&para;')      # &#182;
        para.gsub!(/¹/, '&sup1;')      # &#185;
        para.gsub!(/º/, '&ordm;')      # &#186;
        para.gsub!(/»/, '&raquo;')     # &#187;
        para.gsub!(/¼/, '&frac14;')    # &#188;
        para.gsub!(/½/, '&frac12;')    # &#189;
        para.gsub!(/¾/, '&frac34;')    # &#190;
        para.gsub!(/×/, '&times;')     # &#215;
        para.gsub!(/÷/, '&divide;')    # &#247;
        para.gsub!(/¿/, '&iquest;')    # &#191;
        para.gsub!(/À/, '&Agrave;')    # &#192;
        para.gsub!(/Á/, '&Aacute;')    # &#193;
        para.gsub!(/Â/, '&Acirc;')     # &#194;
        para.gsub!(/Ã/, '&Atilde;')    # &#195;
        para.gsub!(/Ä/, '&Auml;')      # &#196;
        para.gsub!(/Å/, '&Aring;')     # &#197;
        para.gsub!(/Æ/, '&AElig;')     # &#198;
        para.gsub!(/Ç/, '&Ccedil;')    # &#199;
        para.gsub!(/È/, '&Egrave;')    # &#200;
        para.gsub!(/É/, '&Eacute;')    # &#201;
        para.gsub!(/Ê/, '&Ecirc;')     # &#202;
        para.gsub!(/Ë/, '&Euml;')      # &#203;
        para.gsub!(/Ì/, '&Igrave;')    # &#204;
        para.gsub!(/Í/, '&Iacute;')    # &#205;
        para.gsub!(/Î/, '&Icirc;')     # &#206;
        para.gsub!(/Ï/, '&Iuml;')      # &#207;
        para.gsub!(/Ð/, '&ETH;')       # &#208;
        para.gsub!(/Ñ/, '&Ntilde;')    # &#209;
        para.gsub!(/Ò/, '&Ograve;')    # &#210;
        para.gsub!(/Ó/, '&Oacute;')    # &#211;
        para.gsub!(/Ô/, '&Ocirc;')     # &#212;
        para.gsub!(/Õ/, '&Otilde;')    # &#213;
        para.gsub!(/Ö/, '&Ouml;')      # &#214;
        para.gsub!(/Ø/, '&Oslash;')    # &#216;
        para.gsub!(/Ù/, '&Ugrave;')    # &#217;
        para.gsub!(/Ú/, '&Uacute;')    # &#218;
        para.gsub!(/Û/, '&Ucirc;')     # &#219;
        para.gsub!(/Ü/, '&Uuml;')      # &#220;
        para.gsub!(/Ý/, '&Yacute;')    # &#221;
        para.gsub!(/Þ/, '&THORN;')     # &#222;
        para.gsub!(/ß/, '&szlig;')     # &#223;
        para.gsub!(/à/, '&agrave;')    # &#224;
        para.gsub!(/á/, '&aacute;')    # &#225;
        para.gsub!(/â/, '&acirc;')     # &#226;
        para.gsub!(/ã/, '&atilde;')    # &#227;
        para.gsub!(/ä/, '&auml;')      # &#228;
        para.gsub!(/å/, '&aring;')     # &#229;
        para.gsub!(/æ/, '&aelig;')     # &#230;
        para.gsub!(/ç/, '&ccedil;')    # &#231;
        para.gsub!(/è/, '&egrave;')    # &#232;
        para.gsub!(/é/, '&acute;')     # &#233;
        para.gsub!(/ê/, '&circ;')      # &#234;
        para.gsub!(/ë/, '&euml;')      # &#235;
        para.gsub!(/ì/, '&igrave;')    # &#236;
        para.gsub!(/í/, '&acute;')     # &#237;
        para.gsub!(/î/, '&icirc;')     # &#238;
        para.gsub!(/ï/, '&iuml;')      # &#239;
        para.gsub!(/ð/, '&eth;')       # &#240;
        para.gsub!(/ñ/, '&ntilde;')    # &#241;
        para.gsub!(/ò/, '&ograve;')    # &#242;
        para.gsub!(/ó/, '&oacute;')    # &#243;
        para.gsub!(/ô/, '&ocirc;')     # &#244;
        para.gsub!(/õ/, '&otilde;')    # &#245;
        para.gsub!(/ö/, '&ouml;')      # &#246;
        para.gsub!(/ø/, '&oslash;')    # &#248;
        para.gsub!(/ù/, '&ugrave;')    # &#250;
        para.gsub!(/ú/, '&uacute;')    # &#251;
        para.gsub!(/û/, '&ucirc;')     # &#252;
        para.gsub!(/ü/, '&uuml;')      # &#253;
        para.gsub!(/þ/, '&thorn;')     # &#254;
        para.gsub!(/ÿ/, '&yuml;')      # &#255;   
      end
    end
  end
end
module SiSU_XML_tags #Format
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class RDF
    def initialize(md='',seg_name=Array.new,tracker=0)
      @dc_title=@dc_subtitle=@dc_creator=@dc_subject=@dc_description=@dc_publisher=@dc_contributor=@dc_date=@dc_date_created=@dc_date_issued=@dc_date_available=@dc_date_valid=@dc_date_modified=@dc_type=@dc_format=@dc_identifier=@dc_source=@dc_language=@dc_relation=@dc_coverage=@dc_rights=@copyright=@owner=@keywords=''
      #seg_name=%{#{@@seg_name[@@tracker]} - } if @@seg_name[@@tracker]
      @md=md
      @sfx,@pdf=@md.sfx,@md.pdf
      @rdfurl=%{  rdf:about="http://www.jus.uio.no/lm/toc"\n} 
      if @md.dc_title                                                            # DublinCore 1 - title
        @rdf_title=%{    dc.title="#{seg_name}#{@md.dc_title}"\n} 
        @dc_title=%{  <meta name="dc.title" content="#{seg_name}#{@md.dc_title}" />\n}
        #if @md.subtitle
        #  @rdf_title=%{    dc.title="#{seg_name}#{@md.title} - #{@md.subtitle}"\n} 
        #  @title=%{<meta name="dc.title" } +
        #    %{content="#{seg_name}#{@md.title} - #{@md.subtitle}" />\n}
        #else
        #  @rdf_title=%{    dc.title="#{seg_name}#{@md.title}"\n} 
        #  @title=%{<meta name="dc.title" } +
        #    %{content="#{seg_name}#{@md.title}" />\n}
        #end
      end
      if @md.dc_creator                                                          # DublinCore 2 - creator/author (author)
        @rdf_creator=%{    dc.creator="#{@md.dc_creator}"\n} 
        @dc_creator=%{  <meta name="dc.creator" content="#{@md.dc_creator}" />\n}
      end
      if @md.dc_subject                                                          # DublinCore 3 - subject (us library of congress, eric or udc, or schema???)
        @rdf_subject=%{    dc.subject="#{@md.dc_subject}"\n} 
        @dc_subject=%{  <meta name="dc.subject" content="#{@md.dc_subject}" />\n} 
      end
      if @md.dc_description                                                      # DublinCore 4 - description
        @rdf_description=%{    dc.description="#{@md.dc_description}"\n} 
        @dc_description=%{  <meta name="dc.description" content="#{@md.dc_description}" />\n} 
      end
      if @md.dc_publisher                                                        # DublinCore 5 - publisher (current copy published by)
        @rdf_publisher=%{    dc.publisher="#{@md.dc_publisher}"\n} 
        @dc_publisher=%{  <meta name="dc.publisher" content="#{@md.dc_publisher}" />\n}
      end
      if @md.dc_contributor                                                      # DublinCore 6 - contributor
        @rdf_contributor=%{    dc.contributor="#{@md.dc_contributor}"\n} 
        @dc_contributor=%{  <meta name="dc.contributor" content="#{@md.dc_contributor}" />\n}
      end
      if @md.dc_date                                                             # DublinCore 7 - date year-mm-dd
        @rdf_date=%{    dc.date="#{@md.dc_date}"\n} 
        @dc_date=%{  <meta name="dc.date" content="#{@md.dc_date}" #{@md.date_scheme} />\n}
      end
      if @md.dc_date_created                                                     # DublinCore 7 - date.created year-mm-dd
        @rdf_date_created=%{    dc.date.created="#{@md.dc_date_created}"\n} 
        @dc_date_created=%{  <meta name="dc.date.created" content="#{@md.dc_date_created}" #{@md.date_created_scheme} />\n}
      end
      if @md.dc_date_issued                                                      # DublinCore 7 - date.issued year-mm-dd
        @rdf_date_issued=%{    dc.date.issued="#{@md.dc_date_issued}"\n} 
        @dc_date_issued=%{  <meta name="dc.date.issued" content="#{@md.dc_date_issued}" #{@md.date_issued_scheme} />\n}
      end
      if @md.dc_date_available                                                   # DublinCore 7 - date.available year-mm-dd
        @rdf_date_available=%{    dc.date.available="#{@md.dc_date_available}"\n} 
        @dc_date_available=%{  <meta name="dc.date.available" content="#{@md.dc_date_available}" #{@md.date_available_scheme} />\n}
      end
      if @md.dc_date_valid                                                       # DublinCore 7 - date.valid year-mm-dd
        @rdf_date_valid=%{    dc.date.valid="#{@md.dc_date_valid}"\n} 
        @dc_date_valid=%{  <meta name="dc.date.valid" content="#{@md.dc_date_valid}" #{@md.date_valid_scheme} />\n}
      end
      if @md.dc_date_modified                                                    # DublinCore 7 - date.modified year-mm-dd
        @rdf_date_modified=%{    dc.date.modified="#{@md.dc_date_modified}"\n} 
        @dc_date_modified=%{  <meta name="dc.date.modified" content="#{@md.dc_date_modified}" #{@md.date_modified_scheme} />\n}
      end
      if @md.dc_type                                                             # DublinCore 8 - type (genre eg. report, convention etc)
        @rdf_type=%{    dc.type="#{@md.dc_type}"\n} 
        @dc_type=%{  <meta name="dc.type" content="#{@md.dc_type}" />\n}
      end
      if @md.dc_format                                                           # DublinCore 9 - format (use your mime type)
        @rdf_format=%{    dc.format="#{@md.dc_format}"\n} 
        @dc_format=%{  <meta name="dc.format" content="#{@md.dc_format}" />\n}
      end
      if @md.dc_identifier                                                       # DublinCore 10 - identifier (your identifier, could use urn which is free)
        @rdf_identifier=%{    dc.identifier="#{@md.dc_identifier}"\n} 
        @dc_identifier=%{  <meta name="dc.identifier" content="#{@md.dc_identifier}" />\n}
      end
      if @md.dc_source                                                           # DublinCore 11 - source (document source)
        @rdf_source=%{    dc.source="#{@md.dc_source}"\n} 
        @dc_source=%{  <meta name="dc.source" content="#{@md.dc_source}" />\n}
      end
      if @md.dc_language[:name]                                                  # DublinCore 12 - language (English)
        @rdf_language=%{    dc.language="#{@md.dc_language[:name]}"\n} 
        @dc_language=%{  <meta name="dc.language" content="#{@md.dc_language[:name]}" />\n}
      end
      if @md.original_language[:name]                                            
        @rdf_original_language=%{    dc.language="#{@md.original_language[:name]}"\n} 
        @original_language=%{  <meta name="dc.language" content="#{@md.original_language[:name]}" />\n}
      end
      if @md.dc_relation                                                         # DublinCore 13 - relation
        @rdf_relation=%{    dc.relation="#{@md.dc_relation}"\n}
        @dc_relation=%{  <meta name="dc.relation" content="#{@md.dc_relation}" />\n} 
      end
      if @md.dc_coverage                                                         # DublinCore 14 - coverage
        @rdf_coverage=%{    dc.coverage="#{@md.dc_coverage}"\n}
        @dc_coverage=%{  <meta name="dc.coverage" content="#{@md.dc_coverage}" />\n}
      end
      if @md.dc_rights                                                           # DublinCore 15 - rights
        @rdf_rights=%{    dc.rights="#{@md.dc_rights}"\n}
        @dc_rights=%{  <meta name="dc.rights" content="#{@md.dc_rights}" />\n}
      end
      @keywords=%{  <meta name="keywords" content="#{@md.keywords}" />\n} if @md.keywords
      @png=SiSU_Viz::Png.new
      @txt=SiSU_Viz::Txt.new
      @color=SiSU_Viz::Color.new
      @font=SiSU_Viz::Font.new
      @js=SiSU_Viz::Javascript.new
    end
    def rdftoc #tocHead #values strung together, because some empty, and resulting output (line breaks) is much better
      #<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
      #         xmlns:dc="http://purl.org/dc/elements/1.1/">
      #  <rdf:Description rdf:about="http://www.jus.uio.no/lm/doc"
      #      dc:creator="Author"
      #      dc:title="Title"
      #      dc:description="Description if any"
      #      dc:date="Publication Date" 
      #  />
      #</rdf:RDF>
      #Dublin Core
#### XML only :-( KEEP
#<<WOK
#<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
#     xmlns:dc="http://purl.org/dc/elements/1.1/">
#  <rdf:Description
#    #@rdfurl#@rdf_title#@rdf_subtitle#@rdf_creator#@rdf_subject#@rdf_description#@rdf_publisher#@rdf_contributor#@rdf_date#@rdf_dateCreated#@rdf_dateIssued#@rdf_dateAvailable#@rdf_dateValid#@rdf_dateModified#@rdf_type#@rdf_format#@rdf_identifier#@rdf_source#@rdf_language#@rdf_relation #@rdf_coverage#@rdf_rights
#    />\n
#</rdf:RDF>\n
#WOK
    end
    def rdfseg #segHead
      rdftoc
    end
    def comment_xml
      generator="Generated by: #{@md.sisuversion[:project]} #{@md.sisuversion[:version]} of #{@md.sisuversion[:date_stamp]} (#{@md.sisuversion[:date]})"  if @md.sisuversion[:version]
      lastdone="Last Generated on: #{Time.now}"
      rubyv="Ruby version: #{@md.rubyversion}"
      vc=if @md.rc_info
        "Source file: #{@md.rc_filename} version: #{@md.rc_vnumber} of: #{@md.rc_date}"
      else ''
      end
<<WOK
<!-- Document processing information:
     * #{generator}
     * #{rubyv}
     * #{vc}
     * #{lastdone}
     * SiSU http://www.jus.uio.no/sisu
-->
WOK
    end
    def metatag_html #values strung together, because some empty, and resulting output (line breaks) is much better
#{@js.head} 
<<WOK
#@dc_title#@dc_subtitle#@dc_creator#@dc_subject#@dc_description#@dc_publisher#@dc_contributor#@dc_date#@dc_date_created#@dc_date_issued#@dc_date_available#@dc_date_valid#@dc_date_modified#@dc_type#@dc_format#@dc_identifier#@dc_source#@dc_language#@dc_relation#@dc_coverage#@dc_rights#@copyright#@owner
#{@txt.generator}
#{@png.ico}
WOK
    end
  end
end
module SiSU_Tables
  class Table #_xml
    @@tablehead=0
    @@tablefoot=Array.new #watch #bug??? #check was @@tablefoot
    def initialize(one,ocn='')
      @one,@parablock,@ocn,@margin,@paragraph,@table=one,one,ocn,SiSU_Viz::Margin.new,SiSU_Viz::Paragraph.new,SiSU_Viz::Table.new
    end
    def table_split                                                            #% used but, no longer operational, revisit
      @new_content=Array.new
      @one.split(/\n/).each do |parablock|
        table=Table_xml.new("#{parablock}\n")
        @new_content << table.table
      end
      @new_content.join
    end
  end
  class Table_xml <Table
    @@tablehead=0
    @@tablefoot=Array.new #watch #bug??? #check was @@tablefoot
    def initialize(one,ocn='')
      @one,@parablock,@ocn,@margin,@paragraph,@table=one,one,ocn,SiSU_Viz::Margin.new,SiSU_Viz::Paragraph.new,SiSU_Viz::Table.new
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m 
      @parablock.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/<!Th¡/i
      if @parablock =~/<!Th?¡/
        @parablock.gsub!(/<!Th?¡.+?!~(\d+);\w\d+;\w\d+>/,
          %{\n<ocn>#@ocn</ocn><table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">})
      end
      if @parablock =~/<!TZ!>/
        tablefoot=Array.new
        #bug table footers need rethink
        #are removed for now
        #@@tablefoot.each {|x| tablefoot << %{<p align="center"><font size=2><i>#{x}</i></font></p>\n}}
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=Array.new
        @parablock.gsub!(/<!TZ!>\s+<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{32}:[0-9a-f]{32}>/,"</table>\n") # +
      end
      if @@tablehead == 1
        if @parablock =~/¡¡/
          @parablock.gsub!(/<!¡¡(\d+?)¡/,
            %{<tr>
  <td width="\\1%" valign="top">
    #{@paragraph.table_xml}<b>})
          @parablock.gsub!(/¡¡(\d+?)¡/,
            %{</b></td><td width="\\1%" valign="top">
  #{@paragraph.table_xml}<b>})
          @parablock.gsub!(/!>/,"</b>\n</td>\n</tr>")
          @@tablehead=0 #if @parablock =~/!>/
        end
        @parablock
      else
        @parablock.gsub!(/<!¡¡(\d+?)¡/,
          %{<tr>
  <td width="\\1%" valign="top">
    #{@paragraph.table_xml}})
        @parablock.gsub!(/¡¡(\d+?)¡/,
          %{
  </td>
  <td width="\\1%" valign="top">
    #{@paragraph.table_xml}})
        @parablock.gsub!(/!>/,"\n</td>\n</tr>\n")
      end
      @parablock
    end
  end
  class Table_xml_exp <Table
    @@tablehead=0
    @@tablefoot=Array.new #watch
    def initialize(one)
      @one,@parablock,@margin,@paragraph,@table=one,one,SiSU_Viz::Margin.new,SiSU_Viz::Paragraph.new,SiSU_Viz::Table.new
    end
    def table_head(inf)
      %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
  <tr>
    <td valign="top" align="justify">
      <a name="#{inf}"></a>
    </td>
    <td>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">}
    end
    def table_end(tablefoot='')
      %{</table>#{@margin.numless}#{@margin.numless}&nbsp;#{@table.close}
#{tablefoot}}
    end
    def table_row(inf,h=false)
      bold=if h: '<b>'
      else       ''
      end
      %{
<tr>
  <td width="#{inf}%" valign="top">#{bold}}
    end
    def table_cell(inf,h=false)
      if h: %{</b></td><td width="#{inf}%" valign="top"><b>}
      else  %{</td><td width="#{inf}%" valign="top">}
      end
    end
    def table_row_close(h=false)
      bold_close=if h: '</b>'
      else             ''
      end
      "#{bold_close}</td></tr>"
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m 
      @parablock.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/<!Th¡/i
      if @parablock =~/<!Th?¡.+?!~(\d+);\w\d+;\w\d+>/: @parablock=table_head($1)
      end
      if @parablock =~/<!TZ!>/
        tablefoot=Array.new
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=Array.new
        if @parablock =~/<!TZ!>/: @parablock=table_end
        end
      end
      if @@tablehead == 1
        if @parablock =~/¡¡/
          if @parablock =~/<!¡¡(\d+?)¡/
            @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1,true))
          end
          if @parablock =~/¡¡(\d+?)¡/ 
            @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1,true))
          end
          if @parablock =~/!>/
            @parablock.gsub!(/!>/,table_row_close(true))
          end
          @@tablehead=0
        end
        @parablock
      else
        if @parablock =~/<!¡¡(\d+?)¡/
          @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1))
        end
        if @parablock =~/¡¡(\d+?)¡/
          @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1))
        end
        if @parablock =~/!>/
          @parablock.gsub!(/!>/,table_row_close)
        end
        @parablock
      end
      @parablock
    end
  end
end
__END__

