=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: miscellaneous utilities
   * $Id$
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2005.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_text_utils
  class Paragraph
    def initialize(para='',n_char_max=76,n_indent=0,n_hang=nil)
      @para,@n_char_max,@n_indent=para,n_char_max,n_indent
      @br="\n"
      @n_hang=unless n_hang:  @n_hang=@n_indent
      else                    n_hang
      end
    end
    def line_wrap
      space=' '
      spaces_indent,spaces_hang="#@br#{space*@n_indent}",space*@n_hang
      line,out,out[line]=0,Array.new,''
      #@para.gsub!(/<br(?: \/)?>/i, "\n") #watch #added
      words=@para.scan(/\S+/)
      while words != ''
        word=words.shift
        if not word
          out[line].strip!.squeeze!(' ')
          break
        elsif (out[line].length + word.length) > (@n_char_max - @n_indent) and out[line] =~/\S+/
          out[line].strip!.squeeze!(' ')
          line += 1
        end
        out[line]="#{out[line]} #{word}" if word
      end
      out.join(spaces_indent).gsub(/\A\n+/m,'').insert(0,spaces_hang) 
    end
    def line_wrap_indent1
      @n_indent,@n_hang=2,2
      line_wrap
    end
    def line_wrap_endnote
      @n_indent,@n_hang=4,2
      line_wrap
    end
  end
end
__END__

