"%% SiSU Vim misc sort
set showcmd		" Show (partial) command in status line.
set showmatch		" Show matching brackets.
set ignorecase		" Do case insensitive matching
set incsearch		" Incremental search
set autowrite		" Automatically save before commands like :next and :make
"setq tab-width 2
:set nocompatible tabstop=4 ai title
":set nocompatible nu tabstop=4 ai title
"% numbering would be better as a toggle
:map <leader>nn :set nonumber<cr>
:map <leader>nu :set number<cr>
"% plugin Multiple search, colors results 
"g:MultipleSearchMaxColors 8
"g:MultipleSearchColorSequence
"
set guioptions=agmr
"
"If you want color you should set this to true zsh
:syntax on
:set hlsearch
:set incsearch
"% tabs which to use smarttabs or spaces - now spaces
:set tabstop=2
" :retab 2
":set softtabstop=2
":set smarttab
:set expandtab
:set shiftwidth=2
:set autoindent
":set smartindent
":set cindent
:set smartcase
:set gdefault
:set nopaste
"":set pastetoggle=<f8>
:set laststatus=2 "status line always on
":set cmdheight=2 "command line height increased from 1 line to 2
":se splitright
:set whichwrap=<,>,h,l,[,]
":let mapleader = ","
"% wrap
" :windo set wrap
" au FilterWritePre * if &diff | set wrap | endif
:map <leader>wrap :set wrap
:map <leader>nowrap :set nowrap
:map <leader>wrapon :set wrap
:map <leader>wrapoff :set nowrap
"% textwrap
:set nolbr "only affects display not buffer
":set tw=76 " These two are to be extra careful
:set wrap
:set wm=0
"% wrap/formatting paragraph according to the current 'textwidth' with ^J (control-j):
:imap <C-J> <C-O>gqap
:nmap <C-J>      gqap
:vmap <C-J>      gq
"% to html
:let html_use_css = 1
:let html_no_pre = 1
":map <leader>html<cr> :runtime! syntax/2html.vim<cr>
"% synonyms - frequently used mappings
"% fKeyMaps <leader>gu == <url:name> goto
:map <leader>sisudo :! rxvt -bg black -e sisu -mhwp %
:map <f7> :.,$s///c "search and replace down
:map <c-f7> :%s///c "search and replace whole file
:map <leader>rr :rubyd gsub!(//, "") #ruby gsub
:map <leader>regx :rubyd gsub!(//, "")
:map <leader>gsub :rubyd gsub!(//, "")
:map <leader>vsub :%s///c
:map <leader>subv :%s///c
:map <leader>subr :rubyd gsub!(//, "")
:map <leader>sr :%s///c
:map <leader>rpl :%s///c
:map <leader>subv :%s///c
"% minibuf buffers
":source minibufexpl.vim
:map <leader>bo :MiniBufExplorer<cr><cr>
:map <leader>bc :CMiniBufExplorer<cr>
:map <leader>bt :TMiniBufExplorer<cr><cr>
:map <leader>bu :UMiniBufExplorer<cr><cr>
:nmap <silent> <Leader>P :Project<CR>
let g:miniBufExplMaxSize = 0 "4? <max lines: defualt 0> setting this to 0 will mean the window gets as big as is required
let g:miniBufExplSplitBelow=1  " Put new window below
let g:miniBufExplSplitToEdge = 0 " where minibuffer splits, switch off to play well with projects plugin
let g:miniBufExplMapWindowNavVim = 1
let g:miniBufExplMapWindowNavArrows = 1
let g:miniBufExplMapCTabSwitchBuffs = 1
let g:miniBufExplModSelTarget = 1 
"% taglist
:map <leader>tl :Tlist<cr>
:map <leader>et :Tlist<cr>
":map <leader>mb :source ~/.vim/other/minibufexpl.vim
"":map <silent> <leader>tags :Tlist<cr>
let Tlist_Use_Right_Window = 1
let Tlist_WinWidth = 26
let Tlist_File_Fold_Auto_Close = 1
let Tlist_Compact_Format = 1
let Tlist_Exit_OnlyWindow = 1
let Tlist_Inc_Winwidth = 0
"let Tlist_Auto_Open = 1
"% terminfo
:if has("terminfo")
:  let &t_Co=8
:  let &t_Sf="\e[3%p1%dm"
:  let &t_Sb="\e[4%p1%dm"
:else
:  let &t_Co=8
:  let &t_Sf="\e[3%dm"
:  let &t_Sb="\e[4%dm"
:endif
"% searches
:map \vpr /\(\s\\|^\)\(p\\|puts\\|print\)\s
"% save file, go to next file in buffer
:map \nf :w <enter> :n <enter>
"% directory files, placed in vertical split window
:map <leader>dir :vs<cr><C-W><C-R> :Explore<cr>
":map <leader>dir :vs<cr><C-W><C-Left> :Explore<cr>
":map <silent> <leader>dir :vs<cr><C-W>l<cr> :Explore<cr>
":map <silent> <leader>dir :vsp<cr><cr><C-W>r<cr> :Explore<cr>
"% header sisu
:map <leader>url :rubyd sub(/$/, "<url:>")
"% vimdiff q exits
:if &diff
:  cmap q qa
:endif
"au BufLeave * if &diff | qa | endif
"% tidy html
":compiler tidy
"exe 'setlocal equalprg=tidy -quiet -f '.&errorfile
:compiler tidy
"setlocal makeprg=tidy -quiet -e %
"% command output redirected to buffer test this & debug
:redir @c
:silent version
:redir end
"% remapping lines make cursor jump a line at a time within wrapped text
:nnoremap j gj
:nnoremap k gk
:vnoremap j gj
:vnoremap k gk
:nnoremap <Down> gj
:nnoremap <Up> gk
:vnoremap <Down> gj
:vnoremap <Up> gk
:inoremap <Down> <C-o>gj
:inoremap <Up> <C-o>gk
"% pwd t64 working directory set to that of the file you're editing
"changes pwd to directory of file in current buffer
:function! CHANGE_CURR_DIR()
:  let _dir = expand("%:p:h")
:	 exec "cd " . _dir
:	 unlet _dir
:endfunction
"% 
:if has("autocmd")
   " < ... lot of autocmd stuff ... >
   " Change to the directory the file in your current buffer is in
   autocmd BufEnter * :lcd %:p:h
:endif " has("autocmd")
"% autocompletefilenames To search for files in the current directory
:set path=,,
"allows auto-completion for file to edit (e:)in current directory, used in
"normal mode
:map ,e :e <c-r>=expand("%:p:h") . "/" <cr>
:map ,pwd :exe 'cd ' . expand ("%:p:h")<cr>
"% t123 use functionality similar to the * search on multiple files
"will only be useful if you send output to a new buffer - work on if u want it
:map gr :grep <cword> *<cr>
:map gr :grep <cword> %:p:h/*<cr>
:map gR :grep \b<cword>\b *<cr>
:map GR :grep \b<cword>\b %:p:h/*<cr>
"mapping one will search for the word under the cursor (like g*) in any of the files in the current directory
"mapping two will search for the word under the cursor (like g*) in any of the files in the same directory as the current file
"mapping three will search for the word under the cursor by itself (i.e. surrounded by word boundary like *) in any of the files in the current directory
"mapping four will search for the word under the cursor by itself (i.e. surrounded by word boundary like *) in any of the files in the same directory as the current file
"}
"% searchhighlight t93: Toggle search highlight <C-n>
:function! ToggleHLSearched()
:    if &hls
:        set nohls
:    else
:        set hls
:    endif
:endfun
:nmap <silent> <C-n> :silent call ToggleHLSearched()<cr>
"%% SiSU vim folds
:filetype on
:filetype indent on
"set foldmethod=3Dsyntax
"set foldlevel=3Dn
"% dictionary
:let dialect='UK'
:autocmd FileType sisu :set nonumber
:set encoding=utf-8 fileencodings=
:set ff=unix 
:w
set foldexpr=Foldexpr_fun('^\\i')
":set foldmethod=indent
:hi FoldColumn          ctermfg=Black ctermbg=magenta
:hi Folded              ctermfg=Black ctermbg=magenta
"% foldsearchx FoldSearch (opens result of search all else closed) mapped to \f & \z t77 late
:set foldexpr=getline(v:lnum-1)!~@/&&getline(v:lnum)!~@/&&getline(v:lnum+1)!~@/
:map fs :set foldmethod=expr foldcolumn=2 foldlevel=0 <cr>
:map <leader>see :set foldmethod=expr foldcolumn=2 foldlevel=0 <cr>
:map <leader>fa :Fa<cr>
"open fold zR, fold close zM, erase folds, first fold then zE
":map <c-f11> :w!<cr>:!aspell check %<cr>:e! %<cr>
"":autocmd FileType mail :nmap :SPCheck %<cr>:e! %<cr> <f11> :w<cr>:!aspell -e -c %<cr>:e<cr>
function! FoldInst()
  if ( &filetype == "ruby" )
    "erase folds, first fold then erase, or just use open folds zR
    :map <leader>fe :R<cr> zE
    :R
  elseif ( &filetype == "sisu" )
    :map <leader>fe :F<cr> zE
    :F
  else
    :map <leader>fe :F<cr> zE
    :F
  endif
endfunc
:nmap <silent> <leader>ff :silent call FoldInst()<cr>
:map <leader>fO :R <cr>fe<cr> " erase folds
"% foldtoggle Fold Toggle mapped to <space>
" Toggle fold state between closed and opened.  If there is no fold at current line, just moves forward. If it is present, reverse it's state.
fun! ToggleFold()
  if foldlevel('.') == 0
  	normal! l
  else
    if foldclosed('.') < 0
    	.	foldclose
    else
    	. foldopen
    endif
  endif
"  Clear status line
  echo
endfun
" Map this function to Space key.
:noremap <space> :call ToggleFold()<cr>
"}
"% foldtype Fold? set foldtext
:set foldtext=v:folddashes.substitute(getline(v:foldstart),'\\=','','g',)
:set foldexpr=getline(v:lnum-1)!~@/&&getline(v:lnum)!~@/&&getline(v:lnum+1)!~@/
:nnoremap zj :if &foldcolumn \| set nofoldcolumn \| else \| set foldcolumn \| endif<cr>
:nnoremap zI :set foldmethod=indent \| set foldmethod=manual \| set foldcolumn<cr>
:nnoremap zS :set foldmethod=syntax \| set foldmethod=manual \| set foldcolumn<cr>
:noremap fi :set foldmethod=indent \| set ai \| set ic \| set backspace=2 \| set noexpandtab \| set nosmarttab \| set softtabstop=0
:nnoremap X zA " recursively open folds under cursor
:nnoremap fu zA " recursively open folds under cursor
:nnoremap fo zR " fold open
:nnoremap fc zm " fold close - do folds
:nnoremap fC zM " fold close - do folds
:nnoremap fe zE " erase folds
"% foldsearch t77: Fold on search result 
"(Fs <pattern> or Fc Frb Flm Fp) Fs pattern Fold search #Str (structure) ruby program pattern based on module class and def #Strlm (structure) lm file pattern based on <!1!> etc.
function! Foldsearch(search)
  set fdm=manual
  normal zE
  normal G$
  let folded = 0     "flag to set when a fold is found
  let flags = "w"    "allow wrapping in the search
  let line1 =  0     "set marker for beginning of fold
  while search(a:search, flags) > 0
    let  line2 = line(".")
"    echo "pattern found at line # " line2
      if (line2 -1 > line1)
:       "echo line1 . ":" . (line2-1)
:       "echo "A fold goes here."
:       execute ":" . line1 . "," . (line2-1) . "fold"
:       let folded = 1       "at least one fold has been found
:     endif
:     let line1 = line2     "update marker
:     let flags = "W"       "turn off wrapping
:  endwhile
"  Now create the last fold which goes to the end of the file.
:  normal $G
:  let  line2 = line(".")
"  echo "end of file found at line # " line2
:  if (line2  > line1 && folded == 1)
"    echo line1 . ":" . line2
"    echo "A fold goes here."
:    execute ":". line1 . "," . line2 . "fold"
:  endif
:  normal 1G
:endfunction
"% folds Fold Patterns
" Command is executed as ':Fs pattern'"
:command! -nargs=+ -complete=command Fs call Foldsearch(<q-args>)
:command! -nargs=+ -complete=command Fold call Foldsearch(<q-args>)
"% folds :T Fold Patterns exuberant tag list :T
:command! T Fs ^\s*\S\+\s\+(
"% folds :R Fold Patterns Ruby :R
:command! RD Fs \(^\s*\(\(def\|class\|module\)\s\)\)\|^\s*\([#%"0-9]\{0,4\}{\(%\|{{\|!!\)\|#\s\+=\+\s\+\)
:command! R Fs \(^\s*\(\(\(def\|class\|module\)\s\)\|\(\(public\|protected\|private\|__END__\)\(\s\|$\)\)\)\)\|^[0-9]{\|[#%"]\{1,4\}\s*%\|{\({\|!!\)
":command! R Fs \(^\s*\(\(def\|class\|module\)\s\)\)\|^[0-9]{\|[#%"]\{1,4\}\s*{\({\|!!\)
:command! Re Fs \(^\s*\(\(def\|class\|module\)\s\)\)\|^\s*[ #%"0-9\~]\{0,4\}{\({{\|!!\)
:command! RN Fs \(^\s*#\s\+=\+\s\+\)
:command! R0 Fs \(\s\|^\)0{
:command! R1 Fs \(\s\|^\)1{
:command! R2 Fs \(\s\|^\)[12]{
:command! R3 Fs \(\s\|^\)[3]{
:command! R4 Fs \(\s\|^\)4{
:command! R5 Fs \(\s\|^\)[4-5]{
:command! R6 Fs \(\s\|^\)[4-6]{
"% folds :F Fold Patterns SiSU Markup :F
:command! F Fs ^[1-8]\~\|\(^\|\s\+\)[#%<"][#%<"]\s\+
:command! Fa Fs [r1-8]{\|#\s*{{\|^[#%"0-9]\{0,4\}\s*{[{!]\|#{\|^\(Book\|Part\|Chapter\|Section\|Article\|BOOK\|PART\|CHAPTER\|SECTION\|ARTICLE\)\s
"% folds Fold Patterns misc
:command! TI Fs \(^\s*\(\(input texinfo\|@copying\|@titlepage\|@ifnotex\|@node\|@chapter\|@ifnotex\|@bye\)\)\)\|^@c\s*[#"0-9]\{0,4\}\s*{{{
:command! FoldSiSU Fs \(^\s*\(\(def\|class\|module\)\s\)\)\|^\s*[#"0-9]\{0,4\}\s*{{
:command! FoldAstrisk Fs ^\s*\*
:command! Fce Fs \(^\"{\|^#{\|^\">\|^#>\)\|\(^\"\"{\|^##{\|^\"\">\|^##>\)
:command! Fp Fs ^\s*[A-Za-z0-9#]
:command! Strp Fs public\s\|protected\s\|private\s
:command! Fo Fs ^[#\"]\s*[{>]
"% Fold from a new vim help page not working
:fun! MyFoldExpr(line)
:  set foldmethod=expr
:  set foldexpr=MyFoldExpr(v:lnum)
:  let str = getline(a:line)
:  if str =~ '^sub\>'
:    return '1'
:  elseif str =~ '^}'
:    return '<1'
:  else
:    return foldlevel(a:line - 1)
:  endif
:endfun
"vim: sw=4
