=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Document skin for "Free For All" 
 * arch-tag: skin for an individual document set (wayner)
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * $Date$
 * $Id$
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
	include SiSU_Viz
  class Path
    def root                                                                     # the only parameter that cannot be changed here
      './sisu/'
    end
    def rel
      '../'
    end
  end
  class Url
    #def hp # used by wmap, get rid of ie make it seek home instead
    #  'http://www.wayner.org/books/ffa/'
    #end
    def home
      'http://www.wayner.org/books/ffa/'
    end
    def txt                                                                      # text to go with url usually stripped url
      'www.wayner.org'
    end
    #def root_http
      #root server path info, used in document information
    #end
  end
  class Color
    def band1
      '"#000070"'      
    end
  end
  class Txt
    def hp
      'www.wayner.org'
    end
    def home
      'Peter Wayner'
    end
  end
  class Icon
    def home_button
      'wayner.home.png'
    end
    def home_banner
      self.home_button
    end
    def next
      'arrow_next_blue.png'
    end
    def previous
      'arrow_prev_blue.png'
    end
    def up
      'arrow_up_blue.png'
    end    
  end
  class Banner
    def home_button
      %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{@color.yellow_dark}><a href="#{@url.home}">#{@png.home}</a></td></tr></table>\n}
    end
    def home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{@color.yellow_dark}><a href="#{@url.home}" target="_top">#{@png.home}</a></td></tr></table></td><td width="60%"><center><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc.html" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font></td></tr></table></center></center></td><td width="20%">&nbsp;</td></tr></table>}
    end
    def band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{@color.yellow_dark}><a href="#{@url.home}" target="_top">#{@png.home}</a>#{@table.close}}
    end
  end
  class Credits
    def credits
      %{<table summary="credits" align="center"bgcolor="#ffffff"><tr><td><font color="black"><center>Available at Amazon.com<br /><a href="http://www.amazon.com/exec/obidos/tg/detail/-/0066620503/"><img border="0" align="center" src="../_sisu/image/free.for.all.png" alt="Free For All at Amazon.com"></a><br />This book is Copyright  2000 by Peter Wayner.<br />See <a href="http://www.wayner.org/books/ffa/">http://www.wayner.org/books/ffa/</a><br /><a href="mailto://p3@wayner.org">p3@wayner.org</a><br />#{@widget.sisu}</center></font></td></tr></table>}
    end
  end
  class Tex
    def header_center
	    "\\chead{\\href{#{@url.home}}{www.wayner.org}}"
    end
    def home_url
	    "\\href{#{@url.home}}{www.wayner.org}"
    end
    def home
	    "\\href{#{@url.home}}{Peter Wayner}"
    end
    def owner_chapter
      "Document owner details"
    end
    def stmp
	    "\\copyright Ralph Amissah, licence GPL \\\\\n www.jus.uio.no/sisu/"
    end
  end
end
