/*
    Copyright (C) 2002-2008  Thomas Ries <tries@gmx.net>

    This file is part of Siproxd.
    
    Siproxd is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    Siproxd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Siproxd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

/* $Id: plugins.h,v 1.6 2008/03/09 13:30:22 hb9xar Exp $ */

/* fetch local version of ltdl */
#include "../libltdl/ltdl.h"


/* Plugins must return STS_SUCCESS / SUCCESS_FAILURE */


/*
 * Processing stages for Plugins
 */
/* Validation of SIP packet */
#define PLUGIN_VALIDATE		0x00000010	
/* Determining Request Targets */
/* may end the current SIP processing in siproxd by returning STS_SIP_SENT
 * see plugin_shortcut that sends a redirect back to the client */
#define PLUGIN_DETERMINE_TARGET	0x00000020	/* Determining Request Targets */
/* SIP package before siproxd starts the proxying process */
#define PLUGIN_PRE_PROXY	0x00000040	/* before MASQuerading */
/* to/from unregistered UA */
#define PLUGIN_PROXY_UNK	0x00000080	/* e.g. incoming call to unknown UA */
/* before sending the SIP message */
#define PLUGIN_POST_PROXY	0x00000100	/* after MASQuerading */


/* Plugin "database" */
typedef struct {
   void *next;		/* link to next plugin element, NULL if last */
   int  api_version;	/* API version that PLUGIN uses */
   char *name;		/* Plugn name */
   char *desc;		/* Description */
   int  exe_mask;	/* bitmask for activation of different processing
   			   stages during SIP processing that a plugin wants
   			   to be called */
   lt_ptr plugin_process;/* Plugin processing entry point */
   lt_ptr plugin_end;	/* de-initialization function */
   lt_ptr dlhandle;	/* handle returned by dlopen() */
} plugin_def_t;

#define SIPROXD_API_VERSION	0x0100


/* The plugin must provide the following entry points */
/* Plugin is responsable for its dynamic memory management.
   - Storage allocated in _init must be released in _end.
   - manipulation of SIP messages (sip_ticket structure) must
     be made in a way to ensure that no memleaks do exist.
     If you want to change a field, first osip_malloc() new space,
     move the pointer in the osip structure to the new place and then
     osip_free() the old area.
*/
/* plugin_init must define the following fields of the plugin_def_t structure:
   - api_version	(= SIPROXD_API_VERSION)
   - name
   - desc
   - exe_mask
   The rest will be initialized by siproxd and must not be fumbled with.
*/
int  plugin_init(plugin_def_t *plugin_def);
int  plugin_process(int stage, sip_ticket_t *ticket);
int  plugin_end(plugin_def_t *plugin_def);
