int PrintChar(char znak, int x, int y, SDL_Surface *font){
	char pismena[100]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789/.*!<>@#$%^&()[]{}\"';:,?\0";
	int i, j;
	Uint8 r,g,b;
	Uint32 pixel;
	int pozice;
	for(i=0; i<89; i++){
		if(pismena[i]==znak){
			pozice=i;
			break;
		}
	}	
#ifdef DEBUG
	printf("in PrintChar %c %c %d %d\n", znak, pismena[i], x, y);
#endif
	for(i=0;i<10;i++){
		for(j=0;j<font->h;j++){
			pixel=getpixel(font, pozice*10+i,j);
			SDL_GetRGB(pixel, font->format, &r, &g, &b);
			if((r==0xff && g==0xff && b==0xff) || (r==0xf8 && g==0xfc && b==0xf8))
				continue;
			putpixel(screen, i+x, j+y, pixel);
		}
	}
}

void PrintLine(char *line, int x, int y, SDL_Surface *font){
	int i;
#ifdef DEBUG
	printf("in PrintLine\n");
#endif

	SDL_LockSurface(screen);
		for(i=0; *(line+i)!='\0'; i++){
			if(*(line+i)==' ')
				continue;
			PrintChar(*(line+i), i*10+x, y, font);
		}
	SDL_UnlockSurface(screen);
}

Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
    int bpp = surface->format->BytesPerPixel;
    /* Here p is the address to the pixel we want to retrieve */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;       /* shouldn't happen, but avoids warnings */
    }
}

void putpixel(SDL_Surface *surface, int x, int y, Uint32 pixel)
{
    int bpp = surface->format->BytesPerPixel;
    /* Here p is the address to the pixel we want to set */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
    case 1:
        *p = pixel;
        break;

    case 2:
        *(Uint16 *)p = pixel;
        break;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN) {
            p[0] = (pixel >> 16) & 0xff;
            p[1] = (pixel >> 8) & 0xff;
            p[2] = pixel & 0xff;
        } else {
            p[0] = pixel & 0xff;
            p[1] = (pixel >> 8) & 0xff;
            p[2] = (pixel >> 16) & 0xff;
        }
        break;

    case 4:
        *(Uint32 *)p = pixel;
        break;
    }
}
