#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#undef NDEBUG
#include <assert.h>
#include <demangle.h>

void *
xmalloc (size_t sz)
{
	void *p = malloc (sz);
	assert (p);
	return p;
}

void *
xrealloc (void *p, size_t sz)
{
	void *p2 = realloc (p, sz);
	assert (p2);
	return p2;
}

void
usage ()
{
	fprintf (stderr, "usage: mprdem [-p] [-a]\n");
	exit (1);
}

int
main (int argc, char **argv)
{
	char buf[4096], *dem, *cp;
	int opt, noparams=0, noansi=0, demopt=0;

	while ((opt = getopt (argc, argv, "ap")) != -1)
		switch (opt) {
		case 'a':
			noansi = 1;
			break;
		case 'p':
			noparams = 1;
			break;
		case '?':
			usage ();
		}

	if (!noansi)
		demopt |= DMGL_ANSI;

	if (!noparams)
		demopt |= DMGL_PARAMS;

#define demangle(style) cplus_demangle (cp+1, demopt|style)

	while (gets (buf)) {	/* XXX gets() */

		cp = strchr (buf, '\t');
		assert (cp);
		*cp = 0;
		printf ("%s\t", buf);

		if ((dem = demangle (DMGL_AUTO)) ||
		    (dem = demangle (DMGL_GNU)) ||
		    (dem = demangle (DMGL_ARM)) ||
		    (dem = demangle (DMGL_LUCID))) {
			printf ("%s\n", dem);
			free (dem);
		}
		else
			printf ("%s\n", cp+1);
	}

	return 0;
}
