#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "GNUstepGUI/GSDrawFunctions.h"

@implementation NSTabViewItem (theme)

- (void)drawLabel:(BOOL)shouldTruncateLabel
           inRect:(NSRect)tabRect
{
  NSGraphicsContext     *ctxt = GSCurrentContext();
  NSRect lRect; 
  NSRect fRect;
  NSDictionary *attr;
  NSString *string;

  if (shouldTruncateLabel)
    {
      string = [self _truncatedLabel];
    }
  else 
    { 
        string = _label;
    }
    
  _rect = tabRect;
    
  DPSgsave(ctxt);
  fRect = tabRect;

  if (_state == NSSelectedTab)
    {
      fRect.origin.y -= 2;
      fRect.size.height += 2;
      [[NSColor controlBackgroundColor] set];
      NSRectFill(fRect);
    }
  else if (_state == NSBackgroundTab)
    {
      [[NSColor controlBackgroundColor] set];
      NSRectFill(fRect);
    }
  else
    {
      [[NSColor controlBackgroundColor] set];
    }

  attr = [[NSDictionary alloc] initWithObjectsAndKeys:
                               [_tabview font], NSFontAttributeName,
                               [NSColor blackColor], NSForegroundColorAttributeName,
                               nil];

  lRect = tabRect;
  lRect.origin.y += 3;
  [string drawInRect: lRect withAttributes: attr];
  RELEASE(attr);

  DPSgrestore(ctxt);
}


@end
