/*
 SimpleCDR Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */
#include <iostream>
#include <string>
#include "string2int.h"

using namespace std;


string String2int::trackNum(int count)
{
   char suf[20];
   string suffix;
	
	sprintf((char *)suf, "%d", count);
	suffix=suf;
	if (count<10)
		suffix="0"+suffix;
	return suffix;
}

//**************************************

void String2int::trackSuf(int count, string& suffix)
{
   char suf[20];
	
	sprintf((char *)suf, "%d", count);
	suffix=suf;
	if (count<10)
		suffix="0"+suffix;
}
   
//********************************

void String2int::sizeEstimator(string size, string function, int& sizeFloat)
{
   const int arrSize=6;
   string num[arrSize];
   string::size_type len;
   sizeFloat=0;
   len=size.length(); 
   num[0]=size.substr(0,1);
   if (len>1)
      num[1]=size.substr(1,1);
   if (len>2)
      num[2]=size.substr(2,1);
   if (len>3)
      num[3]=size.substr(3,1);
   if (len>4)
      num[4]=size.substr(4,1);
   if (len>5)
      num[5]=size.substr(5,1);
   if (len==1)
   {
      num[5]=num[0];
      num[4]="";
      num[3]="";
      num[0]="";
      num[1]="";
      num[2]="";    
   } 
   if (len==2)
   { 
      num[5]=num[1];
      num[4]=num[0];
      num[3]="";
      num[0]="";
      num[1]="";
      num[2]="";    
   }



   if (len==3)
   {
      num[5]=num[2];
      num[4]=num[1];
      num[3]=num[0];
      num[0]="";
      num[1]="";
      num[2]="";
      if(function=="time")
      {
         num[5]=num[4];
      	num[4]=num[3];
      	num[3]="";
      }
   }
   if (len==4)
   {
      num[5]=num[3];
      num[4]=num[2];
      num[3]=num[1];
      num[2]=num[0];
      num[1]="";
      num[0]="";
      if(function=="time")
      {
         num[5]=num[4];
      	num[4]=num[3];
      	num[3]=num[2];
      	num[2]="";
      }
   }	  
   if (len==5)
   {
      num[5]=num[4];
      num[4]=num[3];
      num[3]=num[2];
      num[2]=num[1];
      num[1]=num[0];
      num[0]="";
   }

   if (num[0]=="9")
      sizeFloat=900000; 
   if (num[0]=="8")
      sizeFloat=800000;
   if (num[0]=="7")
      sizeFloat=700000;
   if (num[0]=="6")
      sizeFloat=600000;
   if (num[0]=="5")
      sizeFloat=500000;
   if (num[0]=="4")
      sizeFloat=400000;
   if (num[0]=="3")
      sizeFloat=300000;
   if (num[0]=="2")
      sizeFloat=200000;
   if (num[0]=="1")
      sizeFloat=100000;
  
   if(num[1]=="9")
   sizeFloat=sizeFloat+90000;
   if(num[1]=="8")
   sizeFloat=sizeFloat+80000;
   if(num[1]=="7")
   sizeFloat=sizeFloat+70000;
   if(num[1]=="6")
   sizeFloat=sizeFloat+60000;
   if(num[1]=="5")
   sizeFloat=sizeFloat+50000;
   if (num[1]=="4")
      sizeFloat=sizeFloat+40000;
   if (num[1]=="3")
     sizeFloat=sizeFloat+30000;
   if (num[1]=="2")
      sizeFloat=sizeFloat+20000;
   if (num[1]=="1")
      sizeFloat=sizeFloat+10000;
   
   if (num[2]=="9")
      sizeFloat=sizeFloat+9000;
   if (num[2]=="8")
      sizeFloat=sizeFloat+8000;
   if (num[2]=="7")
      sizeFloat=sizeFloat+7000;
   if (num[2]=="6")
      sizeFloat=sizeFloat+6000;
   if (num[2]=="5")
      sizeFloat=sizeFloat+5000;
   if (num[2]=="4")
      sizeFloat=sizeFloat+4000;
   if (num[2]=="3")
      sizeFloat=sizeFloat+3000;
   if (num[2]=="2")
      sizeFloat=sizeFloat+2000;
   if (num[2]=="1")
      sizeFloat=sizeFloat+1000; 
     
   if (num[3]=="9")
      sizeFloat=sizeFloat+900; 
   if (num[3]=="8")
      sizeFloat=sizeFloat+800;
   if (num[3]=="7")
      sizeFloat=sizeFloat+700;
   if (num[3]=="6")
      sizeFloat=sizeFloat+600;
   if (num[3]=="5")
      sizeFloat=sizeFloat+500;
   if (num[3]=="4")
      sizeFloat=sizeFloat+400;
   if (num[3]=="3")
      sizeFloat=sizeFloat+300;
   if (num[3]=="2")
      sizeFloat=sizeFloat+200;
   if (num[3]=="1")
      sizeFloat=sizeFloat+100;
     
   if (num[4]=="9")
      sizeFloat=sizeFloat+90;
   if (num[4]=="8")
      sizeFloat=sizeFloat+80;
   if (num[4]=="7")
      sizeFloat=sizeFloat+70;
   if (num[4]=="6")
      sizeFloat=sizeFloat+60;
   if (num[4]=="5")
      sizeFloat=sizeFloat+50;
   if (num[4]=="4")
      sizeFloat=sizeFloat+40;
   if (num[4]=="3")
      sizeFloat=sizeFloat+30;
   if (num[4]=="2")
      sizeFloat=sizeFloat+20;
   if (num[4]=="1")
      sizeFloat=sizeFloat+10;
   
   if (num[5]=="9")
      sizeFloat=sizeFloat+9;
   if (num[5]=="8")
      sizeFloat=sizeFloat+8;
   if (num[5]=="7")
      sizeFloat=sizeFloat+7;
   if (num[5]=="6")
      sizeFloat=sizeFloat+6;
   if (num[5]=="5")
      sizeFloat=sizeFloat+5;
   if (num[5]=="4")
      sizeFloat=sizeFloat+4;
   if (num[5]=="3")
      sizeFloat=sizeFloat+3;
   if (num[5]=="2")
      sizeFloat=sizeFloat+2;
   if (num[5]=="1")
      sizeFloat=sizeFloat+1;
}

//*******************
void String2int::selTracks(string& list, string& track)
{
	int len, num;
	len=list.length();
	num=list.find(",");
   int count;
   int interval_int[1];
   string track_temp;
   string interval[1];

	if (num >= 3 && num <= 5 && int(list.find("-"))!=-1)
	{
  	 int hyp=list.find("-");
 	  if (hyp >= 1 && hyp <= 5)
	   {
	       interval[0]=list.substr(0,hyp);
  	     interval[1]=list.substr(hyp+1, (num-hyp-1));
   	    sizeEstimator(interval[0], "track", interval_int[0]);
   	    sizeEstimator(interval[1], "track", interval_int[1]);
    		count=interval_int[1]-1;
    		list=interval[1]+","+list.substr((num+1), (len - (num +1)));
    
    		while(count > interval_int[0])
	    	{
	    		timeconverter(count, "track", track_temp);
	    		list=track_temp+","+list;
	    		count--;
	 		}

//first of the interval
    		list=interval[0]+","+list;

          len=list.length();
	       num=list.find(",");
	 	}
	    else
	       track="error";
   }					

//
   if (num==-1 && int(list.find("-"))!=-1)
   {
  	 int hyp=list.find("-");

//getting first and last
      interval[0]=list.substr(0,hyp);
		interval[1]=list.substr(hyp+1, len-hyp);

		//conversion to int
		sizeEstimator(interval[0], "track", interval_int[0]);
	   sizeEstimator(interval[1], "track", interval_int[1]);
		count=interval_int[1]-1;
		list=interval[1];
		while (count > interval_int[0])
		{
 	 		timeconverter(count, "track", track_temp);
		 	list=track_temp+","+list;
			 count--;
		}

   	list=interval[0]+","+list;
   	len=list.length();
	   num=list.find(",");
   }	    
		 	
	if (num==2)
	{
	   track=list.substr(0,2);
	   list=list.substr((num+1), (len - (num +1)));
   }
	
	if (num==1)
	{
	   track=list.substr(0,1);
	   list=list.substr((num+1), (len - (num +1)));
	}
	if (len==1 && num==int(string::npos))
	{
	   track=list;
	   list="end";
	}
	if (len==2 && num==int(string::npos))
	{
	   track=list;
	   list="end";
	}
	if (len>2 && num==int(string::npos))
	   track="error";
}
 
//*************************************************************

void String2int::timeconverter(int inttime, string type, string& time)
{
   int track=inttime;
   string temptime;
	char time1[20];
	sprintf((char *)time1, "%d", inttime);
	if (type=="data")
	{
		time=time1;
		time=time+" MB";
	}		
	if (type=="minute")
	{
		time=time1;
		time=time+":";
	}
	if (type=="second")
	{
		temptime=time1;
		if (inttime < 10)
			time=time+"0"+temptime;
		else
			time=time+temptime;
	}
	
	if (type=="track")
		time=time1;
}

//**************************************

string String2int::randName()
{
	string fileName;
	char filename[20]="simplecdrxXXXXXX";
	
	mkstemp((char *)filename);
	fileName=filename;
	
	unlink(filename);
	return fileName;
}
