/*
 SimpleCDR Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include "ucdrom.h"
#include "play.h"

using namespace std;


void Play::playwav(string filename, Setup setupData)
{
   string command;  
   command="play "+filename+" &";
   system(command.c_str());
}

//**************************

void Play::playMP3()
{
  string filename;
  string command;
  cout<<"Enter path and filename to .mp3 file"<<endl<<":";
  getline(cin, filename);
  command="mpg123 "+filename+" &";
  system(command.c_str());
}

//*****************************

void Play::cdplay(int track, Setup setupData1)
{
  
  struct cdrom_tochdr track_list;
  struct cdrom_ti tracks;

  // Open the CD device
   int cd=open(setupData1.readerdev.c_str(), O_RDONLY | O_NONBLOCK);

   if (!cd) 
   {
      cout<<"Failed to Open CD: Press <ENTER>< to continue";
      return;
   }
   // Read the track information.
   ioctl(cd, CDROMREADTOCHDR, &track_list);
   int total=track_list.cdth_trk1;
//   cout<<endl<<"The CD has "<<total<<" tracks"<<endl;
//   cout<<track<<endl;


   if(track_list.cdth_trk1>=track)
   {
      tracks.cdti_trk0 = track;    
      tracks.cdti_ind0 = 0;
      tracks.cdti_trk1 = track;    
      tracks.cdti_ind1 = 1;
      // Start playing the CD
      ioctl(cd, CDROMPLAYTRKIND, &tracks);
   }
   else
   {
  	  close(cd);
	    return;
   }
 	  
   //Stop the CD
   // ioctl(cd, CDROMSTOP);
   close(cd);
   return;
}

//****************************

void Play::cdstop(Setup setupData1)
{
  // Open the CD device
   int cd=open(setupData1.readerdev.c_str(), O_RDONLY | O_NONBLOCK);

   if (!cd) 
   {
      cout<<"Failed to Open CD";
      return;
   }

   //Stop the CD
   ioctl(cd, CDROMSTOP);
   close(cd);
   return;
}

int Play::totalTracks(Setup setupData1)
{
  
  struct cdrom_tochdr track_list;
  struct cdrom_ti tracks;
  int cd;
  // Open the CD device
   cd=open(setupData1.readerdev.c_str(), O_RDONLY | O_NONBLOCK);

   if (!cd) 
   {
      cout<<"Failed to Open CD: Press <ENTER>< to continue";
      return 0;
   }
   // Read the track information.
   cd=ioctl(cd, CDROMREADTOCHDR, &track_list);
   int total=track_list.cdth_trk1;
//   cout<<endl<<"The CD has "<<total<<" tracks"<<endl;
//   cout<<track<<endl;
   if (cd == -1)
	   return -1;
   
   return total;
}
