/*
 SimpleCDR-X Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */

#include "masterdatacd.h"

using namespace std;


int MasterDataCD::createImage(multiType multises, imageType image, Setup setupData1, string pathspec, string isoname)
{
   ifstream inFile;
   string command, size, msinfo;
   int cont;
   if (image==ROCKRIDGE)
      command="cd "+setupData1.tempdirdata+"; mkdir .temp; cd .temp; mkisofs -iso-level 3 -v -v -R -graft-points -path-list="+pathspec+" -m .temp -m '"+setupData1.tempdirdata+"/*' -o "+isoname+" "+setupData1.tempdirdata; 
 
   if (multises==SECOND)
   {
      string msinfo="/tmp/"+convert.randName();
		command="cdrecord dev="+setupData1.recorder+" -msinfo &> "+msinfo;
      cont=exec_cmd(command, setupData1);
      inFile.open(msinfo.c_str());
      inFile>>msinfo;
      inFile.close();
      unlink(msinfo.c_str());
      command="cd "+setupData1.tempdirdata+"; mkdir .temp; cd .temp; mkisofs -iso-level 3 -v -v -R -graft-points -path-list="+pathspec+" -C "+msinfo+" -M "+setupData1.recorderdev+" -m .temp -m '"+setupData1.tempdirdata+"/*' -x "+setupData1.tempdirdata+" -o "+isoname+" "+setupData1.tempdirdata; 
   }
   if (image==JOLIET)
      command="cd "+setupData1.tempdirdata+"; mkdir .temp; cd .temp; mkisofs -allow-lowercase -allow-multidot -J -jcharset iso8859-1 -iso-level 3 -v -v -relaxed-filenames -graft-points -path-list="+pathspec+" -m .temp -m '"+setupData1.tempdirdata+"/*' -o "+isoname+" "+setupData1.tempdirdata; 
   if (image==ROCKNJOL)
      command="cd "+setupData1.tempdirdata+"; mkdir .temp; cd .temp; mkisofs -allow-lowercase -allow-multidot -J -jcharset iso8859-1 -iso-level 3 -v -v -R -relaxed-filenames -graft-points -path-list="+pathspec+" -m .temp -m '"+setupData1.tempdirdata+"/*' -o "+isoname+" "+setupData1.tempdirdata;

   cont=exec_cmd(command, setupData1);
   cout<<"Create Image finished!"<<endl;
   /*struct stat filesize;
   stat(temp.c_str(), &filesize);
	total_size=total_size+float(filesize.st_size)/1048000.0;*/
	if (cont==1)
      return 1;
   
   else if (cont==0)
      return 0;
} 
 
//***********************

void MasterDataCD::writeImage(multiType multises, imageType image, bool simulate, bool overburn, Setup setupData1, string pathspec)
{
   int cont;
   string command, filename, sim, ob;
   ifstream cdImage;
   filename=setupData1.tempdirdata+"/.temp/"+convert.randName()+".iso";
   cdImage.open(filename.c_str());
   if (cdImage)
   {
      cdImage.close();
      unlink(filename.c_str());
   }
   else
   {
   	cdImage.close();
   }
   cont=createImage(multises, image, setupData1, pathspec, filename);
   
	if(cont==1)
      return;
	if(overburn==true)
       ob="-ignsize -overburn";
	else
	   ob="";
   if(simulate==true)
      sim="-dummy";

   cout<<"Burning CD..."<<endl;
   if(multises==FIRST || multises==SECOND)
      command="cd "+setupData1.tempdirdata+"/.temp; rm *.bin; cdrecord "+setupData1.custom_cdrecord+" "+sim+" "+ob+" fs="+setupData1.fifo+"k -v -multi speed="+setupData1.speed+" dev="+setupData1.recorder+" -data "+filename;
   else
      command="cd "+setupData1.tempdirdata+"/.temp; rm *.bin; cdrecord "+setupData1.custom_cdrecord+" "+sim+" "+ob+" fs="+setupData1.fifo+"k -v speed="+setupData1.speed+" dev="+setupData1.recorder+" -data "+filename;
   cout<<command<<endl;
   exec_cmd(command, setupData1);
   cout<<"Finished!"<<endl;

   removeImage(setupData1);
}
 
//****************** 
 
void MasterDataCD::removeImage(Setup setupData1)
{
   string command="cd "+setupData1.tempdirdata+" ; rm -r .temp*";
	system(command.c_str());
 }

//****************

void MasterDataCD::blankCDRW(blankType blank, Setup setupData1)
{
   string command;

   if(blank==ALL)
      command="cdrecord blank=all dev="+setupData1.recorder+" speed="+setupData1.speed;
   if(blank==FAST)
      command="cdrecord blank=fast dev="+setupData1.recorder+" speed="+setupData1.speed;
/*if(blank==session)
 command="cdrecord blank=session dev="+setupData1.recorder+" speed="+setupData1.speed;
if(blank==unclose)
 command="cdrecord blank=unclose dev="+setupData1.recorder+" speed="+setupData1.speed;
*/
	exec_cmd(command, setupData1);
}

//**********************************

void MasterDataCD::scanBus(string& scsi_info)
{
   int l=0;
   string scsitemp, scsiinfo="/tmp/"+convert.randName();
   ifstream inFile;
   string command="cdrecord -scanbus > "+scsiinfo;
	system(command.c_str());
   inFile.open(scsiinfo.c_str());
   while(getline(inFile, scsitemp))
   {
      if(l==3)
         scsi_info=scsi_info+"\n       SCSI ID                    Drive Identification\n";
 
      scsitemp=scsitemp+"\n";
      scsi_info=scsi_info+scsitemp;
      l++;
   }
	inFile.close();
   unlink(scsiinfo.c_str());
}
