/*
 SimpleCDR-X Copyright (C) 2001 John Tobin

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 If you would like to negotiate alternate licensing terms, you may do
 so by contacting the author: John Tobin <ogre@sirinet.net>
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <stdio.h>
#include <unistd.h>


#ifdef HAVE_VORBIS
#include <vorbis/vorbisfile.h>
#endif //HAVE_LIBVORBIS

#include "simplecdr.h"
#include "string2int.h"
#include "play.h"
#include "wave.h"
#include "mp3info.h"
#include "progress.h"

using namespace std;


#ifndef __MASTERAUDIOCD_H__
#define __MASTERAUDIOCD_H__ 

class MasterAudioCD
{
public:
int ripNAdd(string&, string, string, Setup); 
void writeAudioCD(int, bool, bool, bool, bool, bool, Setup, string);
void time_est(string, string&, string&, songType, int&);
void time_sub(string, songType, int&);
int convertTracklist(int, int, string, Setup, string);
#ifdef HAVE_VORBIS
void ogginfo(const char *, int&);
#endif //HAVE_VORBIS
void playWAV();
int load_mp3(const char*);


private:
Setup setupData1;
String2int convert;
WaveFile wav_;
string prompt, buffer;
Play play;
mp3info mp3_;
};

#endif //__MASTERAUDIOCD_H__
