/* Code to get discid for a cddb query.

  *** Linux Version ***

  $Id: discid.c,v 1.1 2002/12/23 03:09:21 ogre7299 Exp $

  Copyright (c) 1998-2000 Jeremy D. Zawodny <Jeremy@Zawodny.com>

  This software is covered by the GPL.

  Is is based on code found in:

    To: code-review@azure.humbug.org.au 
    Subject: CDDB database reader 
    From: Byron Ellacott <rodent@route-qn.uqnga.org.au> 
    Date: Fri, 5 Jun 1998 17:32:40 +1000 

*/

/* Stripped net code, 'cause I only care about the discid */

#include "discid.h"
Setup setupData;
unsigned int total_time;

struct toc {
    int min, sec, frame;
} cdtoc[100];

int read_toc(void) {
    int drive = open(setupData.readerdev.c_str(), O_RDONLY | O_NONBLOCK);
    struct cdrom_tochdr tochdr;
    struct cdrom_tocentry tocentry;
    int i;

    int cd = ioctl(drive, CDROMREADTOCHDR, &tochdr);
	if (cd == -1)
		return cd;
    for (i = tochdr.cdth_trk0; i <= tochdr.cdth_trk1; i++) {
        tocentry.cdte_track = i;
        tocentry.cdte_format = CDROM_MSF;
        ioctl(drive, CDROMREADTOCENTRY, &tocentry);
        cdtoc[i-1].min = tocentry.cdte_addr.msf.minute;
        cdtoc[i-1].sec = tocentry.cdte_addr.msf.second;
        cdtoc[i-1].frame = tocentry.cdte_addr.msf.frame;
        cdtoc[i-1].frame += cdtoc[i-1].min*60*75;
        cdtoc[i-1].frame += cdtoc[i-1].sec*75;
    }
    tocentry.cdte_track = 0xAA;
    tocentry.cdte_format = CDROM_MSF;
    ioctl(drive, CDROMREADTOCENTRY, &tocentry);
    cdtoc[tochdr.cdth_trk1].min = tocentry.cdte_addr.msf.minute;
    cdtoc[tochdr.cdth_trk1].sec = tocentry.cdte_addr.msf.second;
    cdtoc[tochdr.cdth_trk1].frame = tocentry.cdte_addr.msf.frame;
    cdtoc[tochdr.cdth_trk1].frame += cdtoc[tochdr.cdth_trk1].min*60*75;
    cdtoc[tochdr.cdth_trk1].frame += cdtoc[tochdr.cdth_trk1].sec*75;
    close(drive);
    return tochdr.cdth_trk1;
}

unsigned int cddb_sum(int n) {
    unsigned int ret;

    ret = 0;
    while (n > 0) {
      ret += (n % 10);
      n /= 10;
    }
    return ret;
}

unsigned long cddb_discid(int tot_trks) {
    unsigned int i, t = 0, n = 0;

    i = 0;
    while (i < tot_trks) {
      n = n + cddb_sum((cdtoc[i].min * 60) + cdtoc[i].sec);
      i++;
    }
    t = ((cdtoc[tot_trks].min * 60) + cdtoc[tot_trks].sec) -
      ((cdtoc[0].min * 60) + cdtoc[0].sec);
	total_time = t;
    return ((n % 0xff) << 24 | t << 8 | tot_trks);
}

int get_disc_id(Setup setupData1, _main_data *main_data) {
	setupData = setupData1;
    unsigned long discid;
    int tracks, i;

    tracks = read_toc();
	if (tracks == -1)
		return tracks;
    discid = cddb_discid(tracks);
	sprintf((char *) main_data->discid, "%08x", discid);
//    printf("%08x %d", discid, tracks);
    for (i = 0; i < tracks; i++) 
		main_data->track[ i ].begin = cdtoc[i].frame;
 //   for (i = 0; i < tracks; i++) printf(" %d", cdtoc[i].frame);
 //   printf(" %d\n", (cdtoc[tracks].frame)/75);
	main_data->num_tracks = tracks;
	main_data->total_length = total_time;
}

