#include <string>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include "string2int.h"
#include "craparray.h"
#include "interface.h"
#include "support.h"
#include "copycd.h"
#include "simplecdr.h"
#include "string2int.h"
#include "setup.h"
#include "rip.h"
#include "play.h"
#include "masteraudiocd.h"
#include "masterdatacd.h"
#include "id3.h"
#include "clist_common.h"
#include "datacdops.h"

extern GtkWidget *main_win, *filesel, *working, *new_dir_popup, *progress_win,
  *bad_data, *stdout_window, *burn_conf, *mkisowin, *cdaudwin, *multicopy,
  *copy_options, *copy_cdrdao, *burn_bin_win, *imagewin, *mkisoimagewin;

//Class initialization
extern Setup setupData1;
extern Setupconf setup;
extern String2int convert;
extern RipEncode ripenc;
extern RipType ripping;
extern Play play;
extern Copy copycd;
extern MasterAudioCD master_aud;
extern MasterDataCD master_data;
extern id3Tag id3;

//Enumerated Data Types
extern songType song;
extern imageType image;
extern addType mode;

//Global variables
extern string filename;
extern CrapArray < string > file_array, dir_array, subdir_array;
extern int total_members_dir, total_members_file, total_members_subdir;
extern bool refresh_lists;
extern gint r, r1, col, rowtemp, columntemp;
extern int tracks, total_time_;
extern bool simulate, normalize, onthefly, dao, cdrdao_aud;
int block_size;
using namespace std;

void sub_dir_proc ()
{
  string tmp, command, filename_, subdir, pathtolist, temp_name, find_name;
  
  int i = 1, i_, i2, ii;
  string fname = filename;
  if (total_members_dir == -1)
    total_members_dir += total_members_subdir + 1;
  else
    total_members_dir += total_members_subdir;
  if ( 2000 > total_members_dir)
  {
     if (total_members_dir == 0)
        block_size = 1;
     else
        block_size = total_members_dir;
  }
  else
     block_size=2000;
  for (i2 = 0; i2 <= total_members_dir; i2+=block_size)
  {
     for (ii = i2; ii <= i2 + block_size; ii++)
     {
        if (current_dir == "/")
	{
           ii = total_members_dir - total_members_subdir;
	   break;
	}
        else
           find_name = current_dir.substr (0, current_dir.length () - 1);

      if (ii == total_members_dir - total_members_subdir)
	break;

         if (dir_array[ii] == find_name)	//opens a hole in the array to put in new data so that stuff won't be listed twice
	 {
            int it;
            for (it = total_members_dir; it > ii; it--)	
            {
               dir_array[it] = dir_array[it - total_members_subdir];
            }
            break;
         }
     }//end of inner for
  } //end of main for
 
  string dirtempname = "/tmp/" + convert.randName();
  while (i <= total_members_subdir)
  {  
     ifstream inList;
     // Getting the directory to add to
     tmp = current_dir;

     //Getting the filename to add and adding it
     if (mode == EDIRECTORY_CONTENTS)
     {
          /* char *temp__ =
	    gtk_file_selection_get_filename (GTK_FILE_SELECTION (filesel));
	  filename = temp__;*/
        filename = fname;
     }
     if (mode == EDIRECTORY)
     {
        //const char *temp__=fname.c_str();
        //gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel));
        filename = fname;
	  
        filename = filename.substr (0, filename.length () - 1);
        filename = filename.substr (0, filename.find_last_of ("/") + 1);
        if (tmp == "/")
           tmp = "";
     }
     pathtolist = subdir_array[1];	//for listing purposes
     subdir_array[i] =
     subdir_array[i].substr (filename.length () - 1,subdir_array[i].length ());
     if (current_dir == "/")
	tmp = tmp + subdir_array[i];
     else
	tmp = tmp.substr (0, tmp.length () - 1) + subdir_array[i];

     if (int (tmp.find ("//")) != -1)
        tmp = tmp.substr (1, tmp.length ());
 
     dir_array[++ii] = tmp;
     if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (get_widget (main_win, "hidden_yes"))) == TRUE)
	command = "ls -F1a \"" + pathtolist + "\" > " + dirtempname;
     else
        command = "ls -F1 \"" + pathtolist + "\" > " + dirtempname;

      system(command.c_str());
      inList.open(dirtempname.c_str());
     if (!inList)
	cout << "Error, file cannot be opened Datacdops.c line 155 contact programmer " << dirtempname <<endl;
 
     while (getline (inList, filename_))
     {
        if (int (filename_.find ("/")) != -1 /*|| int(filename_.find(":"))!=-1 */)	//allow filenames that contain colons
        {
	}
        else
        {

	    //Storing in mkisofs pathspec file format
	    if (filename_ != "")
            {
               if (int (filename_.find ("*")) != -1)
                  filename_ = filename_.substr (0, filename_.length () - 1);
               if (int (filename_.find ("@")) > 0)
                  filename_ = filename_.substr (0, filename_.length () - 1);

               total_members_file++;
               file_array[total_members_file] = tmp + "/=" + filename.substr (0, filename.length () - 1) + subdir_array[i] + "/" + filename_;
               //Converting from mkisofs pathspec file format to display format
               //filename_ = file_array[total_members_file].substr(file_array[total_members_file].find ("=") + 1, file_array[total_members_file].length ());
            }
         }
     }    //while statement  close
     inList.close();
     unlink(dirtempname.c_str ());
     if ( 2000 > total_members_subdir)
     {
        if (total_members_subdir == 0)
           block_size = 1;
        else
           block_size = total_members_subdir;
     }  
     else
        block_size=2000;
     for (i2 = 0; i2 < total_members_subdir; i2+=block_size)
     {
        for (i_ = i2; i_ <= i2 + block_size; i_++)
           subdir_array[i_] = subdir_array[i_ + 1];

        if ((i2+block_size) > total_members_subdir && i2 != total_members_subdir)
           block_size = total_members_subdir - i2;
     }
     total_members_subdir--;
   } //end of big while
  total_members_subdir = -1;	//resets sub_dir input
  refresh_list ();
}


void add_directory (string filename)
{
  string tmp, tempdir, command, filename_, temp_name, find_name, dirtempname =
    "/tmp/" + convert.randName ();
  ifstream inList;
  int i, ii;
  //to prevent selection garbage when refreshing
  refresh_lists = false;

  // getting selected path
  tmp = current_dir;

  //Getting the filename to add and adding it
  if (filename.find_last_of ("/") != (filename.length () - 1))
    filename += "/";
  tempdir = filename.substr (0, filename.length () - 1);
  tempdir =
    tempdir.substr (tempdir.find_last_of ("/") + 1, tempdir.length ());
  tmp = tmp + tempdir;

  total_members_dir++;

  if (current_dir != "/")
    {
	if ( 2000 > total_members_dir)
	  block_size = total_members_dir;
  else
	  block_size=2000;
  	for (i = 0; i <= total_members_dir; i+=block_size)
	{
		for (ii = i; ii <= i + block_size; ii++)
      {
	
	  find_name = current_dir.substr (0, current_dir.length () - 1);
	  if (dir_array[ii] == find_name)
	    {
	      int it;
	      for (it = total_members_dir; it > i; it--)
		{
		  dir_array[it] = dir_array[it - 1];
		}

	      dir_array[ii++] = tmp;
	      break;
	    }
		}			//end of for
	  if ((i+block_size) > total_members_dir && i != total_members_dir)
	  block_size = total_members_dir - i;

		}				//end of for
  }				//end of if
  else
    dir_array[total_members_dir] = tmp;

  if (gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON (get_widget (main_win, "hidden_yes"))) == TRUE)
    command = "ls -FR1a \"" + filename + "\" > " + dirtempname;
  else 
    command = "ls -FR1 \"" + filename + "\" > " + dirtempname;

  system (command.c_str ());

  inList.open (dirtempname.c_str ());
  if (!inList)
    cout << "Error, file cannot be opened Line  Datacdops.c 283 Please contact programmer" << endl;

	while (getline(inList, filename_))
	{
       if (int (filename_.find ("/")) != -1
	  && int (filename_.find (":")) != -1)
	{
	  if (int (filename_.find (":")) == (int (filename_.length ()) - 1))
	    {
	      total_members_subdir++;
	      subdir_array[total_members_subdir] =
		filename_.substr (0, filename_.length () - 1);
	    }
	}
      else
	{
	  //Storing in mkisofs pathspec file format
	  if (total_members_subdir < 1 && int (filename_.find ("/")) == -1)
	    {
	      if (filename_ != "")
		{
		  if (int (filename_.find ("*")) != -1)
		    filename_ = filename_.substr (0, filename_.length () - 1);
		  if (int (filename_.find ("@")) > 0)
		    filename_ = filename_.substr (0, filename_.length () - 1);

		  total_members_file++;
		  file_array[total_members_file] =
		    tmp + "/=" + filename + filename_;

		  //Converting from mkisofs pathspec file format to display format
		  filename_ =
		    file_array[total_members_file].
		    substr (file_array[total_members_file].find ("=") + 1,
			    file_array[total_members_file].length ());

		  //gchar *file_entry[2] = { (gchar *) filename_.c_str (), "" };
		  //gtk_clist_append(GTK_CLIST(get_widget(main_win,"data_master_list")),file_entry);
		}		//if
	    }			//if
	}			//if

 }					//while

  inList.close ();
  unlink (dirtempname.c_str ());
  sub_dir_proc ();		//process the subdirectories
  if (filesel)
    gtk_widget_destroy (filesel);
}


void
add_dir_contents (string filename)
{
  string tmp, command, filename_, dirtempname = "/tmp/" + convert.randName ();
  ifstream inList;

  //to prevent selection garbage when refreshing
  refresh_lists = false;

// Getting the directory to add to
  tmp = current_dir;

//Getting the filename to add and adding it
  if (gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON (get_widget (main_win, "hidden_yes"))) == TRUE)
    command = "ls -FR1a \"" + filename + "\" > " + dirtempname;
  else 
    command = "ls -FR1 \"" + filename + "\" > " + dirtempname;

  system (command.c_str ());

  inList.open (dirtempname.c_str ());
  if (!inList)
    cout << "Error, file cannot be opened 358" << endl;

  while (getline (inList, filename_))
    {
      if (int (filename_.find ("/")) != -1
	  && int (filename_.find (":")) != -1)
	{
	  if (int (filename_.find (":")) == (int (filename_.length ()) - 1))
	    {
	      total_members_subdir++;
	      subdir_array[total_members_subdir] =
		filename_.substr (0, filename_.length () - 1);
	    }
	}
      else
	{
	  //Storing in mkisofs pathspec file format
	  if (total_members_subdir < 1 && int (filename_.find ("/")) == -1)
	    {
	      if (filename_ != "")
		{
		  if (int (filename_.find ("*")) != -1)
		    filename_ = filename_.substr (0, filename_.length () - 1);
		  if (int (filename_.find ("@")) != -1)
		    filename_ = filename_.substr (0, filename_.length () - 1);

		  total_members_file++;
		  file_array[total_members_file] =
		    tmp + "=" + filename + filename_;

		  //Converting from mkisofs pathspec file format to display format
		  filename_ =
		    file_array[total_members_file].
		    substr (file_array[total_members_file].find ("=") + 1,
			    file_array[total_members_file].length ());

		  gchar *file_entry[2] = { (gchar *) filename_.c_str (), "" };
		  gtk_clist_append (GTK_CLIST
				    (get_widget
				     (main_win, "data_master_list")),
				    file_entry);
		}
	    }
	}
    }

  inList.close ();
  unlink (dirtempname.c_str ());
  sub_dir_proc ();		//process the subdirectories
  gtk_widget_destroy (filesel);
}



//***********************************

void
add_file (string filename)
{
  string tmp;
  tmp = current_dir;
  if (tmp == "")
    tmp = "/";

//to prevent selection garbage when refreshing
  refresh_lists = false;

//Getting the filename to add and adding it
  total_members_file++;

//Storing in mkisofs pathspec file format
  file_array[total_members_file] = tmp + "=" + filename;

//Converting from mkisofs pathspec file format to display format
  filename =
    file_array[total_members_file].substr (file_array[total_members_file].
					   find ("=") + 1,
					   file_array[total_members_file].
					   length ());
  gchar *file_entry[2] = { (gchar *) filename.c_str (), "" };
  gtk_clist_append (GTK_CLIST (get_widget (main_win, "data_master_list")),
		    file_entry);
}



//***********************************

void
refresh_list()
{
  gchar *temp[2];
  char *temp_;
  string tmp, tmp_curr, last_dir;
  int i = 0;
	int ii = 0;
// Initializing localized lists and clearing file list
  gtk_clist_clear (GTK_CLIST (get_widget (main_win, "data_master_list")));

// getting selected path
  if (refresh_lists == true)
    {
      gtk_clist_get_text (GTK_CLIST
			  (get_widget (main_win, "dir_master_list")), r, 0,
			  &temp[0]);
      (gchar *) temp_ = temp[0];
      tmp = temp_;
      if (tmp != "/" && tmp != "..")
	tmp = current_dir + tmp + "/";
      if (tmp != "..")
	{
	  if (tmp == "")
	    tmp = "/";
	  if (tmp == "/")
	    {
	      current_dir = tmp;
	      tmp = "/=";
	    }
	  else
	    {
	      current_dir = tmp;
	      tmp = tmp + "=";
	    }
	}
      else
	{
	  current_dir = current_dir.substr (0, current_dir.rfind ("/"));
	  tmp = current_dir.substr (0, (current_dir.rfind ("/") + 1));
	  current_dir = tmp;
	}
    }
  else
    tmp = current_dir;
  refresh_lists = true;
  if (tmp == "/")
    tmp = "/=";
  
  gtk_entry_set_text (GTK_ENTRY (get_widget (main_win, "current_directory")),
		      (gchar *) current_dir.c_str ());
  
  if ( 2000 > total_members_file)
	  block_size = total_members_file;
  else
	  block_size=2000;
if (total_members_dir !=-1 || tmp == "/=" && total_members_file > 0)
	for (i = 0; i <= total_members_file; i+=block_size)
	{
		for (ii = i; ii <= i + block_size - 1; ii++)
      {
	if (tmp == "/=" && int (file_array[ii].find (tmp)) == int (file_array[ii].find_first_of ("/")) && int (file_array[ii].find (tmp)) != -1)
	  {
	    filename = 
	      file_array[ii].substr (file_array[ii].find ("=") + 1,
				    file_array[ii].length ());
	    gchar *file_entry[2] = { (gchar *) filename.c_str (), "" };
	    
		 gtk_clist_append (GTK_CLIST
			      (get_widget (main_win, "data_master_list")),
			      file_entry);
	  }
	if (tmp != "/=" && int (file_array[ii].find (current_dir)) != -1
	    && file_array[ii].substr (0,
				     file_array[ii].find ("=")) == current_dir)
	  {
	    filename =
	      file_array[ii].substr (file_array[ii].find ("=") + 1,
				    file_array[ii].length ());
	    
		  gchar *file_entry[2] = { (gchar *) filename.c_str (), "" };
	    gtk_clist_append (GTK_CLIST
			      (get_widget (main_win, "data_master_list")),
			      file_entry);
	  }
  }
  if ((i+block_size) > total_members_file && i != total_members_file)
	  block_size = total_members_file - i;
  if (block_size == 0)
	  block_size = 1;
// refresh bugs out with really low file counts, when it hits one file left it infinitely repeats the one file that is left in the list 
      }

if (total_members_file == 0)
{
	filename = 
	      file_array[0].substr (file_array[0].find ("=") + 1,
				    file_array[0].length ());
	    gchar *file_entry[2] = { (gchar *) filename.c_str (), "" };
	    
		 gtk_clist_append (GTK_CLIST
			      (get_widget (main_win, "data_master_list")),
			      file_entry);
	}
	  
	  //refreshing dir list
  gtk_clist_clear (GTK_CLIST (get_widget (main_win, "dir_master_list")));

  if (tmp != "/=")
    {
      gchar *dir_entry[2] = { "..", "" };
      gtk_clist_append (GTK_CLIST (get_widget (main_win, "dir_master_list")),
			dir_entry);
    }

  tmp_curr = current_dir;
  if (tmp_curr == "/=")
    tmp_curr = tmp_curr.substr (0, 1);
 
  if ( 2000 > total_members_dir)
	  if (total_members_dir == 0)
		  block_size = 1;
	  else
		  block_size = total_members_dir;
  else
	  block_size=2000;
  
  if (total_members_dir != -1)
 	for (i = 0; i <= total_members_dir; i+=block_size)
	{
		for (ii = i; ii <= i + block_size; ii++)
      {
	if (int (dir_array[ii].find (tmp_curr)) != -1)
	  {
	    string temp_directory =
	      dir_array[ii].substr (dir_array[ii].find_first_of (tmp_curr) +
				   tmp_curr.length (),
				   dir_array[ii].length ());
	    if (temp_directory.find ("/") ==
		temp_directory.find_last_of ("/"))
	      {
		temp_directory =
		  temp_directory.substr (0, temp_directory.find ("/"));
		if (temp_directory != last_dir)
		  {
		    gchar *dir_[2] =
		      { (gchar *) temp_directory.c_str (), "" };
		    gtk_clist_append (GTK_CLIST
				      (get_widget
				       (main_win, "dir_master_list")), dir_);
		  }
		last_dir = temp_directory;
	      }
	  }
  }
	  if ((i+block_size) > total_members_dir && i != total_members_dir)
	  block_size = total_members_dir - i;

  }
}

//***********************************

void
cd_image_load_file (string filename)
{
  ifstream imageIn;
  int i;
  imageIn.open (filename.c_str ());

  if (!imageIn)
    {
      cout << "Cannot open file, check permissions" << endl;
      return;
    }

  for (i = 0; getline (imageIn, file_array[i]); i++)
    {
      if (file_array[i] == "----Directories----")
	{
	  file_array[i] = "";
	  total_members_file--;
	  break;
	}
      total_members_file++;
    }

  for (i = 0; getline(imageIn, dir_array[i]); i++)
    total_members_dir++;

  total_members_dir--;

  imageIn.close ();
  gtk_widget_destroy (filesel);

//Adding directories to list
  refresh_lists = false;
  refresh_list ();
}

//***********************************

void
cd_image_save_file (string filename)
{
  int i;
  ofstream imageOut;

  imageOut.open (filename.c_str ());
  if (!imageOut)
    {
      cout << "Cannot open file, check permissions" << endl;
      return;
    }
  for (i = 0; i <= total_members_file; i++)
    {
      if (file_array[i] != "")
	imageOut << file_array[i] << "\n";
    }

  imageOut << "----Directories----"<< "\n";

  for (i = 0; i <= total_members_dir; i++)
    {
      if (dir_array[i] != "")
	imageOut << dir_array[i] << "\n";
    }

  imageOut.close ();
  gtk_widget_destroy (filesel);
}


//*************************

void mode_selection()
{
  stdout_window = create_stdout_window();
  gtk_widget_show(stdout_window);

	if (mode == ECREATE_IMG)
    {
	gtk_widget_destroy (filesel);
		multiType multises;
      char image_type[20];
      string image_t, pathspec = "/tmp/" + convert.randName ();
      strcpy (image_type,
	      gtk_entry_get_text (GTK_ENTRY
				  (get_widget (mkisoimagewin, "mkisoimage_entry"))));

	gtk_widget_destroy (mkisoimagewin);
	multises=SINGLE; 
	
      if (image_t == "Rockridge+Joliet")
	image = ROCKNJOL;
      if (image_t == "Joliet")
	image = JOLIET;
      if (image_t == "Rockridge")
	image = ROCKRIDGE;
       int i;
      if (total_members_file == -1)
	{
	  bad_data_show ();
	  return;
	}

      ofstream mkisofsOut;
      mkisofsOut.open (pathspec.c_str ());

      for (i = 0; i <= total_members_file; i++)
	{
	  if (file_array[i] != "")
	    mkisofsOut << file_array[i] << "\n";
	}

      mkisofsOut.close ();
      master_data.createImage (multises, image, setupData1, pathspec, filename);
      unlink (pathspec.c_str ());
       
}

	if (mode == EBURN_MASTERDATA)
    {
      multiType multises;
      gboolean overbrn;
	  bool overburn;
	  char image_type[20];
      string image_t, pathspec = "/tmp/" + convert.randName ();
      strcpy (image_type,
	      gtk_entry_get_text (GTK_ENTRY
				  (get_widget (mkisowin, "mkisofs_entry"))));

      if (gtk_toggle_button_get_active
	  (GTK_TOGGLE_BUTTON (get_widget (mkisowin, "multisession3"))) ==
	  TRUE)
	multises = SINGLE;
      else
	if (gtk_toggle_button_get_active
	    (GTK_TOGGLE_BUTTON (get_widget (mkisowin, "multisession1"))) ==
	    TRUE)
	multises = FIRST;
      else
	if (gtk_toggle_button_get_active
	    (GTK_TOGGLE_BUTTON (get_widget (mkisowin, "multisession2"))) ==
	    TRUE)
	multises = SECOND;

      image_t = image_type;
      if (multises == SINGLE && image_t == "Rockridge+Joliet")
	image = ROCKNJOL;
      if (multises == SINGLE && image_t == "Joliet")
	image = JOLIET;
      if (multises == SINGLE && image_t == "Rockridge")
	image = ROCKRIDGE;
      if (multises != SINGLE)
	image = ROCKRIDGE;
      int i;
      if (total_members_file == -1)
	{
	  bad_data_show ();
	  gtk_widget_destroy(mkisowin);
	  gtk_widget_destroy(stdout_window);
	  return;
	}

      ofstream mkisofsOut;
      mkisofsOut.open (pathspec.c_str ());

      for (i = 0; i <= total_members_file; i++)
	{
	  if (file_array[i] != "")
	    mkisofsOut << file_array[i] << "\n";
	}
	overbrn = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(get_widget(mkisowin, "data_overburn_button")));
     if (overbrn == TRUE)
		overburn = true;
      else
		overburn = false;

      mkisofsOut.close ();
      gtk_widget_destroy (mkisowin);
      master_data.writeImage (multises, image, simulate, overburn, setupData1,
			      pathspec);
      unlink (pathspec.c_str ());
      multises = SINGLE;	//resetting session to single for default value
    }

  if (mode == EBURN_MASTERAUDIO)
    {
      int count = 1, cont;
      gchar *temp[2];
      gboolean overbrn;
      char *temp_;
      bool overburn;
      string tmp, dirname = convert.randName ();
      dirname = setupData1.tempdiraudio + "/" + dirname;
      mkdir (dirname.c_str (), 0755);
      overbrn =
	gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				      (get_widget
				       (cdaudwin, "overburn_button")));

      if (overbrn == TRUE)
	overburn = true;
      else
	overburn = false;

      while (count < tracks)
	{
	  r = count - 1;
	  gtk_clist_get_text (GTK_CLIST (get_widget (main_win, "audio_list")),
			      r, 0, &temp[0]);
	  (gchar *) temp_ = temp[0];
	  tmp = temp_;
	  cont =
	    master_aud.convertTracklist (count, tracks, tmp, setupData1,
					 dirname);
	  if (cont == 1)
	    break;

	  count++;
	}
      if (cont != 1)
	master_aud.writeAudioCD (tracks, simulate, normalize, dao, cdrdao_aud,
				 overburn, setupData1, dirname);

      gtk_widget_destroy (cdaudwin);
      dao = false;
    }

  if (mode == EBURN_CDRDAOCOPY)
    {
      copycd.copyDataCD1 (simulate, onthefly, setupData1);
      onthefly = false;
      gtk_widget_destroy (copy_cdrdao);
    }

  if (mode == EBURN_MKISOFSCOPY)
    {
      copycd.copyDataCD2 (simulate, setupData1);
      gtk_widget_destroy (copy_options);
    }

  if (mode == EBURN_AUDIOCOPYSAMEDEV)
    {
      copycd.copyAudioCDsameDev (simulate, setupData1, filename);
      gtk_widget_destroy (copy_options);
      rmdir (filename.c_str ());
    }

  if (mode == EBURN_AUDIOCOPY)
    {
      string dirname = setupData1.tempdiraudio + "/" + convert.randName ();
      mkdir (dirname.c_str (), 0755);
      if (copycd.copyAudioCD (simulate, setupData1, dirname) == 1)
	{
	  filename = dirname;
	  mode = EBURN_AUDIOCOPYSAMEDEV;
	  multicopy = create_copy_same_dev ();
	  gtk_widget_show (multicopy);
	}
      else
	{
	  gtk_widget_destroy (copy_options);
	  rmdir (dirname.c_str ());
	}
    }

  if (mode == EBURN_ISO)
    {
      copycd.writeISO (simulate, filename, setupData1);
      gtk_widget_destroy (copy_options);
    }
  if (mode == EBURN_BIN)
    {
      bool overburn;
      gboolean overbrn;
      char filen[300], image_type[20], track_type[20];
      string filename_, img_type, trk_type, toc_file;
      overbrn =
	gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
				      (get_widget
				       (burn_bin_win, "overburn_button")));
      if (overbrn == TRUE)
	overburn = true;
      else
	overburn = false;
      strcpy (image_type,
	      gtk_entry_get_text (GTK_ENTRY
				  (get_widget
				   (burn_bin_win, "bin_image_entry"))));
      strcpy (track_type,
	      gtk_entry_get_text (GTK_ENTRY
				  (get_widget
				   (burn_bin_win, "bin_track_entry"))));
		strcpy (filen,
	      gtk_entry_get_text (GTK_ENTRY
				  (get_widget
				   (burn_bin_win, "toc_cue_entry"))));
      img_type = image_type;
      trk_type = track_type;
		toc_file = filen;
      gtk_widget_destroy (burn_bin_win);
      copycd.writeBIN (simulate, overburn, filename, img_type, trk_type, toc_file, setupData1);
    }
//resets simulate button to off

  if (mode != EBURN_AUDIOCOPYSAMEDEV)
    {
      progress_show ();
      simulate = false;
    }
   gtk_widget_destroy (stdout_window);
}
 
 //***********************
 
 void remove_all()
{
	 file_array.clear ();
  total_members_file = -1;

  dir_array.clear ();
  total_members_dir = -1;

  subdir_array.clear ();
  total_members_subdir = -1;

  current_dir = "/";

  refresh_lists = false;
  refresh_list ();

  master_data.removeImage (setupData1);
}

//*******************************

void remove_dir()
{  
	gchar *temp_dir[2];
  char *temp__;
  string tmp_file, tmp_dir, tmp;
  int i;
  if (total_members_dir == -1)
    return;
// Initializing localized lists and clearing file list
  gtk_clist_get_text (GTK_CLIST (get_widget (main_win, "dir_master_list")),
		      rowtemp, 0, &temp_dir[0]);
  (gchar *) temp__ = temp_dir[0];

  tmp_dir = temp__;
  if (tmp_dir == "/")
    return;
  else
    tmp = current_dir + tmp_dir;


/*finds the array member with the matching filename and overwrites it by moving 	
all the array members up one level to fill in any gaps*/
  if (tmp != "" || rowtemp == -1)
    {
      if (0 == total_members_dir)
	{
	  dir_array.clear ();
	  total_members_dir = -1;
	}
      else
	{
	  for (i = 0; i <= total_members_dir; i++)
	    {
	      if (dir_array[i] == tmp)
		{
		  //dir_array.Remove(i, total_members_dir);
		  dir_array[i] = "";

		  break;
		}
	    }
	  tmp += "/";

	  for (i = 0; i <= total_members_dir; i++)
	    {
	      if (int (dir_array[i].find (tmp)) != -1)
		{
		  //dir_array.Remove(i, total_members_dir);
		  dir_array[i] = "";

		}
	    }
	}
      for (i = 0; i <= total_members_file; i++)
	{
	  string tmp_ = tmp.substr (0, tmp.length () - 1) + "=";

	  if (int (file_array[i].find (tmp_)) != -1
	      || int (file_array[i].find (tmp)) != -1)
	    {
	      //file_array.Remove(i, total_members_file);
	      file_array[i] = "";

	    }
	}
    }
  rowtemp = -1;
  refresh_lists = false;
  refresh_list ();
}
	
