#include "craparray.h"

template < class T > CrapArray < T >::CrapArray (int sz)
{
	size = sz;
	array = new T[size];
};

template < class T > CrapArray < T >::CrapArray ()
{
	array = 0;
	size = 0;
};

template < class T > CrapArray < T >::~CrapArray ()
{
	delete[]array;
};

template < class T >
	CrapArray < T > &CrapArray < T >::operator =
	(CrapArray < T > &origVal)
{

	size = origVal.size;
	delete[]array;
	if (size)
	{
		array = new T[size];
	}
	else
		array = 0;
	if (size != 0 || origVal.size != 0)
	{
		for (int i = 0; i <= size; i++)
			array[i] = origVal.array[i];
	}

	return *this;
};

template < class T > T & CrapArray < T >::operator[](int index)
{
	if (index >= size)
		Resize (index);
	return array[index];
};

template < class T > void CrapArray < T >::Resize (int index)
{
	T *temp;
	int newsize;
	if (index < (2 * size))
	{
		newsize = size * 2;
	}
	else
		newsize = index + 1000;
	temp = new T[newsize];
	for (int i = 0; i < size; i++)
	{
		temp[i] = array[i];
	};
	delete[]array;
	array = temp;
	size = newsize;
};

template < class T > void CrapArray < T >::clear ()
{
	if (array)
		delete[]array;
	size = 0;
	array = 0;
};

template < class T > void CrapArray < T >::Remove (int index, int total_size)
{
	T *temp;
	total_size += 1;
	temp = new T[total_size - 1];
	int i;
	if (total_size > 0 && index != total_size)
	{
		for (i = 0; i < index; i++)
		{
			temp[i] = array[i];
		}
		if (index != total_size)
			for (i = index; i < (total_size - 1); i++)
			{
				temp[i] = array[1 + i];
			}

		delete[]array;
		array = temp;
		size = total_size - 1;
	}
};
