#include "windows.h"
#include "stdafx.h"
#include "resource.h"
#include <hash_map>
#include "GrClient.h"
#include "ITextSource.h"
#include "SimpleTextSrc.h"
#include "JtaTextSrc.h"
#include "IGrEngine.h"
#include "IGrJustifier.h"
#include "GrJustifier.h"
#include "SegmentAux.h"
#include "Font.h"
#include "WinFont.h"
#include "Segment.h"
#include "SegmentPainter.h"
#include "WinSegmentPainter.h"

// for clipboard
#include <objidl.h>

#define MAX_LOADSTRING 100
#define TOPMARGIN 10

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// The main windows class name

#define NUMSEGMENTS 15

// keep this data between events
// note that dc should not be kept between events
LOGFONT g_vlf[NUMSEGMENTS];
unsigned short g_szFaceName[32];
bool g_fBold;
bool g_fItalic;

GrJustifier g_gjus;

bool g_fColors;

////bool g_fEngErrMsg; // give couldn't-init-engine message?

JtaTextSrc * g_vpgrtext[NUMSEGMENTS];
int g_vptSizes[NUMSEGMENTS];
Segment * g_vpgrseg[NUMSEGMENTS];
int g_vdyOffsets[NUMSEGMENTS];

////int g_dxWidth; // width of resulting segment
////LgEndSegmentType g_est; // why the segment was ended

int g_ichwAnchor;	// insertion point index or anchor
int g_ichwEnd;		// end of range; == g_ichwAnchor if no range
bool g_bAssocPrev;

unsigned short g_szString[256];

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
void				GrInitialize(void);
void				CreateSegment(HWND hWnd, HDC hdc, WinFont & font, int iseg, bool fSecondTry);
///void				GrfxInit(HDC hdc, GrGraphics & grfx);
void				ResetStringAndSegment();

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	GrInitialize();
	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_JUSTTESTAPP, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_JUSTTESTAPP);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//  FUNCTION: MyRegisterClass()
//  PURPOSE: Registers the window class.
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_JUSTTESTAPP);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCTSTR)IDC_JUSTTESTAPP;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;
	WINDOWPLACEMENT wp;

	hInst = hInstance; // Store instance handle in our global variable

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
		return FALSE;
	}

	// put window in a convenient place on screen
	wp.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(hWnd, &wp); // fill in members not expicilty set below
	wp.rcNormalPosition.left = MulDiv(GetSystemMetrics(SM_CXSCREEN), 1, 4);
	wp.rcNormalPosition.right = MulDiv(GetSystemMetrics(SM_CXSCREEN), 3, 4);
	wp.rcNormalPosition.top = MulDiv(GetSystemMetrics(SM_CYSCREEN), 1, 4);
	wp.rcNormalPosition.bottom = MulDiv(GetSystemMetrics(SM_CYSCREEN), 3, 4);
	SetWindowPlacement(hWnd, &wp);

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	TCHAR szSimple[MAX_LOADSTRING];
	LoadString(hInst, IDS_SIMPLE, szSimple, MAX_LOADSTRING);

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_ABOUT:
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
					break;
				case IDM_EXIT:
					DestroyWindow(hWnd);
					break;
				default:
					return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;

		case WM_PAINT:
			{
			hdc = BeginPaint(hWnd, &ps);

			for (int iseg = 0; iseg < NUMSEGMENTS; iseg++)
			{
				HFONT hfont = CreateFontIndirect(&g_vlf[iseg]);
				HFONT hfontOld = (HFONT)::SelectObject(hdc, hfont); // reset the DC for the current size
				// delete hfontOld??
				WinFont font(hdc);

				if (g_vpgrseg[iseg] == NULL)
				{
					CreateSegment(hWnd, hdc, font, iseg, false);
				}

				WinSegmentPainter painter(g_vpgrseg[iseg], hdc);
				painter.setOrigin(TOPMARGIN, (float)(g_vdyOffsets[iseg] + TOPMARGIN));
				painter.paint();

				if (g_ichwAnchor == g_ichwEnd)
				{
					painter.drawInsertionPoint(g_ichwAnchor, g_bAssocPrev, true, false);
				}
				else
				{
					float fontHeight = font.height();
					float top = g_vdyOffsets[iseg] + float(TOPMARGIN);
					if (g_ichwAnchor >= g_ichwEnd) // todo: is this needed?
						painter.drawSelectionRange(g_ichwEnd, g_ichwAnchor,
							top, top+fontHeight, true);
					else
						painter.drawSelectionRange(g_ichwAnchor, g_ichwEnd,
							top, top+fontHeight, true);
				}

				//	if (g_vpgrseg[iseg])
				//		delete g_vpgrseg[iseg];
				//	g_vpgrseg[iseg] = NULL;
			}

			EndPaint(hWnd, &ps); //cleans up dc
			break;
			}

		case WM_KEYDOWN:
			{
			hdc = GetDC(hWnd);
			HFONT hfont = CreateFontIndirect(&g_vlf[0]);
			HFONT hfontOld = (HFONT)::SelectObject(hdc, hfont);
			// delete hfontOld??
			WinFont font(hdc);
			WinSegmentPainter painter(g_vpgrseg[0], hdc);

			SHORT shiftstate;
			shiftstate = GetKeyState(VK_SHIFT);
			bool bShift = (bool) (shiftstate & 0x8000);
			shiftstate = GetKeyState(VK_CONTROL);
			bool bCtl = (bool) (shiftstate & 0x8000);
			bool bInThisSeg;

			switch(wParam)
			{
				bool bRight;
				int oldEnd;
				bInThisSeg = true;

				case VK_LEFT: // left & right arrow keys
				case VK_RIGHT:
					bRight = (wParam == VK_RIGHT);
					if (!bCtl) // no control key: visual movement
					{
						if (bShift)
						{
							bool bAssocPrev = (g_ichwAnchor == g_ichwEnd) ?
								bRight :
								(g_ichwEnd < g_ichwAnchor);
							g_ichwEnd = painter.extendSelectionPosition(g_ichwEnd, g_ichwEnd != 0,
								bAssocPrev, g_ichwAnchor, bRight, &bInThisSeg);
						}
						else
							g_ichwEnd = painter.arrowKeyPosition(g_ichwEnd, &g_bAssocPrev,
								bRight, &bInThisSeg);
					}
					else // control key: logical movement
					{
						oldEnd = g_ichwEnd;
						bRight ? ++g_ichwEnd : --g_ichwEnd;
						if (!painter.isValidInsertionPoint(g_ichwEnd))
							g_ichwEnd = oldEnd;
						if (g_ichwEnd == 0)
							g_bAssocPrev = false;
					}

					if (!bShift)
						g_ichwAnchor = g_ichwEnd; // insertion point, not range

					InvalidateRect(hWnd, NULL, true);
					break;
				default:
					break;
			}

			ReleaseDC(hWnd, hdc);
			break;
			}
		case WM_CHAR:
			{
			SHORT shiftstate;
			shiftstate = GetKeyState(VK_SHIFT);
			bool bShift = (bool) (shiftstate & 0x8000);
			shiftstate = GetKeyState(VK_CONTROL);
			bool bCtl = (bool) (shiftstate & 0x8000);

			if (bCtl && wParam == 16) // CTRL-p
			{
				IDataObject * pdobj;
				::OleGetClipboard(&pdobj);
				pdobj->AddRef();

				// if there is a UNICODE string stored in the clipboard, paste it in.
				FORMATETC format;
				STGMEDIUM medium;
				format.cfFormat = CF_UNICODETEXT;
				format.ptd = NULL;
				format.dwAspect = DVASPECT_CONTENT;
				format.lindex = -1;
				format.tymed = TYMED_HGLOBAL;
				HRESULT hr = pdobj->GetData(&format, &medium);
				if (hr == S_OK)
				{
					if (medium.tymed == TYMED_HGLOBAL && medium.hGlobal)
					{
						// Convert the global memory string to a TsString without any formatting.
						const OLECHAR * pwszClip = (const OLECHAR *)::GlobalLock(medium.hGlobal);
						int cchw = wcslen(pwszClip);
						std::fill_n(g_szString, 255, 0);
						if (cchw > 255)
							std::copy(pwszClip, pwszClip + 255, g_szString);
						else
							wcscpy(g_szString, pwszClip);
						::GlobalUnlock(medium.hGlobal);

						ResetStringAndSegment();
						g_ichwAnchor = 0;
						g_ichwEnd = 0;
						InvalidateRect(hWnd, NULL, true);
					}
					ReleaseStgMedium(&medium);
				}
				else
					::MessageBox(hWnd, L"Paste operation failed.", L"Error", MB_OK | MB_ICONEXCLAMATION);
				pdobj->Release();
			}
			else if (bCtl && wParam == 6) // CTRL-f
			{
				//HDC hdc;
				CHOOSEFONT cf;
				static LOGFONT lf;
				LPCWSTR lpstr = lf.lfFaceName;
				wcscpy(lf.lfFaceName, g_szFaceName);
				//Platform_UnicodeToANSI(g_szFaceName, -1, lf.lfFaceName, 32);
				lf.lfHeight = -12;
				lf.lfWeight = (g_fBold) ? 700 : 400;
				lf.lfItalic = g_fItalic;

				// Initialize CHOOSEFONT
				ZeroMemory(&cf, sizeof(CHOOSEFONT));
				cf.lStructSize = sizeof(CHOOSEFONT);
				cf.hwndOwner = hWnd;
				cf.lpLogFont = &lf;
				cf.Flags = CF_SCREENFONTS | CF_TTONLY | CF_INITTOLOGFONTSTRUCT ;

				if (ChooseFont(&cf) == TRUE)
				{
					////Platform_UnicodeToANSI(g_szFaceName, -1, lf.lfFaceName, 32);
					wcscpy(g_szFaceName, lf.lfFaceName);
					for (int iseg = 0; iseg < NUMSEGMENTS; iseg++)
                        wcscpy(g_vlf[iseg].lfFaceName, lf.lfFaceName);
					g_fBold = (lf.lfWeight >= 550);
					g_fItalic = (lf.lfItalic == TRUE);
					ResetStringAndSegment();
					InvalidateRect(hWnd, NULL, true);
				}
			}
			else if (bCtl && wParam == 3) // CTRL-c
			{
				g_fColors = !g_fColors;
				ResetStringAndSegment();
				InvalidateRect(hWnd, NULL, true);
			}
			else if (bCtl)
			{
				::MessageBox(hWnd, L"The following options are available:\n   CTRL-p to paste\n   CTRL-f to choose font\n   CTRL-c to toggle color",
					L"Justification Tester App", MB_OK | MB_ICONEXCLAMATION);
			}

			break;
			}

		case WM_LBUTTONDOWN: // left mouse button
			{
			hdc = GetDC(hWnd);

			SHORT shiftstate;
			shiftstate = GetKeyState(VK_SHIFT);
			bool bShift = (bool) (shiftstate & 0x8000);

			POINT pt;
			pt.x = lParam & 0x0000FFFF;
			pt.y = lParam >> 16;

			int iseg;
			for (iseg = 0; iseg < NUMSEGMENTS - 1; iseg++)
			{
				if (pt.y < g_vdyOffsets[iseg + 1] + TOPMARGIN)
					break;
			}

			HFONT hfont = CreateFontIndirect(&g_vlf[iseg]);
			HFONT hfontOld = (HFONT)::SelectObject(hdc, hfont);
			// delete hfontOld??
			WinFont font(hdc);
			WinSegmentPainter painter(g_vpgrseg[iseg], hdc);
			painter.pointToChar(pt, &g_ichwEnd, &g_bAssocPrev);

			if (!bShift)
				g_ichwAnchor = g_ichwEnd;

			InvalidateRect(hWnd, NULL, true);
			ReleaseDC(hWnd, hdc);
			break;
			}

		case WM_SIZE:
			// Resizing the window.
			ResetStringAndSegment();
			InvalidateRect(hWnd, NULL, true);
			break;

		case WM_DESTROY:
			{ for (int iseg = 0; iseg < NUMSEGMENTS; iseg++)
			{
				if (g_vpgrseg[iseg])
					delete g_vpgrseg[iseg];
				if (g_vpgrtext[iseg])
					delete g_vpgrtext[iseg];
			} }
			PostQuitMessage(0);
			break;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

void CreateSegment(HWND hWnd, HDC hdc, WinFont & font, int iseg, bool fSecondTry)
{
	WINDOWPLACEMENT wp;
	wp.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(hWnd, &wp); // fill in members not expicitly set below
	int dxWindowWidth = wp.rcNormalPosition.right - wp.rcNormalPosition.left - (TOPMARGIN * 2);

	if (fSecondTry)
	{
		// caller set color
	}
	else
		g_vpgrtext[iseg]->setColor(RGB(0,0,0)); // black

	// Create the segment.
	LayoutEnvironment layout;
	layout.setDumbFallback(true);
	layout.setJustifier(&g_gjus);
	Segment * psegTemp = new RangeSegment(&font, g_vpgrtext[iseg], &layout);
	int dxNaturalWidth = (int)psegTemp->advanceWidth();
	if (psegTemp == NULL)
	{
		MessageBox(hWnd, L"Could not create segment", L"", MB_OK);
		return;
	}

	Font & fontCopy = psegTemp->getFont();
	WinFont * pfontWin = dynamic_cast<WinFont*>(&fontCopy);
	pfontWin->replaceDC(hdc);
	g_vpgrseg[iseg] = Segment::JustifiedSegment(*psegTemp, (float)dxWindowWidth);
	pfontWin->restoreDC();
	int dxJustifiedWidth = (int)g_vpgrseg[iseg]->advanceWidth();

	delete psegTemp;

	if (!fSecondTry && g_fColors)
	{
		if (dxJustifiedWidth != dxWindowWidth)
		{
			// Color failed segments red.
			delete g_vpgrseg[iseg];
			g_vpgrseg[iseg] = NULL;
			g_vpgrtext[iseg]->setColor(RGB(255,0,0)); // red
			CreateSegment(hWnd, hdc, font, iseg, true);
		}
		else if (dxNaturalWidth > dxJustifiedWidth)
		{
			// Color shrunk segments blue.
			delete g_vpgrseg[iseg];
			g_vpgrseg[iseg] = NULL;
			g_vpgrtext[iseg]->setColor(RGB(0,0,255)); // blue
			CreateSegment(hWnd, hdc, font, iseg, true);
		}
		else if (dxNaturalWidth == dxJustifiedWidth)
		{
			// Color segments that fix exactly green.
			delete g_vpgrseg[iseg];
			g_vpgrseg[iseg] = NULL;
			g_vpgrtext[iseg]->setColor(RGB(0,180,0)); // green
			CreateSegment(hWnd, hdc, font, iseg, true);
		}
		// segments that were adjusted successfully remain black
	}
}

void GrInitialize (void)
{
	OLECHAR * sz = L"The quiick broown foox juumps over the laazy doog.|";
	wcscpy(g_szString, sz);
	g_szString[wcslen(sz)] = 0;

	// List of sizes to try
	int firstPtSize = 9;

	int iseg;

	g_vptSizes[0] = firstPtSize;
	for (iseg = 1; iseg < NUMSEGMENTS; iseg++)
	{
		switch (g_vptSizes[iseg - 1])
		{
		case  7:	g_vptSizes[iseg] =  8; break;
		case  8:	g_vptSizes[iseg] =  9; break;
		case  9:	g_vptSizes[iseg] = 10; break;
		case 10:	g_vptSizes[iseg] = 11; break;
		case 11:	g_vptSizes[iseg] = 12; break;
		case 12:	g_vptSizes[iseg] = 13; break;
		case 13:	g_vptSizes[iseg] = 14; break;
		case 14:	g_vptSizes[iseg] = 16; break;
		case 16:	g_vptSizes[iseg] = 18; break;
		case 18:	g_vptSizes[iseg] = 20; break;
		case 20:	g_vptSizes[iseg] = 24; break;
		case 24:	g_vptSizes[iseg] = 28; break;
		case 28:	g_vptSizes[iseg] = 32; break;
		case 32:	g_vptSizes[iseg] = 40; break;
		case 40:	g_vptSizes[iseg] = 48; break;
		case 48:	g_vptSizes[iseg] = 64; break;
		case 64:	g_vptSizes[iseg] = 72; break;
		default:	g_vptSizes[iseg] = g_vptSizes[iseg - 1] + 10; break;
		}
	}
	wcscpy(g_szFaceName, L"Doulos Justification Test");

	g_vdyOffsets[0] = 0;
	for (iseg = 0; iseg < NUMSEGMENTS; iseg++)
	{
		g_vdyOffsets[iseg] = g_vdyOffsets[iseg - 1] +  (g_vptSizes[iseg - 1]) * 2;

		memset(&g_vlf[iseg], '\0', sizeof(LOGFONT));
		g_vlf[iseg].lfCharSet = DEFAULT_CHARSET;
		g_vlf[iseg].lfHeight = (g_vptSizes[iseg] * -1);
		g_vlf[iseg].lfWeight = 400;
		g_vlf[iseg].lfItalic = FALSE;
		wcscpy(g_vlf[iseg].lfFaceName, g_szFaceName);

        g_vpgrtext[iseg] = new JtaTextSrc(g_szString);	// need copies of these because they vary by color
        g_vpgrseg[iseg] = NULL;
	}

	///g_dxWidth = -1;
	///g_est = kestNoMore;

	g_ichwAnchor = 0;
	g_ichwEnd = 0;
	g_bAssocPrev = false;

	g_fColors = true;
	/////g_fEngErrMsg = true;
}


// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
	return FALSE;
}

void ResetStringAndSegment()
{
	for (int iseg = 0; iseg < NUMSEGMENTS; iseg++)
	{
		if (g_vpgrseg[iseg])
			delete g_vpgrseg[iseg];
		g_vpgrseg[iseg] = NULL;

		if (g_vpgrtext[iseg])
			delete g_vpgrtext[iseg];

		///g_lgchrp.dympHeight = g_vptSizes[iseg];
		g_vpgrtext[iseg] = new JtaTextSrc(g_szString);
	}
	////g_fEngErrMsg = true;
}