
/***************************************************************************
                          imagelistview.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _IMAGELISTVIEW_H_
#define _IMAGELISTVIEW_H_

#include <kfileiconview.h>
#include <ktrader.h>

#include <qtooltip.h>

#include "describe.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "digikamplugins/albumitemhandler.h"
namespace Digikam
{
class AlbumItemHandler;
}


class FileIconItem;
class MainWindow;
class ImageLoader;
class ImageListView;

class KProcess;
class KPopupMenu;
class KFileViewItem;
class KAction;
class KIconEffect;

class QListViewItem;
class QIconViewItem;

class KToolTip : public QToolTip
{
public:
	KToolTip(QWidget *parent, ImageListView *imageList);
	virtual ~KToolTip(){};

	void maybeTip(const QPoint &pos);
	void tip ( const QRect & r, const QString & text );

private:
	ImageListView *imageList;
};



class ImageListView :	public KIconView,
			public Digikam::AlbumItemHandler
{
	Q_OBJECT
public:
	ImageListView (QWidget * parent, const char *name, MainWindow * mw);

	void initMenu(KActionCollection *actionCollection);

	void mousePress (QMouseEvent * e);
	void contentsMouseReleaseEvent ( QMouseEvent * e );
	void contentsMousePressEvent ( QMouseEvent * e );
	void contentsMouseDoubleClickEvent ( QMouseEvent * e );

	virtual void setItemTextPos ( ItemTextPos pos );

	bool doPreload();
	void setPreload(bool p);

	bool doLoop();
	void setLoop(bool loop);

	bool doRandom();
	void setRandom(bool ran);

	bool checkTrash();
	void setCheckTrash(bool trash);
	bool checkDelete();
	void setCheckDelete(bool del);
	bool checkShred();
	void setCheckShred(bool shred);

	bool showMeta();
	void setShowMeta(bool sMeta);
	bool showHexa();
	void setShowHexa(bool sHexa);
	/**
		return true if it have to show ALL files
	*/
	void setPreloadIm(bool prel);
	bool preloadIm();


	FileIconItem* firstItem ();
	FileIconItem* currentItem();
	FileIconItem* lastItem();
	FileIconItem* findItem (const QString & text, bool fullname=false);
	FileIconItem* itemAt(QPoint pos);

	void refresh ();
	void stopLoading ();
	void setThumbnailSize(QSize newSize, bool refresh=true);

	void sort();
	
	KPopupMenu* popupOpenWith();

	QString currentItemName();
	void setCurrentItemName(QString itemName, bool select=true);
	bool hasImages();
	bool hasImageSelected();
	bool hasOnlyOneImageSelected();
	int countSelected();
	FileIconItem* firstSelected();

	bool inFullScreen;
	bool preview;
	ImageLoader * il;
	int currentIconSize;
	
	/** functions for Digikam::AlbumItemHandler*/
	QStringList allItems();
	QStringList selectedItems();
	QStringList allItemsPath();
	QStringList selectedItemsPath();
	void refreshItems(const QStringList& itemList);
	
signals:
	void loadFinish();

protected:
	int sortMode;
	
	QDragObject* dragObject();
	void leaveEvent (QEvent *e) ;

protected slots:
	void deletionDone( KIO::Job *);
	void highlight(QIconViewItem *item);
	void onViewport();
	void slotDescribeClose();

	void popup(QIconViewItem *item, const QPoint &point);
	void slotRun(int id);

public slots:
	void slotByName();
	void slotByExtension();
	void slotBySize();
	void slotByDate();

	void slotWallpaper ();
	void slotKhexedit ();
	void slotGimp ();
	void slotEndGimp (KProcess *proc);

	void slotSupprimmer ();
	void slotMoveToTrash();
	void slotShred();

	void slotFilesMoveTo();
	void slotFilesCopyTo();

	void slotFileProperty();
	void slotImageProperty();
	void slotImageInfo();

	void next ();
	void previous ();
	void first ();
	void last ();

	void slotOpenWith();
	void slotRename();

	void slotSetPixmap (const QPixmap pm);

	void slotLoadFirst ();
	void slotLoadFirst(FileIconItem *item);
	void slotLoadNext ();
	void slotResetThumbnail();

	void slotInvertSelection();
	void slotUnselectAll();
	void slotSelectAll();
	virtual void slotUpdate ();

	void selectionChanged();
	
private:
	bool trash, del, shred;
	QPixmap *currentIconItem;
	QString currentIconItemName;
	QIconViewItem *curIt;
	KIconEffect *iconEffect;
	
	QString lastDestDir;

	Describe *dscr;

	int nbrTh;

	bool loop; //loop icons
	bool p; //preload
	bool random; //random
	bool __preload__;

	bool __sMeta__, __sHexa__;

	MainWindow *mw;
	
	FileIconItem *imageLoading;
	bool isLoadingThumbnail;

	KPopupMenu *m_popup, *m_popupEmpty, *m_popup_openWith ;
	KTrader::OfferList m_offerList;
	KActionCollection *actionCollection;

	KToolTip *toolTips;

  bool mouseIsPressed;
};
#endif
