/***************************************************************************
                         history_action.h  -  description
                             -------------------
    begin                : 2000
    copyright            : (C) 2000 by Simon Hausmann 
    email                : hausmann@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __HISTORY_ACTION_H__
#define __HISTORY_ACTION_H__

#include <kaction.h>

#include <qptrlist.h>

class QPopupMenu;

struct HistoryEntry
{
  QString filePath;
};

typedef QPtrList<HistoryEntry> HistoryEntryList;

class HistoryAction : public KAction
{
Q_OBJECT

public:
	HistoryAction( const QString& text, const QString& icon, int accel, 
		      const QObject* receiver, const char* slot, QObject* parent, const char* name = 0 );
	              
	virtual ~HistoryAction();

	virtual int plug( QWidget *widget, int index = -1 );
	virtual void unplug( QWidget *widget );

	static void fillHistoryPopup( const HistoryEntryList& history,
				      QPopupMenu * popup,
				      bool onlyBack = false,
				      bool onlyForward = false,
				      uint startPos = 0 );

	virtual void setEnabled( bool b );
	virtual void setIconSet( const QIconSet& iconSet );

	QPopupMenu *popupMenu();

signals:
	void activated( int );

private:
	QPopupMenu *m_popup;
};

#endif
