/***************************************************************************
                          fileiconitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fileiconitem.h"


#include "imageviewer.h"
#include "imagelistview.h"

#include <kurl.h>
#include <kiconloader.h>
#include <kfileitem.h>
#include <kfileiconview.h>
#include <kapplication.h>
#include <kwordwrap.h>

#include <qiconview.h>
#include <qstring.h>
#include <qfont.h>
#include <qpainter.h>

FileIconItem::FileIconItem(ImageListView *parent, QString path, QString filename, QString , ImageViewer *iv)
	: KFileIconViewItem (parent,
			filename,
			NULL,
			mKFileItem = new KFileItem(KFileItem::Unknown,
					KFileItem::Unknown,
					KURL(path+filename),
					false)),
	f(filename)

{
	this->imageList=parent;
	this->iv=iv;

	KURL murl;
	murl.setPath(path+filename);
	murl.setProtocol("file");
	mKFileItem->setURL(murl);

	haspreview=false;
	__isimage__=false;
	__ismovable__=false;
}

FileIconItem::~FileIconItem()
{
}

void
FileIconItem::setName(QString n)
{
	myName=n;
}

void
FileIconItem::setType(QString type)
{
	this->type = type;
}

QString
FileIconItem::getType()
{
	return type;
}

void
FileIconItem::setPixmap ( const QPixmap& icon, bool haspreview )
{
	KFileIconViewItem::setPixmap(icon, true, true);
	this->haspreview=haspreview;
}
void 
FileIconItem::setHasPreview (bool preview)
{
	this->haspreview=preview;
}

bool
FileIconItem::hasPreview ()
{
	if(!haspreview) 
		return false;
	else
	{
		bool older=QFileInfo(fullName()).lastModified() < QFileInfo (QDir::homeDirPath () + "/.showimg/cache/" + fullName()).lastModified();
		return older;
	}

}

FileIconItem*
FileIconItem::nextItem ()
{
	return (FileIconItem*)KFileIconViewItem::nextItem();
}

FileIconItem*
FileIconItem::prevItem ()
{
	return (FileIconItem*)KFileIconViewItem::prevItem();
}


QString
FileIconItem::name()
{
	return myName;
}
 
KURL
FileIconItem::getURL()
{
	KURL murl;
	murl.setProtocol("file");
	murl.setPath(fullName ());
	return murl;
}


QString
FileIconItem::getFileName(QString *fullName)
{
	int debut = fullName->findRev ("/");
	int fin = fullName->findRev (".");
	return fullName->mid(debut+1, fin-debut-1);
}


QString
FileIconItem::getFileExt(QString *fullName)
{
	return  fullName->right (fullName->length () - fullName->findRev (".") - 1);
}

QString
FileIconItem::getFullName(QString *fullName)
{
	return fullName->right (fullName->length () - fullName->findRev ("/") - 1);
}

QString
FileIconItem::getFullPath(QString *fullName)
{
	return fullName->left(fullName->findRev ("/") + 1);
}

QString
FileIconItem::mimetype() const
{
	return fileInfo()->mimetype();
}

void
FileIconItem::setKey ( const QString & k )
{
	if(k=="name")
		KIconViewItem::setKey(text());
	else
	if(k=="size")
		KIconViewItem::setKey(size);
	else
	if(k=="type")
		KIconViewItem::setKey(extension);
	else
	if(k=="date")
		KIconViewItem::setKey(date);
	else
		KIconViewItem::setKey(text());

}

void
FileIconItem::setSelected (bool s)
{
	KIconViewItem::setSelected (s);
	kapp->processEvents();
	if (s)
	{
		KApplication::setOverrideCursor (waitCursor);	  // this might take time
		iv->loadImage(fullName(), index());
		kapp->processEvents();
		if (imageList->preloadIm() && nextItem())
			iv-> preloadImage(nextItem()->fullName());
		KApplication::restoreOverrideCursor ();   // restore original cursor
	}
}

bool
FileIconItem::isImage() const
{
	return __isimage__;
}

bool
FileIconItem::isMovable() const
{
	return __ismovable__;
}

QString
FileIconItem::fullName () const
{
	return full;
}


void 
FileIconItem::setPath(QString newPath)
{
//	kdDebug() << __FILE__ << __LINE__ << " begin  FileIconItem::setPath(QString newPath) "<< fullName() << endl;

	QString name = QFileInfo(fullName()).fileName();
	full = newPath+name;

	KURL murl;
	murl.setPath(fullName());
	murl.setProtocol("file");
	mKFileItem->setURL(murl);

//	kdDebug() << __FILE__ << __LINE__ << " end FileIconItem::setPath(QString newPath) "<< fullName() << endl;
}

QString 
FileIconItem::path()
{
	return QFileInfo(fullName()).dir().absPath();
}

QString
FileIconItem::toolTipStr() const
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::toolTipStr() const " << fullName() << endl;
	return "";
}

void 
FileIconItem::calcRect ( const QString & text_ )
{
	KFileIconViewItem::calcRect(text_);
	
}

bool
FileIconItem::suppression(bool)
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::suppression(bool) " << fullName() << endl;
	return false;
}

bool
FileIconItem::suppression()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::suppression() " << fullName() << endl;
	return false;
}

bool
FileIconItem::moveToTrash()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::moveToTrash() " << fullName() << endl;
	return false;
}

bool
FileIconItem::shred()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::shred() " << fullName() << endl;
	return false;
}

QString
FileIconItem::text(int ) const
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::text(int ) const " << fullName() << endl;
	return QString();
}

void
FileIconItem::setWallpaper()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::setWallpaper() " << fullName() << endl;
}

QString
FileIconItem::getFileName(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::getFileName(QString ) "  << endl;
	return QString();
}

QString
FileIconItem::getFileExt(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::getFileExt(QString ) "  << endl;
	return QString();
}

QString
FileIconItem::getFullName(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::getFullName(QString ) "  << endl;
	return QString();
}

QString
FileIconItem::getFullPath(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO FileIconItem::getFullPath(QString ) "  << endl;
	return QString();
}

