/***************************************************************************
                          directory.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult, 2003 OGINO Tomonori
    email                : rgroult@jalix.org ogino@nn.iij4u.or.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "directory.h"

#include "directoryview.h"
#include "imageviewer.h"
#include "imagefileiconitem.h"
#include "dirfileiconitem.h"
#include "compressedimagefileiconitem.h"
#include "compressedfileitem.h"
#include "fileiconitem.h"
#include "imagelistview.h"
#include "mainwindow.h"
#include "directoryview.h"
#include "album.h"
#include "extract.h"

#include <unistd.h>

#include <qlistview.h>
#include <qstring.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qpixmapcache.h>

#include <kio/job.h>
#include <kiconloader.h>
#include <klineeditdlg.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kapplication.h>
#include <konq_operations.h>

Directory::Directory( DirectoryView* parent,
			 ImageViewer *iv,  ImageListView *imageList, MainWindow *mw )
	: ListItem(parent, iv, imageList, mw)
{
	full=( "/" );
	init();
}

Directory::Directory(Directory* parent, QString filename ,
			DirectoryView* dirView, ImageViewer *iv, ImageListView  *imageList, MainWindow *mw )
	: ListItem(parent, filename, dirView, iv, imageList, mw)
{
	full=this->parent()->fullName()+f.name()+"/";
	init();
}


Directory::~Directory()
{
}


void
Directory::init()
{
	readable = TRUE;
	setPixmap(0, BarIcon(KMimeType::iconForURL(full), KIcon::SizeSmall ));
	setDropEnabled(true);
	size=-1;
}


ListItem*
Directory::find(QString dir)
{
	ListItem* dirt;
	dirt=firstChild();
	while(dirt != 0)
	{
		if(QString(dir) == dirt->text(0)) break;
		dirt = dirt->nextSibling ();
	}
	if(dirt) return dirt;
	return NULL;
}

void 
Directory::recursivelyOpen()
{
	setOpen(true);
	QListViewItem* dirt=firstChild();
	while(dirt != 0)
	{
		if(dirt->text(1)==i18n("Directory")) ((Directory*)dirt)->recursivelyOpen();
		dirt = dirt->nextSibling ();
	}
	kapp->processEvents();
}

void
Directory::setOpen( bool o )
{
//	kdDebug() << __FILE__ << __LINE__ << " begin Directory::setOpen( bool o ) " << o << " " << fullName() << endl;
	if ( !isOpen() && o && !childCount() )
	{
		KApplication::setOverrideCursor( waitCursor ); // this might take time
		
		QString s( fullName() );
		QDir thisDir( s );
		if(dirView->showHiddenDir())
			thisDir.setFilter(QDir::All|QDir::Hidden);
		else
			thisDir.setFilter(QDir::All);
		 const QFileInfoList * files = thisDir.entryInfoList();
		 if ( files )
		 {
		 	QFileInfoListIterator it( *files );
		 	QFileInfo * f;

		 	while( (f=it.current()) != 0 )
		 	{
				++it;
		 		  if ( f->fileName() == "." || f->fileName() == ".." )
		 		      ; // nothing
		 		  else
		 		  {
		 		  	  if ( f->isDir() || (f->isSymLink() && QFileInfo(f->readLink()).isDir()) )
		 		  	    	  (void)new Directory( this, f->fileName(), dirView, iv, imageList, mw);
		 		  	  else
		 		  	  {
		 		  	   	   if ( Extract::canExtract(f->fileName()))
		 		  	   	   	(void)new CompressedFileItem(this, f->fileName(), fullName(),  mw, dirView, iv, imageList);
		 		  	   	   else if(QFileInfo(f->fileName()).extension().lower() == "sia")				   
		 		  	   	   	(void)new Album(this, f->fileName(), dirView, iv, imageList, mw);
		 		  	  }
		 		  }
		 	}
			dirView->sort();
		}
		if(!childCount()) setExpandable(false);
		KApplication::restoreOverrideCursor();      // restore original cursor

		dirView->startWatchDir(fullName());
	}
	else
	if(!o && childCount() )
	{
		QListViewItem *dirt=firstChild(), *oldDir;
		while(dirt != 0)
		{
			if(dirt->isSelected()) dirt->setSelected(false);
			dirt->setOpen(false);
			oldDir = dirt;
			dirt = dirt->nextSibling ();
			delete(oldDir);
		}
		dirView->stopWatchDir(fullName());
	}

	if ( o )
	{
		if(KMimeType::iconForURL(full )== "folder")
			setPixmap( 0, SmallIcon("folder_open") );
	}
	else
	{
		setPixmap( 0, SmallIcon(KMimeType::iconForURL(full)) );
	}

	QListViewItem::setOpen( o );
	repaint();
	listView()->setUpdatesEnabled( TRUE );
//	kdDebug() << __FILE__ << __LINE__ << " end Directory::setOpen( bool o ) " << o << " " << fullName() << endl;
}


bool
Directory::refresh(bool )
{
//	kdDebug() << __FILE__ << __LINE__ << " begin Directory::refresh(bool ) "  << fullName() << endl;
	QString s( fullName() );
	QDir thisDir( s );
	bool isS=isSelected();

	if(!isS)
	{
		thisDir.setFilter(QDir::Dirs);
	}
	else
	{
		thisDir.setFilter(dirView->filter() | QDir::Dirs);
	}
	const QFileInfoList * files = thisDir.entryInfoList();
	
	//////////////////
	QStringList after;
	QStringList news;
	QStringList deleted;

	QFileInfoListIterator it( *files );
	QFileInfo * f;
	QString ext;

	QString filename;
	FileIconItem *item;
	while( (f=it.current()) != 0 )
	{
		++it;
		if(
			(f->isDir() && f->fileName()!=".")
			||
			(f->isFile () &&
			(dirView->showAllFile() || dirView->isImage(f))))
		{
			item=imageList->findItem(f->fileName());
			if(!item) news.append(f->fileName());
			after.append(f->fileName());
		}
	}

//	kdDebug() << __FILE__ << __LINE__ << " \t Directory::refresh(bool ) "  << fullName() << endl;

	bool add=false, del=false;
	for ( item=list.first();  item!= 0; item=list.next() )
	{
//		kdDebug() << __FILE__ << __LINE__ << " \t\t Directory::refresh(bool ) item->text()= " << fullName()+item->text() << endl;
		if(!after.contains(item->text()))
		{
			deleted.append(item->text());
			del=true;
		}
	}
	ListItem* dirt=firstChild();
	while(dirt != 0)
	{
		if(!after.contains(dirt->text(0)))
		{
			deleted.append(dirt->text(0));
			del=true;
		}
		dirt = dirt->nextSibling ();
	}

//	kdDebug() << __FILE__ << __LINE__ << " \t Directory::refresh(bool ) "  << fullName() << endl;

	///
	for ( QStringList::Iterator it = news.begin(); it != news.end(); ++it )
	{
//		kdDebug() << __FILE__ << __LINE__ << " \t Directory::refresh(bool ) add " << fullName()+*it  << endl;
		if(!QFileInfo(fullName()+*it).isDir ())
		{
//		kdDebug() << __FILE__ << __LINE__ << " \t\t Directory::refresh(bool ) add file " << fullName()+*it  << endl;
			item= new ImageFileIconItem(imageList, this, *it, fullName(), iv);
			list.append(item);
			mw->slotAddImage();
			size++;
			add=true;
		}
		else
		if(QFileInfo(*it).fileName()!="." && !find(*it))
		{
//			kdDebug() << __FILE__ << __LINE__ << " \t\t Directory::refresh(bool ) add dir " << fullName()+*it  << endl;
			if(QFileInfo(*it).fileName()!="..")
			{
				(void)new Directory(this, *it, dirView, iv, imageList, mw);
				setExpandable( TRUE );
			}
			if(isS && dirView->showDir())
			{
				item= new DirFileIconItem(imageList, this, *it, fullName(), iv);
				list.append(item);
				mw->slotAddImage();
				size++;
				add=true;
			}
		}
	}

//	kdDebug() << __FILE__ << __LINE__ << " \t Directory::refresh(bool ) "  << fullName() << endl;
	
	int toDel=0;
	for ( QStringList::Iterator it = deleted.begin(); it != deleted.end(); ++it )
	{
//		kdDebug() << __FILE__ << __LINE__ << " \t Directory::refresh(bool ) delete " << fullName()+*it  << endl;
		if(QFileInfo(fullName()+*it).exists()) continue;
		dirView->removeDir(fullName()+*it);
		if(isS)
		{
			if( (item=imageList->findItem(*it)) != NULL)
			{
				list.remove(item);
				delete(item);
				toDel++;
			}
		}
	}
//	kdDebug() << __FILE__ << __LINE__ << " \t Directory::refresh(bool ) "  << fullName() << endl;
	if(!del && !add) return false;
  
	if(isOpen() && !childCount()) setExpandable( false );
	if(isS)
	{
		size-=toDel;
		mw->slotRemoveImage(toDel);

		QPoint tl(imageList->contentsX(), imageList->contentsY());
		imageList->sort();
		imageList->setContentsPos(tl.x(), tl.y());
	}
	
	
	
	//////////////////////////////////////////////////////////////////////
//	thisDir.setNameFilter("*.sia");
//	files = thisDir.entryInfoList();

	kapp->processEvents();
//	kdDebug() << __FILE__ << __LINE__ << " end Directory::refresh(bool )"   << endl;	
	return true;
}

void
Directory::goTo(QString)
{
}

void
Directory::setup()
{
	setExpandable( TRUE );
	ListItem::setup();
}


QString
Directory::path()
{
	QDir dir=QFileInfo(fullName()).dir();
	if (dir.cdUp())
		return dir.absPath();
	else
		return QString();
}

QString
Directory::text( int column ) const
{
	if ( column == 0 )
		return f.name();
	else
	if(column == 2 )
	{
		if(size>=0)
			return  QString("%1").arg(size, 10);
		else
			return "";
	}
	else
	if ( readable )
		return i18n("Directory");
	else
		return i18n("Locked");
}

void
Directory::loadFirst()
{
}


void
Directory::removeImage(ImageFileIconItem *imf)
{
	if(!imf)
	{
		return;
	}

	if(list.find(imf)!=-1)
	{
		delete(imf);
		mw->slotRemoveImage(1);
	}
}

void
Directory::unLoad()
{
	if(mw->preview()) imageList->stopLoading();
	mw->slotRemoveImage(list.count());

	for (FileIconItem *item = list.first(); item; item = list.next() )
		delete(item);
	list.clear();
	iv->updateStatus();
	imageList->slotUpdate();
	
	//kapp->processEvents();
}


void
Directory::load(bool )
{
	bool hasIm=imageList->hasImages();
	mw->setMessage(i18n("Loading directory %1...").arg(text(0)));
	//KApplication::setOverrideCursor( waitCursor ); // this might take time
	imageList->setUpdatesEnabled( FALSE );
	imageList->stopLoading();

	QString s( fullName() );
	QDir thisDir( s );
	thisDir.setFilter(dirView->filter());
	const QFileInfoList * files = thisDir.entryInfoList();
	if ( files )
	{
		QFileInfoListIterator it( *files );
		QFileInfo * f;
		QString ext;
		size=0;
		FileIconItem *item=NULL;

		while( (f=it.current()) != 0 )
		{
			++it;
			if(
				f->isFile () &&
					(dirView->showAllFile() ||
					(!dirView->showAllFile() && dirView->isImage(f))))
			{
				item = new ImageFileIconItem(imageList, this, f->fileName(), fullName(), iv);
			}
			else
			if(f->isDir() && f->fileName()!=".")
			{
				item = new DirFileIconItem(imageList, this, f->fileName(), fullName(), iv);
			}

			if(item)
			{
				list.append(item);
				size++;
			}
			item=NULL;
		}
		mw->slotAddImage(size);
		imageList->sort();
		repaint();//kapp->processEvents();
		imageList->setUpdatesEnabled( TRUE );
		if(!hasIm)
		{
			if(dirView->loadFirstImage())
				imageList->first();
			else        
				iv->loadImage();
		}
		imageList->slotUpdate() ;
		iv->updateStatus();
		imageList->slotLoadFirst();
	}
	//KApplication::restoreOverrideCursor();	// restore original cursor

	mw->setMessage(i18n("Ready"));
	//kapp->processEvents();
}


void
Directory::createDir(QString dirName)
{
	KURL url = KURL("file://"+fullName()+dirName);
	KonqOperations::mkdir(mw, url);
	setExpandable(true);
}

void
Directory::createAlbum(QString albumName)
{
	KURL urld = KURL("file://"+fullName()+albumName);
	KURL urlo = KURL("file://"+KStandardDirs().findResource("templates",".source/TextFile.txt"));
	KIO::copy(urlo, urld, false);
	setExpandable(true);
	mw->addToBookmark(i18n("Albums"),fullName()+albumName);
	if(isOpen())
		new Album(this, albumName, dirView, iv, imageList, mw);
}

void
Directory::rename()
{
	kdDebug() << __FILE__ << __LINE__ << " begin  Directory::rename()" << endl;
	if(newDirName!="")
	{	
		f.setName(newDirName);
		full=path()+"/"+newDirName+"/";
		//mw->slotRefresh();
		repaint();
	}
	kdDebug() << __FILE__ << __LINE__ << " end  irectory::rename()" << endl;
}

void
Directory::rename(QString newDirName)
{
	kdDebug() << __FILE__ << __LINE__ << " begin  Directory::rename(QString newDirName="<< newDirName << endl;

	this->newDirName=newDirName;

	QString oldN=fullName();
	QString newN=path()+"/"+newDirName;

	KURL orgName = KURL("file://"+oldN);
	KURL newName = KURL("file://"+newN);

	KIO::SimpleJob *renameJob=KIO::rename(orgName, newName, true );
	QObject::connect(renameJob, SIGNAL(result( KIO::Job *)),
		dirView, SLOT(renameDone( KIO::Job *)));

	f.setName(newDirName);
	updateChildren();
	
	kdDebug() << __FILE__ << __LINE__ << "  Directory::rename(QString newDirName) fullName()="<<  fullName() << " full=" << full << endl;
	kdDebug() << __FILE__ << __LINE__ << " end  Directory::rename(QString newDirName="<< newDirName << endl;
}


void
Directory::properties()
{
}

void
Directory::updateChildren()
{
	kdDebug() << __FILE__ << __LINE__ << " begin  updateChildren() de "<< fullName() << endl;
	
	ListItem::updateChildren();	
	if(isSelected())
	{
		FileIconItem *item;
		for ( item = list.first(); item; item = list.next() )
		{
			item->setPath(fullName());
		}
	}
	
	kdDebug() << __FILE__ << __LINE__ << " end  updateChildren() de "<< fullName() << endl;
}







