/***************************************************************************
                          compressedimagefileiconitem.cpp -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult, 2003 OGINO Tomonori
    email                : rgroult@jalix.org ogino@nn.iij4u.or.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "compressedimagefileiconitem.h"

#include "zipfile.h"
#include "imageviewer.h"
#include "compressedfileitem.h"

#include <qdragobject.h>
#include <qdropsite.h>
#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qpopupmenu.h>
#include <qfileinfo.h>
#include <qstring.h>

#include <klocale.h>
#include <kprocess.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <konq_operations.h>

CompressedImageFileIconItem::CompressedImageFileIconItem (ImageListView *parent,
						  CompressedFileItem *parentDir,
						  QString archive,
						  QString filename,
						  QString,
						  ImageViewer * iv):
     FileIconItem (parent, "/tmp/.qlist"+QString().setNum(getpid())+"/"+getFullName(new QString(archive))+"/" , filename, "tgz", iv)
{
	//kdDebug() << __FILE__ << __LINE__ << " CompressedImageFileIconItem::CompressedImageFileIconItem ) " << fullName()<< endl;

	readable = TRUE;
	this->parentDir = parentDir;
	
	size = "ukn";
	this->archive = archive;
	this->filename = filename;

	full="/tmp/.qlist"+QString().setNum(getpid())+"/"+getFullName(new QString(archive))+"/" + filename;
	extension = filename.right(3).lower();
	setType("zip");
	setName("CompressedImageFileIconItem");

	setPixmap(BarIcon(fileInfo()->iconName(), imageList->currentIconSize));
	__isimage__=true;
}

CompressedImageFileIconItem::~CompressedImageFileIconItem ()
{
}

QString
CompressedImageFileIconItem::toolTipStr() const
{
	QString tip="<table><tr><td>"
		+i18n("<b>name</b>: %1<br><b>archive</b>: %2<br>")
			.arg(text())
			.arg(archive)
		+"</td></tr></table>";
	tip+=fileInfo()->getToolTipText();

	return tip;
}


bool
CompressedImageFileIconItem::suppression (bool )
{
	kdDebug() << __FILE__ << __LINE__ << " CompressedImageFileIconItem::suppression (bool )" << fullName() << endl;
	KApplication::setOverrideCursor (waitCursor); // this might take time

	QString archiveFull = parentDir->fullName();
	ZipFile (archiveFull, filename).deleteFile ();
	parentDir->removeImage (this);

	KApplication::restoreOverrideCursor ();       // restore original cursor

	return true;
}

bool 
CompressedImageFileIconItem::moveToTrash()
{
	KURL list;
	list.setPath(fullName());
	KonqOperations::del(iconView(), KonqOperations::TRASH, list);
	return suppression(true);
}

QString
CompressedImageFileIconItem::text () const
{
	return text (0);
}


QString
CompressedImageFileIconItem::text (int column) const
{
	
	if (column == 0)
	{
		QString s(f.name ());
		int pos = s.findRev ("/");
		return s.right(s.length () - pos - 1);
	}
	else if (column == 1)
	{
		return (extension);
	}
	else if (column == 2)
	{
		return (size+i18n("  "));
	}
	else
		return (type);
}

