/***************************************************************************
                          batchrenamer.h  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __BATCHRENAMER_H__
#define __BATCHRENAMER_H__

// OS includes
#include <stdio.h>
#include <sys/types.h>
#include <utime.h>
#include <time.h>

// QT includes
#include <qdatetime.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qstring.h>

// Own includes
#include "ProgressDialog.h"

enum mode
{
        COPY, MOVE, RENAME, PREVIEW
};

struct data
{
    QString source;
    QString extension;
    QString source_path;

    QString final;
    QString final_path;
    int count;
};

struct datevals
{
    QDate date;

    bool bDate;
    bool changeModification;
    bool changeAccess;

    int hour;
    int minute;
    int second;
};

// Holds all necessary values
struct values
{
    QString text;
    QString dirname;

    int index;
    bool extension;
    bool overwrite;
    struct datevals dvals;
};

/**
  *@author Dominik Seichter
  */

class BatchRenamer {
    public:
        BatchRenamer(ProgressDialog *p=NULL);
        ~BatchRenamer();
        void processFiles( struct data* files, enum mode m, struct values* val, bool preview = false );
        
	QString findOldName( QString oldname, QString text );
        QString findOldNameLower( QString oldname, QString text );
	QString findOldNameUpper( QString oldname, QString text );
        QString findStar ( QString oldname, QString text );
        QString findNumbers( QString text, int index, int count, int i);
	
        static QString doEscape( QString text );
        static QString unEscape( QString text );
        static QString escape( QString text, QString token, QString sequence );

    
    private:
        bool fcopy(QString src, QString dest );
        int getCharacters( int n ) ;
        void work( struct data * files, enum mode m, struct values * val, bool preview );
        bool changeDate( QString file, struct datevals dvals );

    protected:
        QFile *f;
	ProgressDialog* p;
};

#endif
