/***************************************************************************
                          batchrenamer.cpp  -  description
                             -------------------
    begin                : Sat Aug 18 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "batchrenamer.h"
#include <unistd.h>
#include <sys/stat.h>


BatchRenamer::BatchRenamer(ProgressDialog *p)
{
	this->p = p;
}

BatchRenamer::~BatchRenamer()
{
}

void BatchRenamer::processFiles( struct data* files, enum mode m, struct values* val, bool preview )
{
	QString tmp;
	int i;
	QFileInfo fi;

	for( i = 0; i < files[0].count; i++)
	{
		tmp = val->text;
		if( m == RENAME ) // final Path = source Path
			files[i].final_path = files[i].source_path;
		else
			files[i].final_path = val->dirname;

		files[i].source = doEscape( files[i].source );
		tmp = findOldName( files[i].source, tmp );
		tmp = findOldNameLower( files[i].source, tmp );
		tmp = findOldNameUpper( files[i].source, tmp );
		tmp = findStar( files[i].source, tmp );
		tmp = findNumbers( tmp, val->index, files[0].count, i);

		// Add Extension if necesary
		files[i].final = unEscape( tmp );
		if( val->extension )
		{
			if( !files[i].extension.isEmpty())
				files[i].final += files[i].extension;
		}
	}
	work( files, m, val, preview );
}


void BatchRenamer::work( struct data * files, enum mode m, struct values * val, bool preview = false )
{
	int i, error = 0;
	QString in, out;

	for( i = 0; i < files[0].count; i++)
	{
	 	 in = files[i].source_path + files[i].source + files[i].extension;
	 	 out = files[i].final_path + files[i].final;

	 	 if(p)
	 	 {
	 	 	p->inc();
	 	 }
	 	 f = new QFile( out );
	 	 if( f->exists())
	 	 {
	 	 	 if(!val->overwrite)
	 	 	 {
	 	 	 	 error++;
	 	 	 	 delete f;
	 	 	 	 continue;
	 	 	 }
	 	 }
	 	 else
	 	 	delete f;
	 	 	 
	 	 	 
	 	 if(!preview)
	 	 {
	 	 	 if( m == RENAME || m == MOVE )
	 	 	 {
	 	 	 	 if(!rename(in.ascii (), out.ascii ()))
	 	 	 	 	;
	 	 	 	 else
	 	 	 	 {
	 	 	 	 	error++;
	 	 	 	 }
	 	 	 }
	 	 	 else
	 	 	 if( m == COPY )
	 	 	 	if(!fcopy( in, out ))
	 	 	 		error++;

	 	 	 if( val->dvals.bDate )
	 	 	 {
	 	 		if(!changeDate( out, val->dvals ))
	 	 	 		error++;
	 	 	 }
	 	 }
	}
}

bool BatchRenamer::fcopy(QString src, QString dest )
{
	FILE* s;
	FILE* d;
	int c;

	d = fopen(dest.ascii(), "w");
	if( d == NULL ) 
	{
		return false;
	}

	s = fopen(src.ascii(), "r");
	if( s == NULL ) 
	{
		return false;
	}

	while(( c = getc( s )) != EOF )
		putc( c, d );

	fclose( s );
	fclose( d );
	return true;
}

int BatchRenamer::getCharacters( int n )
{
	QString s;
	s.sprintf( "%i", n );
	return s.length();
}


QString BatchRenamer::findNumbers( QString text, int index, int count, int i)
{
	// Rewritten in Version 0.8
	QString temp;
	int num, pos = 0, counter = 1;

	num = text.contains( "#", FALSE );
	// Not really neccessary ;)
	if( num <= 0 )
		return text;

	pos = text.find("#", pos);
	pos++;
	while( text[pos] == '#' )
	{
		text.remove(pos, 1);
		counter++;
	}

	pos = text.find("#", 0);
	if( pos >= 0 )
	{
	 	temp.sprintf("%0*i", counter, index + i );
	 	text.replace( pos, 1, temp);
	}

	return findNumbers( text, index, count, i);
}

QString BatchRenamer::findOldName( QString oldname, QString text )
{
    /*
     * pos can here be -1 because
     * findRev is called with it as a
     * value !
     */
    int pos = -1;
    do {
        pos = text.findRev("$", pos);
        if( pos >= 0 )
            text.replace( pos, 1, oldname);
    } while( pos >= 0 );
    return text;
}

QString BatchRenamer::findOldNameLower( QString oldname, QString text )
{
    int pos = -1;
    do {
        pos = text.findRev("%", pos);
        if( pos >= 0 )
            text.replace( pos, 1, oldname.lower());
    } while( pos >= 0 );
    return text;
}

QString BatchRenamer::findOldNameUpper( QString oldname, QString text )
{
    int pos = -1;
    do {
        pos = text.findRev("&", pos);
        if( pos >= 0 )
            text.replace( pos, 1, oldname.upper());
    } while( pos >= 0 );
    return text;
}

QString BatchRenamer::findStar( QString oldname, QString text )
{
    int pos = -1;
    do {
        pos = text.findRev("*", pos);
        if( pos >= 0 ) {
            QString tmp = oldname.lower();
            if( tmp[0].isLetter() )
                tmp[0] = tmp[0].upper();

            for( unsigned int i = 1; i < tmp.length(); i++ )
                if( tmp[i+1].isLetter() && !tmp[i].isLetter() )
                    tmp[i+1] = tmp[i+1].upper();

            text.replace( pos, 1, tmp);
        }
    } while( pos >= 0 );
    return text;
}

bool BatchRenamer::changeDate( QString file, struct datevals dvals )
{
	FILE * f;
	struct utimbuf * t = new utimbuf();
	struct tm tmp;
	struct stat st;

	time_t ti;

	f = fopen(file.ascii (), "r");
	if( f == NULL )
	{
		return false;
	}

	fclose( f );

	tmp.tm_mday = dvals.date.day();
	tmp.tm_mon = dvals.date.month() - 1;
	tmp.tm_year = dvals.date.year() - 1900;

	tmp.tm_hour = dvals.hour;
	tmp.tm_min = dvals.minute;
	tmp.tm_sec = dvals.second;
	tmp.tm_isdst = -1;

	ti = mktime( &tmp );
	if( ti == -1 ) 
	{
		return false;
	}

	if( stat(file.ascii(), &st ) == -1 )
	{
		return false;
	}

	if(dvals.changeAccess)
		t->actime = ti;
	else
		t->actime = st.st_atime;

	if(dvals.changeModification)
		t->modtime = ti;
	else
		t->modtime = st.st_mtime;

	if(utime(file.ascii(), t ) != 0)
	{
		return false;
	}

	return true;
}

QString BatchRenamer::doEscape( QString text )
{
    text = BatchRenamer::escape( text, "&", QChar( 60000 ) );
    text = BatchRenamer::escape( text, "$", QChar( 60001 ) );
    text = BatchRenamer::escape( text, "%", QChar( 60002 ) );
    text = BatchRenamer::escape( text, "", QChar( 60003 ) );
    text = BatchRenamer::escape( text, "#", QChar( 60004 ) );
    text = BatchRenamer::escape( text, "[", QChar( 60005 ) );
    text = BatchRenamer::escape( text, "]", QChar( 60006 ) );

    return text;
}

QString BatchRenamer::unEscape( QString text )
{
    text = BatchRenamer::escape( text, QChar( 60000 ), "&" );
    text = BatchRenamer::escape( text, QChar( 60001 ), "$" );
    text = BatchRenamer::escape( text, QChar( 60002 ), "%" );
    text = BatchRenamer::escape( text, QChar( 60003 ), "" );
    text = BatchRenamer::escape( text, QChar( 60004 ), "#" );
    text = BatchRenamer::escape( text, QChar( 60005 ), "[" );
    text = BatchRenamer::escape( text, QChar( 60006 ), "]" );

    return text;
}

QString BatchRenamer::escape( QString text, QString token, QString sequence )
{
    /*
     * NEVER, ABSOLUTELY NEVER change pos = 0
     * to pos = -1, it won't work !
     * This bug took hours to find and was
     * a serious bug in 1.7.
     */

    int pos = 0;
    do {
       pos = text.find( token, pos );
       if( pos >= 0 )
           text.replace( pos, 1, sequence );
    } while ( pos >= 0 );
    return text;
}

