#include "defines.h"

#ifdef GNOME
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <applet-widget.h>
#include <gnome.h>
#include <stdlib.h>
#include <libgnomeui/gnome-window-icon.h>
#include <libgnorba/gnorba.h>

#include "aquarium.h"
#include "preferences.h"

gpointer *sher_pointer;


int aquarium_timer;

GdkPixmap *pixmap;
GdkBitmap *mask;


void gnome_timer_off()
{
  if(aquarium_timer!=0)
    gtk_timeout_remove(aquarium_timer);

}
void gnome_timer_on()
{
  if(aquarium_timer!=0)
    aquarium_timer = gtk_timeout_add(20, aquarium_update, NULL);
}



void gnome_background(int size, int firsttime)
{

  char *backimage_file;
  GdkPixbuf *backimage, *backimage2;
  AquariumData *a;

  a=get_ad();

  xmax = ymax = size - 2;
  ymin = xmin = 1;


  if(applet_widget_get_panel_orient(APPLET_WIDGET(a->applet))

     == GNOME_Panel_ORIENT_UP
     || applet_widget_get_panel_orient(APPLET_WIDGET(a->applet))
     == GNOME_Panel_ORIENT_DOWN){
    if(mys.doublewh) xmax *= 2;      
  }
  else{
    if(mys.doublewh) ymax *= 2;
  }

  /* If nothing is changed, then why do it all again? */
  if(a->oldwidth==xmax && a->oldheight==ymax  && 
     a->oldbg==((mys.solidcolour<<3)+(mys.shadedblue<<2)+(mys.wateralike<<1)+mys.yourown)) return;
      
  a->oldwidth=xmax;
  a->oldheight=ymax;
  a->oldbg=((mys.solidcolour<<3)+(mys.shadedblue<<2)+(mys.wateralike<<1)+mys.yourown);

  
  virtual_aquarium_x = xmax + 2 * VIRTUAL_AQUARIUM_DX;
  virtual_aquarium_y = ymax + 2 * VIRTUAL_AQUARIUM_DY;

  /* We are resizing! - Alot of stuff must be reallocated. */
  if(!firsttime){

    /* Change the size of allocated memory for background and work area */

    g_free(a->rgb);
    g_free(a->bgr);

    a->rgb=g_malloc0((xmax + 2) * (ymax + 2) * 3);
    a->bgr=g_malloc0((xmax + 2) * (ymax + 2) * 3);

    bubble_state_change = (ymax / 4);
    prepare_backbuffer();
  }


  backimage_file = filename("aquarium/master-gnome.png");

  backimage = gdk_pixbuf_new_from_file(backimage_file);
  if (!backimage) {
      display_file_error(backimage_file,"gnome_background");
  }

  bubble_state_change = (ymax / BUBBLES_FRAMES);

  
  g_free(backimage_file);

  backimage2 =
    gdk_pixbuf_scale_simple(backimage, xmax + 2, ymax + 2,
			    GDK_INTERP_HYPER);

  gdk_pixbuf_unref(backimage);
  if(pixmap!=NULL)
    gdk_pixmap_unref(pixmap);
  if(mask!=NULL)
    gdk_bitmap_unref(mask);
  

  gdk_pixbuf_render_pixmap_and_mask(backimage2, &pixmap, &mask, 80);
  gdk_pixbuf_unref(backimage2);


  gtk_widget_set_usize(a->drawingarea, xmax + 2, ymax + 2);

  if(firsttime){
    applet_widget_add(APPLET_WIDGET(a->applet), a->drawingarea);

    gtk_widget_realize(a->drawingarea);

  }
  gdk_window_shape_combine_mask(a->drawingarea->window, mask, 0, 0);
  gdk_window_set_back_pixmap(a->drawingarea->window, pixmap, False);


}

void aquarium_change_pixel_size(GtkWidget *a, int size, gpointer *d)
{
  
  gnome_timer_off();

  gnome_background(size,0);
  gnome_timer_on();

  

}

void aquarium_change_orient(GtkWidget *a, PanelOrientType o, gpointer *d)
{
  int size;
  AquariumData *a;


  if(!mys.doublewh) return;
  a=get_ad();

  gnome_timer_off();
  size = applet_widget_get_panel_pixel_size(APPLET_WIDGET(a->applet));
  gnome_background(size, 0);

  gnome_timer_on();

}



void aquarium_main_gnome()
{
  AquariumData *a;

  a=get_ad();

    aquarium_timer = gtk_timeout_add(20, aquarium_update, NULL);

    gtk_signal_connect(GTK_OBJECT(a->applet), "enter_notify_event",
		       GTK_SIGNAL_FUNC(entering_aquarium), NULL);
    gtk_signal_connect(GTK_OBJECT(a->applet), "leave_notify_event",
		       GTK_SIGNAL_FUNC(leaving_aquarium), NULL);


    gtk_signal_connect(GTK_OBJECT(a->applet), "destroy",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &a->applet);


    gtk_signal_connect(GTK_OBJECT(a->applet), "change_pixel_size",
		       GTK_SIGNAL_FUNC(aquarium_change_pixel_size),
		       NULL);

    gtk_signal_connect(GTK_OBJECT(a->applet), "change_orient",
		       GTK_SIGNAL_FUNC(aquarium_change_orient),
		       NULL);





    gtk_widget_show_all(a->applet);

    applet_widget_gtk_main();


}

void help_aquarium(AppletWidget *a, gpointer d)
{
  GtkWidget *help_me;
  
  help_me = gnome_message_box_new("For help, please read the README file\n"
				  "included in the source package.",
				  GNOME_MESSAGE_BOX_INFO,NULL);
  gtk_widget_show(help_me);


}

void about_aquarium(AppletWidget * a, gpointer d)
{
  AquariumData *a;
    char tmp[40], *tmp3;
    char *authors[3];

    a=get_ad();

    if (a->about_box) {
	gtk_widget_show(a->about_box);
	gdk_window_raise(a->about_box->window);
	return;
    }

    g_snprintf(tmp, sizeof(tmp), "Version %s", VERSION);

    authors[0] = "Jonas Aaberg <cja@gmx.net>";
    authors[1] = "See AUTHORS file for a complete list";
    authors[2] =NULL;

    tmp3 = filename("aquarium/sherman_icon.png");


    a->about_box = gnome_about_new("Sherman's aquarium", tmp,
				   "Fish graphics copyrighted by Jim Toomey.",
				   (const char **) authors,
				   "Home is at http://aquariumapplet.sourceforge.net\n",
				   tmp3);

    gtk_window_set_wmclass(GTK_WINDOW(a->about_box), "shermans_aquarium",
			   "Sherman's aquarium");
    gnome_window_icon_set_from_file(GTK_WINDOW(a->about_box),
				    tmp3);

    

    gtk_signal_connect(GTK_OBJECT(a->about_box), "destroy",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed),
		       &a->about_box);
    
    g_free(tmp3);

    gtk_widget_show(a->about_box);

}


void start_preferences(AppletWidget *aw, gpointer d)
{
  create_preferences(1);
}




int aquarium_make_new_applet_gnome_with_panel_test(int argc, char *argv[],
						   int test_panel)
{
    char  tmp2[80];
    char tmp[10];
    char *fakeargv[3];
    AquariumData *a;
    CORBA_Object panel;

    a=get_ad();
    aquarium_timer=0;
    pixmap=NULL;
    mask=NULL;

    if (!gdk_init_check(&argc, &argv)) {
	printf
	    ("GDK init failed. Please check that your \"DISPLAY\" variable is correct.\n");
	exit(-1);
    }

    gdk_rgb_init();
    gtk_init(&argc, &argv);
    g_snprintf(tmp,sizeof(tmp), "%s", VERSION);

/* Giving only one command line option. And goad server option if
   given.
   
   Otherwise it complains about my command line options.

   Work around??  */

    if(goad_server){
      fakeargv[0]=g_malloc0(strlen(argv[0])+10);
      fakeargv[1]=g_malloc0(100);
      fakeargv[2]=NULL;
      g_snprintf(fakeargv[0],strlen(argv[0])+5,"%s",argv[0]);
      g_snprintf(fakeargv[1],100,"--activate-goad-server=shermans_aquarium");
      applet_widget_init("shermans_aquarium", tmp, 2, fakeargv, NULL, 0, NULL);
      g_free(fakeargv[0]);
      g_free(fakeargv[1]);
    }
    else{
      applet_widget_init("shermans_aquarium", tmp, 1, argv, NULL, 0, NULL);

    }




/* This line was taken from gnomeicu. Thanks! */
    panel = goad_server_activate_with_repo_id(NULL, "IDL:GNOME/Panel:1.0",
					      GOAD_ACTIVATE_EXISTING_ONLY,
					      NULL);
    if (panel == CORBA_OBJECT_NIL) {
	return 1;
    }
    /* Only testing if the panel is running? */
    if (test_panel)
	return 0;



    a->applet = applet_widget_new("shermans_aquarium");
    gtk_widget_realize(a->applet);

    a->gc = gdk_gc_new(a->applet->window);

    a->drawingarea = gtk_drawing_area_new();
    gnome_background(applet_widget_get_panel_pixel_size(APPLET_WIDGET(a->applet))
		     ,1);

    applet_widget_register_stock_callback
	(APPLET_WIDGET(a->applet), "properties",
	 GNOME_STOCK_MENU_PROP, "Preferences", start_preferences, NULL);


    applet_widget_register_stock_callback
	(APPLET_WIDGET(a->applet), "help",
	 GNOME_STOCK_PIXMAP_HELP, "Help!", help_aquarium, NULL);

    applet_widget_register_stock_callback
	(APPLET_WIDGET(a->applet), "about",
	 GNOME_STOCK_MENU_ABOUT, "About...", about_aquarium, NULL);





    g_snprintf(tmp2,sizeof(tmp2),"Sherman's aquarium v%s",VERSION);
    applet_widget_set_tooltip(APPLET_WIDGET(a->applet),tmp2);


    return 0;
}



int aquarium_make_new_applet_gnome(int argc, char **argv)
{
    return aquarium_make_new_applet_gnome_with_panel_test(argc, argv, 0);
}

int detect_panel()
{
    return aquarium_make_new_applet_gnome_with_panel_test(0, NULL, 1);
}



#endif
