/***************************************************************************
                          interface_help.cpp  -  description
                             -------------------
    begin                : Mon Jan 14 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "interface.h"

enum {
	HELP_HELP,
	PATTERN_HELP,
	TRACK_HELP,
	ORDER_HELP,
	VARIABLES_HELP,
	BANKS_HELP,
	SYSTEM_HELP,
	MAX_HELP
};

static int help_lines[MAX_HELP] = {93,177,77,46,40,53,32};

static const char* help_help[93]= {

        "HELP - BASIC HELP\n",
        "(for global keys, look at the bottom)\n",
        "\n",
        "At this point, you are probably wondering how to use this \n",
        "program and how are you supposed to be able to make music \n",
        "with it.\n",
        "The following should answer most of your questions/doubts \n",
        "about it.\n",
        "\n",
        "\n",
        "1-What is a Tracker?\n",
        "\n",
        "A tracker is style of program intended for music \n",
        "composition. Its origins date from the amiga years.\n",
        "Trackers became rapidly popular because of it's simple\n",
        "design and easyness of use. To write a song, you basically\n",
        "write a bunch of \"patterns\" (or song sections) and then\n",
        "specify the order in which they should be played.\n",
        "\n",
        "2-What is ShakeTracker?\n",
        "\n",
        "ShakeTracker takes the tracker approach (originally intended\n",
        "for internal audio processing) and adapts it to midi processing. This way, instead of controlling a few internal samples (instruments), you control midi ports.\n",
        "3-What is a midi port?\n",
        "A midi port is a device used for transmision of midi data.\n",
        "Midi data consists on instructions such as \"play this note\",\n",
        "\"use this instrument\", \"change this volume on that channel\", etc.\n",
        "\n",
        "4-Ok, how do i get, at least, a basic sound?\n",
        "\n",
        "First, you need to make sure that you have a working \n",
        "midi port. To do this, go to the SYSTEM tab, and\n",
        "enable the devices you think may be useful (under unix,\n",
        "all devices are enabled by default so this step is not\n",
        "necesary).\n",
        "Once you have selected midiout devices, go to the USER DEVICES\n",
        "section. Now, create a device (or rename the existing null \n",
        "one) and selecte a \"hardware device\" for it.\n",
        "Ok, now you have your device working.. Now it's time to create\n",
        "a track.\n",
        "Go to the TRACK PROPERTIES tab. It should be empty. Push\n",
        "NEW TRACK button and a new track should appear. Now, select\n",
        "the device for this track (use the one you have \n",
        "created/edited). And then select a patch.\n",
        "Now go to the PATTERNS tab. You should see a column with many\n",
        "rows that look like:\n",
        "\n",
        "... .. .00 ...-00\n",
        "... .. .00 ...-00\n",
        "... .. .00 ...-00\n",
        "... .. .00 ...-00\n",
        "\n",
        "Locate the cursor on the leftmost field, and now, use the\n",
        "letters of the keyboard to write notes. Hopefully you should\n",
        "be hearing some sound while you write down the notes. \n",
        "If no sound is heard, try selecting another hardware device\n",
        "in the USER DEVICES tab.\n",
        "\n",
        "Now, to play the pattern, press F6 and you should be hearing it.\n",
        "\n",
        "5-I get no sound! I tried all the hardware devices, What should I do?\n",
        "\n",
        "Apparently, you dont have any device capable of producing\n",
        "sound. Under Windows, most cards come with some sort of midi\n",
        "synth so this is unlikely to happen. Under unix, this is probably what's happening to you. For both Windows and Linux there\n",
        "are excellent free soft-wavetable synthethizers. If you ask me, the best pick is TiMidity (running as ALSA client in linux).\n",
        "\n",
        "6-Ok, now what else?\n",
        "\n",
        "Try reading each section's help. If you still feel that you're\n",
        "missing something you can try to contact me. (I need to\n",
        "set up a mailing list or something).\n",
        "\n",
        "\n",
        "\n",
        "---------\n",
        "\n",
        "GLOBAL KEYS\n",
        "ESC - file menu\n",
        "F1- section help\n",
        "F2- pattern screen\n",
        "F3- instrument screen\n",
        "F5 - play song\n",
        "F6 - play current pattern\n",
        "F7 - play song from cursor\n",
        "F8 - stop\n",
        "shift-F8 - panic\n",
        "F11 - Order list\n",
        "F12 - Global variables\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "--\n",
        "For more help, questions, requests,  etc - mail me at - coding@reduz.com.ar\n"
};

static const char* pattern_help[177]= {

        "HELP- PATTERN SCREEN. (F2)\n",
        "(for global keys, look at the bottom)\n",
        "(for BASIC help, press F1 again)\n",
        "\n",
        "\n",
        "Here you write the contents of your song. Every \"pattern\" is \n",
        "written individually and then the song is created by selecting \n",
        "the order in which the patterns are played. The default amount of columns \n",
        "per track is 1, but you can add more. \n",
        "\n",
        "\n",
        "COLUMNS\n",
        "\n",
        "A column looks like this:\n",
        "... .. .00 ...-00\n",
        "\n",
        "each \"field\" or \"subcolumn\" represents\n",
        "\n",
        "1-Note/Noteoff  (...)\n",
        "Use the letters/numbers in your keyboard to set\n",
        "a note. \n",
        "\n",
        "2-Volume (0-64)\n",
        "Normally, it sets volume(velocity) if specified together with a note.\n",
        "If alone, will change the channel volume. If this field is blank\n",
        "and a note exists, the default volume of the instrument\n",
        "is used.\n",
        "\n",
        "3-Command/Parameter (.00)\n",
        "Setting a letter instead of \".\" here will invoke\n",
        "a \"Command\", with the next hexadecimal number (byte)\n",
        "as parameter. Commands Are described as Xxx\n",
        "where X == command and xx == parameter.\n",
        "I must remark that the parameter is in HEXADECIMAL. (base 16).\n",
        "\n",
        "\n",
        "Possible commands are:\n",
        "\n",
        "Axx - Set RPQ where xx=RPQ \n",
        "Bxx - Jump to pattern xx\n",
        "Cxx - Ends current pattern and jumps to row xx of the the next one (in orderlist)\n",
        "D0x - Channel volume slide down by x (0-0xF) (*)\n",
        "Dx0 - Channel volume slide up by x (0-0xF) (*)\n",
        "DFx - Fine channel volume slide down by x (0-0xF) (*)\n",
        "DxF - Fine channel volume slide up by x (0-0xF) (*)\n",
        "Exx - Pitch slide down by xx (*)\n",
        "Fxx - Pitch slide down by xx (*)\n",
        "Gxx - Portamento to note at speed xx (*)\n",
        "Hxy - vibrato with speed x and depth y (*)\n",
        "Ixx - Tremor with ontime x and offtime y (*)\n",
        "Jxy - Arpeggio (C64 like) with halftones (up) x,y (*)\n",
        "Kxx - H00 + Dxx (*)\n",
        "Lxx - G00 + Dxx (*)\n",
        "Mxx - Set global channel volume (controller 07)\n",
        "Nxx - Global volume channel slide (works like Dxx but for controleler 07) (*)\n",
        "Oxx - Change aftertouch to xx  (0-0xFF mapped to 0-127 internally) \n",
        "Pxx - Panning Slide (affects controller 10, xx works like Dxx too) (*) \n",
        "Qxy - retriggers a note  with y interval and x volume modifier (x as 0-7 is negative and 7-F positive i think..) (*)\n",
        "Rxx - Tremolo with x speed and y depth (like a vibrato but for volume) (*)\n",
        "S1x - move the pitch down by x semitones (*)\n",
        "S2x - move the pitch up by x semitones (*)\n",
        "SDx - delay note by x time , (x=1 == 1/12 of a row., x=3 is 1/4, x=4 is 1/3, x=6 is 1/2, C(12) is a row, and so on) (*)\n",
        "SCx - note off after x time (same timeframe as SDx) (*)\n",
        "Txx - (xx>=20) set tempo\n",
        "T1x - tempo slide up by x units per row (*)\n",
        "T0x - tempo slide down by x units per row (*)\n",
        "Uxx - Aftertouch vibrato with speed x and depth y (*)\n",
        "Vxx - reserved\n",
        "Wxx - Set default controller in controller column to.. xx (in hex,0-80)\n",
        "Xxx - set panning to xx (0-0xFF , 0 = left, FF = right)\n",
        "Yxy - Panbrello (panning vibrato) with speed x and depth y (*)\n",
        "Zxx - reserved\n",
        "\n",
        "remarks:\n",
        "\n",
        "(*) = if you write this command again with 00 as parameter, will repeat\n",
        "the command with the last parameter >0 used.  For example:\n",
        "D09 - channel volume slide down by 9\n",
        "D00 - keeps doing volume slide by 9\n",
        "D00 - and it keeps doing volume slide by 9!\n",
        "\n",
        "Also, commands involving pitch (vibrato, pitch slide,etc) use the pitch bender,\n",
        "which is reset each time a new note is played. You cant control\n",
        "the pitch bender value directly. Commands involving pitch and channel volume\n",
        "get their values back to normal when a note is played. If you want to \n",
        "change the global volume of the channel use Mxx/Nxx commands.\n",
        "Vibratos return the volume/pan/pitch to their original position just after the command\n",
        "finishes.\n",
        "\n",
        "4-Controller (...-00)\n",
        "Set the value of a controller (... is the controller number, in decimal),\n",
        "and 00 is the parameter in hexadecimal. Parameters (0-0xFF are\n",
        "mapped back to 0-127 internally)\n",
        "ShakeTracker supports specifying controller command too in that\n",
        "column, but at the time i'm writing this, they're not implemented.\n",
        "\n",
        "\n",
        "KEY BINDINGS \n",
        "\n",
        "Basic editing:\n",
        "\n",
        "alt+] - Add a column to the track\n",
        "alt+ { - remove a column from the track (i need to find a nicer way to do this)\n",
        "` = note off (keyboard mapping would be nice)\n",
        "ZSXDCVGBHNJM - lower octave C-B\n",
        "Q2W3ER5T6YU8I9OP- upper octaves (C-E)\n",
        "4 - play note under cursor\n",
        "8 - play row under cursor\n",
        "cursor keys - move\n",
        "tab - jump to next column\n",
        "backtab - jump to previous column\n",
        "home - jump to first column\n",
        "end - jump to last column\n",
        "page up - move the same amout of rows up as the row major highlighting\n",
        "page up - move the same amout of rows down as the row major highlighting\n",
        "insert - insert an empty note\n",
        "delete - delete a note\n",
        ". - (period) - delete field under cursor\n",
        ", - (comma) toggle editing mask for field\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "numpad - (minus) - jump to previous pattern\n",
        "numpad + (add) - jump to next pattern\n",
        "\n",
        "Shorcuts\n",
        "\n",
        "Basic selection\n",
        "Alt-B - begin selection\n",
        "Alt-E - end selection\n",
        "Alt-C - copy selection\n",
        "Alt-P - paste selection (inserts)\n",
        "Alt-O - paste selection (overwrite)\n",
        "Alt-M - paste selection (mix)\n",
        "Alt-Z - cut selection\n",
        "Alt-U - deactivate selection\n",
        "\n",
        "Operating inside the selection\n",
        "\n",
        "Alt-Q - raise notes by a semitone (if selection is not active, raises note under cursor)\n",
        "Alt-A - lower notes by a semitone\n",
        "Alt-S - ramp controller values (if at the begining you have 60, at the end 00, will interpolate \n",
        "the intermediate rows  from 0 to 60)\n",
        "Alt-X - Interpolate parameters\n",
        "Alt-X-X wipe command/paramers\n",
        "Alt-W wipe volumes not associated with a note \n",
        "Alt-V set all volumes to the volume mask (last volume used) - very handy if used together with Alt-W\n",
        "Alt-J scale volumes\n",
        "\n",
        "Other\n",
        "\n",
        "Alt-1/9 - set cursor stepping \n",
        "Scroll Lock - toggle song follow mode\n",
        "F4 - toggle pattern lock / song lock\n",
        "F2 - Pattern properties\n",
        "F9 - Mute/Unmute a channel\n",
        "F10 - Solo a channel / Unmute all\n",
        "\n",
        "\n",
        "\n",
        "---------\n",
        "GLOBAL KEYS\n",
        "\n",
        "ESC - file menu\n",
        "F1- section help\n",
        "F2- pattern screen\n",
        "F3- instrument screen\n",
        "F5 - play song\n",
        "F6 - play current pattern\n",
        "F7 - play song from cursor\n",
        "F8 - stop\n",
        "shift-F8 - panic\n",
        "F11 - Order list\n",
        "F12 - Global variables\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "--\n",
        "For more help, questions, requests,  etc - mail me at - coding@reduz.com.ar\n"

};

static const char* track_help[77]= {

        "HELP- TRACK PROPERTIES.(F3)\n",
        "(for global keys, look at the bottom)\n",
        "(for BASIC help, press F1 again)\n",
        "\n",
        "\n",
        "Here you create/select/edit tracks, and its respective instruments\n",
        "if you press the keys (under any non enditable widget) you'll\n",
        "be able to hear the instrument using the same keys as if you were\n",
        "editing a track.\n",
        "\n",
        "Basics:\n",
        "\n",
        "Tracks: track names, click here to select the track being edited\n",
        "Name: editable box to change the track name\n",
        "Move Up: move the track up by 1 row (in pattern screen too)\n",
        "Move Down: move the track down by 1 row (in pattern screen too)\n",
        "New Track - creates a new track\n",
        "Remove Track - removes a track (be careful!)\n",
        "Mute - mutes the track\n",
        "Reset - sends midi reset to the track\n",
        "Keyboard Shorcuts:\n",
        "Page Up - next instrument\n",
        "Page Down - previous instrument\n",
        "\n",
        "Track Properties:\n",
        "\n",
        "Selecting an Instrument:\n",
        "\n",
        "Aviable User Devices: This combo shows the aviable user devices. Pick one\n",
        "and the aviable banks/patches for it should appear.\n",
        "Banks in Device: Shows the aviable banks in the device. Pick one and the \n",
        "patch list of the bank should appear.\n",
        "Selected Patch: here you select the actual patch (instrument).\n",
        "Midi Channel: MIDI has 16 possible channels per device. Usually channel\n",
        "10 is meant for drums.\n",
        "\n",
        "Changing Initial data:\n",
        "\n",
        "Default Volume: When you write a note in the pattern screen and you dont\n",
        "specify the volume (and leave the field blank instead) this value is used.\n",
        "Global Volume: Every note played will pass through this at the moment of playing.\n",
        "if 127, then no volume alteration will be made, if less, the volume will be scaled\n",
        "down progressively yo zero.\n",
        "Volume/Post Note action: Usually, this is what will be used for channel volume\n",
        "(volume column when no note is present and effects Dxx,Rxx)\n",
        "Volume Behavior: When this is normal.. volume works normally (go redundancy :)\n",
        "the Tracker Emulation replaces velocity by channel volume.. (whathever is specified\n",
        "in the option above) this way you get nicer  control of the volume, but at a cost:\n",
        "mutilayered instruments will sound bad (since velocity is allways 127) and using\n",
        "more than one column for the track will be disastrous :)\n",
        "\n",
        "Initial Variables:\n",
        "\n",
        "Here you can set the initial values of some variables (for now, controllers only..\n",
        "maybe sysex and commands in a future). also notice that values go from 0-127\n",
        "(real midi values).. i should write an hex spinbutton someday :).\n",
        "\n",
        "\n",
        "\n",
        "---------\n",
        "\n",
        "GLOBAL KEYS\n",
        "ESC - file menu\n",
        "F1- section help\n",
        "F2- pattern screen\n",
        "F3- instrument screen\n",
        "F5 - play song\n",
        "F6 - play current pattern\n",
        "F7 - play song from cursor\n",
        "F8 - stop\n",
        "shift-F8 - panic\n",
        "F11 - Order list\n",
        "F12 - Global variables\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "--\n",
        "For more help, questions, requests,  etc - mail me at - coding@reduz.com.ar\n"

};

static const char* order_help[46]= {

        "HELP- ORDER LIST.(F11) \n",
        "(for global keys, look at the bottom)\n",
        "(for BASIC help, press F1 again)\n",
        "\n",
        "\n",
        "This describes the order in which patterns are played.\n",
        "the song plays until it finds a \"...\"\n",
        "\n",
        "\n",
        "Fields:\n",
        "\n",
        "... = nothing\n",
        "123 (or any other number) = pattern\n",
        "+++ = go to next order (break) (used for decoration/organization)\n",
        "\n",
        "Keys:\n",
        "\n",
        "Numbers - write pattern\n",
        "Page up - go up 8 orders\n",
        "Page Down - go up 8 orders\n",
        "Insert - insert a blank order\n",
        "Delete - delete an order\n",
        "\".\" (period) - clear order (places \"...\")\n",
        "\"+\" (add) - insert break (places \"+++\")\n",
        "N - writes the previous order +1 (if the order above is 001, will write 002, and so on)\n",
        "\n",
        "\n",
        "\n",
        "---------\n",
        "\n",
        "GLOBAL KEYS\n",
        "ESC - file menu\n",
        "F1- section help\n",
        "F2- pattern screen\n",
        "F3- instrument screen\n",
        "F5 - play song\n",
        "F6 - play current pattern\n",
        "F7 - play song from cursor\n",
        "F8 - stop\n",
        "shift-F8 - panic\n",
        "F11 - Order list\n",
        "F12 - Global variables\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "--\n",
        "For more help, questions, requests,  etc - mail me at - coding@reduz.com.ar\n"
	
};

static const char* variables_help[40]= {

        "HELP- SONG SPEED/INFO (variables).(F12)\n",
        "(for global keys, look at the bottom)\n",
        "(for BASIC help, press F1 again)\n",
        "\n",
        "\n",
        "Song Speed:\n",
        "\n",
        "Rows per Quarter Note (RPQ): This defines how many rows make up a quarter note (figure #4).\n",
        "Tempo: Defines how many quarter notes are played in a minute.\n",
        "\n",
        "Song Info:\n",
        "\n",
        "Title: name your song\n",
        "Author: name yourself\n",
        "Comments: any comments about the song\n",
        "\n",
        "Logo:\n",
        "\n",
        "Quite lame, aint it? I d really appreciate a better one!\n",
        "\n",
        "\n",
        "\n",
        "---------\n",
        "\n",
        "GLOBAL KEYS\n",
        "ESC - file menu\n",
        "F1- section help\n",
        "F2- pattern screen\n",
        "F3- instrument screen\n",
        "F5 - play song\n",
        "F6 - play current pattern\n",
        "F7 - play song from cursor\n",
        "F8 - stop\n",
        "shift-F8 - panic\n",
        "F11 - Order list\n",
        "F12 - Global variables\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "--\n",
        "For more help, questions, requests,  etc - mail me at - coding@reduz.com.ar\n"
};

static const char* banks_help[53]= {

        "HELP- USER DEVICES\n",
        "(for global keys, look at the bottom)\n",
        "(for BASIC help, press F1 again)\n",
        "\n",
        "\n",
        "Here you edit the bank descriptions.\n",
        "Most of the times, it's not enough to only know that you're\n",
        "using a sound blaster live, an external midi out port, a soft\n",
        "synth, etc. You need to know what instruments are in the\n",
        "current device, how is it called, what is attached to it, etc.\n",
        "\n",
        "User Device:\n",
        "\n",
        "Create your custom device here, and select the hardware midi\n",
        "port that it will use. \n",
        "\n",
        "Bank:\n",
        "\n",
        "Midi protocol by itself is limited to only switching\n",
        "between 127 patches. To override this horrible limit\n",
        "\"banks\" were created. This means.. you can choose \n",
        "the \"bank\" a channel is using. This done by sending\n",
        "the \"bank select number\" through controllers 0 and 32.\n",
        "Usually, the bank is a 14 bits long number (so you get up\n",
        "to.. uhm.. i think 16384 banks or something). In most\n",
        "keyboards/synths (and to make life easier to everyone) this bank is divided in two 7 bits number, the most significant byte (upper 7 bits) and least significant byte (lower 7 bits)\n",
        "If you see that your synth manufacturer gives you a big weird number instead of two little nice ones for the banks, you need\n",
        "to do the math by yourself to get MSB/LSB.\n",
        "this is easy:\n",
        "\n",
        "Divide the big number by 127: the result is the MSB and the remainder the LSB.\n",
        "Once you got to setup the bank, you can edit the patch names.\n",
        "\n",
        "\n",
        "\n",
        "---------\n",
        "\n",
        "GLOBAL KEYS\n",
        "ESC - file menu\n",
        "F1- section help\n",
        "F2- pattern screen\n",
        "F3- instrument screen\n",
        "F5 - play song\n",
        "F6 - play current pattern\n",
        "F7 - play song from cursor\n",
        "F8 - stop\n",
        "shift-F8 - panic\n",
        "F11 - Order list\n",
        "F12 - Global variables\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "--\n",
        "For more help, questions, requests,  etc - mail me at - coding@reduz.com.ar\n"


};

static const char* system_help[32]= {

        "HELP- SYSTEM OPTIONS\n",
        "(for BASIC help, press F1 again)\n",
        "\n",
        "\n",
        "Here you can choose to enable/disable hardware devices.\n",
        "While not very useful in unixes (since you can just\n",
        "open/close all or change devices in runtime), \n",
        "this is a must under Windows.. because softsynths cant \n",
        "be plugged/unplugged without rebooting.\n",
        "\n",
        "Nothing else here really works yet.. ;)\n",
        "\n",
        "\n",
        "\n",
        "---------\n",
        "\n",
        "GLOBAL KEYS\n",
        "ESC - file menu\n",
        "F1- section help\n",
        "F2- pattern screen\n",
        "F3- instrument screen\n",
        "F5 - play song\n",
        "F6 - play current pattern\n",
        "F7 - play song from cursor\n",
        "F8 - stop\n",
        "shift-F8 - panic\n",
        "F11 - Order list\n",
        "F12 - Global variables\n",
        "numpad / (slash) - decrease editing octave\n",
        "numpad * (asterisk) - increase editing octave\n",
        "--\n",
        "For more help, questions, requests,  etc - mail me at - coding@reduz.com.ar\n"

};

void Interface::show_help(int p_page) {


	textarea_help.delete_text(0,-1);
	int i;

	

	switch(p_page) {

		case HELP_HELP: {
              	
			for (i=0;i<help_lines[HELP_HELP];i++)
				textarea_help.insert(help_help[i]);
					
					
		}  break;
		case PATTERN_HELP: {
              	
			for (i=0;i<help_lines[PATTERN_HELP];i++)
				textarea_help.insert(pattern_help[i]);
					
					
		}  break;
		case TRACK_HELP: {

			for (i=0;i<help_lines[TRACK_HELP];i++)
				textarea_help.insert(track_help[i]);
				
		} break;
		case ORDER_HELP: {

			for (i=0;i<help_lines[ORDER_HELP];i++)
				textarea_help.insert(order_help[i]);
				
		} break;
		case VARIABLES_HELP: {

			for (i=0;i<help_lines[VARIABLES_HELP];i++)
				textarea_help.insert(variables_help[i]);
				
		}  break;
		case BANKS_HELP: {

			for (i=0;i<help_lines[BANKS_HELP];i++)
				textarea_help.insert(banks_help[i]);
		
		} break;
		case SYSTEM_HELP: {
			
			for (i=0;i<help_lines[SYSTEM_HELP];i++)
				textarea_help.insert(system_help[i]);
		
		} break;
	
	}
        textarea_help.set_point(0);
        helpscroll.get_vadjustment()->set_value(0);
}

