/***************************************************************************
                          properties.cpp  -  description
                             -------------------
    begin                : Wed Sep 26 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "properties.h"

void Properties::add_section(string p_name) {

	Section new_section;

	if (section_exists(p_name)) return;

	section_list[p_name]=new_section;
}

void Properties::add_property(string p_section,string p_name,string p_value) {

	section_list[p_section].property_list[p_name].value=p_value;
}

void Properties::add_property(string p_section,string p_name,int p_value) {

	Property new_prop;
	char name[40];
	string svalue;

	if (property_exists(p_section,p_name)) return;

	sprintf(name,"%i",p_value);
	svalue=name;

	section_list[p_section].property_list[p_name].value=svalue;
}

int Properties::get_int_property(string p_section,string p_name) {

	if (!property_exists(p_section,p_name)) return 0;

	return atoi(section_list[p_section].property_list[p_name].value.c_str());
}

string Properties::get_str_property(string p_section,string p_name) {

	if (!property_exists(p_section,p_name)) return "";

	return section_list[p_section].property_list[p_name].value;
}

bool Properties::section_exists(string p_name) {

	return section_list.find(p_name)!=section_list.end();
}

bool Properties::property_exists(string p_section,string p_name) {

	if (!section_exists(p_section)) return false;

	return section_list[p_section].property_list.find(p_name)!=section_list[p_section].property_list.end();
}

void Properties::set_header_check(string p_header_check) {

	header_check=p_header_check;
}

int Properties::save_to_file(string p_filename) {

        Section_List::iterator I;
        Property_List::iterator J;

	File_Writer writer;

	if (writer.open(p_filename.c_str())) return ERROR_OPENING_FILE_FOR_WRITING;

	writer.store_pascal_string(header_check.c_str());

	for (I=section_list.begin();I!=section_list.end();I++) {

	
		writer.store_byte(CHUNK_SECTION);
		writer.store_pascal_string(I->first.c_str());

		for (J=I->second.property_list.begin();J!=I->second.property_list.end();J++) {

			writer.store_byte(CHUNK_VARIABLE);

			writer.store_pascal_string(J->first.c_str());
			writer.store_pascal_string(J->second.value.c_str());
		}
	}

	writer.close();

	return SUCCESS;
}

int Properties::load_from_file(string p_filename) {

	string section="";
	Property aux_prop;
	string tmp_check;
	Uint8 chunk;

	File_Reader reader;

	if (reader.open(p_filename.c_str())) return ERROR_OPENING_FILE_FOR_READING;

	tmp_check=reader.get_pascal_string();
	if (tmp_check!=header_check) {

		reader.close();
		return ERROR_INVALID_FILE;
	}

	reader.get_byte(chunk);

	while(!reader.eof_reached()) {

		if (chunk==CHUNK_SECTION) {

			section=reader.get_pascal_string();;
			add_section(section);			
		} else {
			string var,val;
                        var=reader.get_pascal_string();
			val=reader.get_pascal_string();
			add_property(section,var,val);		
		}

		reader.get_byte(chunk);
	}

	reader.close();

	return 0;
}


int Properties::save_to_text(string p_filename) {


}
int Properties::load_from_text(string p_filename) {


}


Properties::Properties(){
}
Properties::~Properties(){
}
