/***************************************************************************
                          instrumentmap.cpp  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "instrumentmap.h"
#include "defaultctrls.h"

void InstrumentMap::add_bank() {

	if (banks_count<MAX_BANKS) {

		bank[banks_count]=new Bank;
		banks_count++;
	}

}

void InstrumentMap::add_bank_gm() {

	add_bank();
	bank[banks_count-1]->set_gm_names();
}


void InstrumentMap::delete_bank(int banknum) {

	int i;

	if ((banknum<banks_count) && (banknum>=0)) {

		delete bank[banknum];
		for (i=banknum;i<banks_count-1;i++) bank[i]=bank[i+1];
		banks_count--;		
	}

}


InstrumentMap::InstrumentMap(){
	
        int i;

	for (i=0;i<128;i++) controller_names[i]=default_ctrl_name[i];
	banks_count=0;
	add_bank_gm();

}

InstrumentMap::~InstrumentMap(){
}
