/***************************************************************************
                          event_basic.h  -  description
                             -------------------
    begin                : Fri Aug 17 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EVENT_BASIC_H
#define EVENT_BASIC_H

#include "event_execute.h"
#include "typedefs.h"

/**
  *@author Juan Sebastian Linietsky
  */
class Event {

protected:
	int time_offset; // milliseconds
	Event_Execute *runner;
	int track,column;

	string name;
public:

	const string* get_name() {

		return &name;
	}

       	int get_time_offset() {

		return time_offset;
	};

	void set_time_offset(int p_offset) {

		time_offset=p_offset;
	}

	virtual void execute()=0;

	void set_track(int p_track) {

		track=p_track;

	};

	void set_column(int p_column) {

		column=p_column;
	};

	void set_event_runner(Event_Execute *p_runner) {

		runner=p_runner;
	}
	Event() {

		name="generic";
	}
	virtual ~Event(){}

};

//-----------------------------------------------------------------//

class Event_NoteOn : public Event {


	int note,volume;
public:

	void set_note(int p_note,int p_volume) {

		note=p_note;
		volume=p_volume;
	};

        void execute() {
		
		runner->event_NoteOn(track,column,note,volume);
	};

	Event_NoteOn() {
	
		name="note on";
	}
};

//-----------------------------------------------------------------//

class Event_NoteOff : public Event {


	int volume;
public:

	void set_volume(int p_volume) {

		volume=p_volume;
	};

        void execute() {
		
		runner->event_NoteOff(track,column,volume);
	};

	Event_NoteOff() {

		name="note off";
	}
};

//-----------------------------------------------------------------//

class Event_Controller : public Event {


	int controller;
	float value;
public:

	void set_controller(int p_controller,float p_value) {

		controller=p_controller;
		value=p_value;	
	};

        void execute() {
		
		runner->event_Controller_Set(track,column,controller,value);
	};

	Event_Controller() {

		name="controller";
	}
};

class Event_Controller_Virtual : public Event {


	int controller;
	float value;
public:

	void set_controller(int p_controller,float p_value) {

		controller=p_controller;
		value=p_value;	
	};

        void execute() {
		
		runner->event_controller_set_virtual_displacement(track,column,controller,value);
	};

	Event_Controller_Virtual() {

		name="controller virtual";
	}
};

class Event_Controller_Relative : public Event {


	int controller;
	float value;
public:

	void set_control_displacement(int p_controller,float p_value) {

		controller=p_controller;
		value=p_value;	
	};

        void execute() {
		
		runner->event_Controller_Set(track,column,controller,runner->get_controller_value(track,controller)+value);
	};

	Event_Controller_Relative() {

		name="controller relative";
	}
};

//-----------------------------------------------------------------//

class Event_Pitch : public Event {

	float pitch;
public:

	void set_pitch(float p_pitch) {

		pitch=p_pitch;
	};

        void execute() {
		
		runner->event_Pitch_Set(track,column,pitch);
	};

	Event_Pitch() {

		name="event_pitch";
	}
};

class Event_Pitch_Virtual : public Event {

	float pitch;
public:

	void set_pitch(float p_pitch) {

		pitch=p_pitch;
	};

        void execute() {
		
		runner->event_Pitch_Set_Virtual_Displacement(track,column,pitch);
	};

	Event_Pitch_Virtual() {

		name="pitch virtual";
	}
};

class Event_Pitch_Relative : public Event {

	float seek,amount;
public:

	void set_pitch_displacement(float p_amount) {

		amount=p_amount;
		seek=-1;
	};

	void set_seek(float p_seek) { //seeks pitch

		seek=p_seek;
	};

        void execute() {

		float aux_pitch=runner->get_pitch_value(track);

		if (seek>=0) {

			if (aux_pitch<seek) {

				if (aux_pitch+amount>seek) {

					runner->event_Pitch_Set(track,column,seek);
				} else {
					runner->event_Pitch_Set(track,column,aux_pitch+amount);
				}
			} else if (aux_pitch>seek) {

				if (aux_pitch-amount<seek) {

					runner->event_Pitch_Set(track,column,seek);
                                } else {

					runner->event_Pitch_Set(track,column,aux_pitch-amount);
				}
			}
				
		} else {

			runner->event_Pitch_Set(track,column,aux_pitch+amount);
		}
	}
	
        Event_Pitch_Relative() {

		name="pitch relative";
		seek=-1;
	}

	
};

//-----------------------------------------------------------------//

class Event_Volume : public Event {

	float volume;
public:

	void set_volume(int p_volume) {

		volume=p_volume;
	};

        void execute() {
		
		runner->event_Set_Column_Volume(track,column,volume);
	};
	
	Event_Volume() {

         	name="volume";
	}
};

class Event_Volume_Relative : public Event {

	float volume;
public:

	void set_volume_displacement(float p_volume) {

		volume=p_volume;
	};

        void execute() {

		runner->event_Set_Column_Volume(track,column,runner->get_column_volume(track,column)+volume);
	};

	Event_Volume_Relative() {

		name="volume relative";
	}
};

class Event_Volume_Virtual : public Event {

	float volume;
public:

	void set_volume_displacement(float p_volume) {

		volume=p_volume;
	};

        void execute() {

		runner->event_set_column_volume_virtual(track,column,volume);
	};

	Event_Volume_Virtual() {

		name="volume virtual";
	}
};
//--event aftertouch relative

class Event_Aftertouch : public Event {

	float aftertouch;
public:

	void set_aftertouch(int p_aftertouch) {

		aftertouch=p_aftertouch;
	};

        void execute() {
		
		runner->event_set_aftertouch(track,aftertouch);
	};
	
	Event_Aftertouch() {

         	name="aftertouch";
	}
};

class Event_Channel_Aftertouch_Relative : public Event {

	float disp;
public:

	void set_aftertouch_displacement(float p_disp) {

		disp=p_disp;
	};

        void execute() {
		
		runner->event_set_aftertouch(track,runner->get_aftertouch(track)+disp);
	};

	Event_Channel_Aftertouch_Relative() {

		name="aftertouch relative";
	}
};

#endif
