/***************************************************************************
                          interface_callbacks__virtual_devices.cpp  -  description
                             -------------------
    begin                : Sun Oct 22 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "interface.h"

//combos
void  Interface::combo_virtual_device_hardware_output_changed() {

	if (virtual_device_updating_in_progress) return;

	int selected_midiout;

	selected_midiout=string_to_int(combo_virtual_device_hardware_output->get_entry()->get_text());
	song->user_devices.get_device(selected_device)->hardware_device_index=selected_midiout;
	player->reset();


}

//buttons

void Interface::button_virtual_device_add_pressed() {

	if (song->user_devices.get_device_count()==0) {
 	
		cout << "FIXME: enable all stuff\n";
		selected_device=0;
	}

	song->user_devices.add_device();
	tracker.editor.validate_devices_midiout();
	update_clist_virtual_devices ();
	request_update_track_properties(selected_track);

	player->reset();

}

void Interface::button_virtual_device_load_pressed() {

	fileselection_device_load = new Gtk::FileSelection("Load Device Description");
	fileselection_device_load->set_position(GTK_WIN_POS_CENTER);
	fileselection_device_load->set_modal(true);
	fileselection_device_load->show();
	fileselection_device_load->get_cancel_button()->clicked.connect(slot(this,&Interface::fileselection_device_load_cancel));
	fileselection_device_load->get_ok_button()->clicked.connect(slot(this,&Interface::fileselection_device_load_ok));
}

void Interface::button_virtual_device_save_pressed() {

	fileselection_device_load = new Gtk::FileSelection("Save Device Description");
	fileselection_device_load->set_position(GTK_WIN_POS_CENTER);
	fileselection_device_load->set_modal(true);
	fileselection_device_load->show();
	fileselection_device_load->get_cancel_button()->clicked.connect(slot(this,&Interface::fileselection_device_load_cancel));
	fileselection_device_load->get_ok_button()->clicked.connect(slot(this,&Interface::fileselection_device_save_ok));
}

void Interface::fileselection_device_load_ok() {

	string aux_string;
	aux_string=fileselection_device_load->get_filename();

	if ((aux_string.length()>0) && (aux_string[aux_string.length()-1]!='/')) {
		
		song->user_devices.load_device(aux_string);
		update_clist_virtual_devices ();
		request_update_combobox_devices(selected_track);

		player->reset();

                delete fileselection_device_load;
	}

}

void Interface::fileselection_device_save_ok() {

	string aux_string;

	aux_string=fileselection_device_load->get_filename();

	if ((aux_string.length()>0) && (aux_string[aux_string.length()-1]!='/')) {
		
		song->user_devices.save_device(selected_device,aux_string);

                delete fileselection_device_load;
	}

}

void Interface::fileselection_device_load_cancel() {

	delete fileselection_device_load;
}

void Interface::button_virtual_device_delete_pressed() {


	song->user_devices.delete_device(selected_device);
	
	if (song->user_devices.get_device_count()==0) {
        	
		cout << "FIXME: disable all stuff\n";
	}

        if (selected_device>=song->user_devices.get_device_count()) selected_device=song->user_devices.get_device_count()-1;
	
	update_clist_virtual_devices ();

	tracker.editor.validate_track_midi_instruments();
	request_update_track_properties(selected_track);
	player->reset();
}

void Interface::button_bank_add_pressed() {

	if (song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()==0) {
 	
		cout << "FIXME: enable all BANK stuff\n";
		selected_bank=0;
	}

	song->user_devices.get_device(selected_device)->instrument_map.add_bank_gm();

	update_clist_aviable_banks(selected_device);

	track_properties_updating_in_progress=true;
	
	if (selected_track<0) return; //Dont update the info in TRACK tab since no banks
	else if (song->get_instrument(selected_track)->midi.device==selected_device) request_update_combobox_banks(selected_track);
	
	track_properties_updating_in_progress=false;

	request_update_track_properties(selected_track);

}

void Interface::button_bank_delete_pressed() {


	song->user_devices.get_device(selected_device)->instrument_map.delete_bank(selected_bank);

	if (song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()==0) {
        	
		cout << "FIXME: disable all bank stuff\n";
	}

        if (selected_bank>=song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()) selected_bank=song->user_devices.get_device(selected_device)->instrument_map.get_banks_count()-1;
	
	update_clist_aviable_banks(selected_device);

	tracker.editor.validate_track_midi_instruments();

	request_update_track_properties(selected_track);

}


void Interface::clist_virtual_devices_clicked(gint row,gint column,GdkEvent *event) {
	
        selected_device=row;
	request_update_virtual_devices(selected_device);
}

void Interface::clist_aviable_banks_clicked(gint row,gint column,GdkEvent *event) {
	
        selected_bank=row;
	request_update_bank_info(selected_device,selected_bank);
}

void Interface::clist_bank_patchnames_clicked(gint row,gint column,GdkEvent *event) {
	
        selected_patch=row;
	request_update_patchnames_info(selected_device,selected_bank,selected_patch);
}

void Interface::clist_bank_controller_names_clicked(gint row,gint column,GdkEvent *event) {
	
        selected_controller=row;
	request_update_controllers_info(selected_device);
}

void Interface::entry_virtual_device_name_changed() {

	if (virtual_device_updating_in_progress) return;

	song->user_devices.get_device(selected_device)->name=entry_virtual_device_name->get_text();

	clist_virtual_devices->set_text(selected_device,0,song->user_devices.get_device(selected_device)->name);

	track_properties_updating_in_progress=true;
	request_update_combobox_devices(selected_track);
	track_properties_updating_in_progress=false;

}
void Interface::entry_bank_name_changed() {

	if (virtual_device_banks_updating_in_progress) return;	

	cout << "asking for device name change in " << selected_device << "," << selected_bank <<endl;

	song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->name=entry_bank_name->get_text();
	clist_aviable_banks->set_text(selected_bank,0,song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->name);

	track_properties_updating_in_progress=true;
	
	if (selected_track<0) return; //Dont update the info in TRACK tab since no banks
	else if (song->get_instrument(selected_track)->midi.device==selected_device) request_update_combobox_banks(selected_track);

	track_properties_updating_in_progress=false;
		
}
void Interface::entry_bank_patchname_changed() {

	if (virtual_device_patches_updating_in_progress) return;	

	song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->patch_names[selected_patch]=entry_bank_patchname->get_text();
	clist_bank_patchnames->set_text(selected_patch,0,return_string_with_number(selected_patch+1,song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->patch_names[selected_patch]));

	if (selected_track<0) return; //Dont update the info in TRACK tab since no banks
	else if ((song->get_instrument(selected_track)->midi.device==selected_device)
            && (song->get_instrument(selected_track)->midi.bank==selected_bank)) request_update_clist_patches(selected_track);

}
void Interface::entry_controller_name_changed() {

	if (virtual_device_controllers_updating_in_progress) return;	

	song->user_devices.get_device(selected_device)->instrument_map.controller_names[selected_controller]=entry_controller_name->get_text();
	clist_bank_controller_names->set_text(selected_controller,0,return_string_with_number(selected_controller,song->user_devices.get_device(selected_device)->instrument_map.controller_names[selected_controller]));

	if (selected_track<0) return; //Dont update the info in TRACK tab since no banks
}

void Interface::spinbutton_bank_lsb_adj_value_changed () {

	if (virtual_device_banks_updating_in_progress) return;	

	song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->LSB=spinbutton_bank_lsb->get_value_as_int();

}

void Interface::spinbutton_bank_msb_adj_value_changed () {

	if (virtual_device_banks_updating_in_progress) return;	

	song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->MSB=spinbutton_bank_msb->get_value_as_int();

}


void Interface::radio_bsm_option1_pressed() {

	if (virtual_device_banks_updating_in_progress) return;	

	song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->bank_select_method=0;	


}
void Interface::radio_bsm_option2_pressed() {

	if (virtual_device_banks_updating_in_progress) return;	

	song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->bank_select_method=1;	


}

void Interface::radio_bsm_option3_pressed() {

	if (virtual_device_banks_updating_in_progress) return;	

	song->user_devices.get_device(selected_device)->instrument_map.bank[selected_bank]->bank_select_method=2;	


}
